/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.tabs.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.threadpool.UpdateListThreadPoolManager;
import net.sipsnet.client.utils.viewers.MyAlert;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButtonWithLabel;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButtonWithLabelAndMenu;
import net.sipsnet.client.views.contactsgroup.createeditgroup.ContactsGroupCreatorEditor;
import net.sipsnet.client.views.settings.MyRadioButton;
import net.sipsnet.client.views.tabs.TabBaseView;
import net.sipsnet.client.views.tabs.calls.flow.CallCellView;
import net.sipsnet.client.views.tabs.calls.flow.CallDateCellView;
import net.sipsnet.client.views.tabs.calls.flow.utils.CallDateHandler;
import net.sipsnet.client.views.tabs.calls.flow.utils.CallHandler;
import net.sipsnet.client.views.tabs.contacts.flow.ContactCellView;
import net.sipsnet.client.views.tabs.contacts.flow.util.ContactInfoHeader;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import net.sipsnet.client.views.tabs.utils.IRemovebleCellInterface;
import org.fxmisc.flowless.Cell;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.SessionInfo;

public abstract class TabBaseViewWithRemoveCells<T>
extends TabBaseView<T>
implements IRemovebleCellInterface {
    private static final double BASE_WIDTH = 138.0;
    private HBox deleteHeader;
    private GridPane deleteFooter;
    protected boolean isDeletingSessions = false;
    private final List<String> selectedDates = new ArrayList<String>();
    private final List<String> selectedCells = new ArrayList<String>();
    private final SimpleIntegerProperty selectedForDelete = new SimpleIntegerProperty(0);
    private MyRadioButton myRadioButton;
    protected VBox fx_bvMainBox = new VBox();
    protected ContactInfoHeader groupContactInfoHeader;
    private ImageButtonWithLabel deleteButton;
    private ImageButtonWithLabelAndMenu groupButton;
    private ImageButtonWithLabel favoriteButton;
    private ImageButtonWithLabel shareButton;
    private ImageButtonWithLabel importButton;
    private ImageButtonWithLabel removeButton;

    public TabBaseViewWithRemoveCells(int currentTab, INewMessagesNotification iNewMessagesNotification) {
        super(currentTab, iNewMessagesNotification);
        this.selectedForDelete.addListener((event, oldValue, newValue) -> this.addDeleteFooter(newValue.intValue()));
    }

    @Override
    public boolean isSelectedDateForDelete(String sessionId) {
        return this.selectedDates.contains(sessionId);
    }

    @Override
    public boolean isSelectedForDelete(String sessionId) {
        return this.selectedCells.contains(sessionId);
    }

    @Override
    public void setMultiselectMode() {
        this.setIsMultiselectMode();
    }

    @Override
    public void setIsMultiselectMode() {
        super.setIsMultiselectMode();
    }

    @Override
    public void selectCallCell(boolean isSelected, String sessionId) {
        this.onSelectedCells(isSelected, sessionId);
        this.selectedForDelete.set(this.selectedCells.size());
    }

    @Override
    protected void addDeleteHeader() {
        if (this.deleteHeader == null) {
            this.initDeleteHeader();
        }
        this.selectedCells.clear();
        this.iNewMessagesNotification.setSelectionHeader((Pane)this.deleteHeader);
    }

    @Override
    protected void removeDeleteHeader() {
        ClientSingleton.getInstance().runLater(() -> {
            this.iNewMessagesNotification.setSelectionHeader(null);
            this.myRadioButton.setSelected(false);
        });
    }

    @Override
    protected void clearSelections() {
        ClientSingleton.getInstance().runLater(() -> {
            this.selectedForDelete.set(0);
            this.selectedDates.clear();
            this.selectedCells.clear();
        });
    }

    private void addDeleteFooter(int count) {
        if (this.deleteFooter == null) {
            this.initDeleteFooter();
        }
        if (count > 0) {
            this.getDeleteButton().setLabelString(ClientSingleton.getInstance().getString("delete") + " (" + count + ")");
            if (this.groupContactInfoHeader != null && (this.groupContactInfoHeader.getType() == 6 || this.groupContactInfoHeader.getType() == 5)) {
                this.getRemoveButton().setLabelString(ClientSingleton.getInstance().getString("group_menu2") + " (" + count + ")");
            }
            if (this.deleteFooter.getChildren().isEmpty()) {
                if (this.groupContactInfoHeader == null && this.getCurrentTab() == 4) {
                    this.setButtonPosition(this.getDeleteButton(), 1);
                    this.deleteFooter.getChildren().add((Object)this.getDeleteButton());
                } else if (this.groupContactInfoHeader != null) {
                    if (this.groupContactInfoHeader.getType() == 3) {
                        this.setButtonPosition(this.getFavoriteButton(), 1);
                        this.setButtonPosition(this.getShareButton(), 2);
                        this.setButtonPosition(this.getGroupButton());
                        this.setButtonPosition(this.getDeleteButton(), 4);
                        this.deleteFooter.getChildren().addAll((Object[])new Node[]{this.getFavoriteButton(), this.getShareButton(), this.getGroupButton(), this.getDeleteButton()});
                    } else if (this.groupContactInfoHeader.getType() == 4) {
                        this.setButtonPosition(this.getImportButton(), 1);
                        this.deleteFooter.getChildren().addAll((Object[])new Node[]{this.getImportButton()});
                    } else if (this.groupContactInfoHeader.getType() == 5) {
                        this.setButtonPosition(this.getFavoriteButton(), 1);
                        this.setButtonPosition(this.getShareButton(), 2);
                        this.setButtonPosition(this.getRemoveButton(), 3);
                        this.setButtonPosition(this.getDeleteButton(), 4);
                        this.deleteFooter.getChildren().addAll((Object[])new Node[]{this.getFavoriteButton(), this.getShareButton(), this.getRemoveButton(), this.getDeleteButton()});
                    } else if (this.groupContactInfoHeader.getType() == 6) {
                        this.setButtonPosition(this.getShareButton(), 1);
                        this.setButtonPosition(this.getRemoveButton(), 2);
                        this.deleteFooter.getChildren().addAll((Object[])new Node[]{this.getShareButton(), this.getRemoveButton()});
                    } else {
                        this.setButtonPosition(this.getDeleteButton(), 1);
                        this.deleteFooter.getChildren().add((Object)this.getDeleteButton());
                    }
                }
            }
            this.iNewMessagesNotification.setSelectionFooter((Pane)this.deleteFooter);
        } else {
            this.iNewMessagesNotification.setSelectionFooter(null);
            this.deleteFooter.getChildren().clear();
        }
    }

    private void setButtonPosition(ImageButtonWithLabel button, int column) {
        GridPane.setRowIndex((Node)button, (Integer)1);
        GridPane.setColumnIndex((Node)button, (Integer)column);
        GridPane.setHgrow((Node)button, (Priority)Priority.ALWAYS);
    }

    private void setButtonPosition(ImageButtonWithLabelAndMenu button) {
        GridPane.setRowIndex((Node)button, (Integer)1);
        GridPane.setColumnIndex((Node)button, (Integer)3);
        GridPane.setHgrow((Node)button, (Priority)Priority.ALWAYS);
    }

    @Override
    public void selectDateCell(boolean isSelect, String dateSessionId) {
        IntStream.range(0, this.dataInfoList.size()).forEach(i -> {
            if (this.dataInfoList.get(i) instanceof SessionInfo) {
                if (this.dataInfoList.get(i) instanceof CallDateHandler) {
                    String sessionId = ((CallDateHandler)((Object)((Object)this.dataInfoList.get(i)))).getSessionId();
                    if (Objects.equals(dateSessionId, sessionId)) {
                        this.onSelectedDateCells(isSelect, sessionId);
                    }
                } else if (this.dataInfoList.get(i) instanceof CallHandler) {
                    CallHandler callHandler = (CallHandler)((Object)((Object)this.dataInfoList.get(i)));
                    String sessionId = callHandler.getSessionId();
                    if (dateSessionId.equals(callHandler.getDateSessionId())) {
                        this.onSelectedCells(isSelect, sessionId);
                    }
                }
                this.virtualFlow.getCellIfVisible(i).ifPresent(oCell -> {
                    CallDateCellView callDateCellView;
                    Cell cell = oCell;
                    if (cell.getNode() instanceof CallCellView) {
                        CallCellView callCell = (CallCellView)cell.getNode();
                        if (dateSessionId.equals(callCell.getDateSessionId())) {
                            callCell.setSelectCallCell();
                        }
                    } else if (cell.getNode() instanceof CallDateCellView && dateSessionId.equals((callDateCellView = (CallDateCellView)cell.getNode()).getSessionId())) {
                        callDateCellView.setSelectedDateCell(isSelect);
                    }
                });
            }
        });
        this.selectedForDelete.set(this.selectedCells.size());
    }

    @Override
    public void unselectDateCellTitle(String dateSessionId) {
        this.onSelectedDateCells(false, dateSessionId);
        if (this.myRadioButton.isSelected()) {
            this.myRadioButton.setSelected(false);
        }
        IntStream.range(0, this.dataInfoList.size()).forEach(i -> this.virtualFlow.getCellIfVisible(i).ifPresent(oCell -> {
            CallDateCellView callDateCellView;
            Cell cell = oCell;
            if (cell.getNode() instanceof CallDateCellView && dateSessionId.equals((callDateCellView = (CallDateCellView)cell.getNode()).getSessionId())) {
                callDateCellView.setSelectedDateCell(false);
            }
        }));
    }

    private void initDeleteHeader() {
        this.deleteHeader = new HBox();
        VBox.setMargin((Node)this.deleteHeader, (Insets)new Insets(3.0, 0.0, 10.0, 0.0));
        this.deleteHeader.setAlignment(Pos.CENTER_LEFT);
        this.deleteHeader.setMinHeight(32.0);
        this.deleteHeader.setMaxHeight(32.0);
        this.deleteHeader.setMinWidth(300.0);
        this.deleteHeader.setMaxWidth(300.0);
        this.myRadioButton = new MyRadioButton();
        HBox.setMargin((Node)this.myRadioButton, (Insets)new Insets(0.0, 18.0, 0.0, 8.0));
        this.myRadioButton.setRadioRadius(13);
        this.myRadioButton.setDotRadius(7);
        this.myRadioButton.setBorderColor("#646a7e");
        this.myRadioButton.setSelected(false);
        this.myRadioButton.setOnMouseClicked(mouseEvent -> {
            boolean isSelect = !this.myRadioButton.isSelected();
            this.myRadioButton.setSelected(isSelect);
            Optional<String> optional = ClientSingleton.getInstance().getStyle(Constants.TAB_CELL_TEXT_FILL);
            String sc = isSelect ? "#c2c5d2" : optional.orElse("#646a7e");
            this.myRadioButton.setBorderColor(sc);
            IntStream.range(0, this.dataInfoList.size()).forEach(i -> {
                String id = null;
                if (this.dataInfoList.get(i) instanceof SessionInfo) {
                    if (this.dataInfoList.get(i) instanceof CallDateHandler || this.dataInfoList.get(i) instanceof CallHandler) {
                        id = ((SessionInfo)this.dataInfoList.get(i)).getSessionId();
                    }
                } else if (this.dataInfoList.get(i) instanceof ContactInfo) {
                    id = ClientSingleton.getInstance().getUserID((ContactInfo)this.dataInfoList.get(i));
                }
                if (id != null) {
                    this.onSelectedCells(isSelect, id);
                }
                this.virtualFlow.getCellIfVisible(i).ifPresent(oCell -> {
                    Cell cell = oCell;
                    if (cell.getNode() instanceof CallCellView) {
                        CallCellView callCell = (CallCellView)cell.getNode();
                        callCell.setSelectCallCell();
                    } else if (cell.getNode() instanceof CallDateCellView) {
                        CallDateCellView callDateCellView = (CallDateCellView)cell.getNode();
                        callDateCellView.setSelectedDateCell(isSelect);
                    } else if (cell.getNode() instanceof ContactCellView) {
                        ContactCellView contactCell_view = (ContactCellView)cell.getNode();
                        contactCell_view.setSelectContactCell();
                    }
                });
            });
            this.selectedForDelete.set(this.selectedCells.size());
        });
        this.deleteHeader.getChildren().add((Object)this.myRadioButton);
        HBox hBox = new HBox();
        hBox.prefHeightProperty().bind((ObservableValue)this.deleteHeader.minHeightProperty());
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        hBox.prefHeightProperty().bind((ObservableValue)this.deleteHeader.heightProperty());
        Label label = new Label();
        label.prefHeightProperty().bind((ObservableValue)this.deleteHeader.minHeightProperty());
        hBox.getChildren().add((Object)label);
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        label.setText(ClientSingleton.getInstance().getString("call_transfer0"));
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)label);
        this.deleteHeader.getChildren().add((Object)hBox);
        HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        Label labelCancel = new Label();
        ClientSingleton.getInstance().setMouseCursor((Node)labelCancel);
        labelCancel.prefHeightProperty().bind((ObservableValue)this.deleteHeader.minHeightProperty());
        labelCancel.setText(ClientSingleton.getInstance().getString("cancel"));
        labelCancel.setTextFill((Paint)Color.web((String)WhiteLabels.getCustomBlueColor()));
        labelCancel.setFont(Font.font((String)"HelveticaNeue", (FontWeight)FontWeight.SEMI_BOLD, (double)12.0));
        labelCancel.setOnMouseClicked(event -> {
            this.selectedCells.clear();
            this.removeMultiSelectionMode();
        });
        HBox.setMargin((Node)labelCancel, (Insets)new Insets(0.0, 15.0, 10.0, 0.0));
        this.deleteHeader.getChildren().add((Object)labelCancel);
    }

    private void initDeleteFooter() {
        this.deleteFooter = new GridPane();
        this.deleteFooter.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
        this.deleteFooter.setStyle("-fx-border-width: 1 0 0 0; -fx-border-insets: 1 0 0 0;-fx-border-color:  " + ClientSingleton.getInstance().getStyleValue(Constants.SUBJECT_TEXT_FILL));
        this.deleteFooter.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract(10));
    }

    private ImageButtonWithLabel getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = ImageButtonWithLabel.getInstance().setImagePath("group/contacts/contacts_group_delete.png").setLabelText(ClientSingleton.getInstance().getString("delete")).setLabelStyle("-fx-text-fill:#e65d5d;").addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.deleteMenu())).build();
        }
        return this.deleteButton;
    }

    private void deleteMenu() {
        String title = this.getCurrentTab() == 2 ? ClientSingleton.getInstance().getString("chat_clear_all_contacts") : ClientSingleton.getInstance().getString("chat_clear_all_calls");
        MyAlert myMessageAlert = new MyAlert();
        myMessageAlert.setMessage(title).addPositiveButton(ClientSingleton.getInstance().getString("delete"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            myMessageAlert.hide();
            this.doSelectionAction(this::deleteCells);
        })).addNegativeButton(ClientSingleton.getInstance().getString("cancel"), (EventHandler<MouseEvent>)((EventHandler)event1 -> myMessageAlert.close())).setAlwaysOnTop(true).buildDialogAndShow();
    }

    private void deleteGroupMenu() {
        String title = ClientSingleton.getInstance().getString("chat_delete_group");
        MyAlert myMessageAlert = new MyAlert();
        myMessageAlert.setMessage(title).addPositiveButton(ClientSingleton.getInstance().getString("delete"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            myMessageAlert.hide();
            ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("call_delete_message"));
            MyThreadPoolManager.getInstance().execute(this::deleteGroup);
        })).addNegativeButton(ClientSingleton.getInstance().getString("cancel"), (EventHandler<MouseEvent>)((EventHandler)event1 -> myMessageAlert.close())).setAlwaysOnTop(true).buildDialogAndShow();
    }

    private void deleteGroup() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            try {
                String groupName = this.groupContactInfoHeader.toString();
                String groupId = clientConnector.getContactListId(groupName);
                clientConnector.deleteContactList(groupId);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
        ClientSingleton.getInstance().removeLoadingPane();
        this.clearerSelection();
        this.removeMultiSelectionMode();
        this.setGroupHeader(null);
    }

    private void doSelectionAction(BiConsumer<Boolean, List<String>> myAction) {
        ArrayList<String> list = new ArrayList<String>(this.selectedCells);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "doSelectionAction selectedCells.size()=" + list.size());
        MyRadioButton myRadioButton = (MyRadioButton)((Object)this.deleteHeader.getChildren().get(0));
        boolean deleteAll = myRadioButton.isSelected();
        if (!list.isEmpty()) {
            this.isDeletingSessions = true;
            myAction.accept(deleteAll, list);
        } else {
            this.clearerSelection();
        }
    }

    private void clearerSelection() {
        ClientSingleton.getInstance().runLater(() -> {
            MyRadioButton myRadioButton = (MyRadioButton)((Object)((Object)this.deleteHeader.getChildren().get(0)));
            myRadioButton.setSelected(false);
            this.removeMultiSelectionMode();
            this.iNewMessagesNotification.setSelectionHeader(null);
            this.deleteHeader.prefWidthProperty().unbind();
            this.selectedDates.clear();
            this.selectedCells.clear();
            this.selectedForDelete.set(0);
        });
    }

    private ImageButtonWithLabel getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = ImageButtonWithLabel.getInstance().setImagePath("group/contacts/contacts_group_remove.png").setLabelText(ClientSingleton.getInstance().getString("group_menu2")).addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.doSelectionAction(this::removeGroupMembers))).build();
        }
        return this.removeButton;
    }

    private ImageButtonWithLabel getImportButton() {
        if (this.importButton == null) {
            this.importButton = ImageButtonWithLabel.getInstance().setImagePath("group/contacts/contacts_group_import.png").setLabelText(ClientSingleton.getInstance().getString("contacts_import")).addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.doSelectionAction(this::doImport))).build();
        }
        return this.importButton;
    }

    private void doImport(Boolean aBoolean, List<String> list) {
        ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("call_import_message"));
        MyThreadPoolManager.getInstance().execute(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            clientConnector.uploadContacts((Collection)list.stream().map(this.groupContactInfoHeader::getMemberById).collect(Collectors.toList()), false);
            this.clearerSelection();
            ClientSingleton.getInstance().removeLoadingPane();
        }));
    }

    private ImageButtonWithLabelAndMenu getGroupButton() {
        if (this.groupButton == null) {
            this.groupButton = ImageButtonWithLabelAndMenu.getInstance().setImagePath("group/contacts/contacts_group_create.png").setLabelText(ClientSingleton.getInstance().getString("contacts_group")).build();
        }
        this.groupButton.clearMenu();
        this.groupButton.addItemToMenu(ClientSingleton.getInstance().getString("group_create_group"), (EventHandler<ActionEvent>)((EventHandler)action -> {
            ArrayList<String> selected = new ArrayList<String>(this.selectedCells);
            ContactsGroupCreatorEditor createContactProfileController = new ContactsGroupCreatorEditor();
            createContactProfileController.setGroupMembers(selected);
            createContactProfileController.show();
            this.clearerSelection();
            this.groupButton.hideMenu();
        }), "blue");
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            HashSet hashSet = (HashSet)clientConnector.getContactListNames();
            if (hashSet != null && !hashSet.isEmpty()) {
                ArrayList list = new ArrayList(hashSet);
                for (String title : list) {
                    this.groupButton.addMenuItem(title, (EventHandler<ActionEvent>)((EventHandler)action -> {
                        ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("call_group_message"));
                        MyThreadPoolManager.getInstance().execute(() -> {
                            ArrayList<String> selected = new ArrayList<String>(this.selectedCells);
                            if (selected != null && !selected.isEmpty()) {
                                String groupId = clientConnector.getContactListId(title);
                                List ids = clientConnector.getContactList(title);
                                ids.addAll(selected);
                                try {
                                    clientConnector.updateContactList(groupId, title, ids);
                                    if (this.groupContactInfoHeader != null) {
                                        this.groupContactInfoHeader.removeMembers(list);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            ClientSingleton.getInstance().removeLoadingPane();
                        });
                        this.clearerSelection();
                        this.groupButton.hideMenu();
                    }));
                }
            }
        });
        return this.groupButton;
    }

    private ImageButtonWithLabel getShareButton() {
        if (this.shareButton == null) {
            this.shareButton = ImageButtonWithLabel.getInstance().setImagePath("group/contacts/contacts_group_share.png").setLabelText(ClientSingleton.getInstance().getString("message_menu_share")).addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.doSelectionAction(this::doShare))).build();
        }
        return this.shareButton;
    }

    private ImageButtonWithLabel getFavoriteButton() {
        if (this.favoriteButton == null) {
            this.favoriteButton = ImageButtonWithLabel.getInstance().setImagePath("group/contacts/contacts_group_favorite.png").setLabelText(ClientSingleton.getInstance().getString("contacts_favorites")).addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "doFavorite " + this.selectedCells.size());
                this.doSelectionAction(this::doFavorite);
            })).build();
        }
        return this.favoriteButton;
    }

    private void onSelectedCells(boolean select, String cellId) {
        if (select) {
            if (!this.selectedCells.contains(cellId)) {
                this.selectedCells.add(cellId);
            }
        } else {
            this.selectedCells.remove(cellId);
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "onSelectedCells selectedCells = " + this.selectedCells.size());
    }

    private void onSelectedDateCells(boolean select, String sessionId) {
        if (select) {
            if (!this.selectedDates.contains(sessionId)) {
                this.selectedDates.add(sessionId);
            }
        } else {
            this.selectedDates.remove(sessionId);
        }
    }

    public void setGroupHeader(ContactInfoHeader groupContactInfoHeader) {
    }

    private boolean isNewContact(ContactInfo contactInfo) {
        return "".equals(contactInfo.getName()) || contactInfo.getStatus() == 0;
    }

    private void doFavorite(Boolean isAll, List<String> list) {
        ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("call_group_message"));
        MyThreadPoolManager.getInstance().execute(() -> {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "doFavorite list = " + list);
                for (String id : list) {
                    ContactInfo contactInfo = clientConnector.getContact(id);
                    if (contactInfo == null) continue;
                    try {
                        if (contactInfo.getStatus() == -1 || "".equals(contactInfo.getName())) {
                            if ("".equals(contactInfo.getName())) {
                                contactInfo.setName(contactInfo.toString());
                            }
                            contactInfo.setStatus(4);
                            contactInfo.setFavorite(true);
                            try {
                                clientConnector.setContactInfo(contactInfo, false);
                                Thread.sleep(100L);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            contactInfo.setFavorite(true);
                            clientConnector.updateContactStatus(contactInfo, contactInfo.getStatus());
                        }
                        if (this.groupContactInfoHeader == null || this.groupContactInfoHeader.getType() != 3) continue;
                        this.groupContactInfoHeader.removeMember(contactInfo);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ClientSingleton.getInstance().doNotify(IntentConstants.CONTACT_STATUS_CHANGED);
            });
            this.clearerSelection();
            ClientSingleton.getInstance().removeLoadingPane();
        });
    }

    private void doShare(Boolean isAll, List<String> list) {
        ArrayList<ContactInfo> contactInfoList = new ArrayList<ContactInfo>();
        for (String id : list) {
            ContactInfo contactInfo = ClientSingleton.getInstance().getClientConnector().get().getContact(id);
            if (contactInfo == null) continue;
            contactInfoList.add(contactInfo);
        }
        this.clearerSelection();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "doShare contactInfoList = " + contactInfoList);
        ClientSingleton.getInstance().shareContactList(contactInfoList);
    }

    private void removeGroupMembers(Boolean isAll, List<String> list) {
        ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("call_removing_message"));
        UpdateListThreadPoolManager.getInstance().execute(() -> {
            AtomicBoolean returnLabel = new AtomicBoolean(false);
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                if (this.groupContactInfoHeader != null) {
                    try {
                        if (this.groupContactInfoHeader.getType() == 6) {
                            for (String id : list) {
                                ContactInfo contactInfo = clientConnector.getContact(id);
                                if (contactInfo == null) continue;
                                try {
                                    contactInfo.setFavorite(false);
                                    clientConnector.updateContactStatus(contactInfo, contactInfo.getStatus());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            ClientSingleton.getInstance().doNotify(IntentConstants.CONTACT_STATUS_CHANGED);
                        } else if (this.groupContactInfoHeader.getType() == 5) {
                            try {
                                if (list.size() == this.groupContactInfoHeader.getMemberLists().size()) {
                                    ClientSingleton.getInstance().runLater(this::deleteGroupMenu);
                                    returnLabel.set(true);
                                    return;
                                }
                                this.updateAfterRemove(list, (ClientConnector)clientConnector);
                            }
                            catch (Exception exception) {
                                ClientSingleton.getInstance().removeLoadingPane();
                                exception.printStackTrace();
                            }
                        }
                        this.groupContactInfoHeader.removeMembers(list);
                        this.setGroupHeader(this.groupContactInfoHeader);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.isDeletingSessions = false;
            });
            ClientSingleton.getInstance().removeLoadingPane();
            if (!returnLabel.get()) {
                this.clearerSelection();
            }
        });
    }

    private void updateAfterRemove(List<String> list, ClientConnector clientConnector) throws Exception {
        String groupName = this.groupContactInfoHeader.toString();
        String groupId = clientConnector.getContactListId(groupName);
        ArrayList<String> isForRemove = new ArrayList<String>();
        for (ContactInfo contactInfo : this.groupContactInfoHeader.getMemberLists()) {
            String id = ClientSingleton.getInstance().getUserID(contactInfo);
            if (list.contains(id)) continue;
            isForRemove.add(id);
        }
        clientConnector.updateContactList(groupId, groupName, isForRemove);
    }

    private void deleteCells(boolean deleteAll, List<String> list) {
        ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("call_delete_message"));
        UpdateListThreadPoolManager.getInstance().execute(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            if (this.getCurrentTab() == 4) {
                if (deleteAll) {
                    try {
                        clientConnector.removeCallHistory(null);
                        this.iNewMessagesNotification.clearSelection();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    for (String sessionId : list) {
                        try {
                            clientConnector.removeCallHistory(sessionId);
                            this.iNewMessagesNotification.getSelectedItemId().ifPresent(sessionInfoId -> {
                                if (Objects.equals(sessionInfoId, sessionId)) {
                                    this.iNewMessagesNotification.clearSelection();
                                }
                            });
                            Thread.sleep(50L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                for (int i = list.size() - 1; i >= 0; --i) {
                    String userId = (String)list.get(i);
                    Optional<ContactInfo> optional = ClientSingleton.getInstance().getContactInfoByUserId(userId);
                    if (optional.isEmpty() || !optional.get().canBeDeleted()) continue;
                    ContactInfo contactInfo = optional.get();
                    try {
                        clientConnector.deleteContact(contactInfo);
                        this.iNewMessagesNotification.getSelectedItemId().ifPresent(sessionInfoId -> {
                            if (Objects.equals(sessionInfoId, userId)) {
                                this.iNewMessagesNotification.clearSelection();
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                ClientSingleton.toLog(this.getClass().getSimpleName(), "deleteCells " + list);
                if (this.groupContactInfoHeader != null) {
                    if (list.size() == this.groupContactInfoHeader.getMemberLists().size()) {
                        this.deleteGroup();
                        this.isDeletingSessions = false;
                        return;
                    }
                    try {
                        this.updateAfterRemove(list, (ClientConnector)clientConnector);
                        this.setGroupHeader(this.groupContactInfoHeader);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.isDeletingSessions = false;
            if (this.getCurrentTab() == 4) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.getCurrentTab() == 4) {
                this.updateList(SCROLL_TO_TOP);
            }
            this.clearerSelection();
            ClientSingleton.getInstance().removeLoadingPane();
        }));
    }

    public ContactInfoHeader getGroupContactInfoHeader() {
        return this.groupContactInfoHeader;
    }
}

