/*
 * Decompiled with CFR 0.152.
 */
package com.smile.net;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.Random;

public class StunClient {
    public static final int DEFAULT_UDP_PORT = 3478;
    public static final int MAXBUFSIZE = 1024;
    public static final byte[] MAGIC_COOKIE = new byte[]{33, 18, -92, 66};
    public static Random random = new Random(System.currentTimeMillis());
    private DatagramSocket socket;
    private String returnAddress;
    private int returnPort;
    private String retAddress;
    private int retPort;
    private String otherAddress;
    private int otherPort;

    public StunClient(DatagramSocket socket) {
        this.socket = socket;
    }

    public void sendRequest(InetAddress serverAddress, int serverPort) {
        this.sendRequest(serverAddress, serverPort, 0);
    }

    public void sendRequest(InetAddress serverAddress, int serverPort, int chmode) {
        this.returnAddress = null;
        this.retAddress = null;
        this.otherAddress = null;
        this.returnPort = 0;
        this.retPort = 0;
        this.otherPort = 0;
        int blen = chmode != 0 ? 28 : 20;
        byte[] b = new byte[blen];
        b[0] = 0;
        b[1] = 1;
        b[2] = 0;
        b[3] = (byte)(blen - 20);
        b[4] = MAGIC_COOKIE[0];
        b[5] = MAGIC_COOKIE[1];
        b[6] = MAGIC_COOKIE[2];
        b[7] = MAGIC_COOKIE[3];
        long s = System.currentTimeMillis();
        b[8] = (byte)(s >> 56);
        b[9] = (byte)(s >> 48);
        b[10] = (byte)(s >> 40);
        b[11] = (byte)(s >> 32);
        b[12] = (byte)(s >> 24);
        b[13] = (byte)(s >> 16);
        b[14] = (byte)(s >> 8);
        b[15] = (byte)s;
        int n = random.nextInt();
        b[16] = (byte)(n >> 24);
        b[17] = (byte)(n >> 16);
        b[18] = (byte)(n >> 8);
        b[19] = (byte)n;
        if (chmode != 0) {
            b[20] = 0;
            b[21] = 3;
            b[22] = 0;
            b[23] = 4;
            b[24] = 0;
            b[25] = 0;
            b[26] = 0;
            b[27] = (byte)chmode;
        }
        DatagramPacket packet = new DatagramPacket(b, blen);
        packet.setAddress(serverAddress);
        packet.setPort(serverPort);
        byte[] r = new byte[1024];
        DatagramPacket rcvpacket = new DatagramPacket(r, 1024);
        try {
            this.socket.setSoTimeout(500);
            for (int i = 0; i < 4; ++i) {
                this.socket.send(packet);
                try {
                    this.socket.receive(rcvpacket);
                    this.onResponse(rcvpacket);
                    if (this.returnAddress == null) continue;
                    break;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.setSoTimeout(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getReturnAddress() {
        return this.returnAddress;
    }

    public int getReturnPort() {
        return this.returnPort;
    }

    public String getOtherAddress() {
        return this.otherAddress;
    }

    public int getOtherPort() {
        return this.otherPort;
    }

    private synchronized void onResponse(DatagramPacket packet) {
        InetAddress address = packet.getAddress();
        int port = packet.getPort();
        byte[] b = packet.getData();
        int cmd = (b[0] & 0xFF) << 8 | b[1] & 0xFF;
        int mlen = (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        int mc = (b[4] & 0xFF) << 24 | (b[5] & 0xFF) << 16 | (b[6] & 0xFF) << 8 | b[7] & 0xFF;
        int i = 20;
        int m = i + mlen;
        while (i < m) {
            int iptype;
            int atype = (b[i++] & 0xFF) << 8 | b[i++] & 0xFF;
            int alen = (b[i++] & 0xFF) << 8 | b[i++] & 0xFF;
            if (atype == 1) {
                iptype = (b[i++] & 0xFF) << 8 | b[i++] & 0xFF;
                this.retPort = (b[i++] & 0xFF) << 8 | b[i++] & 0xFF;
                this.retAddress = (b[i++] & 0xFF) + "." + (b[i++] & 0xFF) + "." + (b[i++] & 0xFF) + "." + (b[i++] & 0xFF);
                continue;
            }
            if (atype == 32) {
                iptype = (b[i++] & 0xFF) << 8 | b[i++] & 0xFF;
                this.returnPort = ((b[i++] ^ 0x21) & 0xFF) << 8 | (b[i++] ^ 0x12) & 0xFF;
                this.returnAddress = ((b[i++] ^ MAGIC_COOKIE[0]) & 0xFF) + "." + ((b[i++] ^ MAGIC_COOKIE[1]) & 0xFF) + "." + ((b[i++] ^ MAGIC_COOKIE[2]) & 0xFF) + "." + ((b[i++] ^ MAGIC_COOKIE[3]) & 0xFF);
                continue;
            }
            if (atype != 32812) continue;
            iptype = (b[i++] & 0xFF) << 8 | b[i++] & 0xFF;
            this.otherPort = (b[i++] & 0xFF) << 8 | b[i++] & 0xFF;
            this.otherAddress = (b[i++] & 0xFF) + "." + (b[i++] & 0xFF) + "." + (b[i++] & 0xFF) + "." + (b[i++] & 0xFF);
        }
        if (this.returnAddress == null && this.retAddress != null) {
            this.returnAddress = this.retAddress;
            this.returnPort = this.retPort;
        }
        this.notify();
    }
}

