/*
 * Decompiled with CFR 0.152.
 */
package com.smile.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.Random;
import java.util.Vector;
import smile.util.ResourceStore;
import smile.util.Utils;
import smile.web.client.HttpRequest;
import smile.web.client.SocketChannel;

public class WebSocket
implements Runnable {
    private static final int MAX_PAYLOAD_LENGTH = 20000000;
    public static final int NORMAL_CLOSING = 1000;
    public static final int GOING_AWAY = 1001;
    public static final int PROTOCOL_ERROR = 1002;
    public static final int UNSUPPORTED_DATA_TYPE = 1003;
    public static final int NO_STATUS_CODE = 1005;
    public static final int ABNORMAL_TERMINATION = 1006;
    public static final int INCONSISTENT_DATA = 1007;
    public static final int POLICY_EXCEPTION = 1008;
    public static final int MESSAGE_TOO_BIG = 1009;
    public static final int EXTENSION_NOT_PRESENT = 1010;
    public static final int UNEXPECTED_CONDITION = 1011;
    public static final int TLS_HANDSHAKE_FAILURE = 1015;
    public static final int OPT_TEXT = 1;
    public static final int OPT_BINARY = 2;
    public static final int OPT_CLOSE = 8;
    public static final int OPT_PING = 9;
    public static final int OPT_PONG = 10;
    private SocketChannel channel;
    private MessageSender sender;
    private InputStream socketInputStream;
    private OutputStream outputStream;
    private Random random;
    private boolean hdr = false;
    private boolean fin;
    private byte mask1;
    private byte mask2;
    private byte mask3;
    private byte mask4;
    private int optcode;
    private int keepalive;
    private boolean closed;

    public WebSocket(String url, String protocol, String username, String password, String proxy) throws Exception {
        HttpRequest request = new HttpRequest(url, proxy);
        request.setCredentials(username, password);
        request.setHeader("Upgrade", "websocket");
        request.setHeader("Connection", "Upgrade");
        Object key = Utils.encodeBase64String(Utils.createCallId().getBytes());
        request.setHeader("Sec-WebSocket-Key", (String)key);
        request.setHeader("Sec-WebSocket-Protocol", protocol);
        request.setHeader("Sec-WebSocket-Version", "13");
        int status = request.get();
        if (status != 101) {
            throw new Exception("HTTP response code: " + status);
        }
        key = (String)key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] digest = md.digest(((String)key).getBytes());
        String responseKey = Utils.encodeBase64String(digest);
        if (!responseKey.equals(request.getResponseHeader("Sec-WebSocket-Accept"))) {
            throw new Exception("Invalid Sec-WebSocket-Accept value");
        }
        String h = request.getResponseHeader("Keep-Alive");
        if (h != null) {
            this.keepalive = Integer.parseInt(h.trim());
        }
        this.channel = request.getChannel();
        this.socketInputStream = request.getInputStream();
        this.outputStream = request.getOutputStream();
        this.random = new Random(System.currentTimeMillis());
        this.sender = new MessageSender();
        new Thread(this).start();
    }

    public boolean isServer() {
        return false;
    }

    public InetAddress getInetAddress() {
        return this.channel.getInetAddress();
    }

    public int getPort() {
        return this.channel.getPort();
    }

    public InetAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    public int getLocalPort() {
        return this.channel.getLocalPort();
    }

    public String getProtocol() {
        return this.channel.getProtocol();
    }

    public int getKeepAlive() {
        return this.keepalive;
    }

    public String getHost() {
        return this.getInetAddress().getHostAddress();
    }

    public void close() {
        ResourceStore.toLog(this + " close closed=" + this.closed);
        if (!this.closed) {
            this.closed = true;
            try {
                this.channel.close();
            }
            catch (Exception e) {
                ResourceStore.toLog(this + " close - " + e);
            }
        }
    }

    protected void onClose() {
        this.onClose(1005, 0);
    }

    @Override
    public void run() {
        ResourceStore.toLog(this + " read thread started");
        try {
            while (!this.parse()) {
                Thread.sleep(20L);
            }
        }
        catch (Exception e) {
            ResourceStore.toLog(this + " read thread - " + e);
        }
        this.closeConnection(1011, 0);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length < 1) {
            length = 1;
        }
        return this.socketInputStream.read(buffer, offset, length);
    }

    public boolean parse() throws IOException {
        byte[] msg = null;
        byte[] buf = new byte[20000000];
        int i = 0;
        int j = 0;
        int plength = 0;
        int readBytes = 0;
        while (readBytes > 0 || (readBytes = this.read(buf, i, plength - (i - j))) > 0) {
            i += readBytes;
            readBytes = 0;
            if (!this.hdr) {
                if (i < 2) continue;
                this.fin = (buf[0] & 0x80) != 0;
                this.optcode = buf[0] & 0xF;
                boolean m = (buf[1] & 0x80) != 0;
                plength = buf[1] & 0x7F;
                j = 2;
                if (plength == 0 && m && i < 6) continue;
                if (plength < 126) {
                    if (i < 6) {
                        continue;
                    }
                } else if (plength == 126) {
                    if (i < 8) continue;
                    plength = ((buf[2] & 0xFF) << 8) + (buf[3] & 0xFF);
                    j = 4;
                } else if (plength == 127) {
                    if (i < 14) continue;
                    plength = ((buf[6] & 0xFF) << 24) + ((buf[7] & 0xFF) << 16) + ((buf[8] & 0xFF) << 8) + (buf[9] & 0xFF);
                    j = 10;
                }
                if (m) {
                    this.mask1 = buf[j++];
                    this.mask2 = buf[j++];
                    this.mask3 = buf[j++];
                    this.mask4 = buf[j++];
                }
                if (plength > buf.length - j) {
                    // empty if block
                }
                this.hdr = true;
            }
            if (!this.hdr || i - j < plength) continue;
            int k = plength + j;
            if (plength > 0) {
                int n = 0;
                if (msg == null) {
                    msg = new byte[plength];
                } else {
                    n = msg.length;
                    byte[] b = new byte[n + plength];
                    System.arraycopy(msg, 0, b, 0, n);
                    msg = b;
                }
                do {
                    msg[n++] = (byte)(buf[j] ^ this.mask1);
                    if (++j == k) break;
                    msg[n++] = (byte)(buf[j] ^ this.mask2);
                    if (++j == k) break;
                    msg[n++] = (byte)(buf[j] ^ this.mask3);
                    if (++j == k) break;
                    msg[n++] = (byte)(buf[j] ^ this.mask4);
                } while (++j != k);
            }
            if ((k = i - k) > 0) {
                for (int p = 0; p < k; ++p) {
                    buf[p] = buf[j + p];
                }
            }
            readBytes = k;
            i = 0;
            j = 0;
            this.hdr = false;
            plength = 0;
            if (!this.fin) continue;
            switch (this.optcode) {
                case 1: 
                case 2: {
                    this.processFrame(msg);
                    break;
                }
                case 8: {
                    this.processClose(msg);
                    break;
                }
                case 9: {
                    this.processPing(msg);
                    break;
                }
                case 10: {
                    this.processPong(msg);
                    break;
                }
            }
            msg = null;
        }
        return readBytes == -1;
    }

    protected void onTextFrame(byte[] data) {
    }

    protected void onBinaryFrame(byte[] data) {
    }

    protected void onClose(int code, int cause) {
    }

    protected void onPing(String data) {
        this.sendPong(data);
    }

    protected void onPong(String data) {
    }

    protected void processPing(byte[] msg) {
        Ping ping = new Ping(msg);
        new Thread(ping).start();
    }

    protected void processPong(byte[] msg) {
        Pong pong = new Pong(msg);
        new Thread(pong).start();
    }

    protected void processFrame(byte[] msg) {
        if (msg == null) {
            return;
        }
        Frame frame = new Frame(this.optcode, msg);
        new Thread(frame).start();
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeConnection(int statusCode, int reason) {
        ResourceStore.toLog(this + " closeConnection " + statusCode + " closed=" + this.closed);
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.onClose(statusCode, reason);
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendTextFrame(byte[] data) throws IOException {
        if (this.closed) {
            throw new IOException("Channel closed");
        }
        this.sendFrame(data, 1);
    }

    public void sendBinaryFrame(byte[] data) {
        this.sendFrame(data, 2);
    }

    private void sendFrame(byte[] msg, int type) {
        int plen = msg.length;
        int hlen = 2;
        if (plen > 65535) {
            hlen = 10;
        } else if (plen > 125) {
            hlen = 4;
        }
        int dlen = plen + (this.isServer() ? hlen : hlen + 4);
        byte[] data = new byte[dlen];
        data[0] = (byte)(0x80 | type);
        if (hlen == 2) {
            data[1] = (byte)plen;
        } else if (hlen == 4) {
            data[1] = 126;
            data[2] = (byte)(plen >> 8);
            data[3] = (byte)plen;
        } else {
            data[1] = 127;
            data[2] = 0;
            data[3] = 0;
            data[4] = 0;
            data[5] = 0;
            data[6] = (byte)(plen >> 24);
            data[7] = (byte)(plen >> 16);
            data[8] = (byte)(plen >> 8);
            data[9] = (byte)plen;
        }
        if (this.isServer()) {
            for (int n = 0; n < plen; ++n) {
                data[n + hlen] = msg[n];
            }
        } else {
            this.setMasked(msg, data, hlen);
        }
        this.sendData(data);
    }

    private void setMasked(byte[] src, byte[] dest, int doff) {
        int slen = src.length;
        dest[1] = (byte)(dest[1] | 0x80);
        byte[] mask = new byte[4];
        this.random.nextBytes(mask);
        dest[doff++] = mask[0];
        dest[doff++] = mask[1];
        dest[doff++] = mask[2];
        dest[doff++] = mask[3];
        int n = 0;
        do {
            dest[doff++] = (byte)(src[n++] ^ mask[0]);
            if (n == slen) break;
            dest[doff++] = (byte)(src[n++] ^ mask[1]);
            if (n == slen) break;
            dest[doff++] = (byte)(src[n++] ^ mask[2]);
            if (n == slen) break;
            dest[doff++] = (byte)(src[n++] ^ mask[3]);
        } while (n != slen);
    }

    private void processClose(byte[] data) {
        int code = 1005;
        int reason = 0;
        if (data != null && data.length > 3) {
            code = ((data[0] & 0xFF) << 8) + (data[1] & 0xFF);
            reason = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
        }
        ResourceStore.toLog(this + " processClose code=" + code + " reason=" + reason);
        this.closeConnection(code, reason);
    }

    private void sendClose(byte[] msg) {
        int dlength = msg != null ? msg.length : 0;
        int dlen = dlength + (this.isServer() ? 2 : 6);
        byte[] data = new byte[dlen];
        data[0] = -120;
        data[1] = (byte)dlength;
        if (dlength != 0) {
            if (this.isServer()) {
                for (int n = 0; n < dlength; ++n) {
                    data[n + 2] = msg[n];
                }
            } else {
                this.setMasked(msg, data, 2);
            }
        }
        this.sendData(data);
    }

    public void sendClose(int code, int reason) {
        byte[] data = new byte[]{(byte)(code >> 8), (byte)code, (byte)(reason >> 8), (byte)reason};
        this.sendClose(data);
    }

    public void sendPing(String message) {
        byte[] msg = message.getBytes();
        int dlen = msg.length + (this.isServer() ? 2 : 6);
        byte[] data = new byte[dlen];
        data[0] = -119;
        data[1] = (byte)msg.length;
        if (this.isServer()) {
            for (int n = 0; n < msg.length; ++n) {
                data[n + 2] = msg[n];
            }
        } else {
            this.setMasked(msg, data, 2);
        }
        this.sendData(data);
    }

    public void sendPong(String message) {
        byte[] msg = message.getBytes();
        int dlen = msg.length + (this.isServer() ? 2 : 6);
        byte[] data = new byte[dlen];
        data[0] = -118;
        data[1] = (byte)msg.length;
        if (this.isServer()) {
            for (int n = 0; n < msg.length; ++n) {
                data[n + 2] = msg[n];
            }
        } else {
            this.setMasked(msg, data, 2);
        }
        this.sendData(data);
    }

    private void sendData(byte[] data) {
        this.sender.add(data);
    }

    public String toString() {
        return this.getLocalAddress().getHostAddress() + ":" + this.getLocalPort();
    }

    class MessageSender
    implements Runnable {
        private boolean hasWrite;
        private Vector messages = new Vector();

        MessageSender() {
        }

        public synchronized void add(byte[] message) {
            this.messages.add(message);
            if (!this.hasWrite) {
                this.hasWrite = true;
                new Thread(this).start();
            }
        }

        public synchronized byte[] get() {
            if (this.messages.isEmpty()) {
                this.hasWrite = false;
                return null;
            }
            return (byte[])this.messages.remove(0);
        }

        @Override
        public void run() {
            byte[] message;
            while ((message = this.get()) != null) {
                ResourceStore.toLog(this + " send message " + message.length + " bytes");
                try {
                    WebSocket.this.outputStream.write(message);
                    WebSocket.this.outputStream.flush();
                }
                catch (Exception e) {
                    ResourceStore.toLog(this + " " + e);
                    WebSocket.this.closeConnection(1006, 0);
                    break;
                }
            }
            ResourceStore.toLog(this + " sender thread ended");
        }
    }

    class Pong
    implements Runnable {
        String message;

        public Pong(byte[] data) {
            this.message = data != null ? new String(data) : "";
        }

        @Override
        public void run() {
            WebSocket.this.onPong(this.message);
        }
    }

    class Ping
    implements Runnable {
        String message;

        public Ping(byte[] data) {
            this.message = data != null ? new String(data) : "";
        }

        @Override
        public void run() {
            WebSocket.this.onPing(this.message);
        }
    }

    class Frame
    implements Runnable {
        int type;
        byte[] data;

        public Frame(int type, byte[] data) {
            this.type = type;
            this.data = data;
        }

        @Override
        public void run() {
            if (this.type == 1) {
                WebSocket.this.onTextFrame(this.data);
            } else {
                WebSocket.this.onBinaryFrame(this.data);
            }
        }
    }
}

