/*
 * Decompiled with CFR 0.152.
 */
package com.smile.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import smile.util.ResourceStore;

public class TrustManager
implements X509TrustManager {
    private static List<X509TrustManager> pkixTrustManagers;
    private static X509Certificate[] acceptedIssuers;
    private InetAddress serverAddress;

    public TrustManager(InetAddress iaddress) {
        this.serverAddress = iaddress;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        String acceptedCNs = System.getProperty("acceptedCNs");
        boolean noverifycert = "*".equals(acceptedCNs) || "true".equals(System.getProperty("noverifycert"));
        boolean trusted = false;
        for (int i = 0; i < pkixTrustManagers.size(); ++i) {
            try {
                pkixTrustManagers.get(i).checkServerTrusted(chain, authType);
                trusted = true;
                break;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        if (!trusted && !noverifycert) {
            String err = "Untrusted certificate " + (noverifycert ? "accepted" : " not accepted") + ": {";
            for (int i = 0; i < chain.length; ++i) {
                err = err + " [" + chain[i].getSubjectX500Principal().getName() + "] ";
            }
            err = err + "}";
            ResourceStore.toLog(err);
            if (!noverifycert && !this.serverAddress.isSiteLocalAddress()) {
                throw new CertificateException(err);
            }
        }
        if (noverifycert) {
            return;
        }
        ArrayList<String> cns = new ArrayList<String>();
        if (acceptedCNs != null) {
            String[] s = acceptedCNs.split(",");
            for (int i = 0; i < s.length; ++i) {
                cns.add(s[i]);
            }
        }
        String serverName = this.serverAddress.getHostName();
        X509Certificate cert = chain[0];
        String name = cert.getSubjectX500Principal().getName();
        int n = name.indexOf("CN=");
        if (n != -1) {
            String cn = name.substring(n + 3);
            if ((n = cn.indexOf(44)) != -1) {
                cn = cn.substring(0, n);
            }
            cn.trim();
            ResourceStore.toLog("cn=" + cn + " serverName=" + serverName + " serverAddress=" + this.serverAddress + " host=" + this.serverAddress.getHostAddress() + " cns=" + cns);
            if (cn.equals(serverName) || cn.equals(this.serverAddress.getHostAddress()) || this.serverAddress.isSiteLocalAddress() || cns.contains(cn) || cn.equals(serverName.substring(serverName.indexOf(46) + 1))) {
                return;
            }
            if (cn.startsWith("*.") && (serverName.endsWith(cn.substring(1)) || serverName.equals(cn.substring(2)))) {
                return;
            }
            try {
                InetAddress inetAddress = InetAddress.getByName(cn);
                if (this.serverAddress.equals(inetAddress)) {
                    return;
                }
                if (inetAddress instanceof Inet6Address && cn.substring(cn.indexOf(46) + 1).equals(serverName.substring(serverName.indexOf(46) + 1))) {
                    return;
                }
                InetAddress[] addresses = InetAddress.getAllByName(serverName);
                for (int i = 0; i < addresses.length; ++i) {
                    ResourceStore.toLog("cn=" + cn + " serverName=" + serverName + " inetAddress=" + inetAddress + " host=" + addresses[i]);
                    if (!addresses[i].equals(inetAddress)) continue;
                    return;
                }
            }
            catch (UnknownHostException e) {
                ResourceStore.toLog(e.toString());
            }
            Collection<List<?>> alternativeNames = cert.getSubjectAlternativeNames();
            if (alternativeNames != null) {
                for (List<?> list : alternativeNames) {
                    String altName = list.get(1).toString();
                    if (!altName.equals(serverName) && (!altName.startsWith("*.") || !serverName.endsWith(altName.substring(1)) && !serverName.equals(altName.substring(2))) && !cns.contains(altName)) continue;
                    return;
                }
            }
        }
        throw new CertificateException("Untrusted certificate. Target host name " + serverName + " does not match CN from the server certificate (" + name + ")");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return acceptedIssuers;
    }

    public static KeyStore getkeyStore(String ksFile, char[] ks_password) throws Exception {
        KeyStore keyStore = TrustManager.loadkeyStoreFromJar(ksFile, ks_password);
        if (keyStore == null) {
            keyStore = TrustManager.loadkeyStore(ksFile, ks_password);
        }
        return keyStore;
    }

    public static KeyStore loadkeyStoreFromJar(String ksFile, char[] password) {
        try {
            InputStream input = TrustManager.class.getClassLoader().getResourceAsStream(ksFile);
            if (input == null) {
                return null;
            }
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(input, password);
            input.close();
            return keyStore;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static KeyStore loadkeyStore(String ksFile, char[] password) throws Exception {
        File keystoreFile = new File(System.getProperty("user.home"), ksFile);
        if (!keystoreFile.exists()) {
            return null;
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        FileInputStream input = new FileInputStream(keystoreFile);
        keyStore.load(input, password);
        ((InputStream)input).close();
        return keyStore;
    }

    static {
        String[] ksFiles = new String[]{"security/cacert.p12", "security/cacerts.p12"};
        char[] ks_password = new char[]{};
        pkixTrustManagers = new ArrayList<X509TrustManager>();
        Vector<X509Certificate> issuers = new Vector<X509Certificate>();
        for (int i = 0; i < ksFiles.length; ++i) {
            try {
                KeyStore ks = TrustManager.getkeyStore(ksFiles[i], ks_password);
                if (ks == null) continue;
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
                tmf.init(ks);
                X509TrustManager trustManager = (X509TrustManager)tmf.getTrustManagers()[0];
                X509Certificate[] icerts = trustManager.getAcceptedIssuers();
                for (int j = 0; j < icerts.length; ++j) {
                    issuers.add(icerts[j]);
                }
                pkixTrustManagers.add(trustManager);
                continue;
            }
            catch (Throwable e) {
                ResourceStore.error("TrustManager", e);
            }
        }
        acceptedIssuers = new X509Certificate[issuers.size()];
        issuers.copyInto(acceptedIssuers);
        ResourceStore.toLog("TrustManager acceptedIssuers " + acceptedIssuers.length + " pkixTrustManagers=" + pkixTrustManagers.size());
    }
}

