/*
 * Decompiled with CFR 0.152.
 */
package com.smile.sound;

import com.smile.sound.audioFormat;

public class WavAudioFormat
extends audioFormat {
    public static final WavAudioFormat PCM8_ULAW = new WavAudioFormat(8000, 1, 2, 2);
    public static final WavAudioFormat PCM8_ALAW = new WavAudioFormat(8000, 1, 2, 6);
    public static final WavAudioFormat PCM_LINEAR16 = new WavAudioFormat(8000, 1, 2, 10);
    public static final WavAudioFormat PCM_LINEAR8 = new WavAudioFormat(8000, 1, 2, 3);
    public static final WavAudioFormat PCM_8KHZ = new WavAudioFormat(8000, 1, 2, 7);
    public static final WavAudioFormat PCM_6KHZ = new WavAudioFormat(6000, 1, 2, 7);
    public static final WavAudioFormat PCM_11KHZ = new WavAudioFormat(11025, 1, 2, 7);
    public static final WavAudioFormat ADPCM_8KHZ = new WavAudioFormat(8000, 1, 2, 23);
    public static final WavAudioFormat ADPCM_6KHZ = new WavAudioFormat(6000, 1, 2, 23);
    public static final WavAudioFormat PCM6_ULAW = new WavAudioFormat(6000, 1, 2, 2);
    public static final WavAudioFormat PCM6_ALAW = new WavAudioFormat(6000, 1, 2, 6);
    public static final WavAudioFormat G7231 = new WavAudioFormat(8000, 1, 2, 66);
    public static final WavAudioFormat TRUESPEECH = new WavAudioFormat(8000, 1, 2, 34);
    public static final WavAudioFormat G729 = new WavAudioFormat(8000, 1, 2, 73);
    public static final WavAudioFormat GSM610 = new WavAudioFormat(8000, 1, 2, 50);
    public static final WavAudioFormat MSGSM = new WavAudioFormat(8000, 1, 2, 49);
    public static final WavAudioFormat OPUSNB = new WavAudioFormat(8000, 1, 2, 110);
    public static final WavAudioFormat OPUSWB = new WavAudioFormat(8000, 1, 2, 111);
    public static final WavAudioFormat[] DECODERS = new WavAudioFormat[]{PCM_LINEAR16, PCM8_ALAW, PCM8_ULAW};

    public static WavAudioFormat getWavAudioFormat(String name) {
        if (name.equals("PCM16")) {
            return PCM_LINEAR16;
        }
        if (name.equalsIgnoreCase("PCM8linear")) {
            return PCM_LINEAR8;
        }
        if (name.equalsIgnoreCase("ulaw")) {
            return PCM8_ULAW;
        }
        if (name.equalsIgnoreCase("alaw")) {
            return PCM8_ALAW;
        }
        if (name.equalsIgnoreCase("PCM8")) {
            return PCM_8KHZ;
        }
        if (name.equalsIgnoreCase("PCM6")) {
            return PCM_6KHZ;
        }
        if (name.equalsIgnoreCase("PCM11")) {
            return PCM_11KHZ;
        }
        if (name.equalsIgnoreCase("ADPCM8")) {
            return ADPCM_8KHZ;
        }
        if (name.equalsIgnoreCase("ADPCM6")) {
            return ADPCM_6KHZ;
        }
        if (name.equalsIgnoreCase("ulaw6")) {
            return PCM6_ULAW;
        }
        if (name.equalsIgnoreCase("alaw6")) {
            return PCM6_ALAW;
        }
        if (name.equalsIgnoreCase("G723")) {
            return G7231;
        }
        if (name.equalsIgnoreCase("TrueSpeech")) {
            return TRUESPEECH;
        }
        if (name.equalsIgnoreCase("GSM 6.10")) {
            return GSM610;
        }
        if (name.equalsIgnoreCase("Microsoft GSM")) {
            return MSGSM;
        }
        if (name.equalsIgnoreCase("G729")) {
            return G729;
        }
        if (name.equalsIgnoreCase("Opus")) {
            return OPUSNB;
        }
        if (name.equalsIgnoreCase("Opus16")) {
            return OPUSWB;
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.equals(PCM_LINEAR16)) {
            return "PCM 8 Khz 16 bit";
        }
        if (this.equals(PCM_8KHZ)) {
            return "PCM 8 Khz 8 bit";
        }
        if (this.equals(TRUESPEECH)) {
            return "DSP Group TrueSpeech";
        }
        if (this.equals(PCM8_ULAW)) {
            return "CCITT U-law";
        }
        if (this.equals(PCM8_ALAW)) {
            return "CCITT A-law";
        }
        if (this.equals(GSM610)) {
            return "GSM 6.10";
        }
        if (this.equals(MSGSM)) {
            return "Microsoft GSM";
        }
        if (this.equals(G7231)) {
            return "ITU-T G723.1";
        }
        if (this.equals(G729)) {
            return "ITU-T G729";
        }
        if (this.equals(PCM_LINEAR8)) {
            return "PCM 8Khz 8 bit linear";
        }
        if (this.equals(PCM_6KHZ)) {
            return "PCM 6 Khz";
        }
        if (this.equals(PCM_11KHZ)) {
            return "PCM 11 Khz";
        }
        if (this.equals(ADPCM_8KHZ)) {
            return "ADPCM 8 Khz";
        }
        if (this.equals(ADPCM_6KHZ)) {
            return "ADPCM 6 Khz";
        }
        if (this.equals(PCM6_ULAW)) {
            return "U-Law 6 Khz";
        }
        if (this.equals(PCM6_ALAW)) {
            return "A-Law 6 Khz";
        }
        if (this.equals(OPUSNB)) {
            return "Opus";
        }
        if (this.equals(OPUSWB)) {
            return "Opus 16 Khz";
        }
        return super.getName();
    }

    public static WavAudioFormat fromString(String name) {
        if (name.equals("PCM 8 Khz 16 bit")) {
            return PCM_LINEAR16;
        }
        if (name.equalsIgnoreCase("PCM 8 Khz 8 bit")) {
            return PCM_8KHZ;
        }
        if (name.equalsIgnoreCase("DSP Group TrueSpeech")) {
            return TRUESPEECH;
        }
        if (name.equalsIgnoreCase("CCITT U-law")) {
            return PCM8_ULAW;
        }
        if (name.equalsIgnoreCase("CCITT A-law")) {
            return PCM8_ALAW;
        }
        if (name.equalsIgnoreCase("GSM 6.10")) {
            return GSM610;
        }
        if (name.equalsIgnoreCase("Microsoft GSM")) {
            return MSGSM;
        }
        if (name.equalsIgnoreCase("ITU-T G723.1")) {
            return G7231;
        }
        if (name.equalsIgnoreCase("ITU-T G729")) {
            return G729;
        }
        if (name.equalsIgnoreCase("PCM 8Khz 8 bit linear")) {
            return PCM_LINEAR8;
        }
        if (name.equalsIgnoreCase("PCM 6 Khz")) {
            return PCM_6KHZ;
        }
        if (name.equalsIgnoreCase("PCM 11 Khz")) {
            return PCM_11KHZ;
        }
        if (name.equalsIgnoreCase("ADPCM 8 Khz")) {
            return ADPCM_8KHZ;
        }
        if (name.equalsIgnoreCase("ADPCM 6 Khz")) {
            return ADPCM_6KHZ;
        }
        if (name.equalsIgnoreCase("U-Law 6 Khz")) {
            return PCM6_ULAW;
        }
        if (name.equalsIgnoreCase("A-Law 6 Khz")) {
            return PCM6_ALAW;
        }
        if (name.equalsIgnoreCase("Opus")) {
            return OPUSNB;
        }
        if (name.equalsIgnoreCase("Opus 16 Khz")) {
            return OPUSWB;
        }
        return WavAudioFormat.getWavAudioFormat(name);
    }

    @Override
    public String getName() {
        if (this.equals(PCM_LINEAR16)) {
            return "PCM16";
        }
        if (this.equals(PCM_LINEAR8)) {
            return "PCM8linear";
        }
        if (this.equals(PCM8_ULAW)) {
            return "ulaw";
        }
        if (this.equals(PCM8_ALAW)) {
            return "alaw";
        }
        if (this.equals(PCM_8KHZ)) {
            return "PCM8";
        }
        if (this.equals(PCM_6KHZ)) {
            return "PCM6";
        }
        if (this.equals(PCM_11KHZ)) {
            return "PCM11";
        }
        if (this.equals(ADPCM_8KHZ)) {
            return "ADPCM8";
        }
        if (this.equals(ADPCM_6KHZ)) {
            return "ADPCM6";
        }
        if (this.equals(PCM6_ULAW)) {
            return "ulaw6";
        }
        if (this.equals(PCM6_ALAW)) {
            return "alaw6";
        }
        if (this.equals(G7231)) {
            return "G723";
        }
        if (this.equals(TRUESPEECH)) {
            return "TrueSpeech";
        }
        if (this.equals(GSM610)) {
            return "GSM";
        }
        if (this.equals(MSGSM)) {
            return "MSGSM";
        }
        if (this.equals(G729)) {
            return "G729";
        }
        if (this.equals(OPUSNB)) {
            return "Opus";
        }
        if (this.equals(OPUSWB)) {
            return "Opus16";
        }
        return super.getName();
    }

    public WavAudioFormat(audioFormat format) {
        super(format.getSRate(), format.getChans(), format.getType(), format.getFormat());
    }

    public WavAudioFormat(int srate, int chans, int type, int format) {
        super(srate, chans, type, format);
    }
}

