/*
 * Decompiled with CFR 0.152.
 */
package com.smile.sound;

import com.smile.sound.wavFormatHeader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class WaveParser {
    public static final int RIFF_MAGIC = 1380533830;
    public static final int WAVE_MAGIC = 1463899717;
    public static final int FMT_MAGIC = 1718449184;
    public static final int DATA_MAGIC = 1684108385;
    public static final int FACT_MAGIC = 1717658484;
    public static final int WAVE_FORMAT_UNKNOWN = 0;
    public static final int WAVE_FORMAT_PCM = 1;
    public static final int WAVE_FORMAT_ADPCM = 2;
    public static final int WAVE_FORMAT_ALAW = 6;
    public static final int WAVE_FORMAT_MULAW = 7;
    public static final int WAVE_FORMAT_OKI_ADPCM = 16;
    public static final int WAVE_FORMAT_DIGISTD = 21;
    public static final int WAVE_FORMAT_DIGIFIX = 22;
    public static final int WAVE_FORMAT_DIALOGIC_ADPCM = 23;
    public static final int WAVE_FORMAT_TRUESPEECH = 34;
    public static final int WAVE_IBM_FORMAT_MULAW = 257;
    public static final int WAVE_IBM_FORMAT_ALAW = 258;
    public static final int WAVE_IBM_FORMAT_ADPCM = 259;
    public static final int WAVE_FORMAT_DVI_ADPCM = 17;
    public static final int WAVE_FORMAT_SX7383 = 7175;
    public static final int WAVE_HEADERSIZE = 44;
    public static final int WAVE_DATASIZE_OFFSET = 40;
    public static final int WAVE_MICROSOFT_G723 = 66;
    public static final int WAVE_MS_GSM_610 = 49;
    public static final int WAVE_GSM_610 = 50;
    public static final int WAVE_G729 = 73;
    public static final int WAVE_OPUSNB = 110;
    public static final int WAVE_OPUSWB = 111;

    private int checkHeader(QuotedInputStream data) throws IOException {
        int bytesRead;
        byte[] buf = new byte[4];
        int nread = 0;
        int riffField = data.readInt();
        nread += 4;
        int length = this.rllong(data);
        nread += 4;
        int waveField = data.readInt();
        nread += 4;
        if (riffField != 1380533830 || waveField != 1463899717) {
            throw new IOException("invalid file format");
        }
        while (true) {
            String s;
            bytesRead = data.read(buf, 0, 4);
            nread += 4;
            if (bytesRead == -1 || (s = new String(buf)).startsWith("fmt ")) break;
            length = this.rllong(data);
            nread += 4;
            if (length % 2 > 0) {
                ++length;
            }
            nread += data.skipBytes(length);
        }
        if (bytesRead == -1) {
            throw new IOException("InputStream is not a WAV file");
        }
        return nread;
    }

    public InputStream parseWavHeader(InputStream source, wavFormatHeader header) throws IOException {
        int skipping;
        int maxReadLength = 44;
        QuotedInputStream data = new QuotedInputStream(source);
        byte[] signature = new byte[4];
        int nread = this.checkHeader(data);
        int length = this.rllong(data);
        int endLength = (nread += 4) + length;
        short wav_type = this.rlshort(data);
        nread += 2;
        header.setWavType(wav_type);
        short channels = this.rlshort(data);
        nread += 2;
        header.setChannels(channels);
        double sampleRate = this.rllong(data);
        nread += 4;
        header.setSampleRate(sampleRate);
        int avgBytesPerSec = this.rllong(data);
        nread += 4;
        short blockAlign = this.rlshort(data);
        nread += 2;
        short sampleSizeInBits = this.rlshort(data);
        nread += 2;
        header.setSampleSizeInBits(sampleSizeInBits);
        if (length % 2 != 0) {
            ++length;
        }
        if ((skipping = endLength - nread) > 0) {
            nread += data.skipBytes(skipping);
        } else if (skipping < 0) {
            throw new IOException("Invalid length of format chunk");
        }
        while (true) {
            int bytesRead = data.read(signature, 0, 4);
            nread += 4;
            if (bytesRead == -1) {
                throw new IOException("reached EOF before finding data chunk");
            }
            String s = new String(signature);
            if (s.startsWith("data")) break;
            length = this.rllong(data);
            nread += 4;
            if (length % 2 > 0) {
                ++length;
            }
            nread += data.skipBytes(length);
        }
        length = this.rllong(data);
        header.setDataLength(length);
        data.setQuote(length);
        int offset = nread += 4;
        return data;
    }

    protected int rllong(QuotedInputStream dis) throws IOException {
        int i = dis.readInt();
        int b1 = (i & 0xFF) << 24;
        int b2 = (i & 0xFF00) << 8;
        int b3 = (i & 0xFF0000) >> 8;
        int b4 = (i & 0xFF000000) >>> 24;
        i = b1 | b2 | b3 | b4;
        return i;
    }

    protected short rlshort(QuotedInputStream dis) throws IOException {
        short s = 0;
        s = dis.readShort();
        short high = (short)((s & 0xFF) << 8);
        short low = (short)((s & 0xFF00) >>> 8);
        s = (short)(high | low);
        return s;
    }

    class QuotedInputStream
    extends InputStream {
        private boolean isQuoted = false;
        private int length = -1;
        private InputStream in;

        QuotedInputStream(InputStream source) {
            this.in = source;
        }

        public void setQuote(int len) {
            this.length = len;
            this.isQuoted = true;
        }

        @Override
        public int available() throws IOException {
            return this.length;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public final int read(byte[] b, int off, int len) throws IOException {
            if (this.isQuoted) {
                if (this.length <= 0) {
                    return -1;
                }
                int count = this.in.read(b, off, len);
                if (this.length < count) {
                    count = this.length;
                    this.length = 0;
                } else {
                    this.length -= count;
                }
                return count;
            }
            return this.in.read(b, off, len);
        }

        @Override
        public final int read() throws IOException {
            if (this.isQuoted) {
                if (this.length <= 0) {
                    return -1;
                }
                --this.length;
            }
            return this.in.read();
        }

        public final int readInt() throws IOException {
            int ch4;
            int ch3;
            int ch2;
            int ch1 = this.in.read();
            if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
                throw new EOFException();
            }
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }

        public final short readShort() throws IOException {
            int ch2;
            int ch1 = this.in.read();
            if ((ch1 | (ch2 = this.in.read())) < 0) {
                throw new EOFException();
            }
            return (short)((ch1 << 8) + (ch2 << 0));
        }

        public final int skipBytes(int n) throws IOException {
            for (int i = 0; i < n; i += (int)this.in.skip(n - i)) {
            }
            return n;
        }
    }
}

