/*
 * Decompiled with CFR 0.152.
 */
package com.smile.sound;

import com.smile.sound.sndlib;
import java.io.File;
import java.io.Serializable;
import java.util.Date;

public class audioFormat
implements Cloneable,
Serializable {
    Date date;
    protected int srate;
    protected int chans;
    protected int type;
    protected int format;
    protected int bit_per_sample;
    protected int bytes_per_sample;
    protected int frames;
    protected int samples;
    protected String type_name;
    protected String comment;
    protected float length;
    protected String format_info;
    protected String format_name;
    private int hash = -1;
    static sndlib snd = null;

    public int getSRate() {
        return this.srate;
    }

    public int getChans() {
        return this.chans;
    }

    public int getType() {
        return this.type;
    }

    public int getFormat() {
        return this.format;
    }

    public int getBitPerSample() {
        return this.bit_per_sample;
    }

    public int getBytesPerSample() {
        return this.bytes_per_sample;
    }

    public int getFrames() {
        return this.frames;
    }

    public int getSamples() {
        return this.samples;
    }

    public String getComment() {
        return this.comment;
    }

    public String getPrefferedSuffix() {
        switch (this.type) {
            default: 
        }
        return ".wav";
    }

    public Object clone() throws CloneNotSupportedException {
        return new audioFormat(this);
    }

    public String getName() {
        return this.format_name;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.toString().hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return "date        :" + this.date + "\nsrate       :" + this.srate + "\nchans       :" + this.chans + "\nsamples     :" + this.samples + "\nframes      :" + this.frames + "\ncomment     :" + this.comment + "\nlength      :" + this.length + "\nbit/sample  :" + this.bit_per_sample + "\nbyte/sample :" + this.bytes_per_sample + "\ntype        :" + this.type + "\ntype_name   :" + this.type_name + "\nformat      :" + this.format + "\nformat_info :" + this.format_info + "\nformat_name :" + this.format_name;
    }

    public audioFormat(audioFormat a) {
        this.srate = a.srate;
        this.chans = a.chans;
        this.type = a.type;
        this.format = a.format;
        this.bit_per_sample = a.bit_per_sample;
        this.bytes_per_sample = a.bytes_per_sample;
        this.type_name = a.type_name;
        this.comment = a.comment;
        this.format_info = a.format_info;
        this.format_name = a.format_name;
    }

    public audioFormat(int srate, int chans, int type, int format) {
        this();
        this.srate = srate;
        this.chans = chans;
        this.type = type;
        this.format = format;
        this.bit_per_sample = snd.bitsPerSample(format);
        this.bytes_per_sample = this.bytes_per_sample = snd.bytesPerSample(format);
        this.type_name = snd.sound_type_name(type);
        this.comment = ">8-)";
        this.format_name = snd.sound_format_name(format) + ";" + this.getSRate() / 1000 + "KHz";
        this.format_info = this.type_name + "/" + this.format_name;
    }

    public audioFormat() {
        this.sndinit();
        this.date = new Date();
        this.srate = 8000;
        this.chans = 1;
        this.samples = 0;
        this.comment = "Smile-soft";
        this.length = 0.0f;
        this.type = 2;
        this.type_name = "RIFF";
        this.format = 2;
        this.format_info = this.get_info(this.format);
        this.format_name = this.format + "/" + this.type_name;
        this.frames = 0;
        this.bit_per_sample = snd.bitsPerSample(this.format);
        this.bytes_per_sample = snd.bytesPerSample(this.format);
    }

    int get_format(String file_name) {
        this.format_info = this.get_info(this.format);
        return this.format;
    }

    public String getInfo() {
        String in = this.get_info(this.format) + " " + this.getSRate() / 1000 + "KHz ;" + (this.chans == 1 ? "mono" : "stereo");
        if (in.indexOf("8-bit unsigned") >= 0) {
            in = "PCM " + in;
        }
        return in;
    }

    String get_info(int format) {
        if (format != -1) {
            this.format_info = snd.sound_format_name(format);
        } else {
            this.format_name = audioFormat.decode_format(format, this.type);
            this.format_info = this.format_name != null ? format + "(" + this.format_name + ")" : "[" + format + "]";
        }
        return this.format_info;
    }

    void sndinit() {
        if (snd == null) {
            snd = new sndlib();
        }
    }

    public audioFormat(String file_name) {
        this.sndinit();
        String argv = file_name;
        if (new File(argv).exists()) {
            this.date = new Date(new File(argv).lastModified());
            this.frames = this.samples / this.chans;
            this.length = (float)this.samples / (float)(this.chans * this.srate);
            this.type_name = snd.soundTypeName(this.type);
            this.format = this.get_format(argv);
            this.bytes_per_sample = snd.bytesPerSample(this.format);
            this.format_info = this.get_info(this.format);
        }
    }

    static String decode_format(int format, int type) {
        String retval = null;
        block0 : switch (type) {
            case 0: {
                switch (format) {
                    case 0: {
                        retval = "unspecified";
                        break;
                    }
                    case 8: {
                        retval = "indirect";
                        break;
                    }
                    case 9: {
                        retval = "nested";
                        break;
                    }
                    case 10: {
                        retval = "dsp_core";
                        break;
                    }
                    case 11: {
                        retval = "dsp_data_8";
                        break;
                    }
                    case 12: {
                        retval = "dsp_data_16";
                        break;
                    }
                    case 13: {
                        retval = "dsp_data_24";
                        break;
                    }
                    case 14: {
                        retval = "dsp_data_32";
                        break;
                    }
                    case 16: {
                        retval = "display";
                        break;
                    }
                    case 17: {
                        retval = "mulaw_squelch";
                        break;
                    }
                    case 18: {
                        retval = "emphasized";
                        break;
                    }
                    case 19: {
                        retval = "compressed";
                        break;
                    }
                    case 20: {
                        retval = "compressed_emphasized";
                        break;
                    }
                    case 21: {
                        retval = "dsp_commands";
                        break;
                    }
                    case 22: {
                        retval = "dsp_commands_samples";
                        break;
                    }
                    case 23: {
                        retval = "adpcm_g721";
                        break;
                    }
                    case 24: {
                        retval = "adpcm_g722";
                        break;
                    }
                    case 25: {
                        retval = "adpcm_g723";
                        break;
                    }
                    case 26: {
                        retval = "adpcm_g723_5";
                        break;
                    }
                    case 28: {
                        retval = "aes";
                        break;
                    }
                    case 29: {
                        retval = "delat_mulaw_8";
                    }
                }
                break;
            }
            case 1: {
                if (format <= 0) break;
                Object f4 = "";
                f4 = "" + (format >> 24 & 0xFF) + (format >> 16 & 0xFF) + (format >> 8 & 0xFF) + (format & 0xFF);
                return f4;
            }
            case 2: {
                switch (format) {
                    case 0: {
                        retval = "UNKNOWN";
                        break block0;
                    }
                    case 1: {
                        retval = "PCM";
                        break block0;
                    }
                    case 6: {
                        retval = "A-Law";
                        break block0;
                    }
                    case 7: {
                        retval = "u-Law";
                        break block0;
                    }
                    case 2: {
                        retval = "ADPCM";
                        break block0;
                    }
                    case 4: {
                        retval = "VSELP";
                        break block0;
                    }
                    case 5: {
                        retval = "IBM_CVSD";
                        break block0;
                    }
                    case 16: {
                        retval = "OKI_ADPCM";
                        break block0;
                    }
                    case 17: {
                        retval = "DVI_ADPCM";
                        break block0;
                    }
                    case 18: {
                        retval = "MediaSpace_ADPCM";
                        break block0;
                    }
                    case 19: {
                        retval = "Sierra_ADPCM";
                        break block0;
                    }
                    case 20: {
                        retval = "G723_ADPCM";
                        break block0;
                    }
                    case 21: {
                        retval = "DIGISTD";
                        break block0;
                    }
                    case 22: {
                        retval = "DIGIFIX";
                        break block0;
                    }
                    case 23: {
                        retval = "Dialogic ADPCM";
                        break block0;
                    }
                    case 24: {
                        retval = "Mediavision ADPCM";
                        break block0;
                    }
                    case 25: {
                        retval = "HP cu codec";
                        break block0;
                    }
                    case 32: {
                        retval = "Yamaha_ADPCM";
                        break block0;
                    }
                    case 33: {
                        retval = "SONARC";
                        break block0;
                    }
                    case 34: {
                        retval = "DSPGroup_TrueSpeech";
                        break block0;
                    }
                    case 35: {
                        retval = "EchoSC1";
                        break block0;
                    }
                    case 36: {
                        retval = "AudioFile_AF36";
                        break block0;
                    }
                    case 37: {
                        retval = "APTX";
                        break block0;
                    }
                    case 38: {
                        retval = "AudioFile_AF10";
                        break block0;
                    }
                    case 39: {
                        retval = "prosody 1612";
                        break block0;
                    }
                    case 40: {
                        retval = "lrc";
                        break block0;
                    }
                    case 48: {
                        retval = "Dolby_Ac2";
                        break block0;
                    }
                    case 49: {
                        retval = "GSM610";
                        break block0;
                    }
                    case 50: {
                        retval = "MSN audio codec";
                        break block0;
                    }
                    case 51: {
                        retval = "Antext_ADPCM";
                        break block0;
                    }
                    case 52: {
                        retval = "Control_res_vqlpc";
                        break block0;
                    }
                    case 53: {
                        retval = "DIGIREAL";
                        break block0;
                    }
                    case 54: {
                        retval = "DIGIADPCM";
                        break block0;
                    }
                    case 55: {
                        retval = "Control_res_cr10";
                        break block0;
                    }
                    case 56: {
                        retval = "NMS_VBXADPCM";
                        break block0;
                    }
                    case 57: {
                        retval = "oland rdac";
                        break block0;
                    }
                    case 58: {
                        retval = "echo sc3";
                        break block0;
                    }
                    case 59: {
                        retval = "Rockwell adpcm";
                        break block0;
                    }
                    case 60: {
                        retval = "Rockwell digitalk codec";
                        break block0;
                    }
                    case 61: {
                        retval = "Xebec";
                        break block0;
                    }
                    case 64: {
                        retval = "G721_ADPCM";
                        break block0;
                    }
                    case 65: {
                        retval = "G728 CELP";
                        break block0;
                    }
                    case 66: {
                        retval = "MS G723";
                        break block0;
                    }
                    case 80: {
                        retval = "MPEG";
                        break block0;
                    }
                    case 82: {
                        retval = "RT24";
                        break block0;
                    }
                    case 83: {
                        retval = "PAC";
                        break block0;
                    }
                    case 85: {
                        retval = "Mpeg layer 3";
                        break block0;
                    }
                    case 89: {
                        retval = "Lucent G723";
                        break block0;
                    }
                    case 96: {
                        retval = "Cirrus";
                        break block0;
                    }
                    case 97: {
                        retval = "ESS Tech pcm";
                        break block0;
                    }
                    case 98: {
                        retval = "voxware ";
                        break block0;
                    }
                    case 99: {
                        retval = "canopus atrac";
                        break block0;
                    }
                    case 100: {
                        retval = "G726";
                        break block0;
                    }
                    case 101: {
                        retval = "G722";
                        break block0;
                    }
                    case 102: {
                        retval = "DSAT";
                        break block0;
                    }
                    case 103: {
                        retval = "DSAT display";
                        break block0;
                    }
                    case 105: {
                        retval = "voxware ";
                        break block0;
                    }
                    case 112: {
                        retval = "voxware ac8 ";
                        break block0;
                    }
                    case 113: {
                        retval = "voxware ac10 ";
                        break block0;
                    }
                    case 114: {
                        retval = "voxware ac16";
                        break block0;
                    }
                    case 115: {
                        retval = "voxware ac20";
                        break block0;
                    }
                    case 116: {
                        retval = "voxware rt24";
                        break block0;
                    }
                    case 117: {
                        retval = "voxware rt29";
                        break block0;
                    }
                    case 118: {
                        retval = "voxware rt29hw";
                        break block0;
                    }
                    case 119: {
                        retval = "voxware vr12 ";
                        break block0;
                    }
                    case 120: {
                        retval = "voxware vr18";
                        break block0;
                    }
                    case 121: {
                        retval = "voxware tq40";
                        break block0;
                    }
                    case 128: {
                        retval = "softsound";
                        break block0;
                    }
                    case 129: {
                        retval = "voxware tq60 ";
                        break block0;
                    }
                    case 130: {
                        retval = "MS RT24";
                        break block0;
                    }
                    case 131: {
                        retval = "G729A";
                        break block0;
                    }
                    case 132: {
                        retval = "MVI_MVI2";
                        break block0;
                    }
                    case 133: {
                        retval = "DF G726";
                        break block0;
                    }
                    case 134: {
                        retval = "DF GSM610";
                        break block0;
                    }
                    case 136: {
                        retval = "isaudio";
                        break block0;
                    }
                    case 137: {
                        retval = "onlive";
                        break block0;
                    }
                    case 145: {
                        retval = "sbc24";
                        break block0;
                    }
                    case 146: {
                        retval = "dolby ac3 spdif";
                        break block0;
                    }
                    case 151: {
                        retval = "zyxel adpcm";
                        break block0;
                    }
                    case 152: {
                        retval = "philips lpcbb";
                        break block0;
                    }
                    case 153: {
                        retval = "packed";
                        break block0;
                    }
                    case 256: {
                        retval = "rhetorex adpcm";
                        break block0;
                    }
                    case 257: {
                        retval = "Irat";
                        break block0;
                    }
                    case 258: {
                        retval = "IBM_alaw?";
                        break block0;
                    }
                    case 259: {
                        retval = "IBM_ADPCM?";
                        break block0;
                    }
                    case 273: {
                        retval = "vivo G723";
                        break block0;
                    }
                    case 274: {
                        retval = "vivo siren";
                        break block0;
                    }
                    case 291: {
                        retval = "digital g273";
                        break block0;
                    }
                    case 512: {
                        retval = "Creative_ADPCM";
                        break block0;
                    }
                    case 514: {
                        retval = "Creative fastspeech 8";
                        break block0;
                    }
                    case 515: {
                        retval = "Creative fastspeech 10";
                        break block0;
                    }
                    case 544: {
                        retval = "quarterdeck";
                        break block0;
                    }
                    case 768: {
                        retval = "FM_TOWNS_SND";
                        break block0;
                    }
                    case 1024: {
                        retval = "BTV digital";
                        break block0;
                    }
                    case 1664: {
                        retval = "VME vmpcm";
                        break block0;
                    }
                    case 4096: {
                        retval = "OLIGSM";
                        break block0;
                    }
                    case 4097: {
                        retval = "OLIADPCM";
                        break block0;
                    }
                    case 4098: {
                        retval = "OLICELP";
                        break block0;
                    }
                    case 4099: {
                        retval = "OLISBC";
                        break block0;
                    }
                    case 4100: {
                        retval = "OLIOPR";
                        break block0;
                    }
                    case 4352: {
                        retval = "LH codec";
                        break block0;
                    }
                    case 5120: {
                        retval = "Norris";
                        break block0;
                    }
                    case 5121: {
                        retval = "isaudio";
                        break block0;
                    }
                    case 5376: {
                        retval = "Soundspace musicompression";
                        break block0;
                    }
                    case 8192: {
                        retval = "DVM";
                    }
                }
            }
        }
        return retval;
    }

    public int available() {
        return this.bytes_per_sample * this.samples;
    }

    public boolean equals(Object f) {
        try {
            return this.equals((audioFormat)f);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean equals(audioFormat f) {
        return f.getBytesPerSample() == this.getBytesPerSample() && f.getSRate() == this.getSRate() && f.getChans() == this.getChans() && f.getType() == this.getType() && f.getFormat() == this.getFormat() && f.getBitPerSample() == this.getBitPerSample();
    }
}

