/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.sound.WavAudioFormat;
import com.smile.sound.WaveParser;
import com.smile.sound.wavFormatHeader;
import com.smile.telephony.AudioCodec;
import com.smile.telephony.codec.ALaw;
import com.smile.telephony.codec.ConvertedInputStream;
import com.smile.telephony.codec.ConvertedOutputStream;
import com.smile.telephony.codec.G729A;
import com.smile.telephony.codec.Linear16;
import com.smile.telephony.codec.Linear16A;
import com.smile.telephony.codec.Linear8;
import com.smile.telephony.codec.Opus;
import com.smile.telephony.codec.PCMConverter;
import com.smile.telephony.codec.ULaw;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AudioConverter {
    static final WavAudioFormat[] BWF = new WavAudioFormat[]{WavAudioFormat.PCM_LINEAR16, WavAudioFormat.PCM_8KHZ, WavAudioFormat.PCM8_ULAW, WavAudioFormat.PCM8_ALAW};
    static final AudioCodec[] BAC = new AudioCodec[]{AudioCodec.PCM16LINEAR, AudioCodec.PCM8, AudioCodec.PCM8WSS, AudioCodec.ULAW, AudioCodec.ALAW};

    public static WavAudioFormat[] getAvailableCodecs() {
        int size = BWF.length + 1;
        WavAudioFormat[] formats = new WavAudioFormat[size];
        for (int i = 0; i < BWF.length; ++i) {
            formats[i] = BWF[i];
        }
        formats[size - 1] = WavAudioFormat.G729;
        return formats;
    }

    public static long getMediaDuration(File file) throws Exception {
        FileInputStream is = new FileInputStream(file);
        wavFormatHeader hdr = new wavFormatHeader();
        InputStream stream = new WaveParser().parseWavHeader(is, hdr);
        WavAudioFormat codec = hdr.getAudioFormat();
        if (!codec.equals(WavAudioFormat.PCM_LINEAR16)) {
            AudioConverter acv = new AudioConverter();
            WavAudioFormat[] wav_formats = new WavAudioFormat[]{WavAudioFormat.PCM_LINEAR16};
            ConvertedInputStream cstream = acv.getInputStream(stream, codec, wav_formats);
            if (cstream == null) {
                stream.close();
                return 0L;
            }
            stream = cstream;
        }
        long bytes = stream.available();
        stream.close();
        return bytes / 16L;
    }

    public static File convertFile(File file, WavAudioFormat format) throws IOException {
        wavFormatHeader hdr = new wavFormatHeader();
        InputStream source = new WaveParser().parseWavHeader(new FileInputStream(file), hdr);
        WavAudioFormat sourceFormat = hdr.getAudioFormat();
        if (sourceFormat.equals(format) || sourceFormat.equals(WavAudioFormat.PCM_11KHZ)) {
            source.close();
            return file;
        }
        AudioConverter acv = new AudioConverter();
        WavAudioFormat[] targetFormat = new WavAudioFormat[]{format};
        ConvertedInputStream cin = acv.getInputStream(source, sourceFormat, targetFormat);
        String targetName = format.getName() + "_" + file.getName();
        File target = new File(targetName);
        FileOutputStream fos = new FileOutputStream(target);
        int bodyLen = ((InputStream)cin).available();
        byte[] bodyBytes = new byte[bodyLen];
        ((InputStream)cin).read(bodyBytes);
        hdr = new wavFormatHeader(format);
        hdr.setDataLength(bodyLen);
        byte[] header = hdr.toByteArray();
        int hdrLen = header.length;
        byte[] image = new byte[hdrLen + bodyLen];
        System.arraycopy(header, 0, image, 0, hdrLen);
        System.arraycopy(bodyBytes, 0, image, hdrLen, bodyLen);
        fos.write(image);
        ((InputStream)cin).close();
        fos.close();
        return target;
    }

    public static byte[] convert(File file, WavAudioFormat format) throws IOException {
        return AudioConverter.convert(new FileInputStream(file), format);
    }

    public static byte[] convert(byte[] array, WavAudioFormat format) throws IOException {
        return AudioConverter.convert(new ByteArrayInputStream(array), format);
    }

    public static byte[] convert(InputStream istream, WavAudioFormat format) throws IOException {
        InputStream cin;
        wavFormatHeader hdr = new wavFormatHeader();
        InputStream source = new WaveParser().parseWavHeader(istream, hdr);
        WavAudioFormat sourceFormat = hdr.getAudioFormat();
        if (sourceFormat.equals(format)) {
            cin = source;
        } else {
            AudioConverter acv = new AudioConverter();
            WavAudioFormat[] targetFormat = new WavAudioFormat[]{format};
            cin = acv.getInputStream(source, sourceFormat, targetFormat);
        }
        if (cin == null) {
            throw new IOException("Codec not available for " + format.getName());
        }
        int dataLength = cin.available();
        byte[] buffer = new byte[dataLength];
        cin.read(buffer);
        cin.close();
        return buffer;
    }

    public static byte[] convert(byte[] data, WavAudioFormat source, WavAudioFormat target) throws IOException {
        AudioConverter converter = new AudioConverter();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        WavAudioFormat[] targetFormat = new WavAudioFormat[]{target};
        ConvertedInputStream cin = converter.getInputStream((InputStream)stream, source, targetFormat);
        if (cin == null) {
            return null;
        }
        int dataLength = ((InputStream)cin).available();
        byte[] buffer = new byte[dataLength];
        ((InputStream)cin).read(buffer);
        ((InputStream)cin).close();
        return buffer;
    }

    public ConvertedInputStream getInputStream(InputStream in, AudioCodec codec) {
        AudioCodec encoder = this.getCodec(codec, 1);
        if (encoder == null) {
            return null;
        }
        return new ConvertedInputStream(in, new Linear16(), encoder);
    }

    public ConvertedOutputStream getOutputStream(OutputStream out, AudioCodec codec) {
        AudioCodec decoder = this.getCodec(codec, 0);
        if (decoder == null) {
            return null;
        }
        return new ConvertedOutputStream(out, decoder, new Linear16());
    }

    public ConvertedOutputStream getOutputStream(OutputStream out, AudioCodec[] codecs) {
        AudioCodec decoder = this.getCodec(codecs, 0);
        if (decoder == null) {
            return null;
        }
        return new ConvertedOutputStream(out, decoder, new Linear16());
    }

    public ConvertedInputStream getInputStream(InputStream in, AudioCodec codec, AudioCodec[] availables) {
        AudioCodec decoder = this.getCodec(codec, 0);
        if (decoder == null) {
            return null;
        }
        AudioCodec encoder = this.getCodec(availables, 1);
        if (encoder == null) {
            this.releaseCodec(decoder);
            return null;
        }
        return new ConvertedInputStream(in, decoder, encoder);
    }

    public ConvertedOutputStream getOutputStream(OutputStream out, AudioCodec codec, AudioCodec[] availables) {
        AudioCodec encoder = this.getCodec(codec, 1);
        if (encoder == null) {
            return null;
        }
        AudioCodec decoder = this.getCodec(availables, 0);
        if (decoder == null) {
            this.releaseCodec(encoder);
            return null;
        }
        return new ConvertedOutputStream(out, decoder, encoder);
    }

    public ConvertedInputStream getInputStream(InputStream in, WavAudioFormat codec, WavAudioFormat[] availables) {
        AudioCodec decoder = this.getCodec(codec, 0);
        if (decoder == null) {
            return null;
        }
        AudioCodec encoder = this.getCodec(availables, 1);
        if (encoder == null) {
            this.releaseCodec(decoder);
            return null;
        }
        return new ConvertedInputStream(in, decoder, encoder);
    }

    public ConvertedOutputStream getOutputStream(OutputStream out, WavAudioFormat codec, WavAudioFormat[] availables) {
        AudioCodec encoder = this.getCodec(codec, 1);
        if (encoder == null) {
            return null;
        }
        AudioCodec decoder = this.getCodec(availables, 0);
        if (decoder == null) {
            this.releaseCodec(encoder);
            return null;
        }
        return new ConvertedOutputStream(out, decoder, encoder);
    }

    private AudioCodec getCodec(WavAudioFormat format) {
        return this.getCodec(format, 2);
    }

    private AudioCodec getCodec(WavAudioFormat format, int dir) {
        AudioCodec codec = AudioCodec.getAudioCodec(format);
        return this.getCodec(codec, dir);
    }

    private AudioCodec getCodec(AudioCodec codec, int dir) {
        if (codec == null) {
            return null;
        }
        if (codec.equals(AudioCodec.G729A)) {
            return G729A.getCodec(dir);
        }
        if (codec.equals(AudioCodec.OPUSNB)) {
            return Opus.getCodec(dir, codec);
        }
        if (codec.equals(AudioCodec.OPUSWB)) {
            return Opus.getCodec(dir, codec);
        }
        if (codec.equals(AudioCodec.PCM16LINEAR)) {
            return new Linear16();
        }
        if (codec.equals(AudioCodec.PCM8)) {
            return new Linear8();
        }
        if (codec.equals(AudioCodec.PCM8WSS)) {
            return new PCMConverter();
        }
        if (codec.equals(AudioCodec.ALAW)) {
            return new ALaw();
        }
        if (codec.equals(AudioCodec.ULAW)) {
            return new ULaw();
        }
        if (codec.equals(AudioCodec.PCM16LINEAR_A)) {
            return new Linear16A();
        }
        return null;
    }

    private AudioCodec getCodec(WavAudioFormat[] fmts, int dir) {
        if (fmts == null) {
            return null;
        }
        for (int j = 0; j < fmts.length; ++j) {
            AudioCodec c = this.getCodec(fmts[j], dir);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private AudioCodec getCodec(AudioCodec[] fmts, int dir) {
        if (fmts == null) {
            return null;
        }
        for (int j = 0; j < fmts.length; ++j) {
            AudioCodec c = this.getCodec(fmts[j], dir);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public void releaseCodec(AudioCodec c) {
        c.release();
    }
}

