/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.net.StunClient;
import com.smile.telephony.AudioCodec;
import com.smile.telephony.DeviceListener;
import com.smile.telephony.MediaSocket;
import com.smile.telephony.RTPMediaSocket;
import com.smile.telephony.rtp.RTP;
import com.smile.telephony.rtp.SRTP;
import com.smile.telephony.video.VideoSocket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import smile.util.ResourceStore;

public abstract class MediaEndpoint {
    public static final String KEY_NAME = "h323.name";
    public static final String KEY_ID = "h323.h323id";
    public static final String KEY_USER = "sip.user";
    public static final String KEY_PORT = "h323.port";
    public static final String KEY_ADDRESS = "h323.address";
    public static final String KEY_INTERFACES = "interfaces";
    public static final String KEY_MINJITTER = "h323.minjitter";
    public static final String KEY_MAXJITTER = "h323.maxjitter";
    public static final String KEY_LOG = "h323.log";
    public static final String KEY_STUN = "stun.server";
    public static final String KEY_GATEWAY = "h323.gateway";
    public static final String KEY_BANDWIDTH = "h323.bandwidth";
    public static final String KEY_DISPLAY = "h323.display_name";
    public static final String KEY_TCP_BASE = "h323.tcp_base";
    public static final String KEY_TCP_LAST = "h323.tcp_last";
    public static final String KEY_UDP_BASE = "h323.udp_base";
    public static final String KEY_UDP_LAST = "h323.udp_last";
    public static final String KEY_GK_ARQANSWER = "h323.arqanswer";
    public static final String KEY_GATEKEEPER = "h323.gatekeeper";
    public static final String KEY_GATEKEEPER_REQUEST = "h323.gk_request";
    public static final String KEY_GATEKEEPER_LOGIN = "h323.gk_login";
    public static final String KEY_GATEKEEPER_PASSWORD = "h323.gk_password";
    public static final String KEY_GATEKEEPER_TTL = "h323.gk_ttl";
    public static final String KEY_PARAMETERS = "h323.parameters";
    public static final String KEY_CAPABILITIES = "h323.capabilities";
    public static final String KEY_PREFIXES = "h323.prefixes";
    public static final String KEY_TRANSDIGITS = "h323.transdigits";
    public static final String KEY_ROUTER = "h323.router";
    public static final String KEY_NAT = "h323.proxy";
    public static final String KEY_TOS = "h323.tos";
    public static final String KEY_RTP_PORT = "h323.rtp_port";
    public static final String KEY_RAS_PORT = "h323.ras_port";
    public static final String KEY_FORWARDING = "h323.forwarding";
    public static final String KEY_PONG = "wss.pong";
    public static final String KEY_APPLICATION_NAME = "h323.application_name";
    public static final String KEY_APPLICATION_VERSION = "h323.application_version";
    public static final String KEY_TRACE = "sip.trace";
    public static final String KEY_CALL_EXPIRES = "sip.call_expires";
    public static final String KEY_PROTO = "sip.protocol";
    public static final String KEY_CERT_ALIAS = "sip.tls.cert";
    public static final String KEY_CERT = "sip.remote.cert";
    public static final String KEY_REG_EXPIRES = "sip.reg_expires";
    public static final String KEY_SERVICE_NAME = "sip.service_name";
    public static final String KEY_SOCKET_TIMEOUT = "rtp.socket_timeout";
    public static final String KEY_ACDMODE = "acd.mode";
    public static final String KEY_TCP_SOCKET_TIMEOUT = "sip.tcp.socket_timeout";
    public static final String KEY_NORETRY = "sip.noretry";
    public static final String KEY_PROXY = "sip.outbound_proxy";
    public static final String KEY_RECONNECT = "sip.reconnect";
    public static final AudioCodec[] DEFAULT_CODECS = new AudioCodec[]{AudioCodec.TRUESPEECH53, AudioCodec.TRUESPEECH63, AudioCodec.G729A, AudioCodec.ULAW, AudioCodec.ALAW, AudioCodec.T38UDP, AudioCodec.T38TCP};
    public static final String G711A = "G.711A";
    public static final String G711U = "G.711U";
    public static final String G723 = "G.723";
    public static final String G729 = "G.729";
    public static final String OPUS = "opus";
    public static final String NOT_VOICE = "NOT VOICE";
    public static final int JITTER = 90;
    public static final int MAXJITTER = 900;
    private static final int MIN_BASE = 5000;
    private static final int MAX_BASE = 60000;
    private static final int DEF_RANGE = 5000;
    public static InetAddress ANY_ADDRESS;
    private static int next_base;
    private static String DEF_ADDRESS;
    protected DeviceListener listener;
    protected String productName;
    protected String productVersion;
    protected String name;
    protected int channels = 0;
    protected Map properties = new HashMap();
    protected int[] capabilities = this.getDefaultCapabilities();
    protected int[] parameters = this.getDefaultParameters();
    protected String gateway;
    protected InetAddress outboundRouter;
    protected InetAddress serverAddress;
    private InetAddress localAddress;
    private boolean isAnyaddress = true;
    private Vector ports = new Vector();
    private int nextUdpPort = 5000;
    private int firstUdpPort = 5000;
    private int lastUdpPort = 10000;
    private int tos = 0;
    private int min_jitter = 120;
    private int max_jitter = 960;
    private int socket_timeout = 0;
    private int flags = 0;
    private String sslCertAlias;
    private boolean secure;
    private InetAddress stunAddress;
    private int stunPort;
    private int natType = 0;
    private int natFType = 0;
    private static Map interfaceAddresses;
    private static Map defaultRoutes;
    private static InetAddress defaultAddress;

    private static int getNextBase() {
        int base = next_base;
        if ((next_base += 5000) > 60000) {
            next_base = 5000;
        }
        return base;
    }

    public void setDeviceListener(DeviceListener listener) {
        this.listener = listener;
    }

    public DeviceListener getDeviceListener() {
        return this.listener;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean s) {
        this.secure = s;
    }

    public Vector getCryptoCapabilities() {
        if (!this.secure) {
            return null;
        }
        return SRTP.getCapabilities();
    }

    public void setFlag(int flg) {
        this.flags |= flg;
    }

    public void clearFlag(int flg) {
        this.flags &= ~flg;
    }

    public boolean checkFlag(int flg) {
        return (this.flags & flg) != 0;
    }

    public void addPort(MediaSocket port) {
        MediaEndpoint endpoint = port.getEndpoint();
        if (endpoint != null) {
            endpoint.removePort(port);
        }
        port.setEndpoint(this);
        ++this.channels;
        port.setName(this.getDefaultPortName() + this.channels);
        this.ports.addElement(port);
    }

    public void removePort(MediaSocket port) {
        this.ports.removeElement(port);
        --this.channels;
    }

    public Vector getPorts() {
        return this.ports;
    }

    public String getName() {
        return this.getDefaultPortName();
    }

    public int getChannels() {
        return this.channels;
    }

    public int[] getCapabilities() {
        return this.capabilities;
    }

    public int[] getParameters() {
        return this.parameters;
    }

    public int getMinJitter() {
        return this.min_jitter;
    }

    public int getMaxJitter() {
        return this.max_jitter;
    }

    public int getSocketTimeout() {
        return this.socket_timeout;
    }

    public String getDefaultGateway() {
        return this.gateway;
    }

    public boolean getSilenceSuppressionState() {
        return (this.capabilities[0] & 0x10000) != 0;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setCapabilities(int[] caps) {
        this.capabilities = caps;
        for (int i = 0; i < this.ports.size(); ++i) {
            MediaSocket port = (MediaSocket)this.ports.elementAt(i);
            port.setLocalCapabilities(caps);
        }
    }

    public void setParameters(int[] prms) {
        this.parameters = prms;
        for (int i = 0; i < this.ports.size(); ++i) {
            MediaSocket port = (MediaSocket)this.ports.elementAt(i);
            port.setLocalParameters(prms);
        }
    }

    public void setMinJitter(int value) {
        this.properties.put(KEY_MINJITTER, new Integer(value));
        this.min_jitter = value;
    }

    public void setMaxJitter(int value) {
        this.properties.put(KEY_MAXJITTER, new Integer(value));
        this.max_jitter = value;
    }

    public String getRouterAddress() {
        return this.outboundRouter != null ? this.outboundRouter.getHostAddress() : null;
    }

    public void setProperty(String key, Object value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
        if (key.equals(KEY_NAME)) {
            this.name = value != null ? (String)value : this.getDefaultPortName();
        }
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map props) throws Exception {
        int[] caps;
        String router;
        Integer value;
        String stunServer = (String)props.get(KEY_STUN);
        if (stunServer != null && stunServer.length() > 0) {
            try {
                this.discoverStun(stunServer);
            }
            catch (Exception e) {
                ResourceStore.error("discoverStun", e);
            }
        } else {
            this.stunAddress = null;
        }
        this.properties = props;
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        if ((value = (Integer)this.properties.get(KEY_MINJITTER)) != null) {
            this.min_jitter = value;
        }
        if ((value = (Integer)this.properties.get(KEY_MAXJITTER)) != null) {
            this.max_jitter = value;
        }
        if ((value = (Integer)this.properties.get(KEY_SOCKET_TIMEOUT)) != null) {
            this.socket_timeout = value;
        }
        String oldname = this.name;
        this.name = (String)this.properties.get(KEY_NAME);
        if (this.name == null) {
            this.name = this.getDefaultPortName();
        }
        if (!this.name.equals(oldname)) {
            for (int i = 0; i < this.ports.size(); ++i) {
                MediaSocket port = (MediaSocket)this.ports.elementAt(i);
                port.setName(this.name + (i + 1));
            }
        }
        if ((router = (String)this.properties.get(KEY_ROUTER)) == null) {
            router = "";
        }
        if (router.length() > 0) {
            try {
                this.outboundRouter = InetAddress.getByName(router);
            }
            catch (UnknownHostException e) {
                ResourceStore.error(this.getName(), e);
            }
        } else {
            this.outboundRouter = null;
        }
        this.parameters = (int[])this.properties.get(KEY_PARAMETERS);
        if (this.parameters == null) {
            this.parameters = this.getDefaultParameters();
        }
        if ((caps = (int[])this.properties.get(KEY_CAPABILITIES)) == null) {
            caps = this.getDefaultCapabilities();
        }
        this.setCapabilities(caps);
        this.gateway = (String)this.properties.get(KEY_GATEWAY);
        if (this.gateway == null) {
            this.gateway = "";
        }
        this.productName = (String)this.properties.get(KEY_APPLICATION_NAME);
        if (this.productName == null) {
            this.productName = "Smile phone";
            this.properties.put(KEY_APPLICATION_NAME, this.productName);
        }
        this.productVersion = (String)this.properties.get(KEY_APPLICATION_VERSION);
        if (this.productVersion == null) {
            this.productVersion = "1.0";
            this.properties.put(KEY_APPLICATION_VERSION, this.productVersion);
        }
    }

    public String getCertAlias() {
        return this.sslCertAlias;
    }

    public void setPortRange(int min, int max) {
        this.firstUdpPort = min;
        this.lastUdpPort = max;
        if (this.firstUdpPort == 0) {
            this.firstUdpPort = MediaEndpoint.getNextBase();
        } else if (this.firstUdpPort < 1024) {
            this.firstUdpPort = 1024;
        } else if (this.firstUdpPort > 60000) {
            this.firstUdpPort = 60000;
        }
        if (this.lastUdpPort <= this.firstUdpPort) {
            this.lastUdpPort = this.firstUdpPort + 5000;
        } else if (this.lastUdpPort > 65535) {
            this.lastUdpPort = 65535;
        }
        if (this.nextUdpPort < this.firstUdpPort || this.nextUdpPort > this.lastUdpPort) {
            this.nextUdpPort = this.firstUdpPort;
        }
    }

    public void setAddress(String addr) {
        String address = addr;
        if (address == null || address.length() == 0) {
            address = DEF_ADDRESS;
        }
        try {
            this.localAddress = InetAddress.getByName(address);
            this.isAnyaddress = this.localAddress.isAnyLocalAddress();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        defaultRoutes.clear();
    }

    public void setServerAddress(String address) throws Exception {
        this.serverAddress = InetAddress.getByName(address);
    }

    public void setTOS(int val) {
        this.tos = val;
    }

    public InetAddress getListenerAddress() {
        return this.localAddress;
    }

    public String getLocalAddress() {
        return this.isAnyaddress ? "0.0.0.0" : this.localAddress.getHostAddress();
    }

    public RTP createRTPSession(RTPMediaSocket media) {
        int udpPort = 0;
        int lastPort = this.nextUdpPort;
        while (true) {
            udpPort = this.getNextUDP();
            try {
                RTP rtp = new RTP(media, udpPort, this.localAddress, this.tos);
                return rtp;
            }
            catch (Exception exception) {
                if (udpPort != lastPort) continue;
                ResourceStore.error("Could not open port on " + this.localAddress + " for RTP session: udpPort=" + udpPort + " lastPort=" + lastPort);
                return null;
            }
            break;
        }
    }

    public void createRTPSession(VideoSocket socket, boolean symnat) {
        int udpPort = 0;
        int lastPort = this.nextUdpPort;
        while (true) {
            udpPort = this.getNextUDP();
            try {
                socket.createDatagramSocket(udpPort, this.localAddress, this.tos, symnat);
                return;
            }
            catch (Exception exception) {
                if (udpPort != lastPort) continue;
                ResourceStore.error("Could not open port for RTP session: udpPort=" + udpPort + " nextPort=" + this.nextUdpPort);
                return;
            }
            break;
        }
    }

    private synchronized int getNextUDP() {
        this.nextUdpPort += 2;
        if (this.nextUdpPort >= this.lastUdpPort) {
            this.nextUdpPort = this.firstUdpPort;
        }
        if (this.nextUdpPort % 2 != 0) {
            ++this.nextUdpPort;
        }
        return this.nextUdpPort;
    }

    public InetAddress getStunAddress() {
        return this.stunAddress;
    }

    public int getStunPort() {
        return this.stunPort;
    }

    public void discoverStun(String srvAddr) throws Exception {
        int n = srvAddr.indexOf(58);
        int srvPort = 3478;
        if (n != -1) {
            srvPort = Integer.parseInt(srvAddr.substring(n + 1));
            srvAddr = srvAddr.substring(0, n);
        }
        InetAddress srvAddress = InetAddress.getByName(srvAddr);
        DatagramSocket socket = new DatagramSocket();
        int localPort = socket.getLocalPort();
        StunClient stun = new StunClient(socket);
        stun.sendRequest(srvAddress, srvPort);
        String returnAddress = stun.getReturnAddress();
        int returnPort = stun.getReturnPort();
        String otherAddress = stun.getOtherAddress();
        int otherPort = stun.getOtherPort();
        ResourceStore.syslog("discoverStun: Server " + srvAddr + ":" + srvPort + " returnAddress=" + returnAddress + ":" + returnPort);
        if (returnAddress == null) {
            return;
        }
        if (interfaceAddresses.containsKey(InetAddress.getByName(returnAddress)) && localPort == returnPort) {
            socket.close();
            return;
        }
        this.stunAddress = srvAddress;
        this.stunPort = srvPort;
        if (otherAddress == null) {
            socket.close();
            return;
        }
        InetAddress otherSrvAddress = InetAddress.getByName(otherAddress);
        stun.sendRequest(otherSrvAddress, srvPort);
        String otherReturnAddress = stun.getReturnAddress();
        int otherReturnPort = stun.getReturnPort();
        ResourceStore.syslog("discoverStun: Server " + otherAddress + ":" + srvPort + " returnAddress=" + otherReturnAddress + ":" + otherReturnPort);
        if (returnAddress.equals(otherReturnAddress) && otherReturnPort == returnPort) {
            this.natType = 1;
        }
        stun.sendRequest(otherSrvAddress, otherPort);
        otherReturnAddress = stun.getReturnAddress();
        otherReturnPort = stun.getReturnPort();
        ResourceStore.syslog("discoverStun: Server " + otherAddress + ":" + otherPort + " returnAddress=" + otherReturnAddress + ":" + otherReturnPort);
        this.natType = returnAddress.equals(otherReturnAddress) && otherReturnPort == returnPort ? 2 : 3;
        DatagramSocket socket2 = new DatagramSocket();
        socket.close();
        stun = new StunClient(socket2);
        stun.sendRequest(srvAddress, srvPort, 6);
        returnAddress = stun.getReturnAddress();
        returnPort = stun.getReturnPort();
        ResourceStore.syslog("discoverStun: Server " + srvAddr + ":" + srvPort + " returnAddress=" + returnAddress + ":" + returnPort);
        if (returnAddress != null) {
            this.natFType = 1;
        } else {
            stun.sendRequest(srvAddress, srvPort, 2);
            returnAddress = stun.getReturnAddress();
            returnPort = stun.getReturnPort();
            ResourceStore.syslog("discoverStun: Server " + srvAddr + ":" + srvPort + " returnAddress=" + returnAddress + ":" + returnPort);
            this.natFType = returnAddress != null ? 2 : 3;
        }
        socket2.close();
        ResourceStore.syslog("discoverStun: natType=" + this.natType + " natFType=" + this.natFType);
    }

    public boolean isStunUsable() {
        return this.stunAddress != null;
    }

    public boolean isNatUsable() {
        return this.stunAddress != null && this.natFType != 3;
    }

    public abstract String getRegistrationId();

    public abstract String getRegistrationAddress();

    public abstract String getFeatureServerAlias();

    public abstract void cancelRegistration(boolean var1);

    public abstract void updateRegistration();

    public abstract int getProtocolId();

    public abstract int getListenerPort();

    public abstract String getDefaultPortName();

    public abstract int[] getDefaultParameters();

    public abstract int[] getDefaultCapabilities();

    public static InetAddress getLocalDefaultAddress() throws UnknownHostException {
        return defaultAddress != null ? defaultAddress : InetAddress.getLocalHost();
    }

    public static void checkNetworkInterfaces() {
        defaultRoutes.clear();
        HashMap<InetAddress, Integer> interfaces = new HashMap<InetAddress, Integer>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                try {
                    if (!ni.isUp()) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Enumeration<InetAddress> enu = ni.getInetAddresses();
                while (enu.hasMoreElements()) {
                    InetAddress ia = enu.nextElement();
                    if (ia.isLoopbackAddress() || ia.isMulticastAddress()) continue;
                    interfaces.put(ia, new Integer(24));
                }
                try {
                    for (InterfaceAddress ifaddr : ni.getInterfaceAddresses()) {
                        InetAddress ia;
                        if (ifaddr == null || (ia = ifaddr.getAddress()).isLoopbackAddress() || ia.isMulticastAddress() || ifaddr.getNetworkPrefixLength() == -1) continue;
                        interfaces.put(ia, new Integer(ifaddr.getNetworkPrefixLength()));
                    }
                }
                catch (Exception e) {
                    ResourceStore.error("NetworkInterfaces " + ni + " - " + e);
                }
            }
        }
        catch (Throwable e) {
            ResourceStore.error("NetworkInterfaces", e);
        }
        if (!interfaces.equals(interfaceAddresses)) {
            defaultAddress = null;
            boolean defset = false;
            for (InetAddress ia : interfaces.keySet()) {
                if (defset) continue;
                boolean bl = defset = !ia.isLinkLocalAddress() && ia instanceof Inet4Address;
                if (defaultAddress != null && !defset && (defaultAddress instanceof Inet4Address || !(ia instanceof Inet4Address))) continue;
                defaultAddress = ia;
            }
            interfaceAddresses = interfaces;
        }
        if (defaultAddress == null) {
            try {
                defaultAddress = InetAddress.getLocalHost();
            }
            catch (Throwable x) {
                ResourceStore.error("getLocalHost", x);
            }
        }
        ResourceStore.syslog("Running network interfaces: " + interfaceAddresses + " defaultAddress=" + defaultAddress);
    }

    public String getLocalAddress(String remoteAddress, boolean withRouter) throws UnknownHostException {
        String host = remoteAddress;
        int n = host.indexOf(58);
        if (n != -1) {
            host = host.substring(0, n);
        }
        InetAddress iaddr = this.getLocalInetAddress(host, withRouter);
        return iaddr.getHostAddress();
    }

    public String getLocalAddress(String remoteAddress, String proxyAddress) throws UnknownHostException {
        return this.getLocalAddress(remoteAddress, proxyAddress, null);
    }

    public String getLocalAddress(String remoteAddr, String proxyAddr, String localAddr) throws UnknownHostException {
        InetAddress localHost;
        InetAddress rtpProxy = this.outboundRouter;
        if (proxyAddr != null) {
            try {
                rtpProxy = InetAddress.getByName(proxyAddr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        InetAddress inetAddress = localHost = this.isAnyaddress ? null : this.localAddress;
        if (localAddr != null) {
            try {
                localHost = InetAddress.getByName(localAddr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (localHost != null && (localHost.isLoopbackAddress() || localHost.isLinkLocalAddress())) {
                localHost = null;
            }
        }
        InetAddress iaddr = this.getLocalInetAddress(remoteAddr, localHost, rtpProxy);
        return iaddr.getHostAddress();
    }

    public InetAddress getLocalInetAddress(String remoteHost, boolean withRouter) throws UnknownHostException {
        InetAddress rtpProxy = withRouter ? this.outboundRouter : null;
        return this.getLocalInetAddress(remoteHost, rtpProxy);
    }

    public InetAddress getLocalInetAddress(String remoteHost, InetAddress rtpProxy) throws UnknownHostException {
        return this.getLocalInetAddress(remoteHost, this.isAnyaddress ? null : this.localAddress, rtpProxy);
    }

    public InetAddress getLocalInetAddress(String remoteHost, InetAddress localHost, InetAddress rtpProxy) throws UnknownHostException {
        if (localHost != null && rtpProxy == null) {
            return localHost;
        }
        Map interfaces = interfaceAddresses;
        if (interfaces.isEmpty()) {
            InetAddress address;
            try {
                address = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                address = InetAddress.getByName("127.0.0.1");
            }
            if (!(address instanceof Inet4Address)) {
                address = InetAddress.getByName("127.0.0.1");
            }
            return address;
        }
        if (rtpProxy == null && defaultAddress != null) {
            return defaultAddress;
        }
        InetAddress address = (InetAddress)defaultRoutes.get(remoteHost);
        if (address == null) {
            InetAddress remoteInetAddress = InetAddress.getByName(remoteHost);
            byte[] ra = remoteInetAddress.getAddress();
            int m = -1;
            for (InetAddress ia : interfaces.keySet()) {
                int mlen;
                if (localHost != null && !ia.equals(localHost) || (mlen = ((Integer)interfaces.get(ia)).intValue()) <= m || !this.isSameNetwork(ra, ia.getAddress(), mlen)) continue;
                address = ia;
                m = mlen;
            }
            if (address != null) {
                defaultRoutes.put(remoteHost, address);
                return address;
            }
            try {
                address = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                address = InetAddress.getByName("127.0.0.1");
            }
            defaultRoutes.put(remoteHost, ANY_ADDRESS);
        } else if (address != ANY_ADDRESS) {
            return address;
        }
        if (rtpProxy != null) {
            address = rtpProxy;
        } else if (defaultAddress != null) {
            address = defaultAddress;
        } else {
            try {
                address = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                address = InetAddress.getByName("127.0.0.1");
            }
            if (!(address instanceof Inet4Address)) {
                address = InetAddress.getByName("127.0.0.1");
            }
        }
        return address;
    }

    public boolean hasDirectNetworkRoute(String remoteAddress) {
        try {
            return this.hasDirectNetworkRoute(InetAddress.getByName(remoteAddress));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public boolean hasDirectNetworkRoute(InetAddress remoteInetAddress) {
        boolean isGlobal;
        if (remoteInetAddress == null) {
            return false;
        }
        boolean bl = isGlobal = !remoteInetAddress.isSiteLocalAddress();
        if (isGlobal && (!this.isAnyaddress && !this.localAddress.isSiteLocalAddress() || defaultAddress != null && !defaultAddress.isSiteLocalAddress())) {
            return true;
        }
        byte[] ra = remoteInetAddress.getAddress();
        Map interfaces = interfaceAddresses;
        for (InetAddress ia : interfaces.keySet()) {
            if (!this.isAnyaddress && !ia.equals(this.localAddress) || !this.isSameNetwork(ra, ia.getAddress(), (Integer)interfaces.get(ia))) continue;
            return true;
        }
        return false;
    }

    private boolean isSameNetwork(byte[] ra, byte[] la, int mask) {
        if (ra.length != la.length) {
            return false;
        }
        boolean ok = false;
        int m = mask;
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == ra[i]) {
                if ((m -= 8) > 0) continue;
                ok = true;
                break;
            }
            if (m >= 8) break;
            ok = (la[i] & (m = 65280 >> m & 0xFF)) == (ra[i] & m);
            break;
        }
        return ok;
    }

    static {
        try {
            ANY_ADDRESS = InetAddress.getByName("0.0.0.0");
        }
        catch (Exception e) {
            System.err.println(e);
        }
        next_base = 5000;
        DEF_ADDRESS = "0.0.0.0";
        interfaceAddresses = new HashMap();
        defaultRoutes = new HashMap();
    }
}

