/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.telephony.MediaEndpoint;
import com.smile.telephony.Mixer;
import com.smile.telephony.PipeSocket;
import com.smile.telephony.Resource;
import com.smile.telephony.RouteSocket;
import com.smile.telephony.video.VideoResource;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import smile.util.ResourceStore;
import smile.util.Sync;

public abstract class MediaSocket
extends PipeSocket {
    protected String portName;
    protected MediaEndpoint endpoint;
    protected int[] parameters;
    protected int[] capabilities;
    protected String localOpen;
    protected String localOpenAck;
    protected String remoteOpen;
    protected String remoteOpenAck;
    protected MediaSocket socket;
    protected boolean sigMode;
    protected boolean reopenRTPAllowed;
    protected boolean changeReceiverReq;
    protected boolean allowLocalDirect;
    protected boolean transcoding = true;
    private Sync synchro1 = new Sync();
    private Sync synchro2 = new Sync();
    protected int T1 = 5000;
    protected int T2 = 15000;
    protected int T3 = 5000;
    protected boolean signallingOnly = false;
    protected boolean sigOnlyAddress = false;
    protected boolean allowMediaConnect = false;
    protected boolean symnat = true;
    protected Hashtable localCapabilitiesInfo = new Hashtable();
    protected Hashtable remoteCapabilitiesInfo = new Hashtable();
    protected boolean accepted = false;
    protected int preferredCapability = 0;
    protected Vector acceptedCapabilities = new Vector();
    protected Vector localCryptoCapabilities;
    protected Vector remoteCryptoCapabilities;
    protected String tsmCryptoParameters;
    protected String rcvCryptoParameters;
    protected byte[] cryptokey;
    protected Vector localVideoCryptoCapabilities;
    protected Vector remoteVideoCryptoCapabilities;
    protected String tsmVideoCryptoParameters;
    protected String rcvVideoCryptoParameters;

    public void setName(String name) {
        this.portName = name;
    }

    public String getName() {
        return this.portName;
    }

    public String getPortId() {
        return this.portName;
    }

    public void setEndpoint(MediaEndpoint ep) {
        this.endpoint = ep;
        this.setProperties(null);
    }

    public MediaEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setProperties(Map map) {
        this.setLocalCapabilities(this.endpoint.getCapabilities());
        this.setLocalParameters(this.endpoint.getParameters());
    }

    public Map getProperties() {
        return this.endpoint.getProperties();
    }

    @Override
    protected int getMinJitter() {
        return this.endpoint.getMinJitter();
    }

    @Override
    protected int getMaxJitter() {
        return this.endpoint.getMaxJitter();
    }

    public InetAddress getServerAddress() {
        return this.endpoint.serverAddress;
    }

    protected void setLocalCapabilities(int[] caps) {
        this.capabilities = caps != null ? caps : this.endpoint.getCapabilities();
        this.localCapabilitiesInfo.clear();
        for (int i = 0; i < this.capabilities.length; ++i) {
            this.localCapabilitiesInfo.put(this.capabilities[i] & 0x1FF00, this.capabilities[i]);
        }
    }

    protected void setLocalParameters(int[] prms) {
        this.parameters = prms != null ? prms : this.endpoint.getParameters();
        this.T1 = this.parameters[2];
        this.T2 = this.parameters[3];
        this.T3 = this.parameters[4];
        this.setSignallingMode(this.parameters[5] & 3);
        this.buffering = (this.parameters[5] & 4) != 0;
        this.allowMediaConnect = (this.parameters[5] & 0x20) == 0;
        this.transdigmode = (this.parameters[5] & 0x200) == 0;
        this.symnat = (this.parameters[5] & 0x800) == 0;
        this.transcoding = (this.parameters[5] & 0x2000) == 0;
    }

    protected void setSignallingMode(int mode) {
        this.sigMode = mode != 0;
        this.signallingOnly = this.sigMode;
        this.reopenRTPAllowed = mode == 3;
    }

    public boolean isMediaConnectAllowed() {
        return this.allowMediaConnect;
    }

    @Override
    public boolean route(Resource resource, int mode) {
        if ((mode & 1) != 0) {
            if (resource instanceof MediaSocket && resource != this.socket) {
                ((MediaSocket)((Object)resource)).setRoutedSocket(this);
            } else if (resource instanceof Mixer) {
                if (this.socket != null) {
                    this.socket.clearSocket(this);
                    this.socket = null;
                }
                this.changeReceiverReq = this.signallingOnly;
                this.signallingOnly = false;
                this.fullRouting = true;
                this.localOpen = null;
                this.localOpenAck = null;
            }
        }
        return super.route(resource, mode);
    }

    public boolean setRoutedSocket(RouteSocket routeSocket) {
        if (routeSocket == null) {
            return false;
        }
        if (!(routeSocket instanceof MediaSocket)) {
            if (this.socket != null) {
                this.socket.clearSocket(this);
                this.socket = null;
            }
            this.signallingOnly = false;
            this.fullRouting = true;
            this.localOpen = null;
            this.localOpenAck = null;
            return true;
        }
        if (this.socket != null && this.socket != routeSocket) {
            this.socket.clearSocket(this);
            this.socket = (MediaSocket)routeSocket;
            boolean newmode = this.sigMode && this.socket instanceof MediaSocket && this.socket.sigMode && (!this.socket.accepted || this.socket.reopenRTPAllowed);
            this.changeReceiverReq = this.signallingOnly || newmode;
            this.signallingOnly = newmode;
            if (this.signallingOnly) {
                this.localOpen = this.socket.remoteOpen;
                this.localOpenAck = this.socket.remoteOpenAck;
            } else {
                this.localOpen = null;
                this.localOpenAck = null;
            }
            this.fullRouting = !this.signallingOnly;
            this.allowLocalDirect = false;
            return true;
        }
        if (!this.accepted && this.localOpenAck != null && !this.reopenRTPAllowed) {
            return false;
        }
        if (!this.transcoding || !((MediaSocket)routeSocket).transcoding) {
            boolean found = false;
            Hashtable info = ((MediaSocket)routeSocket).remoteCapabilitiesInfo;
            if (info.isEmpty()) {
                info = ((MediaSocket)routeSocket).localCapabilitiesInfo;
            }
            Enumeration en = this.localCapabilitiesInfo.keys();
            while (en.hasMoreElements()) {
                Integer key = (Integer)en.nextElement();
                if (!info.containsKey(key | 0x10000) && !info.containsKey(key & 0xFF00)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        this.signallingOnly = this.sigMode && (!this.accepted || this.reopenRTPAllowed);
        this.socket = (MediaSocket)routeSocket;
        boolean bl = this.signallingOnly = this.signallingOnly && this.socket.sigMode && (!this.socket.accepted || this.socket.reopenRTPAllowed);
        if (this.signallingOnly) {
            this.localOpen = this.socket.remoteOpen;
            this.localOpenAck = this.socket.remoteOpenAck;
        } else {
            this.localOpen = null;
            this.localOpenAck = null;
            this.synchro1.doNotification();
            this.synchro2.doNotification();
        }
        this.fullRouting = !this.signallingOnly;
        this.changeReceiverReq = false;
        this.allowLocalDirect = false;
        return true;
    }

    protected void clear() {
        this.changeReceiverReq = false;
        this.allowLocalDirect = false;
        this.signallingOnly = false;
        this.accepted = false;
        if (this.socket != null) {
            try {
                this.socket.clearSocket(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
        this.localOpen = null;
        this.localOpenAck = null;
        this.remoteOpen = null;
        this.remoteOpenAck = null;
        this.preferredCapability = 0;
        this.fullRouting = true;
        this.sigOnlyAddress = false;
        this.transcoding = true;
        this.acceptedCapabilities.clear();
        this.remoteCapabilitiesInfo.clear();
        this.cryptokey = null;
        this.tsmCryptoParameters = null;
        this.rcvCryptoParameters = null;
        this.localCryptoCapabilities = null;
        this.remoteCryptoCapabilities = null;
        this.rcvVideoCryptoParameters = null;
        this.tsmVideoCryptoParameters = null;
        this.localVideoCryptoCapabilities = null;
        this.remoteVideoCryptoCapabilities = null;
        this.synchro1.doNotification();
        this.synchro2.doNotification();
    }

    protected void clearSocket(RouteSocket routeSocket) {
        if (this.socket == routeSocket) {
            this.localOpen = null;
            this.localOpenAck = null;
            this.socket = null;
            this.sigOnlyAddress = false;
            this.synchro1.doNotification();
        }
    }

    protected void onAcceptCall() {
        if (this.socket == null) {
            this.accepted = true;
            this.signallingOnly = false;
            this.synchro1.doNotification();
        }
    }

    protected boolean isMediaAddressReady(boolean withAck) {
        if (!this.signallingOnly) {
            return true;
        }
        try {
            this.localOpen = this.socket.remoteOpen;
            this.localOpenAck = this.socket.remoteOpenAck;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this.localOpen != null && (!withAck || this.localOpenAck != null);
    }

    protected String getMediaAddress(boolean tsmit) {
        if (!this.sigMode) {
            return null;
        }
        if (this.socket == null && this.signallingOnly) {
            this.synchro1.waitForNotification(this.T1);
        }
        if (this.socket == null || !this.signallingOnly) {
            return null;
        }
        try {
            if (tsmit) {
                this.localOpen = this.socket.remoteOpen;
                if (this.localOpen == null) {
                    this.synchro1.waitForNotification(this.T3);
                }
                this.localOpen = this.socket.remoteOpen;
                return this.localOpen;
            }
            this.localOpenAck = this.socket.remoteOpenAck;
            if (this.localOpenAck == null) {
                this.synchro2.waitForNotification(this.T3);
            }
            this.localOpenAck = this.socket.remoteOpenAck;
            return this.localOpenAck;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void setMediaAddress(String address, int dir) {
        if ((dir & 1) != 0) {
            this.remoteOpen = address;
        }
        if ((dir & 2) != 0) {
            this.remoteOpenAck = address;
        }
        if (this.socket != null) {
            this.allowLocalDirect = this.socket.allowLocalDirect;
            this.socket.remoteMediaDefined(address, dir, this.preferredCapability);
        }
    }

    protected void remoteMediaDefined(String address, int dir, int preferredCap) {
        this.toLog(" remoteMediaDefined=" + address + " dir=" + dir + " signallingOnly=" + this.signallingOnly + " reopenRTPAllowed=" + this.reopenRTPAllowed + " localOpenAck=" + this.localOpenAck + " remoteOpenAck=" + this.remoteOpenAck);
        this.preferredCapability = preferredCap;
        if (!this.signallingOnly) {
            return;
        }
        if ((dir & 2) != 0) {
            if (!address.equals(this.localOpenAck) && this.localOpenAck != null && this.reopenRTPAllowed) {
                this.changeReceiverReq = true;
                if (this.remoteOpenAck != null && this.remoteOpenAck.substring(0, this.remoteOpenAck.indexOf(58)).equals(this.localOpenAck.substring(0, this.localOpenAck.indexOf(58)))) {
                    this.allowLocalDirect = true;
                }
            }
            this.localOpenAck = address;
            this.synchro2.doNotification();
        }
        if ((dir & 1) != 0) {
            this.localOpen = address;
            this.synchro1.doNotification();
        }
    }

    protected void setLocalMediaAddress(boolean mode) {
        this.sigOnlyAddress = mode;
        if (this.socket != null) {
            this.socket.signallingOnly = mode;
        }
    }

    public boolean mediaAddressChanged(String address) {
        if (this.socket == null || !this.reopenRTPAllowed) {
            return false;
        }
        this.remoteOpen = address;
        this.remoteOpenAck = address;
        this.socket.redefineMedia();
        return true;
    }

    public boolean redefineMedia() {
        return false;
    }

    protected Hashtable getCallCapabilitiesInfo() {
        return this.socket.remoteCapabilitiesInfo;
    }

    protected boolean isMediaRouting() {
        return this.localOpenAck == null || this.remoteOpenAck == null;
    }

    protected void setMediaRouting() {
        this.localOpen = null;
        this.localOpenAck = null;
        if (this.socket != null) {
            this.socket.localOpen = null;
            this.socket.localOpenAck = null;
        }
    }

    protected void setMediaParameters(int codecid, boolean ssup, int pSize) {
        this.setMediaParameters(codecid, ssup, pSize, 0);
    }

    protected void setMediaParameters(int codecid, boolean ssup, int pSize, int oldCapability) {
        for (int i = 0; i < this.capabilities.length; ++i) {
            if (codecid != (this.capabilities[i] >> 8 & 0xFF)) continue;
            int key = this.capabilities[i] & 0xFF00;
            if (ssup) {
                key |= 0x10000;
            }
            int value = key + (pSize != 0 ? pSize : this.capabilities[i] & 0xFF);
            this.remoteCapabilitiesInfo.put(key, value);
            int cap = this.capabilities[i];
            if (this.preferredCapability == 0 || this.capabilities[i] == oldCapability) {
                this.preferredCapability = cap;
            }
            this.acceptedCapabilities.add(cap);
            break;
        }
        this.toLog(" cap=(" + this.capabilitiesToString() + ") setMediaParameters codecid=" + codecid + " ssup=" + ssup + " pSize=" + pSize + " pref=" + this.preferredCapability + " acceptedCapabilities=" + this.acceptedCapabilities);
    }

    protected void setPreferredCapability(int codecid) {
        if (codecid == (this.preferredCapability >> 8 & 0xFF)) {
            return;
        }
        for (int i = 0; i < this.capabilities.length; ++i) {
            if (codecid != (this.capabilities[i] >> 8 & 0xFF)) continue;
            this.preferredCapability = this.capabilities[i];
            break;
        }
    }

    protected void clearAcceptedCapabilities() {
        this.acceptedCapabilities.clear();
        this.preferredCapability = 0;
    }

    protected int getCapability(int codecid) {
        for (int i = 0; i < this.capabilities.length; ++i) {
            if (codecid != (this.capabilities[i] >> 8 & 0xFF)) continue;
            return this.capabilities[i];
        }
        return 0;
    }

    protected int getPreferredCapability() {
        return this.preferredCapability;
    }

    protected void removeMediaParameters(int codecid) {
        int key = (codecid & 0xFF) << 8;
        this.localCapabilitiesInfo.remove(new Integer(key));
        this.localCapabilitiesInfo.remove(new Integer(0x10000 | key));
        this.remoteCapabilitiesInfo.remove(new Integer(key));
        this.remoteCapabilitiesInfo.remove(new Integer(0x10000 | key));
    }

    protected Vector getAcceptedCapabilities() {
        if (this.socket != null && this.socket.preferredCapability != 0) {
            int prefCap = this.socket.preferredCapability;
            for (int i = 0; i < this.acceptedCapabilities.size(); ++i) {
                int cap = (Integer)this.acceptedCapabilities.elementAt(i);
                if ((cap & 0xFF00) != (prefCap & 0xFF00)) continue;
                this.acceptedCapabilities.removeElementAt(i);
                this.acceptedCapabilities.insertElementAt(cap, 0);
            }
        }
        return this.acceptedCapabilities;
    }

    protected int[] getOfferedCapabilities() {
        Integer prefCap;
        if (this.socket == null || this.socket.remoteCapabilitiesInfo.isEmpty()) {
            return this.capabilities;
        }
        Vector<Integer> caps = new Vector<Integer>();
        Vector<Integer> caps1 = new Vector<Integer>();
        Vector<Integer> caps2 = new Vector<Integer>();
        int fax = 0;
        for (int i = 0; i < this.capabilities.length; ++i) {
            int c = this.capabilities[i] & 0x1FF00;
            if (c == 25088) {
                fax = this.capabilities[i];
                continue;
            }
            Object cap = this.socket.remoteCapabilitiesInfo.get(new Integer(c));
            if (cap == null) {
                cap = (c & 0x10000) != 0 ? this.socket.remoteCapabilitiesInfo.get(new Integer(c & 0xFF00)) : this.socket.remoteCapabilitiesInfo.get(new Integer(c | 0x10000));
            }
            if (cap != null) {
                caps.addElement(this.buffering ? this.capabilities[i] : (Integer)cap);
                continue;
            }
            boolean f = false;
            for (int j = 0; j < this.socket.capabilities.length; ++j) {
                if ((this.socket.capabilities[j] & 0xFF00) != (c & 0xFF00)) continue;
                caps1.addElement(new Integer(this.socket.capabilities[j]));
                f = true;
                break;
            }
            if (f) continue;
            caps2.addElement(new Integer(this.capabilities[i]));
        }
        Enumeration en = caps1.elements();
        while (en.hasMoreElements()) {
            caps.addElement((Integer)en.nextElement());
        }
        if (caps.isEmpty()) {
            if (this.signallingOnly || !this.fullRouting) {
                return null;
            }
            return this.capabilities;
        }
        en = caps2.elements();
        while (en.hasMoreElements()) {
            caps.addElement((Integer)en.nextElement());
        }
        if (fax != 0) {
            caps.addElement(new Integer(fax));
        }
        if (caps.removeElement(prefCap = new Integer(this.socket.preferredCapability))) {
            caps.insertElementAt(prefCap, 0);
        }
        int[] callCapabilities = new int[caps.size()];
        for (int i = 0; i < callCapabilities.length; ++i) {
            callCapabilities[i] = (Integer)caps.elementAt(i);
        }
        return callCapabilities;
    }

    protected int getCapabilityInfo(int codecId) {
        if (this.socket != null) {
            int c = codecId << 8;
            Object cap = this.socket.remoteCapabilitiesInfo.get(new Integer(c));
            if (cap != null) {
                return (Integer)cap;
            }
            cap = this.socket.remoteCapabilitiesInfo.get(new Integer(c | 0x10000));
            if (cap != null) {
                return (Integer)cap;
            }
        }
        for (int i = 0; i < this.capabilities.length; ++i) {
            if (codecId != (this.capabilities[i] >> 8 & 0xFF)) continue;
            return this.capabilities[i];
        }
        return 0;
    }

    public Hashtable getCallInfo() {
        Hashtable<String, String> info = new Hashtable<String, String>();
        if (this.remoteOpen != null) {
            info.put("cti.MediaAddress", this.remoteOpen.substring(0, this.remoteOpen.indexOf(":")));
        }
        return info;
    }

    protected void setLocalCryptoCapabilities() {
        this.localCryptoCapabilities = this.endpoint.getCryptoCapabilities();
        if (this instanceof VideoResource) {
            this.localVideoCryptoCapabilities = this.endpoint.getCryptoCapabilities();
        }
    }

    protected Vector getLocalCryptoCapabilities() {
        if (this.sigOnlyAddress) {
            return this.socket.remoteCryptoCapabilities;
        }
        if (this.tsmCryptoParameters != null) {
            Vector<String> v = new Vector<String>();
            v.add(this.tsmCryptoParameters);
            return v;
        }
        return this.localCryptoCapabilities;
    }

    protected void setRemoteCryptoCapabilities(Vector caps) {
        if (caps == null || this.localCryptoCapabilities == null) {
            return;
        }
        this.remoteCryptoCapabilities = caps;
        Enumeration en = this.remoteCryptoCapabilities.elements();
        while (en.hasMoreElements()) {
            String capability = (String)en.nextElement();
            int n = capability.indexOf(32);
            if (n == -1) continue;
            String tag = capability.substring(0, n);
            String cap = capability.substring(n + 1);
            if ((n = cap.indexOf(32)) == -1) continue;
            cap = cap.substring(0, n).trim();
            for (int i = 0; i < this.localCryptoCapabilities.size(); ++i) {
                String localCap = (String)this.localCryptoCapabilities.elementAt(i);
                int c = localCap.indexOf(cap);
                if (c == -1) continue;
                String capkey = localCap.substring(c);
                this.tsmCryptoParameters = tag + " " + capkey;
                this.rcvCryptoParameters = capability;
                return;
            }
        }
    }

    protected Vector getLocalVideoCryptoCapabilities() {
        if (this.sigOnlyAddress) {
            return this.socket.remoteVideoCryptoCapabilities;
        }
        if (this.tsmVideoCryptoParameters != null) {
            Vector<String> v = new Vector<String>();
            v.add(this.tsmVideoCryptoParameters);
            return v;
        }
        return this.localVideoCryptoCapabilities;
    }

    protected void setRemoteVideoCryptoCapabilities(Vector caps) {
        if (caps == null || this.localVideoCryptoCapabilities == null) {
            return;
        }
        this.remoteVideoCryptoCapabilities = caps;
        Enumeration en = this.remoteVideoCryptoCapabilities.elements();
        while (en.hasMoreElements()) {
            String capability = (String)en.nextElement();
            int n = capability.indexOf(32);
            if (n == -1) continue;
            String tag = capability.substring(0, n);
            String cap = capability.substring(n + 1);
            if ((n = cap.indexOf(32)) == -1) continue;
            cap = cap.substring(0, n).trim();
            for (int i = 0; i < this.localVideoCryptoCapabilities.size(); ++i) {
                String localCap = (String)this.localVideoCryptoCapabilities.elementAt(i);
                int c = localCap.indexOf(cap);
                if (c == -1) continue;
                String capkey = localCap.substring(c);
                this.tsmVideoCryptoParameters = tag + " " + capkey;
                this.rcvVideoCryptoParameters = capability;
                return;
            }
        }
    }

    public abstract String getCodec();

    public abstract int getPacketsSent();

    public abstract int getOctetsSent();

    public abstract int getPacketsReceived();

    public abstract int getOctetsReceived();

    public abstract int getPacketsLost();

    public abstract int getJitter();

    public abstract int getJitterMax();

    public abstract int getPacketsSentLost();

    public abstract int getJitterFarEnd();

    public abstract int getDelay();

    public abstract int getDelayMax();

    public abstract void forceDisconnect();

    private String capabilitiesToString() {
        Object str = "";
        for (int i = 0; i < this.capabilities.length; ++i) {
            str = (String)str + this.capabilities[i] + " ";
        }
        return str;
    }

    public void toLog(String str) {
        ResourceStore.toLog(this.portName + ": " + str);
    }
}

