/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.sound.WavAudioFormat;
import com.smile.sound.WaveParser;
import com.smile.sound.wavFormatHeader;
import com.smile.telephony.AudioCodec;
import com.smile.telephony.AudioConverter;
import com.smile.telephony.CTIPort;
import com.smile.telephony.CallInfo;
import com.smile.telephony.CyclePlaybackStream;
import com.smile.telephony.PipeInputStream;
import com.smile.telephony.PipeSocket;
import com.smile.telephony.Resource;
import com.smile.telephony.RouteSocket;
import com.smile.telephony.ToneGenerator;
import com.smile.telephony.audio.SignalProcessor;
import com.smile.telephony.codec.ConvertedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

public class Mixer
extends PipeSocket
implements Resource,
Runnable {
    public static final String CC_SET_SPEAKER = "<set_speaker>";
    public static final String CC_MICROPHONE_ON = "<microphone_on>";
    public static final String CC_MICROPHONE_OFF = "<microphone_off>";
    public static final String CC_PROMPT_MODE = "<prompt_mode>";
    public static final String CC_SPEAKERS_MODE = "<speakers_mode>";
    static final int MAXBUFFERS = 256;
    static final int FRAMETIME = 20;
    static final int BUFSIZE = 320;
    static final boolean VAD = true;
    static final WavAudioFormat[] WCODEC = new WavAudioFormat[]{WavAudioFormat.PCM_LINEAR16};
    static final AudioCodec[] CODEC = new AudioCodec[]{AudioCodec.PCM16LINEAR};
    private static byte[] GAUSSIAN = new byte[320000];
    private int state = 0;
    private Hashtable inputStreams = new Hashtable();
    private Hashtable outputStreams = new Hashtable();
    private HashSet routedNames = new HashSet();
    private Vector holds = new Vector();
    private Object holdPlayer = null;
    private InputStream backstream = null;
    protected Object root = null;
    protected Object mainsrc = null;
    protected Object maintgt = null;
    protected HashSet targets = new HashSet();
    protected HashSet sources = new HashSet();
    protected Hashtable mutes = new Hashtable();
    protected Hashtable dsps = new Hashtable();
    protected HashSet speakers = new HashSet();
    private boolean mute = false;
    private boolean prompt = false;
    private boolean spksmode = false;
    private boolean vadmode = SignalProcessor.isPresent;
    private boolean agcmode = false;
    static final int NO_ACTION = 0;
    static final int PLAY_MUSIC = 1;
    static final int SET_MUTE = 2;
    public static final int STATE_IDLE = 0;
    public static final int STATE_BUSY = 1;

    public Mixer() {
        this.buffering = true;
        this.blockingRead = false;
        this.state = 1;
        Thread thrd = new Thread((Runnable)this, "Mixer-" + this);
        thrd.setPriority(9);
        thrd.start();
    }

    public void conferenceJoined(CTIPort port) {
    }

    public String processMediaControl(String str) {
        return null;
    }

    public void sourceAction(int action) {
    }

    public CallInfo getCallInfo() {
        CallInfo info = new CallInfo("");
        return info;
    }

    @Override
    public boolean seize() {
        return false;
    }

    public void close() {
        this.state = 0;
    }

    @Override
    public void release() {
        if (this.backstream != null) {
            try {
                this.backstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.inputStreams.isEmpty() && this.holds.isEmpty() && this.outputStreams.isEmpty()) {
            this.close();
        }
    }

    public boolean isManaged() {
        return this.root != null;
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object obj) {
        this.root = obj;
    }

    public void addTarget(Object src) {
        this.targets.add(src);
    }

    public void removeTarget(Object src) {
        this.targets.remove(src);
    }

    public void setSingleTargetMode(Object src) {
        this.targets.clear();
        if (src != null) {
            this.targets.add(src);
        }
    }

    public void addSource(Object src) {
        this.sources.add(src);
    }

    public void removeSource(Object src) {
        this.sources.remove(src);
        if (src == this.mainsrc) {
            this.mainsrc = null;
        }
    }

    public void setSingleSourceMode(Object src) {
        this.sources.clear();
        if (src != null) {
            this.mainsrc = src;
            this.sources.add(src);
        }
    }

    public Object getMainSource() {
        return this.mainsrc;
    }

    public void setMainTarget(Object tgt) {
        this.maintgt = tgt;
    }

    public Object getMainTarget() {
        return this.maintgt;
    }

    public void setPromptMode(boolean mode) {
        this.prompt = mode;
    }

    public boolean isPromptMode() {
        return this.prompt;
    }

    public void setSpeakersMode(boolean mode) {
        this.spksmode = mode;
    }

    public boolean isSpeakersMode() {
        return this.spksmode;
    }

    public void setVADMode(boolean mode) {
        this.vadmode = mode;
    }

    public boolean isVADMode() {
        return this.vadmode;
    }

    public void setAGCMode(boolean mode) {
        this.agcmode = mode;
    }

    public boolean isAGCMode() {
        return this.agcmode;
    }

    public HashSet getSources() {
        return this.sources;
    }

    public HashSet getTargets() {
        return this.targets;
    }

    public void setMute(Object source, Object target) {
        this.mutes.put(source, target);
    }

    public void mute(Object src) {
        this.sources.remove(src);
    }

    public int onHold(CTIPort obj, String filename) throws IOException {
        if (!this.mutes.isEmpty()) {
            RouteSocket socket = obj.getRouteSocket();
            if (this.mutes.remove(socket) == null) {
                Object muted = this.mutes.elements().nextElement();
                this.mutes.put(socket, muted);
            }
            return 2;
        }
        this.holds.addElement(obj);
        if (this.inputStreams.size() == this.outputStreams.size() || this.inputStreams.size() > 2 || !new File(filename).exists()) {
            return 0;
        }
        Enumeration en = this.outputStreams.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            if (this.inputStreams.containsKey(key)) continue;
            this.holdPlayer = key;
            break;
        }
        if (this.holdPlayer == null) {
            return 0;
        }
        File file = new File(filename);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("user.home"), filename);
        }
        InputStream voicedata = file.exists() ? new FileInputStream(file) : this.getClass().getClassLoader().getResourceAsStream(filename);
        wavFormatHeader hdr = new wavFormatHeader();
        voicedata = new WaveParser().parseWavHeader(voicedata, hdr);
        WavAudioFormat codec = hdr.getAudioFormat();
        AudioConverter acv = new AudioConverter();
        CyclePlaybackStream cin = new CyclePlaybackStream(acv.getInputStream(voicedata, codec, WCODEC));
        this.inputStreams.put(this.holdPlayer, cin);
        return 1;
    }

    public void setBackgroundSream(InputStream stream) {
        this.backstream = stream;
    }

    public void onConnect(CTIPort obj, int mode) {
        this.onResume(obj);
        if (mode == 3 && this.inputStreams.size() > 2) {
            this.playConferenceTone();
        }
    }

    public void onResume(CTIPort obj) {
        this.holds.removeElement(obj);
        if (this.holds.isEmpty() && this.holdPlayer != null) {
            this.cancelPlayback(this.holdPlayer);
            this.holdPlayer = null;
        }
    }

    public void replaceHold(CTIPort oldhold, CTIPort newhold) {
        this.holds.removeElement(oldhold);
        this.holds.addElement(newhold);
        Object obj = this.inputStreams.remove(oldhold);
        if (obj != null) {
            this.inputStreams.put(newhold, obj);
        }
    }

    public void reRoute() {
        this.mutes.clear();
        this.playConferenceTone();
    }

    public void playConferenceTone() {
        ByteArrayInputStream bais = new ByteArrayInputStream(ToneGenerator.get("Conference"));
        Object o = new Object();
        this.inputStreams.put(o, bais);
        try {
            Thread.sleep(ToneGenerator.getOnTime("Conference"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.inputStreams.remove(o);
    }

    public void startPlayFile(Object obj, File file) throws IOException {
        InputStream voicedata = new FileInputStream(file);
        wavFormatHeader hdr = new wavFormatHeader();
        voicedata = new WaveParser().parseWavHeader(voicedata, hdr);
        WavAudioFormat codec = hdr.getAudioFormat();
        AudioConverter acv = new AudioConverter();
        CyclePlaybackStream cin = new CyclePlaybackStream(acv.getInputStream(voicedata, codec, WCODEC));
        this.inputStreams.put(obj, cin);
    }

    public void stopPlayFile(Object obj) {
        this.cancelPlayback(obj);
    }

    public boolean startPlayPrompt(CTIPort port, InputStream voicedata, WavAudioFormat codec) {
        AudioConverter acv = new AudioConverter();
        ConvertedInputStream cin = acv.getInputStream(voicedata, codec, WCODEC);
        if (cin == null) {
            return false;
        }
        this.inputStreams.put(port, cin);
        this.mute = true;
        return true;
    }

    public void stopPlayPrompt(CTIPort port) {
        this.inputStreams.remove(port);
        this.mute = false;
    }

    public void startRecord(Object ps, OutputStream ostream) {
        this.outputStreams.put(ps, ostream);
    }

    public OutputStream stopRecord(Object ps) {
        return (OutputStream)this.outputStreams.remove(ps);
    }

    public void stopAll() {
        this.inputStreams.clear();
        this.outputStreams.clear();
    }

    public InputStream getInputStream(Object ps) {
        return (InputStream)this.inputStreams.get(ps);
    }

    public OutputStream getOutputStream(Object ps) {
        return (OutputStream)this.outputStreams.get(ps);
    }

    public Hashtable getInputStreams() {
        return this.inputStreams;
    }

    public Hashtable getOutputStreams() {
        return this.outputStreams;
    }

    @Override
    protected boolean startRecord(Object ps, OutputStream ostream, AudioCodec codec) {
        this.outputStreams.put(ps, ostream);
        if (ps instanceof Resource) {
            this.routedNames.add(((Resource)ps).getName());
        }
        return true;
    }

    @Override
    protected void cancelRecord(Object ps) {
        OutputStream os = (OutputStream)this.outputStreams.remove(ps);
        if (ps instanceof Resource) {
            this.routedNames.remove(((Resource)ps).getName());
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected boolean startPlayback(Object ps, InputStream istream, AudioCodec codec) {
        this.inputStreams.put(ps, istream);
        this.mutes.remove(ps);
        if (ps instanceof Resource) {
            this.routedNames.add(((Resource)ps).getName());
        }
        if (this.vadmode) {
            SignalProcessor dsp = new SignalProcessor(160, 8000, 8000);
            dsp.setVAD(1);
            if (this.agcmode) {
                dsp.setAGC(3);
            }
            this.dsps.put(ps, dsp);
        }
        return true;
    }

    @Override
    protected void cancelPlayback(Object ps) {
        InputStream is = (InputStream)this.inputStreams.remove(ps);
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sources.remove(ps);
        if (this.vadmode) {
            SignalProcessor dsp = (SignalProcessor)this.dsps.remove(ps);
            if (dsp != null) {
                dsp.destroy();
            }
            this.speakers.remove(ps);
        }
        if (ps == this.mainsrc) {
            this.mainsrc = null;
        }
        this.mutes.remove(ps);
    }

    public Set getSpeakers() {
        return this.speakers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] mix = new byte[320];
        long nextTick = System.currentTimeMillis();
        Hashtable buffers = new Hashtable(256);
        byte[][] buffs = new byte[256][];
        int e = 0;
        int g = 0;
        int c = 0;
        while (this.state == 1) {
            OutputStream o;
            Object ps;
            long timeout = (nextTick += 20L) - System.currentTimeMillis();
            if (timeout > 0L) {
                Mixer mixer = this;
                synchronized (mixer) {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.inputStreams.isEmpty()) {
                    if (++e <= 10000) continue;
                    this.close();
                    continue;
                }
                e = 0;
            }
            buffers.clear();
            Enumeration en = this.inputStreams.keys();
            while (en.hasMoreElements()) {
                ps = en.nextElement();
                try {
                    InputStream in = (InputStream)this.inputStreams.get(ps);
                    byte[] buffer = new byte[320];
                    int n = in.read(buffer);
                    if (n == 320 && (!this.mute || ps instanceof CTIPort) && (this.sources.isEmpty() || this.sources.contains(ps) || this.prompt && ps == this.root && this.mainsrc != null && this.mainsrc != this.root)) {
                        SignalProcessor dsp;
                        if (this.vadmode && (dsp = (SignalProcessor)this.dsps.get(ps)) != null) {
                            int vad = dsp.process(buffer);
                            if (vad == 1) {
                                this.speakers.add(ps);
                            } else {
                                this.speakers.remove(ps);
                                if (in instanceof PipeInputStream) {
                                    int minbuf = ((PipeInputStream)in).getMinBufferSize();
                                    while (in.available() > minbuf && minbuf > 0 && (n = in.read(buffer)) == 320) {
                                        vad = dsp.process(buffer);
                                        if (vad != 1) continue;
                                        this.speakers.add(ps);
                                        break;
                                    }
                                    if (n != 320) continue;
                                }
                            }
                        }
                        buffers.put(ps, buffer);
                        continue;
                    }
                    if (n != -1 || !(ps instanceof CTIPort)) continue;
                    ((CTIPort)ps).terminate();
                }
                catch (Exception in) {}
            }
            if (buffers.isEmpty()) {
                if (++c > 500 && this.backstream != null) {
                    try {
                        this.backstream.read(mix);
                        en = this.outputStreams.keys();
                        while (en.hasMoreElements()) {
                            ps = en.nextElement();
                            if (!(ps instanceof PipeSocket)) continue;
                            o = (OutputStream)this.outputStreams.get(ps);
                            o.write(mix);
                        }
                        continue;
                    }
                    catch (Exception en2) {
                        continue;
                    }
                }
            } else {
                c = 0;
            }
            en = this.outputStreams.keys();
            while (en.hasMoreElements()) {
                ps = en.nextElement();
                if (this.spksmode && !this.sources.isEmpty() && !this.sources.contains(ps)) continue;
                int k = 0;
                Enumeration eno = buffers.keys();
                while (eno.hasMoreElements()) {
                    byte[] b;
                    Object key = eno.nextElement();
                    if (key == ps || this.mutes.get(key) == ps || !this.targets.isEmpty() && !this.targets.contains(ps) && !this.targets.contains(key) || key == this.root && !this.sources.isEmpty() && !this.sources.contains(key) && (!this.prompt || ps != this.mainsrc) || (b = (byte[])buffers.get(key)) == null) continue;
                    buffs[k++] = b;
                }
                if (k == 0) {
                    if (!(ps instanceof PipeSocket)) continue;
                    try {
                        System.arraycopy(GAUSSIAN, g, mix, 0, 320);
                    }
                    catch (Exception ex) {
                        g = 0;
                    }
                } else if (k == 1) {
                    System.arraycopy(buffs[0], 0, mix, 0, 320);
                } else {
                    for (int i = 0; i < mix.length; i += 2) {
                        int s = 0;
                        for (int j = 0; j < k; ++j) {
                            s += buffs[j][i + 1] << 8 | buffs[j][i] & 0xFF;
                        }
                        mix[i] = (byte)s;
                        mix[i + 1] = (byte)(s >> 8);
                    }
                }
                try {
                    o = (OutputStream)this.outputStreams.get(ps);
                    o.write(mix);
                }
                catch (Exception exception) {}
            }
            if ((g += 320) < GAUSSIAN.length) continue;
            g = 0;
        }
    }

    @Override
    public AudioCodec[] getAudioCodecs(int mode) {
        return CODEC;
    }

    @Override
    public boolean startPlayback(AudioCodec codec) {
        return true;
    }

    @Override
    public boolean startRecord(AudioCodec codec) {
        return true;
    }

    @Override
    public void stopPlayback() {
    }

    @Override
    public void stopRecord() {
    }

    @Override
    public boolean isCallDisconnected() {
        return false;
    }

    @Override
    public int getType() {
        return 32;
    }

    @Override
    public String getName() {
        return "Mixer";
    }

    public HashSet getRoutedNames() {
        return this.routedNames;
    }

    public Vector getHolds() {
        return this.holds;
    }

    public int getLinesCount() {
        return this.inputStreams.size();
    }

    public WavAudioFormat[] getAvailableCodecs(int direction) {
        return WCODEC;
    }

    protected boolean isConnected() {
        return false;
    }

    public void transmitDigit(char digit, Object obj) {
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public RouteSocket getRouteSocket() {
        return this;
    }

    @Override
    public String getErrorMessage() {
        return "";
    }

    @Override
    public int getRecBufferDepth() {
        return 1;
    }

    @Override
    public int getPlayBufferDepth() {
        return 1;
    }

    static {
        Random random = new Random();
        int max = 4;
        int i = 0;
        do {
            int n = (int)(Math.round((double)max * random.nextDouble()) - (long)(max / 2));
            Mixer.GAUSSIAN[i++] = (byte)(n & 0xFF);
            Mixer.GAUSSIAN[i++] = (byte)(n >> 8);
        } while (i < GAUSSIAN.length);
    }
}

