/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.telephony.audio.SignalProcessor;
import java.io.IOException;
import java.io.OutputStream;

public class PipeOutputStream
extends OutputStream {
    private byte[] buffer;
    private int currentRead = 0;
    private int currentWrite = 0;
    private volatile int bytesToRead = 0;
    private boolean closed = false;
    private boolean firstRead = false;
    private boolean readBlock;
    private int frameTime;
    private int frameSize;
    private int minBufferTime;
    private int minBufBytes;
    private boolean marker;
    private boolean jitter;
    private SignalProcessor sp;

    public void setBuffer(int frameSize, int frameTime, boolean blockingRead, int minJitter, int maxJitter) {
        this.frameSize = frameSize;
        this.frameTime = frameTime;
        this.closed = false;
        this.firstRead = false;
        this.readBlock = blockingRead;
        this.minBufferTime = minJitter;
        this.marker = this.jitter = minJitter >= frameTime;
        this.minBufBytes = this.minBufferTime / frameTime * frameSize;
        this.buffer = new byte[frameSize * (maxJitter / frameTime)];
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        if (this.buffer == null) {
            return;
        }
        int c = this.currentWrite;
        for (int i = 0; i < len; ++i) {
            this.buffer[c] = b[offset + i];
            if (++c != this.buffer.length) continue;
            c = 0;
        }
        this.currentWrite = c;
        this.bytesToRead += len;
    }

    public int read() throws IOException {
        return 0;
    }

    public int read(byte[] b, int offset, int len) throws IOException {
        int i;
        if (this.closed) {
            return -1;
        }
        if (this.buffer == null || this.bytesToRead < len) {
            if (this.bytesToRead == 0 && this.jitter) {
                this.marker = true;
            }
            return 0;
        }
        if (!this.firstRead) {
            this.firstRead = true;
            int skipcount = this.bytesToRead - this.minBufBytes;
            if (skipcount > 0) {
                this.marker = false;
                this.currentRead += skipcount;
                while (this.currentRead >= this.buffer.length) {
                    this.currentRead -= this.buffer.length;
                }
                this.bytesToRead -= skipcount;
                if (this.bytesToRead < len) {
                    return 0;
                }
            }
        }
        if (this.jitter && this.marker) {
            if (this.bytesToRead < this.minBufBytes) {
                return 0;
            }
            this.marker = false;
        }
        if (this.bytesToRead > this.buffer.length) {
            this.currentRead += this.bytesToRead - this.buffer.length;
            while (this.currentRead >= this.buffer.length) {
                this.currentRead -= this.buffer.length;
            }
            this.bytesToRead = this.buffer.length;
        } else {
            this.currentRead = this.currentWrite - this.bytesToRead;
            if (this.currentRead < 0) {
                this.currentRead += this.buffer.length;
            }
        }
        int j = Math.min(len, this.bytesToRead);
        for (i = 0; i < j; ++i) {
            b[offset + i] = this.buffer[this.currentRead];
            if (++this.currentRead != this.buffer.length) continue;
            this.currentRead = 0;
        }
        this.bytesToRead -= i;
        return i;
    }

    @Override
    public void write(int b) throws IOException {
    }

    public int available() throws IOException {
        if (this.buffer == null) {
            return 0;
        }
        return Math.min(this.bytesToRead, this.buffer.length);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    public int getMinBufferSize() {
        return this.minBufBytes;
    }
}

