/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.telephony.AudioCodec;
import com.smile.telephony.AudioConverter;
import com.smile.telephony.PipeInputStream;
import com.smile.telephony.PipeOutputStream;
import com.smile.telephony.PipeSocket;
import com.smile.telephony.Recorder;
import com.smile.telephony.RecorderResource;
import com.smile.telephony.RouteSocket;
import com.smile.telephony.codec.ConvertedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import smile.util.ResourceStore;

public class PipeRecorder
extends RouteSocket
implements RecorderResource,
Runnable {
    static final int FRAMETIME = 30;
    static final int BUFSIZE = 480;
    public static final int STATE_IDLE = 0;
    public static final int STATE_BUSY = 1;
    private int state;
    private Recorder device;
    private String recid;
    private OutputStream stream;
    private Thread thrd;
    private Hashtable outstreams = new Hashtable();
    private Hashtable instreams = new Hashtable();
    private int recpausecnt = 500;
    private int breakpausecnt = 30000;
    private AudioCodec pcm = AudioCodec.PCM16LINEAR;

    @Override
    public synchronized void release() {
        if (this.instreams.size() == 0) {
            try {
                this.stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.device != null) {
                this.device.stopRecording(this.recid);
            }
            this.state = 0;
        }
    }

    @Override
    public synchronized boolean seize() {
        if (this.state != 0) {
            return false;
        }
        this.state = 1;
        return true;
    }

    public void setSilencePause(int sec) {
        this.recpausecnt = sec * 1000 / 30;
    }

    public void setBreakPause(int sec) {
        this.breakpausecnt = sec * 1000 / 30;
    }

    public void setAGC(boolean mode) {
        this.pcm = mode ? AudioCodec.PCM16LINEAR_A : AudioCodec.PCM16LINEAR;
    }

    public void setRecorder(Recorder device, OutputStream stream, String recid) {
        this.device = device;
        this.stream = stream;
        this.recid = recid;
        this.state = 1;
        if (this.thrd == null || !this.thrd.isAlive()) {
            this.thrd = new Thread((Runnable)this, this.toString());
            this.thrd.start();
        }
    }

    public synchronized boolean startRecord(PipeSocket ps, AudioCodec codec) {
        PipeOutputStream out = new PipeOutputStream();
        PipeInputStream in = new PipeInputStream(out);
        AudioConverter converter = new AudioConverter();
        AudioCodec[] codecs = new AudioCodec[]{codec};
        ConvertedOutputStream cout = converter.getOutputStream((OutputStream)out, this.pcm, codecs);
        if (cout == null) {
            return false;
        }
        out.setBuffer(this.pcm.getFrameSize(), this.pcm.getFrameTime(), false, 0, 3000);
        this.instreams.put(ps, in);
        this.outstreams.put(ps, cout);
        return true;
    }

    public synchronized void cancelRecord(PipeSocket ps) {
        InputStream in = (InputStream)this.instreams.remove(ps);
        OutputStream out = (OutputStream)this.outstreams.remove(ps);
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void write(PipeSocket ps, byte[] b, int off, int len) throws IOException {
        OutputStream out = (OutputStream)this.outstreams.get(ps);
        if (out != null) {
            out.write(b, off, len);
        }
    }

    @Override
    public synchronized void run() {
        Vector buffers = new Vector();
        byte[] mix = new byte[480];
        long nextTick = System.currentTimeMillis();
        int pauseCount = 0;
        while (this.state == 1) {
            long timeout;
            nextTick += 30L;
            buffers.clear();
            boolean first = true;
            for (int i = 0; i < 480; ++i) {
                mix[i] = 0;
            }
            Enumeration en = this.instreams.elements();
            while (en.hasMoreElements()) {
                InputStream in = (InputStream)en.nextElement();
                try {
                    byte[] buffer = new byte[480];
                    int n = in.read(buffer);
                    if (n != 480) continue;
                    if (first) {
                        for (int i = 0; i < 480; ++i) {
                            mix[i] = buffer[i];
                        }
                        first = false;
                        pauseCount = 0;
                        continue;
                    }
                    this.sum(mix, buffer);
                }
                catch (Exception exception) {}
            }
            if (first && ++pauseCount > this.breakpausecnt) {
                ResourceStore.error(this.recid + " cancel count=" + pauseCount);
                this.cancel();
                break;
            }
            if (pauseCount < this.recpausecnt) {
                try {
                    this.stream.write(mix);
                }
                catch (Exception e) {
                    this.cancel();
                    break;
                }
            }
            if ((timeout = nextTick - System.currentTimeMillis() - 1L) <= 0L) continue;
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void sum(byte[] m, byte[] b) {
        for (int i = 0; i < m.length; i += 2) {
            int s = (m[i + 1] << 8 | m[i] & 0xFF) + (b[i + 1] << 8 | b[i] & 0xFF) >> 1;
            m[i] = (byte)s;
            m[i + 1] = (byte)(s >> 8);
        }
    }

    private void cancel() {
        Enumeration en = this.outstreams.elements();
        while (en.hasMoreElements()) {
            OutputStream out = (OutputStream)en.nextElement();
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
        this.outstreams.clear();
        this.instreams.clear();
        this.release();
    }

    @Override
    public String getErrorMessage() {
        return "";
    }

    @Override
    public String getName() {
        return "Voice recorder";
    }

    @Override
    public RouteSocket getRouteSocket() {
        return this;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public int getType() {
        return 8192;
    }

    @Override
    protected int getSocketType() {
        return 2;
    }

    @Override
    protected boolean routeReceiver(RouteSocket rs) {
        return false;
    }

    @Override
    protected boolean routeTransmitter(RouteSocket rs) {
        return false;
    }

    @Override
    protected boolean unrouteReceiver(RouteSocket rs) {
        return false;
    }

    @Override
    protected boolean unrouteTransmitter(RouteSocket rs) {
        return false;
    }
}

