/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.sound.WavAudioFormat;
import com.smile.telephony.AudioCodec;
import com.smile.telephony.DTMFListener;
import com.smile.telephony.DataResource;
import com.smile.telephony.MediaSocket;
import com.smile.telephony.RTPMediaSocketPlayer;
import com.smile.telephony.RTPMediaSocketRecorder;
import com.smile.telephony.ToneGenerator;
import com.smile.telephony.VoiceResource;
import com.smile.telephony.rtp.RTP;
import com.smile.telephony.video.VideoSocket;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import smile.cti.phone.PhoneLine;
import smile.util.ResourceStore;

public abstract class RTPMediaSocket
extends MediaSocket
implements VoiceResource,
DataResource,
DTMFListener {
    private RTP rtp;
    private InetAddress remoteInetAddress;
    private int remoteDataPort;
    private int remoteControlPort;
    private boolean noorigin = false;
    private boolean playing = false;
    private boolean recording = false;
    private boolean silenceOn = false;
    private boolean sendinfTone = false;
    private String faxLocalId = "";
    private String faxRemoteId = "";
    private int transferredPages = 0;
    protected int dtmfInfo = 1;
    private RTPMediaSocketPlayer player;
    private RTPMediaSocketRecorder recorder;
    private Vector digitBuffer = new Vector();
    protected String sesionInfo = "";
    public static final int DTMF_H245ALPHA = 0;
    public static final int DTMF_H245SIGNAL = 1;
    public static final int DTMF_SIPINFO = 1;
    public static final int DTMF_RFC2833 = 2;
    public static final int DTMF_INBAND = 3;

    protected void setMediaAddress(String remoteHost, int port, String origin) throws UnknownHostException {
        this.toLog(" setMediaAddress=" + remoteHost + ":" + port);
        this.remoteInetAddress = InetAddress.getByName(remoteHost);
        this.remoteDataPort = port;
        this.remoteControlPort = port + 1;
        this.noorigin = !remoteHost.equals(origin);
        super.setMediaAddress(this.remoteInetAddress.getHostAddress() + ":" + port + ":" + (port + 1), 3);
        if (this.rtp != null) {
            this.rtp.setRemoteAddress(this.remoteInetAddress, port);
        }
    }

    protected void setMediaAddress(String iaddress, int dataPort, int controlPort, int dir) {
        try {
            this.remoteInetAddress = InetAddress.getByName(iaddress);
            this.remoteDataPort = dataPort;
            this.remoteControlPort = controlPort;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        super.setMediaAddress(iaddress + ":" + dataPort + ":" + controlPort, dir);
        if (this.rtp != null) {
            this.rtp.setRemoteAddress(this.remoteInetAddress, dataPort);
        }
    }

    protected InetAddress getRemoteAddress() {
        return this.remoteInetAddress;
    }

    protected int getRemoteDataPort() {
        return this.remoteDataPort;
    }

    protected int getRemoteControlPort() {
        return this.remoteControlPort;
    }

    public String getLocalAddress(InetAddress remoteHostAddr, String proxyAddr, String localAddr) throws UnknownHostException {
        String address;
        InetAddress remoteAddr = this.remoteInetAddress == null || this.remoteInetAddress.isSiteLocalAddress() && !remoteHostAddr.isSiteLocalAddress() && !this.noorigin ? remoteHostAddr : this.remoteInetAddress;
        if (this.rtp == null) {
            this.createRTPSession();
            if (this.endpoint.isStunUsable()) {
                this.rtp.setStunAddress(this.endpoint.getStunAddress(), this.endpoint.getStunPort());
            }
        }
        if ((address = this.rtp.getLocalAddress()) != null) {
            return address;
        }
        return this.endpoint.getLocalAddress(remoteAddr.getHostAddress(), proxyAddr, localAddr);
    }

    protected int getSocketLocalPort() {
        return this.rtp != null ? this.rtp.getSocketLocalPort() : 0;
    }

    protected int getLocalDataPort() {
        if (this.rtp == null) {
            this.createRTPSession();
        }
        return this.rtp != null ? this.rtp.getLocalPort() : 0;
    }

    protected int getLocalControlPort() {
        if (this.rtp == null) {
            this.createRTPSession();
        }
        return this.rtp != null ? this.rtp.getLocalPort() + 1 : 0;
    }

    protected void createRTPSession() {
        this.rtp = this.endpoint.createRTPSession(this);
        if (this.cryptokey != null) {
            this.rtp.setCryptoKey(this.cryptokey);
        } else {
            try {
                this.rtp.setCryptoParameters(this.tsmCryptoParameters, this.rcvCryptoParameters);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void createRTPSession(VideoSocket videoSocket) {
        this.endpoint.createRTPSession(videoSocket, this.symnat);
        if (this.rtp.isNatAddress()) {
            videoSocket.setStunAddress(this.endpoint.getStunAddress(), this.endpoint.getStunPort());
        }
    }

    @Override
    protected void setRemoteCryptoCapabilities(Vector caps) {
        super.setRemoteCryptoCapabilities(caps);
        if (this.rtp != null) {
            try {
                this.rtp.setCryptoParameters(this.tsmCryptoParameters, this.rcvCryptoParameters);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void clear() {
        super.clear();
        this.clearDigitBuffer();
        this.sesionInfo = "";
        this.toLog("clear rtp=" + this.rtp);
        if (this.rtp != null) {
            try {
                this.rtp.close();
                Vector v = this.rtp.getSessionInfo();
                if (!v.isEmpty()) {
                    Object str = "";
                    Enumeration en = v.elements();
                    while (en.hasMoreElements()) {
                        Hashtable info = (Hashtable)en.nextElement();
                        Enumeration enn = info.keys();
                        while (enn.hasMoreElements()) {
                            String key = (String)enn.nextElement();
                            str = (String)str + key + "=" + info.get(key) + " ";
                        }
                        str = (String)str + "\r\n";
                    }
                    this.sesionInfo = "Session details:\r\n" + (String)str;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.playing = false;
        this.recording = false;
        this.transdigmode = true;
        this.noorigin = false;
        this.rtp = null;
        this.remoteInetAddress = null;
    }

    protected String getSessionInfo() {
        return this.sesionInfo;
    }

    public int getSocketTimeout() {
        return this.endpoint.getSocketTimeout();
    }

    @Override
    public int getPacketsSent() {
        return this.rtp != null ? this.rtp.getPacketsSent() : 0;
    }

    @Override
    public int getOctetsSent() {
        return this.rtp != null ? this.rtp.getOctetsSent() : 0;
    }

    @Override
    public int getPacketsReceived() {
        return this.rtp != null ? this.rtp.getPacketsReceived() : 0;
    }

    @Override
    public int getOctetsReceived() {
        return this.rtp != null ? this.rtp.getOctetsReceived() : 0;
    }

    @Override
    public int getPacketsLost() {
        return this.rtp != null ? this.rtp.getPacketsLost() : 0;
    }

    @Override
    public int getJitter() {
        return this.rtp != null ? this.rtp.getJitter() : 0;
    }

    @Override
    public int getJitterMax() {
        return this.rtp != null ? this.rtp.getJitterMax() : 0;
    }

    @Override
    public int getPacketsSentLost() {
        return this.rtp != null ? this.rtp.getPacketsSentLost() : 0;
    }

    @Override
    public int getJitterFarEnd() {
        return this.rtp != null ? this.rtp.getJitterFarEnd() : 0;
    }

    @Override
    public int getDelay() {
        return this.rtp != null ? this.rtp.getDelay() : 0;
    }

    @Override
    public int getDelayMax() {
        return this.rtp != null ? this.rtp.getDelayMax() : 0;
    }

    @Override
    public String getCodec() {
        if (this.rtp == null) {
            return "";
        }
        try {
            String rcodec = this.rtp.getReceiveCodec();
            String scodec = this.rtp.getSendCodec();
            if (rcodec.equals(scodec)) {
                return rcodec;
            }
            return rcodec + "/" + scodec;
        }
        catch (Exception e) {
            return "";
        }
    }

    public synchronized void terminate(int reason) {
        this.toLog("terminate player=" + this.player + " recorder=" + this.recorder);
        try {
            if (this.recorder != null) {
                this.recorder.terminate(reason);
            }
            if (this.player != null) {
                this.player.terminate(reason);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyAll();
        try {
            this.wait(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void startReceive(AudioCodec codec) {
        this.toLog("startReceive " + codec.getName() + " isMediaRouting=" + this.isMediaRouting());
        if (this.isMediaRouting()) {
            if (this.rtp == null) {
                this.createRTPSession();
            }
            this.rtp.setRemoteAddress(this.remoteInetAddress, this.remoteDataPort);
            this.rtp.startReceiver(codec, this.symnat, this.dtmfInfo == 3);
        }
        this.recording = true;
        this.setPreferredCapability(codec.getId());
    }

    protected void startTransmit(AudioCodec codec, int fpp) {
        this.startTransmit(codec, fpp, null);
    }

    protected void startTransmit(AudioCodec codec, int fpp, HashMap prms) {
        this.toLog("startTransmit " + codec.getName() + " buffered=" + this.buffered);
        if (this.buffered && codec != AudioCodec.T38UDP && this.isMediaRouting()) {
            if (this.rtp == null) {
                this.createRTPSession();
            }
            this.rtp.setRemoteAddress(this.remoteInetAddress, this.remoteDataPort);
            this.rtp.startTransmitter(codec, fpp, prms);
        }
        this.playing = true;
        this.setPreferredCapability(codec.getId());
    }

    @Override
    protected boolean isMediaRouting() {
        if (super.isMediaRouting()) {
            return true;
        }
        if (this.socket != null && this.socket instanceof RTPMediaSocket) {
            return !this.allowDirectConnection(this.remoteInetAddress, ((RTPMediaSocket)this.socket).remoteInetAddress);
        }
        return true;
    }

    protected void stopTransmit() {
        this.toLog("stopTransmit");
        this.playing = false;
        if (this.rtp != null) {
            this.rtp.stopTransmitter();
        }
        if (this.player != null) {
            try {
                this.player.terminate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void stopReceive() {
        this.toLog("stopReceive");
        this.recording = false;
        if (this.rtp != null) {
            this.rtp.stopReceiver();
        }
    }

    public void sendRTPPacket(byte[] buffer, int len) {
        if (this.playing && !this.sendinfTone) {
            try {
                this.rtp.sendRTPPacket(buffer, len);
            }
            catch (Exception e) {
                this.toLog(e.toString());
            }
        }
    }

    @Override
    public void sendData(byte[] buffer, int len) throws IOException {
        if (this.playing && !this.sendinfTone) {
            this.rtp.sendDataPacket(buffer, len);
        }
    }

    public void onReceiveData(byte[] buffer, int len) {
        if (!this.recording) {
            return;
        }
        try {
            if (this.isConnected(2) && this.master instanceof DataResource) {
                ((DataResource)((Object)this.master)).sendData(buffer, len);
            }
        }
        catch (Exception e) {
            this.recording = false;
        }
    }

    public void onReceiveData(byte[] buffer, int len, int type, int offset, boolean mainPayload, int lostSamples) {
        block39: {
            if (!this.recording) {
                return;
            }
            try {
                if (this.isConnected(2) && this.master instanceof RTPMediaSocket && !this.master.buffered) {
                    int wlen;
                    if (type == RTP.RFC2833 && ((RTPMediaSocket)this.master).dtmfInfo != 2) {
                        return;
                    }
                    if (this.voiceRecorder != null && mainPayload && (wlen = len - offset) >= 10) {
                        this.silenceOn = false;
                        if (type == 4) {
                            if ((buffer[offset] & 1) != 0 && wlen % 20 == 0) {
                                int nlen = wlen / 20 * 24;
                                byte[] b = new byte[nlen];
                                int n = 0;
                                int k = 0;
                                while (n < wlen) {
                                    int i;
                                    for (i = 0; i < 20; ++i) {
                                        b[k++] = buffer[offset + n++];
                                    }
                                    for (i = 0; i < 4; ++i) {
                                        b[k++] = 0;
                                    }
                                }
                                this.voiceRecorder.write(this, b, 0, nlen);
                            } else if (wlen % 24 == 0) {
                                this.voiceRecorder.write(this, buffer, offset, wlen);
                            }
                        } else if (type == 18 || type == 19) {
                            this.voiceRecorder.write(this, buffer, offset, wlen - wlen % 10);
                        } else {
                            if (lostSamples > 0) {
                                this.voiceRecorder.write(this, null, 0, lostSamples);
                            }
                            this.voiceRecorder.write(this, buffer, offset, wlen);
                        }
                    }
                    ((RTPMediaSocket)this.master).sendRTPPacket(buffer, len);
                } else if (mainPayload) {
                    int wlen = len - offset;
                    if (wlen >= 10) {
                        this.silenceOn = false;
                        if (type == 4) {
                            if ((buffer[offset] & 1) != 0 && wlen % 20 == 0) {
                                int nlen = wlen / 20 * 24;
                                byte[] b = new byte[nlen];
                                int n = 0;
                                int k = 0;
                                while (n < wlen) {
                                    int i;
                                    for (i = 0; i < 20; ++i) {
                                        b[k++] = buffer[offset + n++];
                                    }
                                    for (i = 0; i < 4; ++i) {
                                        b[k++] = 0;
                                    }
                                }
                                this.writeBuffer(b, 0, nlen);
                            } else if (wlen % 24 == 0) {
                                this.writeBuffer(buffer, offset, wlen);
                            }
                        } else if (type == 18 || type == 19) {
                            this.writeBuffer(buffer, offset, wlen - wlen % 10);
                        } else {
                            if (lostSamples > 0) {
                                this.writeBuffer(null, 0, lostSamples);
                            }
                            this.writeBuffer(buffer, offset, wlen);
                        }
                    } else if (type > 90) {
                        if (lostSamples > 0) {
                            this.writeBuffer(null, 0, lostSamples);
                        }
                        this.writeBuffer(buffer, offset, wlen);
                    }
                } else if (type == RTP.RFC2833 && this.isConnected(2) && this.master instanceof RTPMediaSocket && ((RTPMediaSocket)this.master).dtmfInfo == 2) {
                    ((RTPMediaSocket)this.master).sendRTPPacket(buffer, len);
                } else {
                    this.toLog(" writeBuffer type=" + type + " len=" + len + " off=" + offset);
                }
            }
            catch (Exception e) {
                this.toLog("writeBuffer: " + e);
                this.recording = false;
                if (this.recorder == null) break block39;
                try {
                    this.recorder.terminate(512);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public int readBuffer(byte[] buffer, int offset, int length) {
        if (!this.playing) {
            return 0;
        }
        int rlen = super.readBuffer(buffer, offset, length);
        if (rlen == -1 && this.player != null) {
            try {
                this.player.terminate(512);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rlen;
    }

    public int play(InputStream istream, char[] signal_mask, int maxtime, AudioCodec codec, int fpp) {
        if (this.player != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.player != null) {
                return -1;
            }
        }
        this.clearDigitBuffer();
        this.setInputStream(istream);
        if (this.rtp == null) {
            this.createRTPSession();
        }
        this.rtp.setRemoteAddress(this.remoteInetAddress, this.remoteDataPort);
        this.player = new RTPMediaSocketPlayer(signal_mask, maxtime);
        this.rtp.startReceiver(codec, this.symnat, this.dtmfInfo == 3);
        this.rtp.startTransmitter(codec, fpp, null);
        this.playing = true;
        int result = this.player.getTermination();
        if (this.player.needClearDigitBuffer()) {
            this.clearDigitBuffer();
        }
        this.player = null;
        this.stopTransmit();
        this.setInputStream(null);
        return result;
    }

    public int record(OutputStream ostream, char[] signal_mask, int maxsilence, int maxtime, AudioCodec codec) {
        this.clearDigitBuffer();
        this.setOutputStream(ostream);
        if (this.rtp == null) {
            this.createRTPSession();
        }
        this.rtp.setRemoteAddress(this.remoteInetAddress, this.remoteDataPort);
        this.recorder = new RTPMediaSocketRecorder(signal_mask, maxsilence, maxtime);
        this.rtp.startReceiver(codec, this.symnat, this.dtmfInfo == 3);
        this.recCodec = codec;
        this.recording = true;
        int result = this.recorder.getTermination();
        if (result != 64) {
            this.clearDigitBuffer();
        }
        this.recorder = null;
        this.recCodec = null;
        this.setOutputStream(null);
        return result;
    }

    public void onReadTimeout() {
        if (this.master instanceof PhoneLine) {
            ((PhoneLine)this.master).playTone("Progress2");
        }
    }

    @Override
    public int play(String filename, char[] signal_mask, int maxtime) {
        return -1;
    }

    @Override
    public int record(String filename, char[] signal_mask, int maxtime, int maxsilence, WavAudioFormat codec) {
        return -1;
    }

    @Override
    public String progressCallAnalyse(int timeout) {
        return "VOICE";
    }

    @Override
    public void sendSignal(int freq1, int freq2, int duration) {
    }

    protected void clearDigitBuffer() {
        this.digitBuffer.removeAllElements();
    }

    protected synchronized void setDigitBuffer(String chars) {
        this.digitBuffer.removeAllElements();
        for (int i = 0; i < chars.length(); ++i) {
            this.digitBuffer.addElement(new Character(chars.charAt(i)));
        }
        this.notify();
    }

    @Override
    public synchronized void digitReceived(char digit) {
        boolean maskValid = true;
        try {
            if (this.recorder != null) {
                maskValid = this.recorder.isMaskValid(digit);
            } else if (this.player != null) {
                maskValid = this.player.isMaskValid(digit);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.toLog("digitReceived =" + digit + " maskValid=" + maskValid + " digitBuffer=" + this.digitBuffer);
        if (maskValid) {
            this.digitBuffer.addElement(new Character(digit));
            if (digit >= '0' && digit <= '9' || digit == '*' || digit == '#' || this.endpoint.checkFlag(1) && digit != '\u001e' && digit != '\u001f') {
                super.transmitDigit(digit);
            }
            this.notify();
        }
    }

    @Override
    public synchronized char retriveSignal(int timeout) {
        if (!this.digitBuffer.isEmpty()) {
            return ((Character)this.digitBuffer.remove(0)).charValue();
        }
        if (timeout > 0) {
            try {
                this.wait(timeout * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.digitBuffer.isEmpty()) {
                return ((Character)this.digitBuffer.remove(0)).charValue();
            }
        }
        return '\u001a';
    }

    @Override
    public void sendDigits(String str) {
        this.toLog("sendDigits " + str + " type=" + this.dtmfInfo);
        if (this.rtp == null) {
            this.createRTPSession();
        }
        this.sendinfTone = true;
        try {
            if (this.dtmfInfo == 3) {
                WavAudioFormat codec = this.playCodec != null ? AudioCodec.getWavAudioFormat(this.playCodec) : this.getAvailableCodecs(2)[0];
                InputStream stream = this.getInputStream();
                boolean transmit = this.rtp.isTransmit();
                if (!transmit) {
                    this.rtp.startTransmitter(AudioCodec.getAudioCodec(codec), 2, null);
                }
                for (int i = 0; i < str.length(); ++i) {
                    byte[] data;
                    char digit = str.charAt(i);
                    if (digit == ',') {
                        Thread.sleep(2000L);
                        continue;
                    }
                    if (digit == '&' || (data = ToneGenerator.get(String.valueOf(digit), codec)) == null) continue;
                    this.toLog("sendDigits inband digit=" + digit + " data=" + data.length);
                    this.setInputStream(new ByteArrayInputStream(data));
                    Thread.sleep(250L);
                }
                if (!transmit) {
                    this.rtp.stopTransmitter();
                }
                this.setInputStream(stream);
            } else {
                this.rtp.sendDigits(str, 7, 150, 100);
            }
        }
        catch (Exception e) {
            ResourceStore.error("sendDigits: ", e);
        }
        this.sendinfTone = false;
    }

    public void setTransparentDTMF(boolean mode) {
        this.transdigmode = mode;
    }

    public void transmitDigit(char digit, RTPMediaSocket socket) {
        if (this.dtmfInfo != 3 && this.dtmfInfo != 2 || this.dtmfInfo != socket.dtmfInfo) {
            this.sendDigits(String.valueOf(digit));
        }
    }

    @Override
    public Hashtable getCallInfo() {
        Hashtable info = super.getCallInfo();
        if (this.rtp != null) {
            String value = null;
            switch (this.rtp.getReceiveCodecType()) {
                case 0: {
                    value = "G.711U";
                    break;
                }
                case 8: {
                    value = "G.711A";
                    break;
                }
                case 4: {
                    value = "G.723";
                    break;
                }
                case 18: {
                    value = "G.729";
                }
            }
            if (value != null) {
                info.put("cti.MediaCodec", value);
            }
            if (!info.containsKey("cti.MediaAddress")) {
                try {
                    info.put("cti.MediaAddress", this.rtp.getRemoteAddress().getHostAddress());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return info;
    }

    protected abstract String getRemoteHostAddress();

    protected boolean allowDirectConnection(InetAddress inet1, InetAddress inet2) {
        boolean l2;
        this.toLog("allowDirectConnection: " + inet1 + " & " + inet2 + " allowLocalDirect=" + this.allowLocalDirect + " rh1=" + this.getRemoteHostAddress() + " rh2=" + ((RTPMediaSocket)this.socket).getRemoteHostAddress());
        if (this.allowLocalDirect) {
            return true;
        }
        boolean l1 = inet1.isSiteLocalAddress();
        if (l1 != (l2 = inet2.isSiteLocalAddress())) {
            return false;
        }
        if (!l1) {
            return true;
        }
        if (!(this.socket instanceof RTPMediaSocket)) {
            return false;
        }
        String host1 = this.getRemoteHostAddress();
        String host2 = ((RTPMediaSocket)this.socket).getRemoteHostAddress();
        return inet1.getHostAddress().equals(host1) && inet2.getHostAddress().equals(host2) || host1.equals(host2);
    }
}

