/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

public class RTPMediaSocketRecorder {
    static final int MAXTIME = 10000;
    private int result = 32;
    private char[] sig_mask;
    private int maxsilence;
    private long stopTime;
    boolean notified;
    boolean silenceOn;

    public RTPMediaSocketRecorder(char[] mask, int maxsil, int timeout) {
        this.sig_mask = mask;
        int maxtime = timeout > 0 ? timeout * 1000 : 10000000;
        int n = this.maxsilence = maxsil > 0 ? maxsil * 1000 : 10000000;
        if (this.maxsilence > maxtime) {
            this.maxsilence = maxtime;
        }
        this.stopTime = System.currentTimeMillis() + (long)maxtime;
    }

    boolean isMaskValid(char digit) {
        if (digit == '\u001f' || digit == '\u001e') {
            this.terminate(8192);
            return false;
        }
        if (this.sig_mask != null) {
            for (int i = 0; i < this.sig_mask.length; ++i) {
                if (digit != this.sig_mask[i]) continue;
                this.terminate(64);
                return true;
            }
        }
        return false;
    }

    synchronized int getTermination() {
        if (this.result != 32) {
            return this.result;
        }
        while (System.currentTimeMillis() < this.stopTime) {
            this.silenceOn = true;
            try {
                this.wait(this.maxsilence);
                if (!this.notified) {
                    if (!this.silenceOn) continue;
                    return 2;
                }
            }
            catch (InterruptedException e) {}
            break;
        }
        return this.result;
    }

    void setSilenceOff() {
        this.silenceOn = false;
    }

    synchronized void terminate(int res) {
        this.result = res;
        this.notified = true;
        this.notify();
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

