/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.security.Repository;
import com.smile.security.RepositoryResource;
import com.smile.security.ResourceEntry;
import com.smile.telephony.ResourceProvider;
import java.util.Enumeration;
import java.util.Vector;
import smile.util.ResourceStore;

public class ResourceBundle {
    private ResourceProvider[] provider = null;

    public ResourceBundle(String bundle) {
        Vector providers = new Vector();
        RepositoryResource device = Repository.getRepositoryResource(bundle);
        Enumeration e = device.getKeysEnumeration();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            ResourceEntry entry = device.getResourceEntry(name);
            this.appendProvider(name, entry, providers);
        }
        int size = providers.size();
        this.provider = new ResourceProvider[size];
        if (size > 0) {
            providers.copyInto(this.provider);
        }
    }

    private void appendProvider(String name, ResourceEntry entry, Vector providers) {
        try {
            Class<?> deviceClass = Class.forName(name);
            ResourceProvider device = (ResourceProvider)deviceClass.newInstance();
            Enumeration e = entry.getKeysEnumeration();
            while (e.hasMoreElements()) {
                String serial = (String)e.nextElement();
                byte[] signature = (byte[])entry.get(serial);
                device.startBoard(serial, signature);
            }
            providers.addElement(device);
        }
        catch (Throwable t) {
            ResourceStore.error(name, t);
        }
    }

    public ResourceProvider[] getResourceProviders() {
        return this.provider;
    }

    public String getApplicationParametersString() {
        return Repository.getRepositoryInfo("parameters");
    }
}

