/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony;

import com.smile.enterprise.cti.deviceDriver;
import com.smile.enterprise.cti.portDriver;
import com.smile.sound.WavAudioFormat;
import com.smile.sound.WaveParser;
import com.smile.sound.wavFormatHeader;
import com.smile.telephony.AudioCodec;
import com.smile.telephony.AudioConverter;
import com.smile.telephony.CTIPort;
import com.smile.telephony.CallInfo;
import com.smile.telephony.CyclePlaybackStream;
import com.smile.telephony.DisconnectListener;
import com.smile.telephony.DspResource;
import com.smile.telephony.FaxResource;
import com.smile.telephony.MediaSocket;
import com.smile.telephony.Mixer;
import com.smile.telephony.PipeSocket;
import com.smile.telephony.Port;
import com.smile.telephony.Resource;
import com.smile.telephony.ResourceBundle;
import com.smile.telephony.ResourceProvider;
import com.smile.telephony.RouteRequest;
import com.smile.telephony.RouteSocket;
import com.smile.telephony.ToneGenerator;
import com.smile.telephony.VoiceResource;
import com.smile.telephony.codec.ConvertedInputStream;
import com.smile.telephony.codec.ConvertedOutputStream;
import com.smile.telephony.video.VideoResource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import smile.util.ResourceStore;

public class ResourceManager
implements deviceDriver,
Runnable {
    private ResourceBundle resourceBundle;
    private ResourceProvider[] providers;
    private portDriver[] drivers;
    private Hashtable ctiports = new Hashtable();
    private static Vector resources = new Vector();
    private WavAudioFormat[] codecs;
    private WavAudioFormat defaultFormat;
    private Vector waitingPorts = new Vector();
    public static final int TRANSMITTER = 1;
    public static final int RECEIVER = 2;
    private Vector disconnect_listeners = new Vector();

    static Vector getResources() {
        return resources;
    }

    public ResourceManager(String bundle) {
        this.resourceBundle = new ResourceBundle(bundle);
        ResourceProvider[] prds = this.resourceBundle.getResourceProviders();
        Vector<ResourceProvider> pps = new Vector<ResourceProvider>();
        for (int i = 0; i < prds.length; ++i) {
            try {
                Resource[] res = prds[i].getResources();
                if (res == null || res.length == 0) continue;
                for (int j = 0; j < res.length; ++j) {
                    resources.addElement(res[j]);
                }
                pps.addElement(prds[i]);
                continue;
            }
            catch (Throwable t) {
                ResourceStore.error("ResourceManager", t);
            }
        }
        this.providers = new ResourceProvider[pps.size()];
        if (pps.isEmpty()) {
            return;
        }
        pps.copyInto(this.providers);
        new Thread(this).start();
    }

    @Override
    public portDriver[] getPortDrivers() throws IOException {
        if (this.drivers != null) {
            return this.drivers;
        }
        Vector<Resource> ports = new Vector<Resource>();
        for (int i = 0; i < resources.size(); ++i) {
            Resource r = (Resource)resources.elementAt(i);
            if ((r.getType() & 1) == 0) continue;
            ports.addElement(r);
        }
        if (ports.isEmpty()) {
            return null;
        }
        this.drivers = this.createPortDrivers(ports);
        for (int j = 0; j < this.drivers.length; ++j) {
            this.ctiports.put(this.drivers[j].getPortName(), this.drivers[j]);
        }
        return this.drivers;
    }

    @Override
    public portDriver[] getPortDrivers(String device) throws IOException {
        for (int i = 0; i < this.providers.length; ++i) {
            int j;
            if (!device.equals(this.providers[i].getDeviceName())) continue;
            Resource[] res = this.providers[i].getResources();
            if (res == null) {
                return null;
            }
            Vector<Resource> ports = new Vector<Resource>();
            for (j = 0; j < res.length; ++j) {
                if ((res[j].getType() & 1) == 0) continue;
                ports.addElement(res[j]);
            }
            if (ports.isEmpty()) {
                return null;
            }
            this.drivers = this.createPortDrivers(ports);
            for (j = 0; j < this.drivers.length; ++j) {
                this.ctiports.put(this.drivers[j].getPortName(), this.drivers[j]);
            }
            break;
        }
        return this.drivers;
    }

    protected portDriver[] createPortDrivers(Vector ports) {
        portDriver[] devices = new CTIPort[ports.size()];
        for (int j = 0; j < ports.size(); ++j) {
            devices[j] = new CTIPort((Port)ports.elementAt(j), this);
        }
        return devices;
    }

    @Override
    public String[] getDeviceNames() {
        if (this.providers == null) {
            return new String[0];
        }
        String[] devnames = new String[this.providers.length];
        for (int i = 0; i < this.providers.length; ++i) {
            devnames[i] = this.providers[i].getDeviceName();
        }
        return devnames;
    }

    public CTIPort getPortByName(String portName) {
        int n = portName.lastIndexOf(46);
        return (CTIPort)this.ctiports.get(n == -1 ? portName : portName.substring(n + 1));
    }

    public CTIPort getPortByLabel(String label) {
        if (label == null) {
            return null;
        }
        if (label.indexOf(46) != -1) {
            Enumeration en = this.ctiports.elements();
            while (en.hasMoreElements()) {
                CTIPort ctiport = (CTIPort)en.nextElement();
                if (!ctiport.getRoutingLabel().equals(label)) continue;
                return ctiport;
            }
        } else {
            Enumeration en = this.ctiports.elements();
            while (en.hasMoreElements()) {
                CTIPort ctiport = (CTIPort)en.nextElement();
                if (ctiport.getPortName().equals(label)) {
                    return ctiport;
                }
                RouteSocket rs = ctiport.getRouteSocket();
                if (!(rs instanceof Resource) || !((Resource)((Object)rs)).getName().equals(label)) continue;
                return ctiport;
            }
        }
        return null;
    }

    public String getApplicationParametersString() {
        return this.resourceBundle.getApplicationParametersString();
    }

    @Override
    public String getDeviceName() {
        return "Resource Manager";
    }

    public static WavAudioFormat[] getAvailableCodecs() {
        return ResourceManager.withAudioConverter(ResourceManager.getCodecs());
    }

    WavAudioFormat[] getAvailableCodecs(Resource port) {
        WavAudioFormat[] hdFms = (port.getType() & 2) != 0 ? ((VoiceResource)port).getAvailableCodecs(1) : this.codecs;
        return ResourceManager.withAudioConverter(hdFms);
    }

    private static WavAudioFormat[] withAudioConverter(WavAudioFormat[] hdFms) {
        int i;
        Vector<WavAudioFormat> fms = new Vector<WavAudioFormat>();
        WavAudioFormat[] swFms = AudioConverter.getAvailableCodecs();
        for (i = 0; i < swFms.length; ++i) {
            fms.addElement(swFms[i]);
        }
        if (hdFms != null) {
            for (i = 0; i < hdFms.length; ++i) {
                if (fms.contains(hdFms[i])) continue;
                fms.addElement(hdFms[i]);
            }
        }
        Object[] wafs = new WavAudioFormat[fms.size()];
        fms.copyInto(wafs);
        return wafs;
    }

    public String playTone(CTIPort ctiport, String tone, char[] mask, int timeout) {
        Port port = ctiport.getPort();
        String result = "TIMEOUT";
        if ((port.getType() & 0x1000) == 0 || tone.equals("Comfort Noise")) {
            if (timeout == -1) {
                return this.playGenTone(ctiport, tone, mask, -1);
            }
            long end = System.currentTimeMillis() + (long)(timeout * 1000);
            int time = timeout;
            do {
                if ((result = this.playGenTone(ctiport, tone, mask, time)).equals("EOF")) continue;
                return result;
            } while ((time = (int)((end - System.currentTimeMillis()) / 1000L)) > 0);
            return "TIMEOUT";
        }
        DspResource dsp = (DspResource)this.getResource(port, 2048, 1);
        if (dsp == null) {
            ResourceStore.error(ctiport.getPortName() + " playTone", new Exception("DSP resource not available"));
            return "ERROR";
        }
        int[] tonedef = ToneGenerator.getDef(tone);
        if (tonedef == null) {
            return "FORMAT";
        }
        int count = (int)Math.ceil((double)timeout * 1000.0 / (double)(tonedef[2] + tonedef[3]));
        int pause = tonedef[3] / 1000;
        for (int i = 0; i < count; ++i) {
            dsp.sendSignal(tonedef[0], tonedef[1], tonedef[2]);
            if (pause == 0) {
                try {
                    Thread.sleep(tonedef[3]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(result = this.getDigits(ctiport, 1, pause, mask, true, true)).equals("TIMEOUT")) break;
            if (ctiport.isDisconnected()) {
                return "DISCONNECT";
            }
            if (ctiport.getPortStatus().equals("playing tone")) continue;
            if (ctiport.getPortStatus().equals("call arrived")) continue;
            return "TERMINATION";
        }
        return result;
    }

    public String sendDigits(CTIPort ctiport, String str) {
        DspResource dsp = (DspResource)this.getResource(ctiport.getPort(), 2048, 1);
        if (dsp == null) {
            ResourceStore.error(ctiport.getPortName() + " sendDigits", new Exception("DSP resource not available"));
            return "ERROR";
        }
        dsp.sendDigits(str);
        return "OK";
    }

    public String getDigits(CTIPort ctiport, int count, int timeout, char[] mask, boolean withMasked, boolean ignoreOther) {
        Port port = ctiport.getPort();
        DspResource dsp = (DspResource)this.getResource(port, 2048, 2);
        if (dsp == null) {
            ResourceStore.error(ctiport.getPortName() + " getDigits", new Exception("DSP resource not available"));
            return "ERROR";
        }
        for (int i = 0; i < count; ++i) {
            if (i == 0 && dsp instanceof PipeSocket) {
                ((PipeSocket)((Object)dsp)).setDigitMask(mask);
            }
            char ch = dsp.retriveSignal(timeout);
            if (i == 0 && dsp instanceof PipeSocket) {
                ((PipeSocket)((Object)dsp)).setDigitMask(null);
            }
            switch (ch) {
                case '\u001a': {
                    return "TIMEOUT";
                }
                case '\u001d': {
                    return "DISCONNECT";
                }
                case '\u001c': {
                    return "TERMINATION";
                }
                case '\u001f': {
                    return "FAX";
                }
                case '\u001e': {
                    return "FAX";
                }
                case '\u001b': {
                    return "ERROR";
                }
            }
            for (int j = 0; j < mask.length; ++j) {
                if (ch != mask[j]) continue;
                if (withMasked) {
                    ctiport.digitsBuffer = ctiport.digitsBuffer + ch;
                } else {
                    ctiport.breakDigit = String.valueOf(ch);
                }
                return "DTMF";
            }
            if (ignoreOther) continue;
            ctiport.digitsBuffer = ctiport.digitsBuffer + ch;
        }
        return ctiport.digitsBuffer.length() == 0 ? "TIMEOUT" : "DTMF";
    }

    public String playGenTone(CTIPort ctiport, String tone, char[] mask, int timeout) {
        VoiceResource vr = (VoiceResource)this.getResource(ctiport.getPort(), 2, 3);
        if (vr == null) {
            ResourceStore.error(ctiport.getPortName() + " play", new Exception("Voice resource not available"));
            return "ERROR";
        }
        WavAudioFormat[] awf = vr.getAvailableCodecs(2);
        if (awf == null) {
            return "FORMAT";
        }
        WavAudioFormat codec = null;
        byte[] data = ToneGenerator.get(tone, WavAudioFormat.PCM_LINEAR16);
        if (data != null) {
            codec = WavAudioFormat.PCM_LINEAR16;
        }
        if (data == null) {
            return "FORMAT";
        }
        ByteArrayInputStream voicedata = new ByteArrayInputStream(data);
        return this.play(ctiport, (InputStream)voicedata, mask, timeout, codec);
    }

    public String play(CTIPort ctiport, String ttsdata, char[] mask, int timeout) {
        VoiceResource vr = (VoiceResource)this.getResource(ctiport.getPort(), 2, 3);
        if (vr == null) {
            ResourceStore.error(ctiport.getPortName() + " play", new Exception("Voice resource not available"));
            return "ERROR";
        }
        WavAudioFormat[] awf = vr.getAvailableCodecs(2);
        if (awf == null) {
            return "FORMAT";
        }
        WavAudioFormat codec = null;
        InputStream voicedata = null;
        return this.play(ctiport, voicedata, mask, timeout, codec);
    }

    public String play(CTIPort ctiport, File file, char[] mask, int timeout) throws IOException {
        VoiceResource vr = (VoiceResource)this.getResource(ctiport.getPort(), 2, 3);
        if (vr == null) {
            ResourceStore.error(ctiport.getPortName() + " play", new Exception("Voice resource not available"));
            return "ERROR";
        }
        WavAudioFormat[] formats = vr.getAvailableCodecs(2);
        if (formats == null) {
            return "FORMAT";
        }
        WavAudioFormat codec = null;
        InputStream voicedata = null;
        if (voicedata == null) {
            voicedata = new FileInputStream(file);
            wavFormatHeader hdr = new wavFormatHeader();
            try {
                voicedata = new WaveParser().parseWavHeader(voicedata, hdr);
                codec = hdr.getAudioFormat();
            }
            catch (IOException e) {
                try {
                    voicedata.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return this.convertVoiceResult(vr.play(file.getAbsolutePath(), mask, timeout));
            }
        }
        if (timeout > 0) {
            voicedata = new CyclePlaybackStream(voicedata);
        }
        String result = this.play(ctiport, voicedata, mask, timeout, codec);
        voicedata.close();
        return result;
    }

    public String play(CTIPort ctiport, InputStream voicedata, char[] mask, int timeout, WavAudioFormat codec) {
        Port port = ctiport.getPort();
        VoiceResource vr = (VoiceResource)this.getResource(port, 2, 3);
        if (vr == null) {
            ResourceStore.error(ctiport.getPortName() + " play", new Exception("Voice resource not available"));
            return "ERROR";
        }
        int result = this.play(vr, voicedata, mask, timeout, codec);
        return this.convertVoiceResult(result);
    }

    public int play(VoiceResource vr, InputStream voicedata, char[] mask, int timeout, WavAudioFormat codec) {
        WavAudioFormat[] avlcodecs;
        AudioConverter acv;
        ConvertedInputStream cin;
        int result = vr.play(voicedata, mask, timeout, codec);
        if (result == 16384 && (cin = (acv = new AudioConverter()).getInputStream(voicedata, codec, avlcodecs = vr.getAvailableCodecs(2))) != null) {
            AudioCodec playcodec = cin.getEncoder();
            result = vr.play(cin, mask, timeout, AudioCodec.getWavAudioFormat(playcodec));
            cin.release();
        }
        return result;
    }

    public String record(CTIPort ctiport, OutputStream voicedata, char[] mask, int silence, int timeout, WavAudioFormat codec) {
        Port port = ctiport.getPort();
        VoiceResource vr = (VoiceResource)this.getResource(port, 2, 2);
        if (vr == null) {
            ResourceStore.error(ctiport.getPortName() + " record", new Exception("Voice resource not available"));
            return "ERROR";
        }
        int result = this.record(vr, voicedata, mask, silence, timeout, codec);
        if (result == 16384 && (port.getPortType() == 4 || port.getPortType() == 7)) {
            result = this.record(vr, voicedata, mask, silence, timeout, codec);
        }
        return this.convertVoiceResult(result);
    }

    public int record(VoiceResource vr, OutputStream voicedata, char[] mask, int silence, int timeout, WavAudioFormat codec) {
        WavAudioFormat[] avlcodecs;
        AudioConverter acv;
        ConvertedOutputStream cout;
        int result = vr.record(voicedata, mask, silence, timeout, codec);
        if (result == 16384 && (cout = (acv = new AudioConverter()).getOutputStream(voicedata, codec, avlcodecs = vr.getAvailableCodecs(1))) != null) {
            AudioCodec reccodec = cout.getDecoder();
            result = vr.record(cout, mask, silence, timeout, AudioCodec.getWavAudioFormat(reccodec));
            cout.release();
        }
        return result;
    }

    private String convertVoiceResult(int result) {
        switch (result) {
            case 0: {
                return "EOF";
            }
            case 512: {
                return "EOF";
            }
            case 64: {
                return "DTMF";
            }
            case 32: {
                return "TIMEOUT";
            }
            case 2: {
                return "SILENCE";
            }
            case 256: {
                return "TERMINATION";
            }
            case 8192: {
                return "FAX";
            }
            case 8: {
                return "DISCONNECT";
            }
            case 16384: {
                return "FORMAT";
            }
        }
        return "ERROR";
    }

    public String sendFax(CTIPort ctiport, File file, int startpage, boolean isHighResolution, boolean issueVoiceRequest) {
        Port port = ctiport.getPort();
        FaxResource fr = (FaxResource)this.getResource(port, 4, 3);
        if (fr == null) {
            ResourceStore.error(ctiport.getPortName() + " sendFax", new Exception("Fax resource not available"));
            return "ERROR";
        }
        fr.setHeaderInfo(ctiport.faxHeader);
        fr.setLocalID(ctiport.faxLocalID);
        int result = fr.transmit(file, startpage, isHighResolution, issueVoiceRequest);
        ctiport.transferredPages = fr.getTransferredPages();
        ctiport.faxRemoteID = fr.getRemoteID();
        this.releaseResource(port, fr, 3);
        return this.convertFaxResult(result);
    }

    public String receiveFax(CTIPort ctiport, File file, boolean pollingMode, boolean issueVoiceRequest) {
        Port port = ctiport.getPort();
        FaxResource fr = (FaxResource)this.getResource(port, 4, 3);
        if (fr == null) {
            ResourceStore.error(ctiport.getPortName() + " receiveFax", new Exception("Fax resource not available"));
            return "ERROR";
        }
        fr.setLocalID(ctiport.faxLocalID);
        int result = fr.receive(file, pollingMode, issueVoiceRequest);
        ctiport.transferredPages = fr.getTransferredPages();
        ctiport.faxRemoteID = fr.getRemoteID();
        this.releaseResource(port, fr, 3);
        return this.convertFaxResult(result);
    }

    private String convertFaxResult(int result) {
        switch (result) {
            case 0: {
                return "EOF";
            }
            case 1: {
                return "POLLING";
            }
            case 4: {
                return "DISCONNECT";
            }
            case 5: {
                return "TIMEOUT";
            }
            case 3: {
                return "COMMUNICATION ERROR";
            }
            case 8: {
                return "NO POLL";
            }
            case 7: {
                return "COMPATIBILITY";
            }
            case 2: {
                return "FORMAT";
            }
            case 6: {
                return "USER STOP";
            }
            case 9: {
                return "TERMINATION";
            }
            case -1: {
                return "ERROR";
            }
        }
        return "DISCONNECT";
    }

    boolean preRoute(Port port1, Port port2) {
        RouteSocket socket1 = port1.getRouteSocket();
        RouteSocket socket2 = port2.getRouteSocket();
        if (socket1 == null || socket2 == null) {
            return false;
        }
        if (socket1 instanceof MediaSocket) {
            if (!(socket2 instanceof PipeSocket)) {
                socket2 = (RouteSocket)((Object)this.getResource(port2, 64, 3));
            }
            if (!((MediaSocket)socket1).setRoutedSocket(socket2)) {
                return false;
            }
        }
        if (socket2 instanceof MediaSocket) {
            if (!(socket1 instanceof PipeSocket)) {
                socket1 = (RouteSocket)((Object)this.getResource(port1, 64, 3));
            }
            if (!((MediaSocket)socket2).setRoutedSocket(socket1)) {
                return false;
            }
        }
        return true;
    }

    boolean route(Port port1, Port port2, int mode) {
        int sType;
        RouteSocket msocket = port1.getRouteSocket();
        RouteSocket ssocket = port2.getRouteSocket();
        if (msocket == null || ssocket == null) {
            return false;
        }
        int mType = msocket.getSocketType();
        if (mType != (sType = ssocket.getSocketType())) {
            Resource sres;
            Resource mres;
            return mType == 1 && sType == 2 ? (mres = this.getResource(port1, 64, 3)) != null && ((RouteSocket)((Object)mres)).route(port2, 3) : mType == 2 && sType == 1 && (sres = this.getResource(port2, 64, 3)) != null && ((RouteSocket)((Object)sres)).route(port1, 3);
        }
        if (mode != 3) {
            return ssocket.route(port1, mode);
        }
        if (port1 instanceof MediaSocket) {
            if (!ssocket.route(port1, 1)) {
                return false;
            }
            if (!msocket.route(port2, 1)) {
                ssocket.unroute(port1, 1);
                return false;
            }
        } else {
            if (!msocket.route(port2, 1)) {
                return false;
            }
            if (!ssocket.route(port1, 1)) {
                msocket.unroute(port2, 1);
                return false;
            }
        }
        return true;
    }

    void unroute(Port port1, Port port2) {
        int sType;
        RouteSocket msocket = port1.getRouteSocket();
        RouteSocket ssocket = port2.getRouteSocket();
        if (msocket == null || ssocket == null) {
            return;
        }
        int mType = msocket.getSocketType();
        if (mType != (sType = ssocket.getSocketType())) {
            Resource ipm;
            if (mType == 1 && sType == 2) {
                Resource ipm2 = msocket.findResource(64);
                if (ipm2 != null) {
                    ((RouteSocket)((Object)ipm2)).unroute(port2, 3);
                }
            } else if (mType == 2 && sType == 1 && (ipm = ssocket.findResource(64)) != null) {
                ((RouteSocket)((Object)ipm)).unroute(port1, 3);
            }
        } else {
            msocket.unroute(port2, 1);
            ssocket.unroute(port1, 1);
        }
    }

    boolean routeMix(CTIPort master, CTIPort slave, Mixer mix, int mode) {
        if (slave == null) {
            return false;
        }
        RouteSocket msocket = master.getRouteSocket();
        RouteSocket ssocket = slave.getRouteSocket();
        if (msocket == null || ssocket == null) {
            return false;
        }
        Resource mixer = mix;
        if (mixer == null) {
            mixer = msocket.findResource(32);
        }
        if (mixer == null) {
            mixer = ssocket.findResource(32);
        }
        if (mixer == null) {
            mixer = this.getMixer(master.getPort(), slave.getPort());
        }
        if (!msocket.route(mixer, 3)) {
            return false;
        }
        if (!ssocket.route(mixer, mode)) {
            msocket.unroute(mixer, 3);
            return false;
        }
        return true;
    }

    private Mixer getMixer(Port port1, Port port2) {
        if (!(port1 instanceof VideoResource) || !(port2 instanceof VideoResource)) {
            return new Mixer();
        }
        if (((VideoResource)((Object)port1)).getVideoMode() == -1 || ((VideoResource)((Object)port2)).getVideoMode() == -1) {
            return new Mixer();
        }
        return new Mixer();
    }

    private Resource getResource(Port port, int type, int mode) {
        RouteSocket socket = port.getRouteSocket();
        if (socket == null) {
            return (port.getType() & type) != 0 ? port : null;
        }
        if ((port.getType() & type) != 0) {
            return port;
        }
        Resource rs = socket.attachResource(type, mode);
        return rs;
    }

    private boolean releaseResource(Port port, Resource rs, int mode) {
        RouteSocket socket = port.getRouteSocket();
        if (socket != null && port != rs) {
            if (!socket.unroute(rs, mode)) {
                return false;
            }
            rs.release();
        }
        return true;
    }

    void releaseResources(Port port, boolean all) {
        RouteSocket socket = port.getRouteSocket();
        if (socket != null) {
            socket.releaseResources(all);
        }
    }

    boolean releaseResource(Port port, Resource rs) {
        return this.releaseResource(port, rs, 3);
    }

    void stopOperation(Port port, boolean all) {
        port.release();
        this.releaseResources(port, all);
    }

    public String routeCall(CTIPort ctiport, String number, int timeout, String filename, String termmask, String calling, String resApp, CallInfo callInfo, Map parameters) {
        RouteRequest route_request = new RouteRequest(ctiport, number, timeout, filename, termmask, calling, resApp, callInfo, parameters);
        this.notifyWaitingPorts();
        String result = route_request.getRoute();
        return result;
    }

    public synchronized void notifyWaitingPorts() {
        this.notify();
    }

    public void onRouting(CTIPort inbound, CTIPort outbound) {
    }

    public void addEventListener(CTIPort ctiport) {
        this.waitingPorts.add(new WaitingPort(ctiport));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                int i;
                long checkTime = System.currentTimeMillis();
                for (i = this.waitingPorts.size() - 1; i >= 0; --i) {
                    WaitingPort wp = (WaitingPort)this.waitingPorts.get(i);
                    int result = -1;
                    String ps = wp.ctiport.getPortStatus();
                    if (!ps.equals("waiting call") && !ps.equals("waiting")) {
                        result = 5;
                    } else if (wp.endtime < checkTime) {
                        result = 0;
                    } else {
                        if (wp.in && (result = wp.ctiport.getPort().waitCall(0)) == 0) {
                            result = -1;
                        }
                        if (result == -1 && wp.out) {
                            wp.request = RouteRequest.getRouteRequest(wp.ctiport);
                            if (wp.request != null) {
                                result = 1;
                            }
                        }
                    }
                    if (result == -1) continue;
                    wp.result = result;
                    this.waitingPorts.removeElementAt(i);
                    if (wp.newway) {
                        new PortThread(wp).start();
                        continue;
                    }
                    CTIPort cTIPort = wp.ctiport;
                    synchronized (cTIPort) {
                        wp.ctiport.notify();
                        continue;
                    }
                }
                for (i = this.disconnect_listeners.size() - 1; i >= 0; --i) {
                    try {
                        DisconnectListener dl = (DisconnectListener)this.disconnect_listeners.elementAt(i);
                        CTIPort ctiport = dl.getCTIPort();
                        if (!dl.isDisconnected() || !this.removeDisconnectListener(dl)) continue;
                        ctiport.remoteDisconnect();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            int sleeptime = this.waitingPorts.size() < this.ctiports.size() ? 100 : Integer.MAX_VALUE;
            ResourceManager resourceManager = this;
            synchronized (resourceManager) {
                try {
                    this.wait(sleeptime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitCall(CTIPort ctiport, int timeout, boolean wait_inbound, boolean routing) {
        int result = 0;
        WaitingPort wp = new WaitingPort(ctiport, timeout, wait_inbound, routing);
        this.waitingPorts.add(wp);
        CTIPort cTIPort = ctiport;
        synchronized (cTIPort) {
            try {
                ctiport.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        result = wp.result;
        if (wp.request != null) {
            result = wp.request.process(ctiport);
        }
        return result;
    }

    public boolean acceptCall(CTIPort ctiport, int rings) {
        Port port = ctiport.getPort();
        switch (port.acceptCall(rings)) {
            case 1: {
                return true;
            }
            case 2: {
                if (rings > 0) {
                    this.playTone(ctiport, "Ringback", new char[0], rings * ToneGenerator.getTime("Ringback"));
                }
                if (port.isCallDisconnected()) break;
                return true;
            }
        }
        return false;
    }

    public boolean answerCall(CTIPort ctiport) {
        return ctiport.getPort().answerCall(0);
    }

    public void dropCall(CTIPort ctiport, int causeValue, String descriptionint) {
    }

    public String makeCall(CTIPort ctiport, String number, int timeout, CallInfo callInfo, CTIPort routingPort) {
        String result;
        Resource dsp = null;
        Port port = ctiport.getPort();
        if (number.length() == 0 && port.getPortType() != 0 && port.getPortType() != 1) {
            return "FORMAT";
        }
        if (routingPort != null) {
            if (!this.preRoute(port, routingPort.getPort())) {
                return "COMPATIBILITY";
            }
        } else if (port.getPortType() == 2 && (dsp = this.getResource(port, 2048, 3)) == null) {
            ResourceStore.error(ctiport.getPortName() + " makeCall", new Exception("DSP Resource not available"));
            return "NOT AVAILABLE";
        }
        if ((result = port.makeCall(number, timeout, callInfo)).equals("ERROR")) {
            if (dsp != null) {
                this.releaseResource(port, dsp, 3);
            }
            ResourceStore.error(ctiport.getPortName() + " makeCall", new Exception(port.getErrorMessage()));
            return "ERROR";
        }
        if (routingPort == null && (result.equals("ALERTED") || result.equals("PROGRESS") || result.equals("INBAND") || result.equals("NO ANSWER") || result.equals("NO RINGBACK"))) {
            result = "NO ANSWER";
            long etime = System.currentTimeMillis() + (long)(timeout * 1000);
            do {
                String res;
                if ((res = port.progressCall(timeout)).equals("PROGRESS") || res.equals("INBAND") || res.equals("ALERTED")) continue;
                result = res;
                break;
            } while ((timeout = (int)((etime - System.currentTimeMillis()) / 1000L)) > 0);
        }
        if (result.equals("BUSY")) {
            ctiport.setCause(port.getDisconnectCause());
        }
        if (dsp != null) {
            this.releaseResource(port, dsp, 3);
        }
        return result;
    }

    public String makeCall(CTIPort ctiport, String number, CallInfo callInfo, CTIPort routingPort) {
        Resource dsp = null;
        Port port = ctiport.getPort();
        if (number.length() == 0 && port.getPortType() != 0 && port.getPortType() != 1) {
            return "FORMAT";
        }
        if (routingPort != null) {
            if (!this.preRoute(port, routingPort.getPort())) {
                return "COMPATIBILITY";
            }
        } else if (port.getPortType() == 2 && (dsp = this.getResource(port, 2048, 3)) == null) {
            ResourceStore.error(ctiport.getPortName() + " makeCall", new Exception("DSP Resource not available"));
            return "NOT AVAILABLE";
        }
        int timeout = 4;
        switch (port.getPortType()) {
            case 0: 
            case 5: {
                timeout = 1;
                break;
            }
            case 3: {
                timeout = 2;
                break;
            }
            case 1: 
            case 2: {
                timeout = 5;
                break;
            }
            case 6: {
                timeout = 5;
            }
        }
        String result = port.makeCall(number, timeout, callInfo);
        if (result.equals("ERROR")) {
            if (dsp != null) {
                this.releaseResource(port, dsp, 3);
            }
            ResourceStore.error(ctiport.getPortName() + " makeCall", new Exception(port.getErrorMessage()));
            return "ERROR";
        }
        if (result.equals("BUSY")) {
            ctiport.setCause(port.getDisconnectCause());
        }
        if (dsp != null) {
            this.releaseResource(port, dsp, 3);
        }
        return result;
    }

    public String progressCall(CTIPort ctiport, int timeout, boolean full) {
        Resource dsp = null;
        Port port = ctiport.getPort();
        if (port.getPortType() == 2 && (dsp = this.getResource(port, 2048, 3)) == null) {
            ResourceStore.error(port.getName() + " progressCall", new Exception("DSP Resource not available"));
            return "NOT AVAILABLE";
        }
        String result = "NO ANSWER";
        long etime = System.currentTimeMillis() + (long)(timeout * 1000);
        do {
            String res = port.progressCall(timeout);
            if (full && (res.equals("PROGRESS") || res.equals("INBAND") || res.equals("ALERTED"))) continue;
            result = res;
            if (!result.equals("BUSY")) break;
            ctiport.setCause(port.getDisconnectCause());
            break;
        } while ((timeout = (int)((etime - System.currentTimeMillis()) / 1000L)) > 0);
        if (dsp != null && (result.equals("VOICE") || result.equals("FAX"))) {
            this.releaseResource(port, dsp, 3);
        }
        return result;
    }

    public String progressCallAnalyse(Port port, int timeout) {
        String result = "VOICE";
        Resource dsp = this.getResource(port, 2048, 2);
        if (dsp == null) {
            ResourceStore.error(port.getName() + " progressCallAnalyse", new Exception("DSP Resource not available"));
            return "ERROR";
        }
        result = ((DspResource)dsp).progressCallAnalyse(timeout);
        if (result.equals("STOPPED")) {
            result = "NO ANSWER";
        }
        this.releaseResource(port, dsp, 2);
        return result;
    }

    private int checkRouteRequest(CTIPort ctiport) {
        RouteRequest request = RouteRequest.getRouteRequest(ctiport);
        return request != null ? request.process(ctiport) : 0;
    }

    private static WavAudioFormat[] getCodecs() {
        WavAudioFormat[] afs = null;
        Vector<WavAudioFormat> tmp = new Vector<WavAudioFormat>();
        for (int i = 0; i < resources.size(); ++i) {
            Resource r = (Resource)resources.elementAt(i);
            if ((r.getType() & 2) == 0) continue;
            afs = ((VoiceResource)r).getAvailableCodecs(1);
            if (afs == null) {
                return null;
            }
            if (tmp.size() == 0) {
                for (int j = 0; j < afs.length; ++j) {
                    tmp.addElement(afs[j]);
                }
                continue;
            }
            if (r.getRouteSocket() == null) continue;
            Enumeration e = tmp.elements();
            while (e.hasMoreElements()) {
                boolean exists = false;
                WavAudioFormat a = (WavAudioFormat)e.nextElement();
                for (int k = 0; k < afs.length; ++k) {
                    if (!a.equals(afs[k])) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                tmp.removeElement(a);
            }
        }
        if (tmp.size() == 0) {
            return null;
        }
        afs = new WavAudioFormat[tmp.size()];
        for (int f = 0; f < afs.length; ++f) {
            afs[f] = (WavAudioFormat)tmp.elementAt(f);
        }
        return afs;
    }

    public WavAudioFormat getDefaultAudioFormat() {
        return this.defaultFormat;
    }

    public static boolean isArrayContains(Object[] array, Object object) {
        if (array == null || object == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    void addDisconnectListener(DisconnectListener dl) {
        if (!this.disconnect_listeners.contains(dl)) {
            this.disconnect_listeners.addElement(dl);
        }
    }

    boolean removeDisconnectListener(DisconnectListener dl) {
        return this.disconnect_listeners.removeElement(dl);
    }

    class WaitingPort {
        boolean in;
        boolean out;
        long endtime;
        CTIPort ctiport;
        int result = -1;
        RouteRequest request;
        boolean newway;

        public WaitingPort(CTIPort ctiport) {
            this.ctiport = ctiport;
            this.endtime = Long.MAX_VALUE;
            this.in = true;
            this.out = true;
            this.newway = true;
            ctiport.setStatus("waiting call");
        }

        public WaitingPort(CTIPort ctiport, int timeout, boolean in, boolean out) {
            this.ctiport = ctiport;
            this.endtime = System.currentTimeMillis() + (long)timeout * 1000L;
            this.in = in;
            this.out = out;
        }
    }

    class PortThread
    extends Thread {
        WaitingPort wp;

        public PortThread(WaitingPort wp) {
            this.wp = wp;
        }

        @Override
        public void run() {
            try {
                this.wp.ctiport.processEvent(this.wp.result, this.wp.request);
            }
            catch (Exception e) {
                ResourceStore.error("PortThread", e);
            }
            this.wp.ctiport.setStatus("waiting call");
            this.wp.request = null;
            ResourceManager.this.waitingPorts.add(this.wp);
        }
    }
}

