/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.audio;

import java.io.File;

public class SignalProcessor {
    public static final int AGC_ANALOG = 1;
    public static final int AGC_DIGITAL = 2;
    public static final int AGC_FIXED = 3;
    public static String nativeLibraryPathPrefix = System.getProperty("user.dir") + File.separator + "bin" + File.separator;
    public static String nativeLibrarySuffix;
    public static boolean isPresent;
    private long handle;

    public static synchronized SignalProcessor getInstance(int frameSize, int samplingRate, int scSamplingRate) {
        return new SignalProcessor(frameSize, samplingRate, scSamplingRate);
    }

    public SignalProcessor(int frameSize, int samplingRate, int scSamplingRate) {
        this.handle = this.init(frameSize, samplingRate, scSamplingRate);
    }

    public synchronized void destroy() {
        this.destroy(this.handle);
        this.handle = -1L;
    }

    public synchronized void reset() {
        this.reset(this.handle);
    }

    public synchronized int process(byte[] frame) {
        return this.process(this.handle, frame);
    }

    public synchronized void setFilter() {
        this.setFilter(this.handle);
    }

    public synchronized void setVAD(int mode) {
        this.setVAD(this.handle, mode);
    }

    public synchronized void setAGC(int mode) {
        this.setAGC(this.handle, mode);
    }

    public synchronized void setAGCLevel(int level) {
        this.setAGCLevel(this.handle, level);
    }

    public synchronized void setAGCCompressionGain(int level) {
        this.setAGCCompressionGain(this.handle, level);
    }

    public synchronized void setNoiseSuppression(int mode) {
        this.setDenoise(this.handle, mode);
    }

    public synchronized void setEchoCancellation(int delay) {
        this.setEchoCancellation(this.handle, delay);
    }

    public synchronized void render(byte[] frame) {
        this.render(this.handle, frame);
    }

    public synchronized int setResampler(int inrate, int outrate) {
        return this.setResampler(this.handle, inrate, outrate);
    }

    public synchronized void resample(byte[] input, byte[] output) {
        this.resample(this.handle, input, output);
    }

    public synchronized void setSoundCaptureLevel(int level) {
        this.setSoundCaptureLevel(this.handle, level);
    }

    public synchronized int getSoundCaptureLevel() {
        return this.getSoundCaptureLevel(this.handle);
    }

    private native long init(int var1, int var2, int var3);

    private native void destroy(long var1);

    private native void reset(long var1);

    private native void setFilter(long var1);

    private native void setVAD(long var1, int var3);

    private native void setAGC(long var1, int var3);

    private native void setAGCLevel(long var1, int var3);

    private native void setAGCCompressionGain(long var1, int var3);

    private native void setDenoise(long var1, int var3);

    private native void setEchoCancellation(long var1, int var3);

    private native void render(long var1, byte[] var3);

    private native int process(long var1, byte[] var3);

    private native void resample(long var1, byte[] var3, byte[] var4);

    private native int setResampler(long var1, int var3, int var4);

    private native void setSoundCaptureLevel(long var1, int var3);

    private native int getSoundCaptureLevel(long var1);

    static {
        String os = System.getProperty("os.name").toLowerCase();
        System.out.println("Library os: " + os);
        if (os.startsWith("windows")) {
            nativeLibrarySuffix = ".dll";
        } else if (os.startsWith("mac")) {
            nativeLibraryPathPrefix = nativeLibraryPathPrefix + "lib";
            nativeLibrarySuffix = ".dylib";
            System.out.println("Library nativeLibraryPathPrefix: " + nativeLibraryPathPrefix);
        } else if (os.startsWith("linux")) {
            nativeLibraryPathPrefix = nativeLibraryPathPrefix + "lib";
            nativeLibrarySuffix = ".so";
        }
        try {
            System.load(nativeLibraryPathPrefix + "dsp" + nativeLibrarySuffix);
            System.out.println("Library : " + nativeLibraryPathPrefix + "dsp" + nativeLibrarySuffix + " is loaded");
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
            try {
                System.loadLibrary("dsp");
                isPresent = true;
            }
            catch (Throwable e) {
                System.out.println(e);
            }
        }
    }
}

