/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.codec;

import com.smile.telephony.AudioCodec;

public class ALaw
extends AudioCodec {
    int[] seg_aend = new int[]{31, 63, 127, 255, 511, 1023, 2047, 4095};

    public ALaw() {
        super(AudioCodec.ALAW);
    }

    @Override
    public int encode(byte[] input, byte[] output) {
        return this.encode(input, output, 0, output.length);
    }

    public int encode(byte[] input, byte[] output, int outoff, int outlen) {
        int i = 0;
        for (int j = 0; j < outlen; ++j) {
            int seg;
            int mask;
            int pcm_val = (input[i++] & 0xFF) + (input[i++] << 8);
            if ((pcm_val >>= 3) >= 0) {
                mask = 213;
            } else {
                mask = 85;
                pcm_val = -pcm_val - 1;
            }
            for (seg = 0; seg < this.seg_aend.length && pcm_val > this.seg_aend[seg]; ++seg) {
            }
            if (seg >= 8) {
                output[outoff + j] = (byte)(0x7F ^ mask);
                continue;
            }
            int aval = seg << 4;
            aval = seg < 2 ? (aval |= pcm_val >> 1 & 0xF) : (aval |= pcm_val >> seg & 0xF);
            output[outoff + j] = (byte)(aval ^ mask);
        }
        return outlen;
    }

    @Override
    public int decode(byte[] input, byte[] output) {
        return this.decode(input, 0, input.length, output);
    }

    public int decode(byte[] input, int inoff, int inlen, byte[] output) {
        int j = 0;
        for (int i = 0; i < inlen; ++i) {
            int val = input[inoff + i] ^ 0x55;
            int t = (val & 0xF) << 4;
            int seg = (val & 0x70) >> 4;
            switch (seg) {
                case 0: {
                    t += 8;
                    break;
                }
                case 1: {
                    t += 264;
                    break;
                }
                default: {
                    t += 264;
                    t <<= seg - 1;
                }
            }
            val = (val & 0x80) != 0 ? t : -t;
            output[j++] = (byte)(val & 0xFF);
            output[j++] = (byte)(val >> 8 & 0xFF);
        }
        return j;
    }
}

