/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.codec;

import com.smile.telephony.AudioCodec;
import com.smile.telephony.AudioConverter;
import com.smile.telephony.DTMFListener;
import com.smile.telephony.codec.ConvertedOutputStream;
import com.smile.telephony.codec.goertzel_filter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class DTMFDecoder
extends OutputStream {
    private goertzel_filter[] row_banks;
    private goertzel_filter[] row_banks_2f;
    private goertzel_filter[] column_banks;
    private goertzel_filter[] column_banks_2f;
    private String keys = "123A456B789C*0#D";
    private char last_key = '\u0000';
    private char prev_key = '\u0000';
    private char key = '\u0000';
    private int reset_banks = 0;
    private Vector hist = new Vector();
    private int seq = 0;
    private final int block_size = 136;
    private final double thr_twist_std = 2.6;
    private final double thr_twist_rev = 6.4;
    private final double thr_toOtherTones = 9.0;
    private final double thr_toOtherDialTones = 5.0;
    private final int time_pause = 4;
    private final int time_tone = 3;
    private ConvertedOutputStream cstream;
    private DTMFListener listener;
    private AudioConverter converter = new AudioConverter();

    public DTMFDecoder(AudioCodec codec, DTMFListener listener) throws IOException {
        AudioCodec[] decoder = new AudioCodec[]{codec};
        this.cstream = this.converter.getOutputStream((OutputStream)this, AudioCodec.PCM16LINEAR, decoder);
        if (this.cstream == null) {
            throw new IOException(codec.toString() + " decoder not available");
        }
        this.listener = listener;
        this.row_banks = new goertzel_filter[4];
        this.row_banks[0] = new goertzel_filter(697.0f, 8000.0f, 136);
        this.row_banks[1] = new goertzel_filter(770.0f, 8000.0f, 136);
        this.row_banks[2] = new goertzel_filter(852.0f, 8000.0f, 136);
        this.row_banks[3] = new goertzel_filter(941.0f, 8000.0f, 136);
        this.row_banks_2f = new goertzel_filter[4];
        this.row_banks_2f[0] = new goertzel_filter(1394.0f, 8000.0f, 136);
        this.row_banks_2f[1] = new goertzel_filter(1540.0f, 8000.0f, 136);
        this.row_banks_2f[2] = new goertzel_filter(1704.0f, 8000.0f, 136);
        this.row_banks_2f[3] = new goertzel_filter(1882.0f, 8000.0f, 136);
        this.column_banks = new goertzel_filter[4];
        this.column_banks[0] = new goertzel_filter(1209.0f, 8000.0f, 136);
        this.column_banks[1] = new goertzel_filter(1336.0f, 8000.0f, 136);
        this.column_banks[2] = new goertzel_filter(1477.0f, 8000.0f, 136);
        this.column_banks[3] = new goertzel_filter(1633.0f, 8000.0f, 136);
        this.column_banks_2f = new goertzel_filter[4];
        this.column_banks_2f[0] = new goertzel_filter(2418.0f, 8000.0f, 136);
        this.column_banks_2f[1] = new goertzel_filter(2672.0f, 8000.0f, 136);
        this.column_banks_2f[2] = new goertzel_filter(2954.0f, 8000.0f, 136);
        this.column_banks_2f[3] = new goertzel_filter(3266.0f, 8000.0f, 136);
        for (int i = 0; i < 3; ++i) {
            this.hist.add("_");
        }
    }

    @Override
    public void close() throws IOException {
        this.cstream.release();
    }

    public void reset() {
        for (goertzel_filter filter : this.row_banks) {
            filter.reset();
        }
        for (goertzel_filter filter : this.column_banks) {
            filter.reset();
        }
        for (goertzel_filter filter : this.row_banks_2f) {
            filter.reset();
        }
        for (goertzel_filter filter : this.column_banks_2f) {
            filter.reset();
        }
        this.last_key = '\u0000';
        this.prev_key = '\u0000';
        this.key = '\u0000';
        this.reset_banks = 0;
        this.seq = 1;
    }

    public void check(byte[] data, int off, int len) throws IOException {
        this.cstream.write(data, off, len);
    }

    @Override
    public void write(byte[] data, int off, int len) throws IOException {
        float[] samples = new float[len / 2];
        int i = off;
        int j = 0;
        while (j < samples.length) {
            samples[j] = (short)(data[i] & 0xFF | data[i + 1] << 8 & 0xFF00);
            ++j;
            i += 2;
        }
        for (float sample : samples) {
            for (goertzel_filter goertzel_filter2 : this.row_banks) {
                goertzel_filter2.ProcessSample(sample);
            }
            for (goertzel_filter goertzel_filter3 : this.column_banks) {
                goertzel_filter3.ProcessSample(sample);
            }
            for (goertzel_filter goertzel_filter4 : this.row_banks_2f) {
                goertzel_filter4.ProcessSample(sample);
            }
            for (goertzel_filter goertzel_filter5 : this.column_banks_2f) {
                goertzel_filter5.ProcessSample(sample);
            }
            if (this.reset_banks++ <= 136) continue;
            this.reset_banks = 0;
            float[] levels = new float[4];
            for (int i2 = 0; i2 < this.row_banks.length; ++i2) {
                levels[i2] = this.row_banks[i2].getMagnitudeSquared();
            }
            int row = this.level_decode(levels);
            for (int i3 = 0; i3 < this.column_banks.length; ++i3) {
                levels[i3] = this.column_banks[i3].getMagnitudeSquared();
            }
            int column = this.level_decode(levels);
            this.key = row == 4 || column == 4 || (double)(this.row_banks[row].getMagnitudeSquared() / this.column_banks[column].getMagnitudeSquared()) > 2.6 || (double)(this.column_banks[column].getMagnitudeSquared() / this.row_banks[row].getMagnitudeSquared()) > 6.4 || (double)(this.row_banks[row].getMagnitudeSquared() / this.row_banks_2f[row].getMagnitudeSquared()) < 9.0 || (double)(this.column_banks[column].getMagnitudeSquared() / this.column_banks_2f[column].getMagnitudeSquared()) < 9.0 ? (char)95 : this.keys.charAt(row * 4 + column);
            for (goertzel_filter filter3 : this.row_banks) {
                filter3.reset();
            }
            for (goertzel_filter filter : this.column_banks) {
                filter.reset();
            }
            for (goertzel_filter filter : this.row_banks_2f) {
                filter.reset();
            }
            for (goertzel_filter filter : this.column_banks_2f) {
                filter.reset();
            }
            Object e = this.hist.remove(0);
            this.hist.add(Character.valueOf(this.key));
            if (this.hist.elementAt(0) == this.hist.elementAt(2) && this.hist.elementAt(1) != this.hist.elementAt(2)) {
                this.hist.setElementAt(this.hist.elementAt(2), 1);
            }
            this.key = e.toString().charAt(0);
            this.seq = this.prev_key == this.key ? ++this.seq : 0;
            if (this.key == '_') {
                if (this.seq == 4) {
                    this.last_key = this.key;
                }
            } else if (this.seq == 3) {
                if (this.last_key != this.key) {
                    this.listener.digitReceived(this.prev_key);
                }
                this.last_key = this.key;
            }
            this.prev_key = this.key;
        }
    }

    @Override
    public void write(int b) throws IOException {
    }

    private int level_decode(float[] levels) {
        float max = 0.0f;
        float sum = 0.0f;
        boolean ind = false;
        for (float level : levels) {
            max = Math.max(level, max);
            sum += level;
        }
        sum = (sum - max) / 3.0f;
        if (max == 0.0f || (double)(max / sum) < 5.0) {
            return 4;
        }
        for (int i = 0; i < levels.length; ++i) {
            if (max != levels[i]) continue;
            return i;
        }
        return 4;
    }
}

