/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.codec;

import com.smile.telephony.AudioCodec;
import com.smile.telephony.audio.SignalProcessor;
import java.util.Vector;
import smile.util.ResourceStore;

public class G729A
extends AudioCodec {
    private static Vector codecs;
    private int handle;
    private int direction;

    public static AudioCodec getCodec(int dir) {
        if (codecs == null) {
            return null;
        }
        for (int i = 0; i < codecs.size(); ++i) {
            G729A c = (G729A)codecs.elementAt(i);
            if (!c.seize(dir)) continue;
            return c;
        }
        G729A c = new G729A(dir);
        if (!c.seize(dir)) {
            return null;
        }
        codecs.addElement(c);
        return c;
    }

    public G729A(int dir) {
        super(AudioCodec.G729A);
        this.direction = dir;
        this.handle = com.smile.telephony.codec.G729A.open();
    }

    private synchronized boolean seize(int dir) {
        if (this.state == 0 && dir == this.direction && (dir == 1 && com.smile.telephony.codec.G729A.initEncoder(this.handle) || dir == 0 && com.smile.telephony.codec.G729A.initDecoder(this.handle))) {
            this.state = 1;
            return true;
        }
        return false;
    }

    @Override
    public void release() {
        this.state = 0;
    }

    static native int open();

    static native boolean initEncoder(int var0);

    static native boolean initDecoder(int var0);

    static native boolean encode(int var0, byte[] var1, int var2, byte[] var3, int var4);

    static native boolean decode(int var0, byte[] var1, int var2, byte[] var3, int var4);

    @Override
    public int encode(byte[] input, byte[] output) {
        return com.smile.telephony.codec.G729A.encode(this.handle, input, 0, output, 0) ? output.length : -1;
    }

    @Override
    public int decode(byte[] input, byte[] output) {
        return com.smile.telephony.codec.G729A.decode(this.handle, input, 0, output, 0) ? output.length : -1;
    }

    static {
        System.out.print("Loading g729a.dll ...");
        try {
            System.load(SignalProcessor.nativeLibraryPathPrefix + "g729a" + SignalProcessor.nativeLibrarySuffix);
            codecs = new Vector();
            ResourceStore.syslog("Library : " + SignalProcessor.nativeLibraryPathPrefix + "g729a" + SignalProcessor.nativeLibrarySuffix + " is loaded");
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
            try {
                System.loadLibrary("g729a");
                codecs = new Vector();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }
}

