/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.codec;

public class goertzel_filter {
    float coeff;
    float q1;
    float q2;
    float sine;
    float cosine;

    public goertzel_filter(float target_freq, float sampling_rate, int block_size) {
        this.Init(target_freq, sampling_rate, block_size);
    }

    public void reset() {
        this.q1 = 0.0f;
        this.q2 = 0.0f;
    }

    public void Init(float target_freq, float sampling_rate, int block_size) {
        int k = (int)(0.5 + (double)(target_freq * (float)block_size / sampling_rate));
        float omega = (float)(Math.PI * 2 * (double)k) / (float)block_size;
        this.sine = (float)Math.sin(omega);
        this.cosine = (float)Math.cos(omega);
        this.coeff = 2.0f * this.cosine;
        this.reset();
    }

    public void ProcessSample(float sample) {
        float q0 = this.coeff * this.q1 - this.q2 + sample;
        this.q2 = this.q1;
        this.q1 = q0;
    }

    public float getReal() {
        return this.q1 - this.q2 * this.cosine;
    }

    public float getImag() {
        return this.q2 * this.sine;
    }

    public float getMagnitudeSquared() {
        return this.q1 * this.q1 + this.q2 * this.q2 - this.q1 * this.q2 * this.coeff;
    }
}

