/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.codec.video;

import com.smile.telephony.audio.SignalProcessor;
import com.smile.telephony.codec.video.H263;
import com.smile.telephony.codec.video.H263P;
import com.smile.telephony.codec.video.H264;
import com.smile.telephony.video.VideoCapability;
import smile.util.ResourceStore;

public class Codec {
    public static final String PIX_FMT_YUV420P = "YUV420P";
    public static final String PIX_FMT_YUYV422 = "YUYV422";
    public static final String PIX_FMT_NV12 = "NV12";
    public static final String PIX_FMT_RGB24 = "RGB24";
    public static final String PIX_FMT_RGBA = "RGBA";
    static boolean isLoaded;
    private VideoCapability capability;
    long idObj = this.init();
    boolean isOpen = false;
    boolean isEncoder = false;
    boolean closed = false;
    int type = 4;

    public static Codec getCodec(int capability, boolean encode) {
        return Codec.getCodec(VideoCapability.getDefaultCapabilities(capability), encode);
    }

    public static Codec getCodec(VideoCapability capability, boolean encode) {
        Codec codec = null;
        switch (capability.getCodecType()) {
            case 4: {
                codec = new H264();
                break;
            }
            case 2: {
                codec = new H263P();
                break;
            }
            case 1: {
                codec = new H263();
                break;
            }
            case 0: {
                break;
            }
            default: {
                return null;
            }
        }
        codec.type = capability.getCodecType();
        codec.setDirection(encode);
        codec.setVideoCapability(capability);
        return codec;
    }

    public VideoCapability getVideoCapability() {
        return this.capability;
    }

    public void setVideoCapability(VideoCapability cap) {
        this.capability = cap;
    }

    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public int getType() {
        return this.type;
    }

    public synchronized boolean setImageFmt(int width, int height, String depth) {
        return this.setParam("width", Integer.toString(width)) & this.setParam("height", Integer.toString(height)) & this.setParam("pixel_format", depth);
    }

    public synchronized boolean setParam(String param, String value) {
        return !this.closed && this.setParam(this.idObj, param, value) == 0;
    }

    public String getParam(String param) {
        return this.getParam(this.idObj, param);
    }

    public float getAspectRatio() {
        return Float.parseFloat(this.getParam("width")) / Float.parseFloat(this.getParam("height"));
    }

    public void setKeyRate(int rate) {
        this.setParam("g", String.valueOf(rate));
    }

    public boolean open_codec() {
        String sps;
        boolean bl = this.isOpen = this.open_codec(this.idObj) == 0;
        if (this.isEncoder || (sps = (String)this.capability.getParameter("sprop-parameter-sets")) != null) {
            // empty if block
        }
        return this.isOpen;
    }

    public synchronized void close_codec() {
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        this.closed = true;
        this.close_codec(this.idObj);
        this.dispose(this.idObj);
    }

    public void setDirection(boolean encode) {
        this.setParam("direction", encode ? "encode" : "decode");
        this.isEncoder = encode;
    }

    public byte[] process(byte[] in) {
        return this.process(in, in.length);
    }

    public synchronized byte[] process(byte[] in, int len) {
        if (this.closed) {
            return new byte[0];
        }
        return this.process(this.idObj, in, len);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setKey() {
        this.setKey(this.idObj);
    }

    public boolean isKeyFrame() {
        return this.getKey(this.idObj);
    }

    public boolean isLostKey() {
        return this.isLostKey(this.idObj);
    }

    public boolean isLostFrame() {
        return this.isLostFrame(this.idObj);
    }

    public boolean isError() {
        return this.isError(this.idObj);
    }

    public boolean isCorruptedFrame() {
        return this.isCorruptedFrame(this.idObj);
    }

    public boolean isNoReference() {
        return this.isNoReference(this.idObj);
    }

    private native long init();

    private native void dispose(long var1);

    private native int setParam(long var1, String var3, String var4);

    private native String getParam(long var1, String var3);

    private native int open_codec(long var1);

    private native void close_codec(long var1);

    private native byte[] process(long var1, byte[] var3, int var4);

    private native void setKey(long var1);

    private native boolean getKey(long var1);

    private native boolean isLostFrame(long var1);

    private native boolean isLostKey(long var1);

    private native boolean isError(long var1);

    private native boolean isCorruptedFrame(long var1);

    private native boolean isNoReference(long var1);

    public void setBitRate(int br) {
        this.setParam("bit_rate", Integer.toString(br));
    }

    public void setFrameRate(int fr) {
        this.setParam("frame_rate", Integer.toString(fr));
    }

    public void setFrameSize(int w, int h) {
        this.setParam("width", Integer.toString(w));
        this.setParam("height", Integer.toString(h));
    }

    public void setPixelFormat(PixFmt pf) {
        this.setParam("pixel_format", pf.toString());
    }

    public void setResizeMethod(ResizeMethod rm) {
        this.setParam("resize_method", rm.toString());
    }

    public void setQcomp(double q) {
        this.setParam("qcomp", Double.toString(q));
    }

    public void setQblur(double q) {
        this.setParam("qblur", Double.toString(q));
    }

    public void setQmin(int q) {
        this.setParam("qmin", Integer.toString(q));
    }

    public void setQmax(int q) {
        this.setParam("qmax", Integer.toString(q));
    }

    public void setQdiff(int q) {
        this.setParam("max_qdiff", Integer.toString(q));
    }

    public void setIQfactor(double q) {
        this.setParam("i_qfactor", Double.toString(q));
    }

    public void setIQoffset(double q) {
        this.setParam("i_qoffset", Double.toString(q));
    }

    public void setMeMethod(MeMethod mm) {
        this.setParam("me_method", mm.toString());
    }

    public void setMeSubpelQuality(int q) {
        this.setParam("subq", Integer.toString(q));
    }

    public void setMeRange(int r) {
        this.setParam("me_range", Integer.toString(r));
    }

    public void setMeDiaSize(int s) {
        this.setParam("dia_size", Integer.toString(s));
    }

    public void setMeCmpChroma() {
        this.setParam("cmp", "chroma");
    }

    public void setMeThreshold(int t) {
        this.setParam("me_threshold", Integer.toString(t));
    }

    public void setMePenaltyCompensation(int t) {
        this.setParam("me_penalty_compensation", Integer.toString(t));
    }

    public void setSceneChangeThereshold(int t) {
        this.setParam("sc_thereshold", Integer.toString(t));
    }

    public void setSceneChangeFactor(int f) {
        this.setParam("sc_factor", Integer.toString(f));
    }

    public void setNoiseReduction(int st) {
        this.setParam("noise_reduction", Integer.toString(st));
    }

    public void setQuantNoiseShaping(int st) {
        this.setParam("qnoise_shaping", Integer.toString(st));
    }

    public void setGOPlength(int len) {
        this.setParam("g", Integer.toString(len));
    }

    public void setMinGOPlength(int len) {
        this.setParam("keyint_min", Integer.toString(len));
    }

    public void setClosedGOP() {
        this.setParam("flags", "+closed_gop");
    }

    public void setMBDecision(mbDecision d) {
        this.setParam("mb_decision", d.toString());
    }

    public void setLoopFilter() {
        this.setParam("flags", "+loop_filter");
    }

    public void setTruncated() {
        this.setParam("flags", "+truncated");
    }

    public void setRTPPayload(int size) {
        this.setParam("rtp_payload", Integer.toString(size));
    }

    public int getWidth() {
        return Integer.parseInt(this.getParam("width"));
    }

    public int getHeight() {
        return Integer.parseInt(this.getParam("height"));
    }

    public int getOutWidth() {
        return Integer.parseInt(this.getParam("out_width"));
    }

    public int getOutHeight() {
        return Integer.parseInt(this.getParam("out_height"));
    }

    public int getBitRate() {
        return Integer.parseInt(this.getParam("bit_rate"));
    }

    public float getFrameRate() {
        return Float.parseFloat(this.getParam("frame_rate"));
    }

    public String getPixelFormat() {
        return this.getParam("pixel_format");
    }

    static {
        try {
            System.load(SignalProcessor.nativeLibraryPathPrefix + "dvp" + SignalProcessor.nativeLibrarySuffix);
            isLoaded = true;
            ResourceStore.syslog("Library : " + SignalProcessor.nativeLibraryPathPrefix + "dvp" + SignalProcessor.nativeLibrarySuffix + " is loaded");
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
            try {
                System.loadLibrary("dvp");
                isLoaded = true;
                System.out.println("loadLibrary dvp OK");
            }
            catch (Throwable e) {
                System.out.println(e);
                ResourceStore.error(e.toString());
            }
        }
    }

    public static enum mbDecision {
        simple,
        bits,
        rd;

    }

    public static enum MeMethod {
        full,
        epzs,
        hex,
        umh,
        tesa,
        zero;

    }

    public static enum ResizeMethod {
        bilinear,
        fast_bilinear,
        bicubic,
        X,
        point,
        area,
        bicublin,
        gauss,
        sinc,
        lanczos,
        spline;

    }

    public static enum PixFmt {
        RGB24,
        RGB32,
        BGR24,
        BGR32,
        YUV420,
        YUV422,
        NV12;

    }
}

