/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.codec.video;

import com.smile.telephony.codec.video.Codec;
import com.smile.telephony.video.VideoCapability;
import java.util.Vector;

public class H264
extends Codec {
    public final int p8x8 = 1;
    public final int p4x4 = 2;
    public final int b8x8 = 4;
    public final int i8x8 = 8;
    public final int i4x4 = 22;
    static final int IntelH264_QUALITY_AUTO = 0;
    static final int IntelH264_QUALITY_BEST_QUALITY = 1;
    static final int IntelH264_QUALITY_BALANCED = 4;
    static final int IntelH264_QUALITY_BEST_SPEED = 7;

    public static int getMaxBitrate(VideoCapability cap) {
        String maxRecvLevel;
        int profile_idc = 66;
        int profile_iop = 128;
        int level_idc = 30;
        String profileLevelId = (String)cap.getParameter("profile-level-id");
        if (profileLevelId != null) {
            try {
                int plid = Integer.parseInt(profileLevelId, 16);
                profile_idc = plid >> 16 & 0xFF;
                profile_iop = plid >> 8 & 0xFF;
                level_idc = plid & 0xFF;
            }
            catch (NumberFormatException plid) {
                // empty catch block
            }
        }
        if ((maxRecvLevel = (String)cap.getParameter("max-recv-level")) != null) {
            try {
                int plid = Integer.parseInt(maxRecvLevel, 16);
                profile_iop = plid >> 8 & 0xFF;
                level_idc = plid & 0xFF;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((profile_iop & 0x10) != 0 && level_idc == 11 || (profile_iop & 0x10) == 0 && level_idc == 9) {
            level_idc = 27;
        }
        return H264.getMaxBr(level_idc);
    }

    public static int getMaxFbs(int level) {
        if (level >= 40) {
            return 8192;
        }
        if (level == 32) {
            return 5120;
        }
        if (level == 31) {
            return 3600;
        }
        if (level >= 22) {
            return 1620;
        }
        if (level == 21) {
            return 792;
        }
        if (level >= 11) {
            return 396;
        }
        return 99;
    }

    public static int getMaxBr(int level) {
        if (level >= 32) {
            return 20000000;
        }
        if (level == 31) {
            return 14000000;
        }
        if (level == 30) {
            return 10000000;
        }
        if (level >= 21) {
            return 4000000;
        }
        if (level == 20) {
            return 2000000;
        }
        if (level == 13) {
            return 768000;
        }
        if (level == 12) {
            return 384000;
        }
        if (level == 11) {
            return 192000;
        }
        if (level == 10) {
            return 128000;
        }
        return 64000;
    }

    public static int getMaxFr(String format, int level) {
        if (format.equals("128x96") || format.equals("96x128")) {
            if (level <= 10) {
                return 30;
            }
            if (level == 11) {
                return 62;
            }
            if (level == 12) {
                return 125;
            }
            return 172;
        }
        if (format.equals("160x90") || format.equals("90x160")) {
            if (level <= 10) {
                return 25;
            }
            if (level == 11) {
                return 62;
            }
            if (level == 12) {
                return 125;
            }
            return 172;
        }
        if (format.equals("160x120") || format.equals("120x160")) {
            if (level <= 10) {
                return 20;
            }
            if (level == 11) {
                return 62;
            }
            if (level == 12) {
                return 125;
            }
            return 172;
        }
        if (format.equals("176x144") || format.equals("144x176")) {
            if (level <= 10) {
                return 15;
            }
            if (level == 11) {
                return 30;
            }
            if (level == 12) {
                return 60;
            }
            if (level <= 20) {
                return 120;
            }
            return 172;
        }
        if (format.equals("192x144") || format.equals("144x192")) {
            if (level <= 10) {
                return 15;
            }
            if (level == 11) {
                return 30;
            }
            if (level == 12) {
                return 60;
            }
            if (level <= 20) {
                return 120;
            }
            return 172;
        }
        if (format.equals("320x180") || format.equals("180x320")) {
            if (level <= 10) {
                return 0;
            }
            if (level == 11) {
                return 15;
            }
            if (level == 12) {
                return 30;
            }
            if (level <= 20) {
                return 39;
            }
            if (level == 21) {
                return 66;
            }
            if (level == 22) {
                return 67;
            }
            if (level == 30) {
                return 135;
            }
            return 172;
        }
        if (format.equals("320x240") || format.equals("240x320")) {
            if (level <= 10) {
                return 0;
            }
            if (level == 11) {
                return 10;
            }
            if (level == 12) {
                return 20;
            }
            if (level <= 20) {
                return 39;
            }
            if (level == 21) {
                return 66;
            }
            if (level == 22) {
                return 67;
            }
            if (level == 30) {
                return 135;
            }
            return 172;
        }
        if (format.equals("352x240") || format.equals("240x352")) {
            if (level <= 10) {
                return 0;
            }
            if (level == 11) {
                return 9;
            }
            if (level == 12) {
                return 18;
            }
            if (level <= 20) {
                return 36;
            }
            if (level == 21) {
                return 60;
            }
            if (level == 22) {
                return 61;
            }
            if (level == 30) {
                return 122;
            }
            return 172;
        }
        if (format.equals("352x288") || format.equals("288x352")) {
            if (level <= 10) {
                return 0;
            }
            if (level == 11) {
                return 7;
            }
            if (level == 12) {
                return 15;
            }
            if (level <= 20) {
                return 30;
            }
            if (level == 21) {
                return 50;
            }
            if (level == 22) {
                return 51;
            }
            if (level == 30) {
                return 102;
            }
            return 172;
        }
        if (format.equals("384x288") || format.equals("288x384")) {
            if (level <= 10) {
                return 0;
            }
            if (level == 11) {
                return 7;
            }
            if (level == 12) {
                return 15;
            }
            if (level <= 20) {
                return 30;
            }
            if (level == 21) {
                return 50;
            }
            if (level == 22) {
                return 51;
            }
            if (level == 30) {
                return 102;
            }
            return 172;
        }
        if (format.equals("352x480")) {
            if (level <= 20) {
                return 0;
            }
            if (level <= 22) {
                return 30;
            }
            if (level == 30) {
                return 61;
            }
            if (level == 31) {
                return 163;
            }
            return 172;
        }
        if (format.equals("352x576")) {
            if (level <= 20) {
                return 0;
            }
            if (level <= 22) {
                return 25;
            }
            if (level == 30) {
                return 51;
            }
            if (level == 31) {
                return 136;
            }
            return 172;
        }
        if (format.equals("640x360") || format.equals("360x640")) {
            if (level <= 21) {
                return 0;
            }
            if (level == 22) {
                return 16;
            }
            if (level == 30) {
                return 33;
            }
            if (level == 31) {
                return 90;
            }
            return 172;
        }
        if (format.equals("640x480") || format.equals("480x640")) {
            if (level <= 21) {
                return 0;
            }
            if (level == 22) {
                return 16;
            }
            if (level == 30) {
                return 33;
            }
            if (level == 31) {
                return 90;
            }
            return 172;
        }
        if (format.equals("704x480") || format.equals("480x704")) {
            if (level <= 21) {
                return 0;
            }
            if (level == 22) {
                return 15;
            }
            if (level == 30) {
                return 30;
            }
            if (level == 31) {
                return 81;
            }
            if (level == 32) {
                return 163;
            }
            return 172;
        }
        if (format.equals("720x480") || format.equals("480x720")) {
            if (level <= 21) {
                return 0;
            }
            if (level == 22) {
                return 15;
            }
            if (level == 30) {
                return 30;
            }
            if (level == 31) {
                return 80;
            }
            if (level == 32) {
                return 160;
            }
            return 172;
        }
        if (format.equals("704x576") || format.equals("576x704")) {
            if (level <= 21) {
                return 0;
            }
            if (level == 22) {
                return 12;
            }
            if (level == 30) {
                return 25;
            }
            if (level == 31) {
                return 68;
            }
            if (level == 32) {
                return 136;
            }
            if (level <= 41) {
                return 155;
            }
            return 172;
        }
        if (format.equals("720x576") || format.equals("576x720")) {
            if (level <= 21) {
                return 0;
            }
            if (level == 22) {
                return 12;
            }
            if (level == 30) {
                return 25;
            }
            if (level == 31) {
                return 66;
            }
            if (level == 32) {
                return 133;
            }
            if (level <= 41) {
                return 151;
            }
            return 172;
        }
        if (format.equals("800x600") || format.equals("600x800")) {
            if (level <= 30) {
                return 0;
            }
            if (level == 31) {
                return 56;
            }
            if (level == 32) {
                return 113;
            }
            if (level <= 41) {
                return 129;
            }
            return 172;
        }
        if (format.equals("1024x768") || format.equals("768x1024")) {
            if (level <= 30) {
                return 0;
            }
            if (level == 31) {
                return 35;
            }
            if (level == 32) {
                return 70;
            }
            if (level <= 41) {
                return 80;
            }
            return 172;
        }
        if (format.equals("1280x720") || format.equals("720x1280")) {
            if (level <= 30) {
                return 0;
            }
            if (level == 31) {
                return 30;
            }
            if (level == 32) {
                return 60;
            }
            if (level <= 41) {
                return 68;
            }
            if (level == 42) {
                return 145;
            }
            if (level == 50) {
                return 163;
            }
            return 172;
        }
        if (format.equals("1280x960") || format.equals("960x1280")) {
            if (level <= 31) {
                return 0;
            }
            if (level == 32) {
                return 45;
            }
            if (level <= 41) {
                return 51;
            }
            if (level == 42) {
                return 108;
            }
            if (level == 50) {
                return 122;
            }
            return 172;
        }
        if (format.equals("1280x1024") || format.equals("1024x1280")) {
            if (level <= 31) {
                return 0;
            }
            if (level == 32) {
                return 42;
            }
            if (level <= 41) {
                return 48;
            }
            if (level == 42) {
                return 102;
            }
            if (level == 50) {
                return 115;
            }
            return 172;
        }
        if (format.equals("1408x960") || format.equals("960x1408")) {
            if (level <= 32) {
                return 0;
            }
            if (level <= 41) {
                return 46;
            }
            if (level == 42) {
                return 98;
            }
            if (level == 50) {
                return 111;
            }
            return 172;
        }
        if (format.equals("1408x1152") || format.equals("1152x1408")) {
            if (level <= 32) {
                return 0;
            }
            if (level <= 41) {
                return 38;
            }
            if (level == 42) {
                return 82;
            }
            if (level == 50) {
                return 93;
            }
            return 155;
        }
        if (format.equals("1600x1200") || format.equals("1200x1600")) {
            if (level <= 32) {
                return 0;
            }
            if (level <= 41) {
                return 32;
            }
            if (level == 42) {
                return 69;
            }
            if (level == 50) {
                return 78;
            }
            return 131;
        }
        if (format.equals("1920x1080") || format.equals("1080x1920")) {
            if (level <= 32) {
                return 0;
            }
            if (level <= 41) {
                return 30;
            }
            if (level == 42) {
                return 64;
            }
            if (level == 50) {
                return 72;
            }
            return 120;
        }
        return 0;
    }

    public static int getSuggestedBitrate(String format) {
        if (format.equals("128x96") || format.equals("96x128")) {
            return 48000;
        }
        if (format.equals("160x90") || format.equals("90x160")) {
            return 64000;
        }
        if (format.equals("160x120") || format.equals("120x160")) {
            return 64000;
        }
        if (format.equals("176x144") || format.equals("144x176")) {
            return 96000;
        }
        if (format.equals("192x144") || format.equals("144x192")) {
            return 128000;
        }
        if (format.equals("320x180") || format.equals("180x320")) {
            return 256000;
        }
        if (format.equals("320x240") || format.equals("240x320")) {
            return 256000;
        }
        if (format.equals("352x240") || format.equals("240x352")) {
            return 256000;
        }
        if (format.equals("352x288") || format.equals("288x352")) {
            return 320000;
        }
        if (format.equals("384x288") || format.equals("288x384")) {
            return 384000;
        }
        if (format.equals("352x480") || format.equals("480x352")) {
            return 512000;
        }
        if (format.equals("352x576") || format.equals("572x352")) {
            return 512000;
        }
        if (format.equals("640x360") || format.equals("360x640")) {
            return 512000;
        }
        if (format.equals("640x480") || format.equals("480x640")) {
            return 576000;
        }
        if (format.equals("704x480") || format.equals("480x704")) {
            return 640000;
        }
        if (format.equals("720x480") || format.equals("480x720")) {
            return 640000;
        }
        if (format.equals("704x576") || format.equals("576x704")) {
            return 768000;
        }
        if (format.equals("720x576") || format.equals("576x720")) {
            return 768000;
        }
        if (format.equals("800x600") || format.equals("600x800")) {
            return 1024000;
        }
        if (format.equals("1024x768") || format.equals("768x1024")) {
            return 2048000;
        }
        if (format.equals("1280x720") || format.equals("720x1280")) {
            return 2804000;
        }
        if (format.equals("1280x960") || format.equals("960x1280")) {
            return 0x2EE000;
        }
        if (format.equals("1280x1024") || format.equals("1024x1280")) {
            return 0x2EE000;
        }
        if (format.equals("1408x960") || format.equals("960x1408")) {
            return 3328000;
        }
        if (format.equals("1408x1152") || format.equals("1152x1408")) {
            return 3584000;
        }
        if (format.equals("1600x1200") || format.equals("1200x1600")) {
            return 4500000;
        }
        if (format.equals("1920x1080") || format.equals("1080x1920")) {
            return 6500000;
        }
        return 1024000;
    }

    public static int getMaxFormatIndex(double bitrate) {
        int n = VideoCapability.FORMATS.length - 1;
        if (bitrate <= 128000.0) {
            n = 4;
        } else if (bitrate <= 256000.0) {
            n = 9;
        } else if (bitrate <= 512000.0) {
            n = 13;
        } else if (bitrate <= 1024000.0) {
            n = 18;
        } else if (bitrate <= 2048000.0) {
            n = 20;
        } else if (bitrate <= 4096000.0) {
            n = 26;
        }
        return n;
    }

    public static Vector getSupportedFormats(int level) {
        Vector<String> v = new Vector<String>();
        for (int n = H264.getMaxFormatIndex(level); n >= 0; --n) {
            v.add(VideoCapability.FORMATS[n]);
        }
        return v;
    }

    public static int getMaxFormatIndex(int level) {
        int n = VideoCapability.FORMATS.length - 1;
        if (level <= 10) {
            n = 4;
        }
        if (level <= 12) {
            n = 6;
        } else if (level <= 20) {
            n = 9;
        } else if (level == 21) {
            n = 11;
        } else if (level <= 30) {
            n = 17;
        } else if (level == 31) {
            n = 20;
        } else if (level == 32) {
            n = 22;
        }
        return n;
    }

    public H264() {
        this.setParam("codec", "h264");
        this.setProfile(x264Profile.h264_baseline);
        this.setParam("preset", "veryfast");
        this.setParam("tune", "zerolatency");
        this.setParam("threads", "2");
        this.setParam("subq", "7");
        this.setGOPlength(30);
        this.setQcomp(0.6);
        this.setQmin(10);
        this.setQmax(51);
        this.setQdiff(4);
        this.setSliceMaxSize(1200);
        this.setParam("impl", "software");
    }

    public String getDefaultPixelFormat() {
        return "YUV420P";
    }

    public void setProfile(int profile_idc, int profile_iop) {
        switch (profile_idc) {
            case 66: {
                this.setProfile((profile_iop & 0x40) != 0 ? x264Profile.h264_constrained : x264Profile.h264_baseline);
                break;
            }
            case 77: {
                this.setProfile((profile_iop & 0x80) != 0 ? x264Profile.h264_constrained : x264Profile.h264_main);
                break;
            }
            case 88: {
                this.setProfile((profile_iop & 0xC0) == 192 ? x264Profile.h264_constrained : x264Profile.h264_extended);
                break;
            }
            case 100: {
                this.setProfile(x264Profile.h264_high);
            }
        }
    }

    public void setMaxBFrames(int nb) {
        this.setParam("max_b_frames", Integer.toString(nb));
    }

    public void setBQfactor(double q) {
        this.setParam("b_qfactor", Double.toString(q));
    }

    public void setBQoffset(double q) {
        this.setParam("b_qoffset", Double.toString(q));
    }

    public void setProfile(x264Profile pr) {
        this.setParam("profile", pr.toString());
    }

    public void setPreset(x264Preset pr) {
        this.setParam("preset", pr.toString());
    }

    public void setTune(x264tune tune) {
        this.setParam("tune", tune.toString());
    }

    public void setLevel(int lvl) {
        this.setParam("level", Integer.toString(lvl));
    }

    public void setCabac(boolean t) {
        this.setParam("cabac", t ? "1" : "0");
    }

    public void setCRF(float crf) {
        this.setParam("crf", Float.toString(crf));
    }

    public void setCRFmax(float crf_max) {
        this.setParam("crf_max", Float.toString(crf_max));
    }

    public void setQP(int qp) {
        this.setParam("qp", Integer.toString(qp));
    }

    public void setAQMode(x264aqmode mode) {
        this.setParam("aq-mode", mode.toString());
    }

    public void setAQStrength(float str) {
        this.setParam("aq-strength", Float.toString(str));
    }

    public void setPsy(boolean t) {
        this.setParam("psy", t ? "1" : "0");
    }

    public void setPsyRD(float psyrd, float psytrellis) {
        this.setParam("psy-rd", Float.toString(psyrd) + ":" + Float.toString(psytrellis));
    }

    public void setRCLookahead(int len) {
        this.setParam("rc-lookahead", Integer.toString(len));
    }

    public void setWeightb(boolean t) {
        this.setParam("weightb", t ? "1" : "0");
    }

    public void setWeightp(x264WeightPredMethod pm) {
        this.setParam("weightp", pm.toString());
    }

    public void setIntraRefresh(boolean t) {
        this.setParam("intra-refresh", t ? "1" : "0");
    }

    public void setBBias(int bbias) {
        this.setParam("b-bias", Integer.toString(bbias));
    }

    public void setBPyramid(x264BPyramid bp) {
        this.setParam("b-pyramid", bp.toString());
    }

    public void setMixedRefs(boolean t) {
        this.setParam("mixed-refs", t ? "1" : "0");
    }

    public void set8x8dct(boolean t) {
        this.setParam("8x8dct", t ? "1" : "0");
    }

    public void setFastPSkip(boolean t) {
        this.setParam("fast-pskip", t ? "1" : "0");
    }

    public void setAud(boolean t) {
        this.setParam("aud", t ? "1" : "0");
    }

    public void setMBTree(boolean t) {
        this.setParam("mbtree", t ? "1" : "0");
    }

    public void setDeblock(float alpha, float beta) {
        this.setParam("deblock", Float.toString(alpha) + ":" + Float.toString(beta));
    }

    public void setCPLXBlur(float blur) {
        this.setParam("cplxblur", Float.toString(blur));
    }

    public void setPartitions(int part) {
        Object spart = "";
        if (part == 0) {
            this.setParam("partitions", "none");
        } else if (part >= 32) {
            this.setParam("partitions", "all");
        } else {
            if ((part & 1) != 0) {
                spart = (String)spart + "p8x8,";
            }
            if ((part & 2) != 0) {
                spart = (String)spart + "p4x4,";
            }
            if ((part & 4) != 0) {
                spart = (String)spart + "b8x8,";
            }
            if ((part & 8) != 0) {
                spart = (String)spart + "i8x8,";
            }
            if ((part & 0x16) != 0) {
                spart = (String)spart + "i4x4,";
            }
            this.setParam("partitions", (String)spart);
        }
    }

    public void setDirectPred(x264directpred pred) {
        this.setParam("direct-pred", pred.toString());
    }

    public void setSliceMaxSize(int size) {
        this.setParam("slice-max-size", Integer.toString(size));
    }

    public int getImpl() {
        String p = this.getParam("hardware");
        if (p.equals("")) {
            return -1;
        }
        return Integer.parseInt(p);
    }

    public void setQuality(int quality) {
        this.setParam("quality", Integer.toString(quality));
    }

    public void setImplCodec(codecImpl impl) {
        this.setParam("impl", impl.toString());
    }

    public void setMaxBitRate(int br) {
        this.setParam("maxBR", Integer.toString(br));
    }

    public void setQPI(int q) {
        this.setParam("qpi", Integer.toString(q));
    }

    public void setQPP(int q) {
        this.setParam("qpp", Integer.toString(q));
    }

    public void setQPB(int q) {
        this.setParam("qpb", Integer.toString(q));
    }

    public void setAccuracy(int ac) {
        this.setParam("accuracy", Integer.toString(ac));
    }

    public void setConvergence(int c) {
        this.setParam("convergence", Integer.toString(c));
    }

    public static enum codecImpl {
        auto,
        hardware,
        software;

    }

    public static enum x264directpred {
        none,
        spatial,
        temporal,
        auto;

    }

    public static enum x264BPyramid {
        none,
        strict,
        normal;

    }

    public static enum x264WeightPredMethod {
        none,
        simple,
        smart;

    }

    public static enum x264aqmode {
        none,
        variance,
        autovariance;

    }

    public static enum x264tune {
        film,
        animation,
        grain,
        stillimage,
        psnr,
        ssim,
        fastdecode,
        zerolatency;

    }

    public static enum x264Preset {
        ultrafast,
        superfast,
        veryfast,
        faster,
        fast,
        medium,
        slow,
        slower,
        veryslow,
        placebo;

    }

    public static enum x264Profile {
        h264_baseline,
        h264_constrained,
        h264_main,
        h264_extended,
        h264_high,
        h264_high_10,
        h264_high_10_intra,
        h264_high_422,
        h264_high_422_intra,
        h264_high_444,
        h264_high_444_intra,
        h264_high_444_predictive,
        h264_cavlc_444;

    }
}

