/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.rtp;

public class RTPPacket {
    private byte[] b;
    private int size;

    public RTPPacket(byte[] buffer, int length) {
        this.b = buffer;
        this.size = length;
    }

    public RTPPacket(int size) {
        this.size = size;
        this.b = new byte[size];
        this.b[0] = 0;
        this.b[1] = 0;
    }

    public byte[] getBuffer() {
        return this.b;
    }

    public int getSize() {
        return this.size;
    }

    public int getVersion() {
        return this.b[0] >> 6 & 3;
    }

    public void setVersion(int version) {
        this.b[0] = (byte)(this.b[0] & 0x3F | version << 6);
    }

    public void setExtension(boolean e) {
        this.b[0] = e ? (byte)(this.b[0] | 0x10) : (byte)(this.b[0] & 0xEF);
    }

    public boolean getExtension() {
        return (this.b[0] & 0x10) != 0;
    }

    public void setMarker(boolean m) {
        this.b[1] = m ? (byte)(this.b[1] | 0x80) : (byte)(this.b[1] & 0x7F);
    }

    public boolean getMarker() {
        return (this.b[1] & 0x80) != 0;
    }

    public void setPayloadType(int t) {
        this.b[1] = (byte)(this.b[1] & 0x80);
        this.b[1] = (byte)(this.b[1] | t);
    }

    public int getPayloadType() {
        return this.b[1] & 0x7F;
    }

    public void setSequenceNumber(int n) {
        this.b[2] = (byte)(n >> 8 & 0xFF);
        this.b[3] = (byte)(n & 0xFF);
    }

    public int getSequenceNumber() {
        return this.b[2] << 8 & 0xFF00 | this.b[3] & 0xFF;
    }

    public void setTimestamp(long n) {
        this.b[4] = (byte)(n >> 24 & 0xFFL);
        this.b[5] = (byte)(n >> 16 & 0xFFL);
        this.b[6] = (byte)(n >> 8 & 0xFFL);
        this.b[7] = (byte)(n & 0xFFL);
    }

    public long getTimestamp() {
        return (long)(this.b[4] << 24 | this.b[5] << 16 & 0xFF0000 | this.b[6] << 8 & 0xFF00 | this.b[7] & 0xFF) & 0xFFFFFFFFL;
    }

    public void setSyncSource(int n) {
        this.b[8] = (byte)(n >> 24 & 0xFF);
        this.b[9] = (byte)(n >> 16 & 0xFF);
        this.b[10] = (byte)(n >> 8 & 0xFF);
        this.b[11] = (byte)(n & 0xFF);
    }

    public int getSyncSource() {
        return this.b[8] << 24 | this.b[9] << 16 & 0xFF0000 | this.b[10] << 8 & 0xFF00 | this.b[11] & 0xFF;
    }

    public int getPaddingSize() {
        if ((this.b[0] & 4) == 0) {
            return 0;
        }
        return this.b[this.size - 1];
    }

    public int getPayloadOffset() {
        if ((this.b[0] & 0x10) == 0) {
            return 12 + 4 * (this.b[0] & 0xF);
        }
        return 12 + 4 * (this.b[0] & 0xF) + 4 + 4 * this.getExtensionSize();
    }

    public int getExtensionSize() {
        if ((this.b[0] & 0x10) == 0) {
            return 0;
        }
        int extLenIndex = 12 + 4 * (this.b[0] & 0xF) + 2;
        return (this.b[extLenIndex] << 4 | this.b[extLenIndex + 1]) * 4;
    }

    public int getPayloadSize() {
        return this.size - this.getPayloadOffset();
    }

    public void setByte(int pos, byte data) {
        this.b[this.getPayloadOffset() + pos] = data;
    }

    public byte getByte(int pos) {
        return this.b[this.getPayloadOffset() + pos];
    }

    public void append(byte[] data, int len) {
        if (this.b.length >= this.size + len) {
            System.arraycopy(data, 0, this.b, this.size, len);
        } else {
            byte[] newBuffer = new byte[this.size + len];
            System.arraycopy(this.b, 0, newBuffer, 0, this.size);
            System.arraycopy(data, 0, newBuffer, this.size, len);
            this.b = newBuffer;
        }
        this.size += len;
    }

    public byte[] shrink(int len) {
        this.size -= len;
        byte[] b0 = new byte[len];
        System.arraycopy(this.b, this.size, b0, 0, len);
        byte[] newBuffer = new byte[this.size];
        System.arraycopy(this.b, 0, newBuffer, 0, this.size);
        this.b = newBuffer;
        return b0;
    }

    public void setSize(int s) {
        this.size = s;
    }
}

