/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.rtp;

import com.smile.telephony.rtp.RTPPacket;
import com.smile.telephony.rtp.SRTPContext;
import java.lang.invoke.CallSite;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import smile.util.Utils;

public class SRTP {
    public static final String AES_CM_128_HMAC_SHA1_80 = "AES_CM_128_HMAC_SHA1_80";
    public static final String AES_CM_128_HMAC_SHA1_32 = "AES_CM_128_HMAC_SHA1_32";
    public static final String F8_128_HMAC_SHA1_80 = "F8_128_HMAC_SHA1_80";
    public static final String[] CAPABILITIES = new String[]{"AES_CM_128_HMAC_SHA1_80", "AES_CM_128_HMAC_SHA1_32", "F8_128_HMAC_SHA1_80"};
    public static final int AESCM_ENCRYPTION = 1;
    public static final int AESF8_ENCRYPTION = 2;
    public static final int HMACSHA1_AUTHENTICATION = 1;
    private int encType = 1;
    private int encKeyLength = 16;
    private int authType = 1;
    private int authKeyLength = 20;
    private int authTagLength = 10;
    private int saltKeyLength = 14;
    private byte[] masterKey;
    private byte[] masterSalt;
    private long deriveRate = 0L;
    private int mkilen = 0;
    private Hashtable contexts = new Hashtable();
    private String key;

    public static Vector getCapabilities() {
        Vector<CallSite> v = new Vector<CallSite>();
        String key1 = Utils.generateBase64CryptoKey(240);
        v.add((CallSite)((Object)("a=crypto:1 AES_CM_128_HMAC_SHA1_80 inline:" + key1)));
        String key2 = Utils.generateBase64CryptoKey(240);
        v.add((CallSite)((Object)("a=crypto:2 AES_CM_128_HMAC_SHA1_32 inline:" + key2)));
        return v;
    }

    public SRTP(String str) throws Exception {
        this.key = str;
        StringTokenizer stz = new StringTokenizer(str, " ");
        stz.nextToken();
        String suite = stz.nextToken();
        if (suite.equals(F8_128_HMAC_SHA1_80)) {
            this.encType = 2;
        } else if (suite.equals(AES_CM_128_HMAC_SHA1_32)) {
            this.authTagLength = 4;
        }
        String key = stz.nextToken();
        key = key.substring(7);
        int n = key.indexOf(124);
        String opt = null;
        if (n != -1) {
            opt = key.substring(n + 1);
            key = key.substring(0, n);
        }
        byte[] b = Utils.decodeBase64String(key);
        this.masterKey = new byte[16];
        System.arraycopy(b, 0, this.masterKey, 0, 16);
        this.masterSalt = new byte[14];
        System.arraycopy(b, 16, this.masterSalt, 0, 14);
        if (opt != null && (n = opt.indexOf(58)) != -1) {
            if ((n = (opt = opt.substring(n + 1)).indexOf(124)) != -1) {
                opt = opt.substring(0, n);
            }
            this.mkilen = Integer.parseInt(opt);
        }
    }

    public String getKey() {
        return this.key;
    }

    public SRTP(byte[] key) {
        this.masterKey = new byte[16];
        System.arraycopy(key, 0, this.masterKey, 0, 16);
        this.masterSalt = new byte[14];
        System.arraycopy(key, 16, this.masterSalt, 0, 14);
    }

    public SRTP(byte[] masterKey, byte[] masterSalt) {
        this.masterKey = masterKey;
        this.masterSalt = masterSalt;
    }

    public int getMKILength() {
        return this.mkilen;
    }

    public int getAuthKeyLength() {
        return this.authKeyLength;
    }

    public void setAuthKeyLength(int authKeyLength) {
        this.authKeyLength = authKeyLength;
    }

    public int getAuthTagLength() {
        return this.authTagLength;
    }

    public void setAuthTagLength(int authTagLength) {
        this.authTagLength = authTagLength;
    }

    public int getAuthType() {
        return this.authType;
    }

    public void setAuthType(int authType) {
        this.authType = authType;
    }

    public int getEncKeyLength() {
        return this.encKeyLength;
    }

    public void setEncKeyLength(int encKeyLength) {
        this.encKeyLength = encKeyLength;
    }

    public int getEncType() {
        return this.encType;
    }

    public void setEncType(int encType) {
        this.encType = encType;
    }

    public int getSaltKeyLength() {
        return this.saltKeyLength;
    }

    public void setSaltKeyLength(int keyLength) {
        this.saltKeyLength = keyLength;
    }

    public byte[] getMasterKey() {
        return this.masterKey;
    }

    public byte[] getMasterSalt() {
        return this.masterSalt;
    }

    public long getDeriveRate() {
        return this.deriveRate;
    }

    public void setDeriveRate(long deriveRate) {
        this.deriveRate = deriveRate;
    }

    public void encrypt(RTPPacket pkt) throws Exception {
        long ssrc = pkt.getSyncSource();
        SRTPContext context = (SRTPContext)this.contexts.get(ssrc);
        if (context == null) {
            context = new SRTPContext(this, ssrc);
            context.init(pkt.getSequenceNumber());
            this.contexts.put(ssrc, context);
        }
        context.encrypt(pkt);
    }

    public void decrypt(RTPPacket pkt) throws Exception {
        this.decrypt(pkt, true);
    }

    public void decrypt(RTPPacket pkt, boolean checkReplay) throws Exception {
        long ssrc = pkt.getSyncSource();
        SRTPContext context = (SRTPContext)this.contexts.get(ssrc);
        if (context == null) {
            context = new SRTPContext(this, ssrc);
            context.init(pkt.getSequenceNumber());
            this.contexts.put(ssrc, context);
        }
        context.decrypt(pkt, checkReplay);
    }
}

