/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip;

import com.smile.telephony.sip.SipEndpoint;
import com.smile.telephony.sip.address.Address;
import com.smile.telephony.sip.address.SipURI;
import com.smile.telephony.sip.header.AuthorizationHeader;
import com.smile.telephony.sip.header.CSeqHeader;
import com.smile.telephony.sip.header.CallIdHeader;
import com.smile.telephony.sip.header.ContactHeader;
import com.smile.telephony.sip.header.ExpiresHeader;
import com.smile.telephony.sip.header.FromHeader;
import com.smile.telephony.sip.header.Header;
import com.smile.telephony.sip.header.MaxForwardsHeader;
import com.smile.telephony.sip.header.ProxyAuthenticateHeader;
import com.smile.telephony.sip.header.RouteHeader;
import com.smile.telephony.sip.header.ToHeader;
import com.smile.telephony.sip.header.UserAgentHeader;
import com.smile.telephony.sip.header.ViaHeader;
import com.smile.telephony.sip.header.WWWAuthenticateHeader;
import com.smile.telephony.sip.message.Request;
import com.smile.telephony.sip.message.Response;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.ListIterator;
import smile.util.ResourceStore;

public class Registration
extends Thread {
    public static final int NOT_REGISTERED = 0;
    public static final int AUTHORIZATION = 1;
    public static final int REGISTERED = 2;
    public static final int LOST_REGISTRATION = 3;
    public static final int UNREGISTRATION = 4;
    public static final int REQUEST_TIMEOUT = 61000;
    private SipEndpoint sip;
    private String address;
    private String user;
    private String auth;
    private String pass;
    private String rkey;
    private int ttl;
    private String proxy;
    private String auth1;
    private String pass1;
    private SipURI uri;
    private SipURI toUri;
    private SipURI fromUri;
    private SipURI contactUri;
    private CallIdHeader callIdHeader;
    private UserAgentHeader uaHeader;
    private int status = 0;
    private int responseCode;
    private String errorMessage = "Timeout";
    private AuthorizationHeader authHeader;
    private int seqNumber;
    private String serviceAddress;
    private String routerAddress;
    private String serverAddress;
    private String registeredAddress;
    private boolean exitOnLost;
    private boolean cancelled;
    private boolean rereg;
    private boolean drop;
    private Request request = null;
    private long lastRegistrationTime;
    private String remoteSecret;

    public Registration(SipEndpoint sip, String address, String user, String auth, String pass, int ttl, String proxy, String auth1, String pass1, String router, String devinfo) throws Exception {
        this.sip = sip;
        this.address = address;
        this.user = user;
        this.auth = auth;
        this.pass = pass;
        this.ttl = ttl;
        this.proxy = proxy;
        this.auth1 = auth1;
        this.pass1 = pass1;
        this.routerAddress = router;
        this.serverAddress = address;
        this.rkey = auth + "@" + address;
        this.serviceAddress = address;
        this.setName("Registration-" + this.serviceAddress);
        this.uri = (SipURI)SipEndpoint.sipAddressFactory.createURI("sip:" + this.serviceAddress);
        if (!"UDP".equals(sip.getTransport())) {
            this.uri.setTransportParam(sip.getTransport());
        }
        this.toUri = SipEndpoint.sipAddressFactory.createSipURI(user, this.serviceAddress);
        this.fromUri = SipEndpoint.sipAddressFactory.createSipURI(user, this.serviceAddress);
        int n = this.serviceAddress.indexOf(58);
        if (n != -1) {
            this.serviceAddress = this.serviceAddress.substring(0, n);
        }
        this.callIdHeader = new CallIdHeader(sip.createCallId());
        this.seqNumber = sip.createSeqNumber();
        this.uaHeader = SipEndpoint.sipHeaderFactory.createUserAgentHeader(devinfo);
    }

    public void setAutoRetrieve(boolean mode) {
        this.exitOnLost = !mode;
    }

    public Request createRequest() throws Exception {
        ToHeader toHeader = SipEndpoint.sipHeaderFactory.createToHeader(SipEndpoint.sipAddressFactory.createAddress(this.toUri), null);
        FromHeader fromHeader = SipEndpoint.sipHeaderFactory.createFromHeader(SipEndpoint.sipAddressFactory.createAddress(this.fromUri), null);
        fromHeader.setTag(this.sip.createTag());
        String localAddress = "127.0.0.1";
        this.contactUri = SipEndpoint.sipAddressFactory.createSipURI(this.user, localAddress);
        if (this.sip.getListenerPort() != 5060) {
            this.contactUri.setPort(this.sip.getListenerPort());
        }
        if (!"UDP".equals(this.sip.getTransport())) {
            this.contactUri.setTransportParam(this.sip.getTransport());
        }
        ViaHeader viaHeader = SipEndpoint.sipHeaderFactory.createViaHeader(localAddress, this.sip.getListenerPort(), this.sip.getTransport(), this.sip.createBranchId());
        ArrayList<ViaHeader> via = new ArrayList<ViaHeader>();
        via.add(viaHeader);
        CSeqHeader cSeqHeader = SipEndpoint.sipHeaderFactory.createCSeqHeader(this.seqNumber++, "REGISTER");
        ExpiresHeader expiresHeader = SipEndpoint.sipHeaderFactory.createExpiresHeader(this.ttl);
        MaxForwardsHeader maxForward = SipEndpoint.sipHeaderFactory.createMaxForwardsHeader(70);
        Address contactAddress = SipEndpoint.sipAddressFactory.createAddress(this.user, this.contactUri);
        ContactHeader contactHeader = SipEndpoint.sipHeaderFactory.createContactHeader(contactAddress);
        Request request = new Request(this.uri, "REGISTER", this.callIdHeader, cSeqHeader, fromHeader, toHeader, via, maxForward);
        request.addHeader(contactHeader);
        request.addHeader(this.uaHeader);
        request.addHeader(expiresHeader);
        request.addHeader(SipEndpoint.sipHeaderFactory.createAllowHeader("INVITE, ACK, OPTIONS, CANCEL, BYE, UPDATE, REFER, NOTIFY, INFO, SUBSCRIBE, MESSAGE"));
        if (this.proxy != null && this.proxy.length() > 0) {
            int n = this.proxy.indexOf(64);
            String paddr = n == -1 ? this.proxy : this.proxy.substring(n + 1);
            Address routeAddress = SipEndpoint.sipAddressFactory.createAddress("sip:" + paddr + ";transport=" + this.sip.getTransport());
            RouteHeader routeHeader = SipEndpoint.sipHeaderFactory.createRouteHeader(routeAddress);
            request.addHeader(routeHeader);
        }
        this.sip.addOutboundRouteHeaders(request);
        return request;
    }

    public Request getRequest() {
        return this.request;
    }

    public int getRegistrationResult() {
        try {
            this.request = this.createRequest();
            if ("WSS".equals(this.sip.getTransport())) {
                this.authHeader = SipEndpoint.sipHeaderFactory.createAuthorizationHeader("Basic");
                this.authHeader.setUsername(this.auth);
                this.authHeader.setPassword(this.pass);
                this.request.addHeader(this.authHeader);
            }
            Thread t = new Thread(){

                @Override
                public void run() {
                    ResourceStore.toLog(Registration.this.hashCode() + " sendRequest");
                    try {
                        Registration.this.sip.sendRequest(Registration.this.request);
                    }
                    catch (Exception x) {
                        ResourceStore.error(Registration.this.hashCode() + " sendRequest", x);
                        Registration.this.processError(x.getMessage());
                    }
                }
            };
            t.setPriority(10);
            t.start();
            this.waitForEvent(61000L);
            if (t.isAlive()) {
                t.interrupt();
            }
        }
        catch (Throwable e) {
            this.errorMessage = e.getMessage();
            ResourceStore.error("Registration Error: ", e);
        }
        return this.responseCode;
    }

    private synchronized void waitForEvent(long time) {
        if (!this.cancelled) {
            try {
                this.wait(time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void processError(String err) {
        this.errorMessage = err;
        this.notifyAll();
    }

    public synchronized void processTimeout() {
        this.errorMessage = "Request Timeout";
        this.notifyAll();
    }

    public synchronized void processResponse(Response response) {
        this.errorMessage = response.getReasonPhrase();
        this.responseCode = response.getStatusCode();
        ResourceStore.toLog(this.hashCode() + " processResponse responseCode=" + this.responseCode + " status=" + this.status);
        if (this.responseCode == 200) {
            if (this.status == 4) {
                this.sip.onRegistrationLost(null);
            } else {
                ContactHeader ch = null;
                ListIterator list = response.getHeaders("Contact");
                while (list.hasNext()) {
                    ContactHeader c = (ContactHeader)list.next();
                    if (!this.contactUri.equals(c.getAddress().getURI())) continue;
                    ch = c;
                    break;
                }
                if (this.status != 2) {
                    Header header;
                    this.registeredAddress = this.serverAddress;
                    int n = this.serverAddress.indexOf(58);
                    if (n != -1) {
                        this.registeredAddress = this.serverAddress.substring(0, n);
                    }
                    try {
                        this.registeredAddress = InetAddress.getByName(this.registeredAddress).getHostAddress();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.sip.addRegistrationAddress(this.registeredAddress, this);
                    if (ch == null) {
                        list = response.getHeaders("Contact");
                        while (list.hasNext()) {
                            String usr;
                            ContactHeader c = (ContactHeader)list.next();
                            SipURI sipUri = (SipURI)c.getAddress().getURI();
                            if (!this.contactUri.getHost().equals(sipUri.getHost()) || this.contactUri.getPort() != sipUri.getPort() || (usr = sipUri.getUser()) == null) continue;
                            this.user = usr;
                            this.toUri.setUser(this.user);
                            this.fromUri.setUser(this.user);
                            this.contactUri.setUser(this.user);
                            ch = c;
                            break;
                        }
                    }
                    if ((header = response.getHeader("Secret")) != null) {
                        this.remoteSecret = header.getValue();
                    }
                }
                if (this.status == 0 || this.status == 1 || this.status == 3) {
                    if (ch != null && ch.getExpires() > 0) {
                        this.ttl = ch.getExpires();
                    } else {
                        ExpiresHeader eh = (ExpiresHeader)response.getHeader("Expires");
                        if (eh != null && eh.getExpires() > 0) {
                            this.ttl = eh.getExpires();
                        }
                    }
                    if (!this.rereg) {
                        this.sip.addRegistration(this.rkey, this);
                    }
                }
                this.status = 2;
                this.lastRegistrationTime = System.currentTimeMillis();
            }
            this.notifyAll();
        } else if (this.responseCode == 401 || this.responseCode == 407) {
            this.authHeader = null;
            switch (this.status) {
                case 0: {
                    if (this.sendAuthorization(response)) {
                        this.status = 1;
                        return;
                    }
                }
                case 1: {
                    this.notify();
                    return;
                }
                case 2: {
                    this.status = 3;
                    this.rereg = true;
                }
                case 3: 
                case 4: {
                    this.sendAuthorization(response);
                }
            }
        } else if (this.responseCode == 403) {
            this.notifyAll();
        } else if (this.responseCode == 301 || this.responseCode == 302) {
            ContactHeader ch = (ContactHeader)response.getHeader("Contact");
            if (ch == null) {
                return;
            }
            SipURI sipUri = (SipURI)ch.getAddress().getURI();
            String host = sipUri.getHost();
            this.user = sipUri.getUser();
            int port = sipUri.getPort();
            try {
                this.uri.setHost(host);
                if (port != -1) {
                    this.uri.setPort(port);
                }
                if (!"UDP".equals(this.sip.getTransport())) {
                    this.uri.setTransportParam(this.sip.getTransport());
                }
                if (this.user != null) {
                    this.toUri.setUser(this.user);
                    this.fromUri.setUser(this.user);
                    this.contactUri.setUser(this.user);
                }
                Request request = this.createRequest();
                this.sip.sendRequest(request);
                this.serverAddress = host;
                if (port != -1) {
                    this.serverAddress = this.serverAddress + ":" + port;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.responseCode != 100) {
            if (this.status == 0 || this.status == 1) {
                this.notifyAll();
            } else if (this.status == 2) {
                this.status = 3;
                this.notifyAll();
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String getCallId() {
        return this.callIdHeader.getCallId();
    }

    public String getKey() {
        return this.rkey;
    }

    public String getRegisteredAddress() {
        return this.registeredAddress;
    }

    public SipURI getURI() {
        return this.uri;
    }

    public SipURI getFromURI() {
        return this.fromUri;
    }

    public SipURI getContactURI() {
        return this.contactUri;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getServiceAddress() {
        return this.address;
    }

    public String getAuthName() {
        return this.auth;
    }

    public String getRegisteredUser() {
        return this.user;
    }

    public String getUserLogin() {
        return this.auth;
    }

    public String getUserPassword() {
        return this.pass;
    }

    public String getProxy() {
        return this.proxy;
    }

    public String getErorMessage() {
        return this.errorMessage;
    }

    public void setTTL(int ttl) {
        this.ttl = ttl;
    }

    public String getRemoteSecret() {
        return this.remoteSecret;
    }

    public void setUserPassword(String pass) {
        this.pass = pass;
        ResourceStore.syslog(this.hashCode() + " setUserPassword " + pass);
    }

    public AuthorizationHeader getAuthorizationHeader() {
        return this.authHeader;
    }

    public void setAuthorizationHeader(AuthorizationHeader header) {
        this.authHeader = header;
    }

    public void setToUser(String username) throws Exception {
        this.toUri.setUser(username);
    }

    public synchronized void cancelRegistration(boolean unreg) {
        this.lastRegistrationTime = 0L;
        this.cancelled = !unreg;
        this.ttl = 0;
        this.status = 4;
        if (this.cancelled && this.request != null) {
            try {
                this.sip.closeConnection(this.request);
            }
            catch (Exception e) {
                ResourceStore.error("closeConnection", e);
            }
            this.request = null;
        }
        this.notifyAll();
        ResourceStore.syslog(this.hashCode() + " cancelRegistration rkey=" + this.rkey + " cancelled=" + this.cancelled + " exitOnLost=" + this.exitOnLost);
    }

    public void cancel() {
        this.drop = true;
    }

    public boolean isRunning() {
        return this.isAlive() && this.ttl > 0;
    }

    public long getLastRegistrationTime() {
        return this.lastRegistrationTime;
    }

    @Override
    public void run() {
        String key = this.rkey + "/" + this.hashCode();
        ResourceStore.syslog(key + " registration thread started. ttl=" + this.ttl);
        this.sip.onRegistrationFound(key);
        boolean reglost = false;
        long recovertime = Math.max(60 - this.ttl, 5) * 1000;
        while (this.ttl > 0) {
            try {
                if (!reglost && this.responseCode != 0) {
                    long nextregtime = System.currentTimeMillis() + (long)(Math.max(this.ttl - 10, 1) * 1000);
                    do {
                        Registration.sleep(100L);
                    } while (this.ttl > 0 && nextregtime > System.currentTimeMillis());
                }
                if (this.ttl == 0 || this.drop) break;
                this.rereg = false;
                this.responseCode = 0;
                long waittime = Math.min(this.ttl, 60) * 1000;
                this.request = this.createRequest();
                if (this.ttl == 0 || this.drop) break;
                ResourceStore.syslog(key + " registration thread sendRequest");
                this.sip.sendRequest(this.request);
                this.waitForEvent(waittime);
                if (this.ttl == 0) break;
                if (this.responseCode != 200) {
                    if (!reglost) {
                        ResourceStore.syslog("Registration lost - " + key + "  code=" + this.responseCode);
                        reglost = true;
                        if (this.exitOnLost) {
                            this.cancelled = true;
                            break;
                        }
                        this.sip.onRegistrationLost(key);
                        this.callIdHeader = this.sip.getNewRegistrationId(this);
                    }
                    if (this.responseCode == 403) {
                        this.cancelled = true;
                        break;
                    }
                    this.waitForEvent(recovertime);
                    continue;
                }
                if (reglost) {
                    reglost = false;
                    ResourceStore.syslog("Registered " + key + " id=" + this.getCallId());
                    this.sip.onRegistrationFound(key);
                    continue;
                }
                if (!this.rereg) continue;
                ResourceStore.syslog("Reregistered " + key + " id=" + this.getCallId());
                this.sip.onRegistrationFound(key);
            }
            catch (Exception e) {
                ResourceStore.error("Registration lost - " + key + "  ", e);
                reglost = true;
                if (this.exitOnLost) {
                    this.cancelled = true;
                    break;
                }
                this.sip.onRegistrationLost(key);
                this.callIdHeader = this.sip.getNewRegistrationId(this);
                this.waitForEvent(recovertime);
            }
        }
        ResourceStore.syslog(key + " registration thread drop=" + this.drop + " cancelled=" + this.cancelled);
        if (!this.drop) {
            if (!this.cancelled) {
                try {
                    this.request = this.createRequest();
                    this.sip.sendRequest(this.request);
                    this.waitForEvent(5000L);
                }
                catch (Exception e) {
                    ResourceStore.error("registration thread", e);
                }
            }
            if (this.sip.removeRegistration(this)) {
                if (this.request != null) {
                    try {
                        this.sip.closeConnection(this.request);
                    }
                    catch (Exception e) {
                        ResourceStore.error("closeConnection", e);
                    }
                }
                this.sip.onRegistrationLost(this.rkey + "/" + this.hashCode());
            }
        }
        ResourceStore.syslog(key + " registration thread ended");
    }

    private boolean sendAuthorization(Response response) {
        if (this.ttl != this.request.getExpires().getExpires()) {
            return false;
        }
        boolean isProxy = response.getStatusCode() == 407;
        WWWAuthenticateHeader wwwauth = isProxy ? (ProxyAuthenticateHeader)response.getHeader("Proxy-Authenticate") : (WWWAuthenticateHeader)response.getHeader("WWW-Authenticate");
        if (wwwauth == null) {
            return false;
        }
        try {
            String password;
            String login;
            this.request = this.createRequest();
            String string = login = isProxy && this.auth1 != null && this.auth1.length() > 0 ? this.auth1 : this.auth;
            if (login == null || login.length() == 0) {
                login = "anonymous";
            }
            String string2 = password = isProxy && this.auth1 != null && this.auth1.length() > 0 ? this.pass1 : this.pass;
            if (password == null) {
                password = "";
            }
            this.sip.addAuthorizationHeader(this.request, wwwauth, login, password);
            this.authHeader = (AuthorizationHeader)this.request.getHeader("Authorization");
            this.sip.sendRequest(this.request);
            return true;
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            return false;
        }
    }
}

