/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip;

import com.smile.telephony.rtp.RTP;
import com.smile.telephony.video.VideoCapability;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SdpInfo {
    public static final int SENDRECV = 0;
    public static final int SENDONLY = 1;
    public static final int RECVONLY = 2;
    public static final String KEY_MIN_PTIME = "minptime";
    public static final String KEY_MAX_PTIME = "maxptime";
    public static final String KEY_MAX_BITRATE = "maxaveragebitrate";
    private String version = "0";
    private String sessionName;
    private String sessionId;
    private String sessionVersion;
    private String originAddress;
    private String originName;
    private String phone;
    private String sessionInfo;
    private long startTime = 0L;
    private long stopTime = 0L;
    private String host;
    private int port = 0;
    private int bandwidth;
    private Vector capabilities;
    private HashMap capnumbers;
    private HashMap parameters;
    private boolean silenceSupp;
    private boolean g729b;
    private boolean g723a;
    private boolean faxTransferredTCF;
    private int amode = 0;
    private int dmode = -1;
    private int ptime = 0;
    private boolean dtmfrelay;
    private int dtmfPayloadType = RTP.RFC2833;
    private Vector crypto;
    private Vector vcrypto;
    private Vector keyInfo;
    private Vector vcapabilities;
    private int vport = 0;
    private int vmode = -1;
    private String vprof;
    private int natType = 0;

    public SdpInfo(String sname, String username, String address) {
        this.parameters = new HashMap();
        this.capnumbers = new HashMap();
        this.sessionName = sname;
        this.originName = username;
        this.originAddress = address;
        this.sessionId = String.valueOf(System.currentTimeMillis() / 1000L);
        this.sessionVersion = "1";
    }

    public SdpInfo(SdpInfo info) {
        this.parameters = new HashMap();
        this.capnumbers = new HashMap();
        this.sessionName = info.sessionName;
        this.originName = info.originName;
        this.originAddress = info.originAddress;
        this.sessionId = info.sessionId;
        this.sessionVersion = String.valueOf(Integer.parseInt(info.sessionVersion) + 1);
    }

    public SdpInfo(byte[] content) throws Exception {
        String line;
        this.capabilities = new Vector();
        this.capnumbers = new HashMap();
        this.parameters = new HashMap();
        LineNumberReader lnr = new LineNumberReader(new StringReader(new String(content)));
        while ((line = lnr.readLine()) != null) {
            if ((line = line.trim()).startsWith("v=")) {
                this.version = line.substring(2);
                continue;
            }
            if (line.startsWith("s=")) {
                this.sessionName = line.substring(2);
                continue;
            }
            if (line.startsWith("b=")) {
                try {
                    this.bandwidth = Integer.parseInt(line.substring(5));
                }
                catch (Exception exception) {}
                continue;
            }
            if (line.startsWith("p=")) {
                this.phone = line.substring(2);
                continue;
            }
            if (line.startsWith("i=")) {
                this.sessionInfo = line.substring(2);
                continue;
            }
            if (line.startsWith("o=")) {
                int n = (line = line.substring(2).trim()).indexOf(" ");
                if (n == -1) {
                    this.originName = line.substring(0);
                    continue;
                }
                this.originName = line.substring(0, n);
                int m = line.indexOf(" ", n + 1);
                if (m == -1) {
                    this.sessionId = line.substring(n + 1);
                    continue;
                }
                this.sessionId = line.substring(n + 1, m);
                n = line.indexOf(" ", m + 1);
                if (n == -1) continue;
                this.sessionVersion = line.substring(m + 1, n);
                this.originAddress = line.substring(n + 1);
                continue;
            }
            if (line.startsWith("t=")) {
                line = line.substring(2).trim();
                int n = line.indexOf(" ");
                this.startTime = Long.parseLong(line.substring(0, n));
                this.stopTime = Long.parseLong(line.substring(n + 1));
                continue;
            }
            if (line.startsWith("c=")) {
                line = line.trim();
                if ((line = line.substring(line.lastIndexOf(" ") + 1)).equals("0.0.0.0")) continue;
                this.host = line;
                continue;
            }
            if (line.startsWith("m=")) {
                this.parseMedia(line, lnr);
                continue;
            }
            if (line.startsWith("a=key-mgmt:")) {
                line = line.substring(11);
                this.addKeyInfo(line);
                continue;
            }
            if (!line.startsWith("a=X-nat:")) continue;
            int n = (line = line.substring(8)).indexOf(" ");
            if (n != -1) {
                line = line.substring(0, n);
            }
            try {
                this.natType = Integer.parseInt(line);
            }
            catch (Exception exception) {}
        }
    }

    private void parseMedia(String line, LineNumberReader lnr) throws Exception {
        if (line.startsWith("m=audio")) {
            this.parseAudio(line, lnr);
        } else if (line.startsWith("m=image")) {
            this.parseImage(line, lnr);
        } else if (line.startsWith("m=video")) {
            this.parseVideo(line, lnr);
        }
    }

    private void parseAudio(String line, LineNumberReader lnr) throws Exception {
        StringTokenizer stz = new StringTokenizer(line, " ");
        stz.nextToken();
        this.port = Integer.parseInt(stz.nextToken());
        if (stz.hasMoreTokens()) {
            stz.nextToken();
        }
        while (stz.hasMoreTokens()) {
            String codecid = stz.nextToken();
            if (codecid.equals("97") || codecid.equals("98")) continue;
            this.capabilities.addElement(codecid);
        }
        this.amode = 0;
        Hashtable<String, String> rtpmap = new Hashtable<String, String>();
        while ((line = lnr.readLine()) != null) {
            if ((line = line.trim()).startsWith("a=silenceSupp:")) {
                line = line.substring(14);
                this.silenceSupp = line.startsWith("on");
                continue;
            }
            if (line.startsWith("a=sendonly")) {
                this.amode = 1;
                continue;
            }
            if (line.startsWith("a=recvonly")) {
                this.amode = 2;
                continue;
            }
            if (line.startsWith("a=ptime:")) {
                line = line.substring(8).trim();
                try {
                    this.ptime = Integer.parseInt(line);
                }
                catch (Exception exception) {}
                continue;
            }
            if (line.startsWith("a=fmtp:4")) {
                int n = (line = line.substring(8)).indexOf("annexa=");
                if (n == -1) continue;
                this.g723a = line.charAt(n + 7) == 'y';
                continue;
            }
            if (line.startsWith("a=fmtp:18")) {
                int n = (line = line.substring(9)).indexOf("annexb=");
                if (n == -1) continue;
                this.g729b = line.charAt(n + 7) == 'y';
                continue;
            }
            if (line.startsWith("a=fmtp:")) {
                int n = (line = line.substring(7)).indexOf(" ");
                if (n == -1) continue;
                HashMap<String, String> prms = new HashMap<String, String>();
                this.parameters.put(line.substring(0, n), prms);
                StringTokenizer stz1 = new StringTokenizer(line.substring(n + 1), ";");
                while (stz1.hasMoreTokens()) {
                    String s = stz1.nextToken().trim();
                    String v = null;
                    n = s.indexOf(61);
                    if (n != -1) {
                        v = s.substring(n + 1);
                        s = s.substring(0, n);
                    }
                    prms.put(s, v);
                }
                continue;
            }
            if (line.startsWith("a=rtpmap:")) {
                String str = line.substring(9);
                int n = str.indexOf(32);
                if (n <= 0) continue;
                rtpmap.put(str.substring(0, n), str.substring(n + 1).trim());
                continue;
            }
            if (line.startsWith("a=crypto:")) {
                if (this.crypto == null) {
                    this.crypto = new Vector();
                }
                this.crypto.add(line);
                continue;
            }
            if (line.startsWith("m=")) {
                this.parseMedia(line, lnr);
                break;
            }
            if (!line.startsWith("c=") || this.host != null || (line = line.substring(line.lastIndexOf(" ") + 1)).equals("0.0.0.0")) continue;
            this.host = line;
        }
        Enumeration en = rtpmap.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = (String)rtpmap.get(key);
            String pt = SdpInfo.getCodecPayloadType(value);
            if (pt == null || key.equals(pt)) continue;
            int i = this.capabilities.indexOf(key);
            if (i != -1) {
                this.capabilities.set(i, pt);
                Object p = this.parameters.remove(key);
                if (p == null) continue;
                this.parameters.put(pt, p);
                this.capnumbers.put(pt, key);
                continue;
            }
            this.capabilities.add(pt);
        }
    }

    private void parseImage(String line, LineNumberReader lnr) throws Exception {
        StringTokenizer stz = new StringTokenizer(line, " ");
        stz.nextToken();
        this.port = Integer.parseInt(stz.nextToken());
        String cap = stz.nextToken();
        if (stz.hasMoreTokens()) {
            cap = stz.nextToken();
        }
        this.capabilities.addElement(cap);
        this.dmode = 0;
        while ((line = lnr.readLine()) != null) {
            if ((line = line.trim()).startsWith("a=T38FaxRateManagement:")) {
                line = line.substring(23);
                this.faxTransferredTCF = line.startsWith("transferredTCF");
                continue;
            }
            if (line.startsWith("a=sendonly")) {
                this.dmode = 1;
                continue;
            }
            if (line.startsWith("a=recvonly")) {
                this.dmode = 2;
                continue;
            }
            if (line.startsWith("a=rtpmap:")) continue;
            if (line.startsWith("a=crypto:")) {
                if (this.crypto == null) {
                    this.crypto = new Vector();
                }
                this.crypto.add(line);
                continue;
            }
            if (!line.startsWith("m=")) continue;
            this.parseMedia(line, lnr);
            break;
        }
    }

    private void parseVideo(String line, LineNumberReader lnr) throws Exception {
        StringTokenizer stz = new StringTokenizer(line, " ");
        stz.nextToken();
        this.vcapabilities = new Vector();
        this.vport = Integer.parseInt(stz.nextToken());
        if (this.vport == 0) {
            return;
        }
        this.vprof = stz.nextToken();
        while (stz.hasMoreTokens()) {
            int rtptype = Integer.parseInt(stz.nextToken());
            VideoCapability vc = new VideoCapability(rtptype);
            if (rtptype == 34) {
                vc.setCodec("H263");
            }
            this.vcapabilities.addElement(vc);
        }
        this.vmode = 0;
        block5: while ((line = lnr.readLine()) != null) {
            VideoCapability vc;
            Enumeration en;
            if ((line = line.trim()).startsWith("a=inactive")) {
                return;
            }
            if (line.startsWith("a=rtpmap:")) {
                line = line.substring(9);
                stz = new StringTokenizer(line, " ");
                int rtptype = Integer.parseInt(stz.nextToken());
                Enumeration en2 = this.vcapabilities.elements();
                while (en2.hasMoreElements()) {
                    VideoCapability vc2 = (VideoCapability)en2.nextElement();
                    if (rtptype != vc2.getRTPType()) continue;
                    String codec = stz.nextToken();
                    int n = codec.indexOf(47);
                    if (n != -1) {
                        try {
                            vc2.setClockRate(Integer.parseInt(codec.substring(n + 1)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        codec = codec.substring(0, n);
                    }
                    vc2.setCodec(codec);
                    continue block5;
                }
                continue;
            }
            if (line.startsWith("a=fmtp:")) {
                String rtptype = line = line.substring(7).trim();
                int i = line.indexOf(32);
                if (i != -1) {
                    rtptype = line.substring(0, i);
                    line = line.substring(i + 1);
                }
                en = this.vcapabilities.elements();
                while (en.hasMoreElements()) {
                    vc = (VideoCapability)en.nextElement();
                    if (!rtptype.equals(String.valueOf(vc.getRTPType()))) continue;
                    stz = new StringTokenizer(line, ";");
                    while (stz.hasMoreTokens()) {
                        String prm = stz.nextToken().trim();
                        String value = "";
                        int n = prm.indexOf(61);
                        if (n != -1) {
                            value = prm.substring(n + 1);
                            prm = prm.substring(0, n);
                        }
                        vc.setParameter(prm, value);
                    }
                    continue block5;
                }
                continue;
            }
            if (line.startsWith("a=rtcp-fb:")) {
                int n = (line = line.substring(10)).indexOf(32);
                if (n == -1) continue;
                String c = line.substring(0, n);
                en = this.vcapabilities.elements();
                while (en.hasMoreElements()) {
                    vc = (VideoCapability)en.nextElement();
                    if (!c.equals("*") && !c.equals(String.valueOf(vc.getRTPType()))) continue;
                    vc.addCapability(line.substring(n).trim());
                }
                continue;
            }
            if (line.startsWith("a=sendonly")) {
                this.vmode = 1;
                continue;
            }
            if (line.startsWith("a=recvonly")) {
                this.vmode = 2;
                continue;
            }
            if (line.startsWith("b=")) {
                try {
                    this.bandwidth = Integer.parseInt(line.substring(5));
                }
                catch (Exception n) {}
                continue;
            }
            if (line.startsWith("a=crypto:")) {
                if (this.vcrypto == null) {
                    this.vcrypto = new Vector();
                }
                this.vcrypto.add(line);
                continue;
            }
            if (!line.startsWith("m=")) continue;
            this.parseMedia(line, lnr);
            break;
        }
        for (int i = this.vcapabilities.size() - 1; i >= 0; --i) {
            VideoCapability vc = (VideoCapability)this.vcapabilities.elementAt(i);
            if (vc.getCodec() != null) continue;
            this.vcapabilities.removeElementAt(i);
        }
    }

    public byte[] encode() {
        StringWriter swr = new StringWriter();
        swr.write("v=" + this.version + "\r\n");
        swr.write("o=" + this.originName + " " + this.sessionId + " " + this.sessionVersion + " " + this.originAddress + "\r\n");
        swr.write("s=" + this.sessionName + "\r\n");
        if (this.sessionInfo != null) {
            swr.write("i=" + this.sessionInfo + "\r\n");
        }
        swr.write("c=IN IP4 " + this.host + "\r\n");
        swr.write("t=" + this.startTime + " " + this.stopTime + "\r\n");
        if (this.keyInfo != null) {
            Enumeration en = this.keyInfo.elements();
            while (en.hasMoreElements()) {
                swr.write("a=key-mgmt:" + (String)en.nextElement() + "\r\n");
            }
        }
        if (this.natType != 0) {
            swr.write("a=X-nat:" + this.natType);
        }
        Object media = "m=audio " + this.port + " RTP/" + (this.crypto == null ? "AVP" : "SAVP");
        boolean ssup = false;
        Vector<Object> attributes = new Vector<Object>();
        Enumeration en = this.capabilities.elements();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (key.equals("t38")) {
                swr.write("m=image " + this.port + " udptl t38\r\n");
                swr.write("a=T38FaxVersion:0\r\n");
                swr.write("a=T38MaxBitRate:14400\r\n");
                swr.write("a=T38FaxRateManagement:" + (this.faxTransferredTCF ? "transferredTCF" : "localTCF") + "\r\n");
                swr.write("a=T38FaxMaxBuffer:72\r\n");
                swr.write("a=T38FaxMaxDatagram:316\r\n");
                swr.write("a=T38FaxUdpEC:t38UDPRedundancy\r\n");
                return swr.toString().getBytes();
            }
            String cinfo = SdpInfo.getCodecInfo(key);
            HashMap prms = (HashMap)this.parameters.get(key);
            String k = (String)this.capnumbers.get(key);
            if (k != null) {
                key = k;
            }
            media = (String)media + " " + key;
            String attr = "a=rtpmap:" + key + " " + cinfo;
            attributes.addElement(attr);
            if (key.equals("18") && this.g729b) {
                attributes.addElement("a=fmtp:18 annexb=yes");
            } else if (key.equals("4") && this.g723a) {
                attributes.addElement("a=fmtp:4 annexa=yes");
            } else if (key.equals("0") || key.equals("8")) {
                ssup = true;
            }
            if (prms == null) continue;
            String fmtp = "a=fmtp:" + key;
            for (String p : prms.keySet()) {
                fmtp = fmtp + " " + p + "=" + prms.get(p) + ";";
            }
            attributes.addElement(fmtp);
        }
        if (this.dtmfrelay) {
            media = (String)media + " " + this.dtmfPayloadType;
            attributes.addElement("a=rtpmap:" + this.dtmfPayloadType + " telephone-event/8000\r\na=fmtp:" + this.dtmfPayloadType + " 0-15");
        }
        swr.write((String)media + "\r\n");
        en = attributes.elements();
        while (en.hasMoreElements()) {
            swr.write((String)en.nextElement() + "\r\n");
        }
        if (ssup && this.silenceSupp) {
            swr.write("a=silenceSupp:on - - - -\r\n");
        }
        if (this.ptime > 0) {
            swr.write("a=ptime:" + this.ptime + "\r\n");
        }
        if (this.amode == 0) {
            swr.write("a=sendrecv\r\n");
        } else if (this.amode == 2) {
            swr.write("a=recvonly\r\n");
        } else if (this.amode == 1) {
            swr.write("a=sendonly\r\n");
        }
        if (this.crypto != null) {
            en = this.crypto.elements();
            while (en.hasMoreElements()) {
                swr.write((String)en.nextElement() + "\r\n");
            }
        }
        if (this.vcapabilities != null) {
            media = "";
            Object rtpmap = "";
            Hashtable caps = new Hashtable();
            Enumeration<Object> en2 = this.vcapabilities.elements();
            while (en2.hasMoreElements()) {
                VideoCapability vcap = (VideoCapability)en2.nextElement();
                String codec = vcap.getCodec();
                media = (String)media + " " + vcap.getRTPType();
                rtpmap = (String)rtpmap + "a=rtpmap:" + vcap.getRTPType() + " " + codec + "/" + vcap.getClockRate() + "\r\n";
                Hashtable prms = vcap.getParameters();
                if (!prms.isEmpty()) {
                    rtpmap = (String)rtpmap + "a=fmtp:" + vcap.getRTPType();
                    Enumeration enp = prms.keys();
                    while (enp.hasMoreElements()) {
                        Object key = enp.nextElement();
                        rtpmap = (String)rtpmap + " " + key + "=" + prms.get(key) + ";";
                    }
                    if (((String)rtpmap).endsWith(";")) {
                        rtpmap = ((String)rtpmap).substring(0, ((String)rtpmap).length() - 1);
                    }
                    rtpmap = (String)rtpmap + "\r\n";
                }
                for (Object next : vcap.getCapabilities()) {
                    Vector<Integer> v = (Vector<Integer>)caps.get(next);
                    if (v == null) {
                        v = new Vector<Integer>();
                        caps.put(next, v);
                    }
                    v.add(vcap.getRTPType());
                }
            }
            if (((String)rtpmap).length() > 0) {
                media = "m=video " + this.vport + " RTP/" + (this.vcrypto == null ? "AVP" : "SAVP") + (String)media;
                swr.write((String)media + "\r\n");
                swr.write((String)rtpmap);
                if (this.vmode == 0) {
                    swr.write("a=sendrecv\r\n");
                } else if (this.vmode == 2) {
                    swr.write("a=recvonly\r\n");
                } else if (this.vmode == 1) {
                    swr.write("a=sendonly\r\n");
                }
                if (this.vcrypto != null) {
                    en2 = this.vcrypto.elements();
                    while (en2.hasMoreElements()) {
                        swr.write((String)en2.nextElement() + "\r\n");
                    }
                }
                en2 = caps.keys();
                while (en2.hasMoreElements()) {
                    Object next = en2.nextElement();
                    Vector v = (Vector)caps.get(next);
                    if (v.size() == this.vcapabilities.size()) {
                        swr.write("a=rtcp-fb:* " + next + "\r\n");
                        continue;
                    }
                    Enumeration enu = v.elements();
                    while (enu.hasMoreElements()) {
                        swr.write("a=rtcp-fb:" + enu.nextElement() + " " + next + "\r\n");
                    }
                }
            } else {
                swr.write("m=video 0 RTP/AVP 100\r\n");
            }
        }
        return swr.toString().getBytes();
    }

    public static String getCodecInfo(String number) {
        if (number.equals("0")) {
            return "PCMU/8000";
        }
        if (number.equals("4")) {
            return "G723/8000";
        }
        if (number.equals("8")) {
            return "PCMA/8000";
        }
        if (number.equals("18")) {
            return "G729/8000";
        }
        if (number.equals("110")) {
            return "opus/48000/2";
        }
        return "";
    }

    public static String getCodecPayloadType(String info) {
        if (info.equals("PCMU/8000")) {
            return "0";
        }
        if (info.equals("G723/8000")) {
            return "4";
        }
        if (info.equals("PCMA/8000")) {
            return "8";
        }
        if (info.equals("G729/8000")) {
            return "18";
        }
        if (info.startsWith("opus/48000")) {
            return "110";
        }
        return null;
    }

    public void setCapabilityPayloadType(String id, String payloadType) {
        this.capnumbers.put(id, payloadType);
    }

    public String getCapabilityPayloadType(String id) {
        String payloadType = (String)this.capnumbers.get(id);
        return payloadType != null ? payloadType : id;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getBandwidth() {
        return this.bandwidth;
    }

    public Vector getCapabilities() {
        return this.capabilities;
    }

    public int getDtmfPayloadType() {
        return this.dtmfPayloadType;
    }

    public boolean getSilenceSuppression(int c) {
        if (c == 0 || c == 8) {
            return this.silenceSupp;
        }
        if (c == 4) {
            return this.g723a;
        }
        if (c == 18) {
            return this.g729b;
        }
        return false;
    }

    public boolean getFaxTrasferredTCF() {
        return this.faxTransferredTCF;
    }

    public String getOriginName() {
        return this.originName;
    }

    public String getOriginAddress() {
        return this.originAddress;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getSessionVersion() {
        return this.sessionVersion;
    }

    public String getSessionInfo() {
        return this.sessionInfo;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public String getPhone() {
        return this.phone;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setBandwidth(int bandwidth) {
        this.bandwidth = bandwidth;
    }

    public void setNatType(int type) {
        this.natType = type;
    }

    public void setCapabilities(Vector capabilities) {
        this.capabilities = capabilities;
    }

    public void setDtmfPayloadType(int type) {
        this.dtmfPayloadType = type;
    }

    public void setOriginName(String name) {
        this.originName = name;
    }

    public void setOriginAddress(String addr) {
        this.originAddress = addr;
    }

    public void setSessionId(String sid) {
        this.sessionId = sid;
    }

    public void setSessionInfo(String info) {
        this.sessionInfo = info;
    }

    public void setSessionVersion(String ver) {
        this.sessionVersion = ver;
    }

    public void setSessionName(String sname) {
        this.sessionName = sname;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setTime(long time1, long time2) {
        this.startTime = time1;
        this.stopTime = time2;
    }

    public void setSilenceSuppression(int c, boolean s) {
        if (c == 0 || c == 8) {
            this.silenceSupp = s;
        } else if (c == 4) {
            this.g723a = s;
        } else if (c == 18) {
            this.g729b = s;
        }
    }

    public int getPacketTime() {
        return this.ptime;
    }

    public void setPacketTime(int p) {
        this.ptime = p;
    }

    public int getAudioMode() {
        return this.amode;
    }

    public void setAudioMode(int p) {
        this.amode = p;
    }

    public void setDtmfRelay(boolean s) {
        this.dtmfrelay = s;
    }

    public void setFaxTrasferredTCF(boolean s) {
        this.faxTransferredTCF = s;
    }

    public Vector getCrypto() {
        return this.crypto;
    }

    public void setCrypto(Vector v) {
        this.crypto = v;
    }

    public Vector getKeyInfo() {
        return this.keyInfo;
    }

    public void addKeyInfo(String k) {
        if (this.keyInfo == null) {
            this.keyInfo = new Vector();
        }
        this.keyInfo.add(k);
    }

    public Vector getVideoCapabilities() {
        return this.vcapabilities;
    }

    public void setVideoCapabilities(Vector c) {
        this.vcapabilities = c;
    }

    public Vector getVideoCrypto() {
        return this.vcrypto;
    }

    public void setVideoCrypto(Vector v) {
        this.vcrypto = v;
    }

    public int getVideoPort() {
        return this.vport;
    }

    public void setVideoPort(int p) {
        this.vport = p;
    }

    public int getVideoMode() {
        return this.vmode;
    }

    public void setVideoMode(int p) {
        this.vmode = p;
    }

    public String getVideoProfile() {
        return this.vprof;
    }

    public void setVideoProfile(String prof) {
        this.vprof = prof;
    }

    public HashMap getCodecParameters(String codecid) {
        return (HashMap)this.parameters.get(codecid);
    }

    public void setCodecParameters(String codecid, HashMap prms) {
        if (prms == null) {
            this.parameters.remove(codecid);
        } else {
            this.parameters.put(codecid, prms);
        }
    }

    public String getCodecParameter(String codecid, String prm) {
        HashMap prms = (HashMap)this.parameters.get(codecid);
        if (prms == null) {
            return null;
        }
        return (String)prms.get(prm);
    }

    public void setCodecParameter(String codecid, String prm, String value) {
        HashMap<String, String> prms = (HashMap<String, String>)this.parameters.get(codecid);
        if (prms == null) {
            prms = new HashMap<String, String>();
            this.parameters.put(codecid, prms);
        }
        prms.put(prm, value);
    }

    public String toString() {
        return this.sessionId + "/" + this.sessionVersion + " " + this.host + ":" + this.port + " v=" + this.vport + " vm=" + this.vmode;
    }
}

