/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip;

import com.smile.telephony.sip.SdpInfo;
import com.smile.telephony.sip.SipEndpoint;
import com.smile.telephony.sip.address.SipURI;
import com.smile.telephony.sip.address.TelURL;
import com.smile.telephony.sip.address.URI;
import com.smile.telephony.sip.header.AuthorizationHeader;
import com.smile.telephony.sip.header.CallInfoHeader;
import com.smile.telephony.sip.header.ContactHeader;
import com.smile.telephony.sip.header.FromHeader;
import com.smile.telephony.sip.header.Header;
import com.smile.telephony.sip.header.ServerHeader;
import com.smile.telephony.sip.header.ToHeader;
import com.smile.telephony.sip.header.UserAgentHeader;
import com.smile.telephony.sip.header.ViaHeader;
import com.smile.telephony.sip.message.Request;
import com.smile.telephony.sip.message.Response;
import com.smile.telephony.sip.stack.Transaction;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;

public class SipCall {
    public static final int INCOMING = 1;
    public static final int OUTGOING = 2;
    private Request request;
    private Transaction transaction;
    private URI remoteURI;
    private ToHeader toHeader;
    private FromHeader fromHeader;
    private ContactHeader contactHeader;
    private ViaHeader localViaHeader;
    private AuthorizationHeader auth;
    private String redirectionNumber;
    private String redirectionHost;
    private String redirectionReason;
    private String originalCalledUser;
    private String originalCalledHost;
    private String originalRedirectionReason;
    private String localName;
    private String localUser;
    private String localHost;
    private String remoteName;
    private String remoteUser;
    private String remoteHost;
    private String regKey;
    private String contactAddress;
    private int contactPort;
    private String receivedAddress;
    private String transport;
    private int receivedPort;
    private int remotePort;
    private String toUser;
    private String toHost;
    private String remoteLogin;
    private URI remoteSipAddress;
    private boolean remoteContactAddress;
    private String remoteTag;
    private String localTag;
    private int direction;
    private int seqNumber;
    private String user;
    private String pass;
    private String proxyLogin;
    private String proxyPassword;
    private UserAgentHeader uah;
    private ServerHeader ush;
    private String routerAddress;
    private String remoteAddress;
    private long timestamp = System.currentTimeMillis();
    private Hashtable altCalls;
    private SdpInfo localSDPInfo;
    private SdpInfo remoteSDPInfo;

    public SipCall(Request request, Transaction transaction, int direction, String remoteHostAddress) throws UnknownHostException {
        this.request = request;
        this.transaction = transaction;
        this.direction = direction;
        this.toHeader = (ToHeader)request.getHeader("To");
        this.fromHeader = (FromHeader)request.getHeader("From");
        this.contactHeader = (ContactHeader)request.getHeader("Contact");
        if (direction == 1) {
            this.parseIncomingRequest();
        } else {
            this.parseOutgoingRequest();
            this.contactAddress = remoteHostAddress != null ? remoteHostAddress : ((SipURI)this.remoteURI).getHost();
            this.contactPort = ((SipURI)this.remoteURI).getPort();
        }
    }

    private void parseIncomingRequest() throws UnknownHostException {
        URI requestUri = this.request.getRequestURI();
        if (requestUri instanceof SipURI) {
            this.localUser = ((SipURI)requestUri).getUser();
            this.localHost = ((SipURI)requestUri).getHost();
        } else if (requestUri instanceof TelURL) {
            this.localUser = ((TelURL)requestUri).getPhoneNumber();
        }
        URI localSipAddress = this.toHeader.getAddress().getURI();
        if (localSipAddress instanceof SipURI) {
            this.toUser = ((SipURI)localSipAddress).getUser();
            if (this.localUser != null && !this.localUser.equals(this.toUser)) {
                this.originalCalledUser = this.toUser;
            }
            this.toHost = ((SipURI)localSipAddress).getHost();
            if (this.localHost == null || !this.localHost.equals(this.toHost)) {
                this.originalCalledHost = this.toHost;
            }
        } else if (localSipAddress instanceof TelURL) {
            this.toUser = ((TelURL)localSipAddress).getPhoneNumber();
            if (this.localUser != null && !this.localUser.equals(this.toUser)) {
                this.originalCalledUser = this.toUser;
            }
        }
        this.localName = this.toHeader.getAddress().getDisplayName();
        this.remoteName = this.fromHeader.getAddress().getDisplayName();
        this.remoteSipAddress = this.fromHeader.getAddress().getURI();
        this.remoteTag = this.fromHeader.getTag();
        if (this.remoteSipAddress instanceof SipURI) {
            this.remoteUser = ((SipURI)this.remoteSipAddress).getUser();
            this.remoteHost = ((SipURI)this.remoteSipAddress).getHost();
        } else if (this.remoteSipAddress instanceof TelURL) {
            this.remoteUser = ((TelURL)this.remoteSipAddress).getPhoneNumber();
        }
        if (this.remoteUser == null) {
            this.remoteUser = "";
        }
        if (this.contactHeader != null) {
            this.setRemoteContactAddress((SipURI)this.contactHeader.getAddress().getURI());
        }
        ViaHeader via = (ViaHeader)this.request.getHeader("Via");
        this.transport = via.getTransport();
        this.remoteAddress = via.getHost();
        this.remotePort = via.getPort();
        if (this.remotePort == -1) {
            this.remotePort = SipEndpoint.getDefaultPort(this.transport);
        }
        this.receivedPort = this.request.getReceivedPort();
        this.receivedAddress = this.request.getReceivedAddress();
        this.seqNumber = this.request.getSequenceNumber() + 25;
        this.uah = (UserAgentHeader)this.request.getHeader("User-Agent");
        this.ush = (ServerHeader)this.request.getHeader("Server");
        ListIterator diversion = this.request.getHeaders("Diversion");
        if (diversion != null && diversion.hasNext()) {
            int c = -1;
            do {
                String str = diversion.next().toString();
                int n = str.indexOf(60);
                int m = str.indexOf(62);
                if (n == -1 || m == -1) continue;
                String host = null;
                String reason = null;
                String number = str.substring(n + 1, m);
                if ((n = number.indexOf(58)) != -1) {
                    number = number.substring(n + 1);
                }
                if ((n = number.indexOf(64)) != -1) {
                    host = number.substring(n + 1);
                    number = number.substring(0, n);
                }
                if ((n = str.indexOf("reason=")) != -1 && (n = (reason = str.substring(n + 7).trim()).indexOf(";")) != -1) {
                    reason = reason.substring(0, n).trim();
                }
                int cnt = 0;
                n = str.indexOf("counter=");
                if (n != -1) {
                    String counter = str.substring(n + 8).trim();
                    if ((n = counter.indexOf(";")) != -1) {
                        counter = counter.substring(0, n).trim();
                    }
                    try {
                        cnt = Integer.parseInt(counter);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (cnt <= 1) {
                    if (number.equals(this.originalCalledUser)) {
                        this.originalRedirectionReason = reason;
                    } else if (this.originalCalledUser == null) {
                        this.originalCalledUser = number;
                        this.originalCalledHost = host;
                        this.originalRedirectionReason = reason;
                    }
                }
                if (cnt <= c) continue;
                this.redirectionNumber = number;
                this.redirectionHost = host;
                this.redirectionReason = reason;
                c = cnt;
            } while (diversion.hasNext());
        } else {
            diversion = this.request.getHeaders("History-Info");
        }
        this.auth = (AuthorizationHeader)this.request.getHeader("Authorization");
    }

    private void parseOutgoingRequest() throws UnknownHostException {
        this.remoteURI = this.request.getRequestURI();
        this.localViaHeader = (ViaHeader)this.request.getHeader("Via");
        this.remoteSipAddress = this.toHeader.getAddress().getURI();
        this.localTag = this.fromHeader.getTag();
        this.seqNumber = this.request.getSequenceNumber();
        this.remoteName = this.toHeader.getAddress().getDisplayName();
        this.localName = this.fromHeader.getAddress().getDisplayName();
        SipURI localURI = (SipURI)this.contactHeader.getAddress().getURI();
        this.localUser = localURI.getUser();
        this.localHost = localURI.getHost();
        if (this.remoteSipAddress instanceof SipURI) {
            this.remoteUser = ((SipURI)this.remoteSipAddress).getUser();
            this.remoteHost = ((SipURI)this.remoteSipAddress).getHost();
        } else if (this.remoteSipAddress instanceof TelURL) {
            this.remoteUser = ((TelURL)this.remoteSipAddress).getPhoneNumber();
        }
    }

    public void addAlternateCall(SipCall call) {
        if (this.altCalls == null) {
            this.altCalls = new Hashtable();
        }
        this.altCalls.put(call.getCallId(), call);
    }

    public Hashtable getAlternateCalls() {
        return this.altCalls;
    }

    public void setLocalSDPInfo(SdpInfo sdpInfo) {
        this.localSDPInfo = sdpInfo;
    }

    public SdpInfo getLocalSDPInfo() {
        return this.localSDPInfo;
    }

    public void setRemoteSDPInfo(SdpInfo sdpInfo) {
        this.remoteSDPInfo = sdpInfo;
    }

    public SdpInfo getRemoteSDPInfo() {
        return this.remoteSDPInfo;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request r) {
        this.request = r;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction t) {
        this.transaction = t;
    }

    public URI getRemoteURI() {
        return this.remoteURI;
    }

    public void setRemoteURI(URI uri) {
        this.remoteURI = uri;
    }

    public URI getRemoteAddressURI() {
        return this.remoteSipAddress;
    }

    public boolean hasRemoteContactAddress() {
        return this.remoteContactAddress;
    }

    public void setRemoteContactAddress(SipURI uri) throws UnknownHostException {
        this.remoteContactAddress = true;
        this.remoteURI = uri;
        this.contactPort = uri.getPort();
        if (this.localUser != null) {
            this.regKey = this.localUser + "@" + uri.getHost();
            if (this.contactPort > 0) {
                this.regKey = this.regKey + ":" + this.contactPort;
            }
        }
    }

    public AuthorizationHeader getAuthorizationHeader() {
        return this.auth;
    }

    public void setAuthorizationHeader(AuthorizationHeader auth) {
        this.auth = auth;
    }

    public String getRegKey() {
        return this.regKey;
    }

    public String getRemoteUserAgent() {
        String remoteua = "";
        if (this.uah != null) {
            remoteua = this.uah.getProduct();
        } else if (this.ush != null) {
            remoteua = this.ush.getProduct();
        }
        return remoteua.trim();
    }

    public void setRemoteInfo(Response response) {
        this.uah = (UserAgentHeader)response.getHeader("User-Agent");
        this.ush = (ServerHeader)response.getHeader("Server");
    }

    public void setRemoteTag(String tag) throws ParseException {
        this.remoteTag = tag;
        this.toHeader.setTag(tag);
    }

    public void setLocalTag(String tag) throws ParseException {
        this.localTag = tag;
        this.toHeader.setTag(tag);
    }

    public String getRemoteTag() {
        return this.remoteTag;
    }

    public String getLocalTag() {
        return this.localTag;
    }

    public String getLocalParty() {
        return this.localUser;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public String getRemoteParty() {
        return this.remoteUser;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getCallingParty() {
        return this.direction == 1 ? this.remoteUser : this.localUser;
    }

    public String getCalledParty() {
        return this.direction == 1 ? this.localUser : this.remoteUser;
    }

    public String getCallingName() {
        return this.direction == 1 ? this.remoteName : this.localName;
    }

    public String getCalledName() {
        return this.direction == 1 ? this.localName : this.remoteName;
    }

    public String getConnectedParty() {
        if (this.remoteURI instanceof SipURI) {
            return ((SipURI)this.remoteURI).getUser();
        }
        if (this.remoteURI instanceof TelURL) {
            return ((TelURL)this.remoteURI).getPhoneNumber();
        }
        return this.remoteUser;
    }

    public String getCallingPartyNumber() {
        if (this.direction == 2) {
            return this.localUser;
        }
        return this.remoteUser;
    }

    private boolean isPhoneNumber(String number) {
        for (int i = 0; i < number.length(); ++i) {
            char c = number.charAt(i);
            if (i == 0 && c == '+' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public String getCallingHost() {
        return this.direction == 1 ? this.remoteHost : this.localHost;
    }

    public String getCalledHost() {
        return this.direction == 1 ? this.localHost : this.remoteHost;
    }

    public String getReceivedAddress() {
        return this.receivedAddress;
    }

    public int getReceivedPort() {
        return this.receivedPort;
    }

    public String getRemoteAddress() {
        return this.direction == 1 ? this.receivedAddress : this.contactAddress;
    }

    public int getRemotePort() {
        return this.direction == 1 ? this.receivedPort : this.contactPort;
    }

    public String getRouterAddress() {
        return this.routerAddress;
    }

    public void setRouterAddress(String addr) {
        this.routerAddress = addr;
    }

    public void setLocalParty(String user) {
        this.localUser = user;
    }

    public void setLocalHost(String host) {
        this.localHost = host;
    }

    public String getCallId() {
        return this.request.getCallId();
    }

    public String getReferReplaces() {
        return this.getCallId() + ";to-tag=" + this.toHeader.getTag() + ";from-tag=" + this.fromHeader.getTag();
    }

    public ToHeader getToHeader() {
        return this.request.getTo();
    }

    public FromHeader getFromHeader() {
        return this.request.getFrom();
    }

    public int getDirection() {
        return this.direction;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public void setSeqNumber(int n) {
        this.seqNumber = n;
    }

    public void setUsername(String user) {
        this.user = user;
    }

    public void setPassword(String pass) {
        this.pass = pass;
    }

    public String getUsername() {
        return this.user;
    }

    public String getPassword() {
        return this.pass;
    }

    public void setProxyLogin(String login) {
        this.proxyLogin = login;
    }

    public void setProxyPassword(String pass) {
        this.proxyPassword = pass;
    }

    public String getProxyLogin() {
        return this.proxyLogin;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public ViaHeader getLocalViaHeader() {
        return this.localViaHeader;
    }

    public void setLocalViaHeader(ViaHeader via) {
        this.localViaHeader = via;
    }

    public void clear() {
    }

    public boolean isLocalUser(String user) {
        if (user.equals(this.toUser) || user.equals(this.localUser)) {
            this.remoteLogin = user;
            return true;
        }
        return false;
    }

    public void setCallInfo(Hashtable info) {
        String str;
        info.put("cti.CallID", this.request.getCallId());
        if (this.remoteLogin != null) {
            info.put("cti.RemoteHostLogin", this.remoteLogin);
        }
        info.put("cti.RemoteHost", this.getRemoteAddress());
        info.put("cti.RemoteDevice", this.getRemoteUserAgent());
        if (this.originalCalledUser != null) {
            info.put("cti.OriginalCalledNumber", this.originalCalledUser);
        }
        if (this.originalCalledHost != null) {
            info.put("cti.OriginalCalledHost", this.originalCalledHost);
        }
        if (this.originalRedirectionReason != null) {
            info.put("cti.OriginalRedirectingReason", this.originalRedirectionReason);
        }
        if (this.redirectionNumber != null) {
            info.put("cti.RedirectingNumber", this.redirectionNumber);
        }
        if (this.redirectionHost != null) {
            info.put("cti.RedirectingHost", this.redirectionHost);
        }
        if (this.redirectionReason != null) {
            info.put("cti.RedirectingReason", this.redirectionReason);
        }
        if (!((str = this.getCallingName()) == null || this.direction != 2 && str.equals(this.remoteUser))) {
            info.put("cti.CallingName", str);
        }
        if ((str = this.getCalledName()) != null) {
            info.put("cti.CalledName", str);
        }
        if ((str = this.getCallingHost()) != null) {
            info.put("cti.CallingHost", str);
        }
        if ((str = this.getCalledHost()) != null) {
            info.put("cti.CalledHost", str);
        }
        if (this.direction == 1) {
            String obj;
            List extHeaders = this.request.getExtensionHeaders();
            for (int i = 0; i < extHeaders.size(); ++i) {
                Header header = (Header)extHeaders.get(i);
                String hname = header.getHeaderName();
                if (hname.equals("Diversion") || hname.equals("History-Info")) continue;
                info.put("sip." + hname, header.getValue());
            }
            this.routerAddress = this.receivedAddress + ":" + this.receivedPort;
            CallInfoHeader callInfoHeader = (CallInfoHeader)this.request.getHeader("Call-Info");
            if (callInfoHeader != null && (obj = callInfoHeader.getParameter("answer-after")) != null) {
                info.put("cti.AUTOANSWER", obj);
            }
        }
    }

    public boolean isSmileClient() {
        String ua = this.getRemoteUserAgent();
        return ua.startsWith("Smile");
    }
}

