/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.address;

import com.smile.telephony.sip.address.SipURI;
import com.smile.telephony.sip.address.URI;

public final class Address
implements Cloneable {
    public static final int NAME_ADDR = 1;
    public static final int ADDRESS_SPEC = 2;
    public static final int WILD_CARD = 3;
    protected int addressType = 1;
    protected String displayName;
    protected URI address;

    public int getAddressType() {
        return this.addressType;
    }

    public void setAddressType(int atype) {
        this.addressType = atype;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.addressType = 1;
    }

    public void setAddess(URI address) {
        this.address = address;
    }

    public String getUser() {
        if (!(this.address instanceof SipURI)) {
            return null;
        }
        SipURI uri = (SipURI)this.address;
        return uri.getUser();
    }

    public String getHost() {
        if (!(this.address instanceof SipURI)) {
            return null;
        }
        SipURI uri = (SipURI)this.address;
        return uri.getHost();
    }

    public int getPort() {
        if (!(this.address instanceof SipURI)) {
            return -1;
        }
        SipURI uri = (SipURI)this.address;
        return uri.getPort();
    }

    public String getUserAtHostPort() {
        if (this.address instanceof SipURI) {
            SipURI uri = (SipURI)this.address;
            return uri.getUserAtHostPort();
        }
        return this.address.toString();
    }

    public String getUserAtHost() {
        if (this.address instanceof SipURI) {
            SipURI uri = (SipURI)this.address;
            return uri.getUserAtHost();
        }
        return this.address.toString();
    }

    public String encode() {
        if (this.addressType == 3) {
            return "*";
        }
        if (this.address != null) {
            if (this.displayName != null) {
                return "\"" + this.displayName + "\" <" + this.address.encode() + ">";
            }
            if (this.addressType == 1) {
                return "<" + this.address.encode() + ">";
            }
            return this.address.encode();
        }
        if (this.displayName != null) {
            return "\"" + this.displayName + "\"";
        }
        return "";
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        Address that = (Address)other;
        if (this.addressType == 3 && that.addressType != 3) {
            return false;
        }
        return this.address.equals(that.address);
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public void removeDisplayName() {
        this.displayName = null;
    }

    public boolean isSIPAddress() {
        return this.address instanceof SipURI;
    }

    public URI getURI() {
        return this.address;
    }

    public boolean isWildcard() {
        return this.addressType == 3;
    }

    public void setURI(URI address) {
        this.address = address;
    }

    public void setUser(String user) {
        ((SipURI)this.address).setUser(user);
    }

    public void setWildCardFlag() {
        this.addressType = 3;
        this.address = new SipURI();
        ((SipURI)this.address).setHost("*");
    }

    public String toString() {
        return this.encode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

