/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.address;

import com.smile.telephony.sip.address.URI;
import java.text.ParseException;

public class TelURL
extends URI {
    protected String phoneNumber;

    public TelURL() {
        this.scheme = "tel";
    }

    public TelURL(String uri) throws ParseException {
        this.scheme = "tel";
        int i = uri.indexOf(59);
        if (i == -1) {
            this.phoneNumber = uri;
        } else {
            this.phoneNumber = uri.substring(0, i);
            this.parseParameters(uri.substring(i + 1));
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof TelURL && this.phoneNumber.equals(((TelURL)obj).phoneNumber);
    }

    public void setPhoneNumber(String num) {
        this.phoneNumber = num;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getPostDial() {
        return (String)this.getParameter("postdial");
    }

    public String getIsdnSubaddress() {
        return (String)this.getParameter("isub");
    }

    public boolean hasPostDial() {
        return this.hasParameter("postdial");
    }

    public boolean hasIsdnSubaddress() {
        return this.hasParameter("isub");
    }

    public boolean isGlobal() {
        return this.phoneNumber.startsWith("+");
    }

    public void removePostDial() {
        this.removeParameter("postdial");
    }

    public void removeIsdnSubaddress() {
        this.removeParameter("isub");
    }

    public void setPostDial(String p) {
        this.setParameter("postdial", p);
    }

    public void setIsdnSubaddress(String isub) {
        this.setParameter("isub", isub);
    }

    @Override
    public String encode() {
        return "tel:" + this.phoneNumber + this.encodeParameters();
    }

    public void setIsdnSubAddress(String isdnSubAddress) {
        this.setParameter("isub", isdnSubAddress);
    }
}

