/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.header.ValueParametersHeader;
import java.text.ParseException;

public class AcceptHeader
extends ValueParametersHeader {
    public static final String NAME = "Accept";
    protected String type;
    protected String subtype;

    public AcceptHeader() {
        this.setHeaderName(NAME);
    }

    @Override
    protected void parseValue(String value) throws ParseException {
        int n = value.indexOf(47);
        if (n != -1) {
            this.type = value.substring(0, n);
            this.subtype = value.substring(n + 1);
        } else {
            this.type = value;
            this.subtype = "*";
        }
    }

    public boolean allowsAllContentTypes() {
        return this.type != null && this.type.compareTo("*") == 0;
    }

    public boolean allowsAllContentSubTypes() {
        return this.subtype != null && this.subtype.compareTo("*") == 0;
    }

    @Override
    protected String encodeBody() {
        return this.type + "/" + this.subtype + super.encodeBody();
    }

    public String getContentType() {
        return this.type;
    }

    public String getContentSubType() {
        return this.subtype;
    }

    public float getQValue() {
        return super.getFloatParameter("q");
    }

    public boolean hasQValue() {
        return super.hasParameter("q");
    }

    public void removeQValue() {
        super.removeParameter("q");
    }

    public void setContentSubType(String subtype) {
        this.subtype = subtype;
    }

    public void setContentType(String type) {
        this.type = type;
    }

    public void setQValue(float qValue) {
        if (qValue == -1.0f) {
            super.removeParameter("q");
        }
        super.setParameter("q", String.valueOf(qValue));
    }
}

