/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.address.URI;
import com.smile.telephony.sip.header.AuthorizationHeader;
import com.smile.telephony.sip.header.Header;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import smile.util.Utils;

public abstract class AuthenticationHeader
extends Header {
    public static final String REALM = "realm";
    public static final String STALE = "stale";
    public static final String QOP = "qop";
    public static final String NC = "nc";
    public static final String USERNAME = "username";
    public static final String URI = "uri";
    public static final String DOMAIN = "domain";
    public static final String CNONCE = "cnonce";
    public static final String RESPONSE = "response";
    public static final String OPAQUE = "opaque";
    public static final String ALGORITHM = "algorithm";
    public static final String DIGEST = "Digest";
    public static final String SIGNED_BY = "signed-by";
    public static final String SIGNATURE = "signature";
    public static final String NONCE = "nonce";
    public static final String NEXT_NONCE = "nextnonce";
    public static final String NONCE_COUNT = "nc";
    public static final String RESPONSE_AUTH = "rspauth";
    public static final String PASSWORD = "password";
    protected String scheme = "Digest";
    protected HashMap parameters = new HashMap();

    public AuthenticationHeader(String name) {
        this.setHeaderName(name);
    }

    @Override
    protected int parse(String str, int offset) throws ParseException {
        int i;
        int n = str.indexOf(32, offset);
        this.scheme = str.substring(offset, n);
        if (this.scheme.equals("Basic") && this instanceof AuthorizationHeader) {
            int m = n + 1;
            if ((n = str.indexOf(32, m)) == -1) {
                n = str.length();
            }
            String challenge = Utils.decodeBase64(str.substring(m, n));
            m = challenge.indexOf(58);
            this.parameters.put(USERNAME, challenge.substring(0, m));
            this.parameters.put(PASSWORD, challenge.substring(m + 1));
            return n;
        }
        String name = null;
        boolean quoted = false;
        block6: for (i = ++n; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\"': {
                    quoted = !quoted;
                    continue block6;
                }
                case ',': {
                    if (quoted) continue block6;
                    if (name != null) {
                        this.setParameter(name, str.substring(n, i));
                        name = null;
                    }
                    n = i + 1;
                    continue block6;
                }
                case '\t': 
                case ' ': {
                    if (quoted || name != null) continue block6;
                    ++n;
                    continue block6;
                }
                case '=': {
                    if (quoted) continue block6;
                    name = str.substring(n, i);
                    n = i + 1;
                }
            }
        }
        if (i > n && name != null) {
            this.setParameter(name, str.substring(n, i));
        }
        return i;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        AuthenticationHeader ah = (AuthenticationHeader)obj;
        return this.scheme.equals(ah.scheme) && this.parameters.equals(ah.parameters);
    }

    public void setParameter(String name, String value) {
        if (value.startsWith("\"")) {
            value = value.substring(1, value.indexOf("\"", 1));
        }
        this.parameters.put(name, value);
    }

    public String getParameter(String name) {
        return (String)this.parameters.get(name);
    }

    @Override
    public String encodeBody() {
        if (this.scheme.equals("Basic") && this instanceof AuthorizationHeader) {
            return this.scheme + " " + Utils.encodeBase64(this.parameters.get(USERNAME) + ":" + this.parameters.get(PASSWORD));
        }
        String str = this.scheme + " ";
        Iterator it = this.parameters.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = (String)this.parameters.get(key);
            if (!(key.equals("nc") || key.equals(ALGORITHM) || key.equals(STALE))) {
                value = "\"" + (String)value + "\"";
            }
            str = str + key + "=" + (String)value;
            if (!it.hasNext()) continue;
            str = str + ",";
        }
        return str;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setRealm(String realm) {
        this.setParameter(REALM, realm);
    }

    public String getRealm() {
        return this.getParameter(REALM);
    }

    public void setNonce(String nonce) {
        this.setParameter(NONCE, nonce);
    }

    public String getNonce() {
        return this.getParameter(NONCE);
    }

    public void setURI(URI uri) {
        this.setParameter(URI, uri.toString());
    }

    public void setURI(String uri) {
        this.setParameter(URI, uri);
    }

    public String getURI() {
        return this.getParameter(URI);
    }

    public void setAlgorithm(String algorithm) {
        this.setParameter(ALGORITHM, algorithm);
    }

    public String getAlgorithm() {
        return this.getParameter(ALGORITHM);
    }

    public void setQop(String qop) {
        this.setParameter(QOP, qop);
    }

    public String getQop() {
        return this.getParameter(QOP);
    }

    public void setOpaque(String opaque) {
        this.setParameter(OPAQUE, opaque);
    }

    public String getOpaque() {
        return this.getParameter(OPAQUE);
    }

    public void setDomain(String domain) {
        this.setParameter(DOMAIN, domain);
    }

    public String getDomain() {
        return this.getParameter(DOMAIN);
    }

    public void setStale(boolean stale) {
        this.setParameter(STALE, "yes");
    }

    public boolean isStale() {
        return "yes".equals(this.getParameter(STALE));
    }

    public void setCNonce(String cnonce) {
        this.setParameter(CNONCE, cnonce);
    }

    public String getCNonce() {
        return this.getParameter(CNONCE);
    }

    public int getNonceCount() {
        String value = this.getParameter(STALE);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setNonceCount(int param) {
        Object nc = Integer.toHexString(param);
        String base = "00000000";
        nc = base.substring(0, 8 - ((String)nc).length()) + (String)nc;
        this.setParameter("nc", (String)nc);
    }

    public String getResponse() {
        return this.getParameter(RESPONSE);
    }

    public void setResponse(String response) {
        this.setParameter(RESPONSE, response);
    }

    public String getUsername() {
        return this.getParameter(USERNAME);
    }

    public void setUsername(String username) {
        this.setParameter(USERNAME, username);
    }

    public String getNextNonce() {
        return this.getParameter(NEXT_NONCE);
    }

    public void setNextNonce(String nextNonce) {
        this.setParameter(NEXT_NONCE, nextNonce);
    }

    public String getPassword() {
        return this.getParameter(PASSWORD);
    }

    public void setPassword(String password) {
        this.setParameter(PASSWORD, password);
    }
}

