/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.header.Header;
import java.text.ParseException;

public class CSeqHeader
extends Header {
    public static final String NAME = "CSeq";
    protected int seqno;
    protected String method;

    public CSeqHeader() {
        this.setHeaderName(NAME);
        this.required = true;
    }

    public CSeqHeader(int seqno, String method) {
        this();
        this.seqno = seqno;
        this.method = method;
    }

    @Override
    protected int parse(String str, int offset) throws ParseException {
        int n = str.indexOf(32, offset);
        try {
            this.seqno = Integer.parseInt(str.substring(offset, n));
            this.method = str.substring(n + 1);
        }
        catch (Exception e) {
            throw new ParseException(str, offset);
        }
        return str.length();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CSeqHeader && this.seqno == ((CSeqHeader)obj).seqno && this.method.equalsIgnoreCase(((CSeqHeader)obj).method);
    }

    @Override
    public String encodeBody() {
        return this.seqno + " " + this.method.toUpperCase();
    }

    public String getMethod() {
        return this.method;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.seqno = new Integer(sequenceNumber);
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public int getSequenceNumber() {
        return this.seqno;
    }
}

