/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.header.Header;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateHeader
extends Header {
    public static final String NAME = "Date";
    protected DateFormat format;
    protected Date date;

    public DateHeader() {
        this.setHeaderName(NAME);
        this.format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    @Override
    public int parse(String value, int offset) throws ParseException {
        this.date = this.format.parse(value);
        return value.length();
    }

    @Override
    public String encodeBody() {
        if (this.date == null) {
            this.date = new Date();
        }
        return this.format.format(this.date);
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    @Override
    public boolean equals(Object obj) {
        return this.date != null && this.date.equals(obj);
    }
}

