/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.address.Address;
import com.smile.telephony.sip.address.URI;
import com.smile.telephony.sip.header.AcceptEncodingHeader;
import com.smile.telephony.sip.header.AcceptHeader;
import com.smile.telephony.sip.header.AcceptLanguageHeader;
import com.smile.telephony.sip.header.AlertInfoHeader;
import com.smile.telephony.sip.header.AllowEventsHeader;
import com.smile.telephony.sip.header.AllowHeader;
import com.smile.telephony.sip.header.AuthenticationInfoHeader;
import com.smile.telephony.sip.header.AuthorizationHeader;
import com.smile.telephony.sip.header.CSeqHeader;
import com.smile.telephony.sip.header.CallIdHeader;
import com.smile.telephony.sip.header.CallInfoHeader;
import com.smile.telephony.sip.header.ContactHeader;
import com.smile.telephony.sip.header.ContentDispositionHeader;
import com.smile.telephony.sip.header.ContentEncodingHeader;
import com.smile.telephony.sip.header.ContentLanguageHeader;
import com.smile.telephony.sip.header.ContentLengthHeader;
import com.smile.telephony.sip.header.ContentTypeHeader;
import com.smile.telephony.sip.header.DateHeader;
import com.smile.telephony.sip.header.ErrorInfoHeader;
import com.smile.telephony.sip.header.EventHeader;
import com.smile.telephony.sip.header.ExpiresHeader;
import com.smile.telephony.sip.header.ExtensionHeader;
import com.smile.telephony.sip.header.FromHeader;
import com.smile.telephony.sip.header.Header;
import com.smile.telephony.sip.header.HeaderList;
import com.smile.telephony.sip.header.InReplyToHeader;
import com.smile.telephony.sip.header.MaxForwardsHeader;
import com.smile.telephony.sip.header.MimeVersionHeader;
import com.smile.telephony.sip.header.MinExpiresHeader;
import com.smile.telephony.sip.header.OrganizationHeader;
import com.smile.telephony.sip.header.PriorityHeader;
import com.smile.telephony.sip.header.ProxyAuthenticateHeader;
import com.smile.telephony.sip.header.ProxyAuthorizationHeader;
import com.smile.telephony.sip.header.ProxyRequireHeader;
import com.smile.telephony.sip.header.RAckHeader;
import com.smile.telephony.sip.header.RSeqHeader;
import com.smile.telephony.sip.header.ReasonHeader;
import com.smile.telephony.sip.header.RecordRouteHeader;
import com.smile.telephony.sip.header.ReferToHeader;
import com.smile.telephony.sip.header.ReplyToHeader;
import com.smile.telephony.sip.header.RequireHeader;
import com.smile.telephony.sip.header.RetryAfterHeader;
import com.smile.telephony.sip.header.RouteHeader;
import com.smile.telephony.sip.header.ServerHeader;
import com.smile.telephony.sip.header.SubjectHeader;
import com.smile.telephony.sip.header.SubscriptionStateHeader;
import com.smile.telephony.sip.header.SupportedHeader;
import com.smile.telephony.sip.header.TimeStampHeader;
import com.smile.telephony.sip.header.ToHeader;
import com.smile.telephony.sip.header.UnsupportedHeader;
import com.smile.telephony.sip.header.UserAgentHeader;
import com.smile.telephony.sip.header.ViaHeader;
import com.smile.telephony.sip.header.WWWAuthenticateHeader;
import com.smile.telephony.sip.header.WarningHeader;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class HeaderFactory {
    static HashMap headerNames = new HashMap();

    public static Header createHeader(String line) throws ParseException {
        int n = line.indexOf(58);
        if (n < 1) {
            return null;
        }
        String headerName = line.substring(0, n).trim();
        String canonicName = (String)headerNames.get(headerName.toLowerCase());
        if (canonicName != null) {
            headerName = canonicName;
        }
        String headerValue = line.substring(n + 1).trim();
        try {
            return HeaderList.createHeader(headerName, headerValue);
        }
        catch (Exception e) {
            throw new ParseException(line, 0);
        }
    }

    public AcceptEncodingHeader createAcceptEncodingHeader(String encoding) {
        AcceptEncodingHeader acceptEncoding = new AcceptEncodingHeader();
        acceptEncoding.setEncoding(encoding);
        return acceptEncoding;
    }

    public AcceptHeader createAcceptHeader(String contentType, String contentSubType) {
        AcceptHeader accept = new AcceptHeader();
        accept.setContentType(contentType);
        accept.setContentSubType(contentSubType);
        return accept;
    }

    public AcceptLanguageHeader createAcceptLanguageHeader(Locale language) {
        AcceptLanguageHeader acceptLanguage = new AcceptLanguageHeader();
        acceptLanguage.setAcceptLanguage(language);
        return acceptLanguage;
    }

    public AlertInfoHeader createAlertInfoHeader(URI alertInfo) {
        AlertInfoHeader a = new AlertInfoHeader();
        a.setURI(alertInfo);
        return a;
    }

    public AllowEventsHeader createAllowEventsHeader(String eventType) {
        AllowEventsHeader allowEvents = new AllowEventsHeader();
        allowEvents.setEventType(eventType);
        return allowEvents;
    }

    public AllowHeader createAllowHeader(String method) {
        AllowHeader allow = new AllowHeader();
        allow.setMethod(method);
        return allow;
    }

    public AuthenticationInfoHeader createAuthenticationInfoHeader(String response) throws ParseException {
        AuthenticationInfoHeader auth = new AuthenticationInfoHeader();
        auth.setResponse(response);
        return auth;
    }

    public AuthorizationHeader createAuthorizationHeader(String scheme) {
        AuthorizationHeader auth = new AuthorizationHeader();
        auth.setScheme(scheme);
        return auth;
    }

    public CSeqHeader createCSeqHeader(int sequenceNumber, String method) {
        CSeqHeader cseq = new CSeqHeader();
        cseq.setMethod(method);
        cseq.setSequenceNumber(sequenceNumber);
        return cseq;
    }

    public CallIdHeader createCallIdHeader(String callId) {
        CallIdHeader c = new CallIdHeader();
        c.setCallId(callId);
        return c;
    }

    public CallInfoHeader createCallInfoHeader(URI callInfo) {
        CallInfoHeader c = new CallInfoHeader();
        c.setURI(callInfo);
        return c;
    }

    public ContactHeader createContactHeader(Address address) {
        ContactHeader contact = new ContactHeader();
        contact.setAddress(address);
        return contact;
    }

    public ContactHeader createContactHeader() {
        ContactHeader contact = new ContactHeader();
        contact.setWildCardAddress();
        contact.setExpires(0);
        return contact;
    }

    public ContentDispositionHeader createContentDispositionHeader(String contentDisposition) {
        ContentDispositionHeader c = new ContentDispositionHeader();
        c.setDispositionType(contentDisposition);
        return c;
    }

    public ContentEncodingHeader createContentEncodingHeader(String encoding) throws ParseException {
        ContentEncodingHeader c = new ContentEncodingHeader();
        c.setEncoding(encoding);
        return c;
    }

    public ContentLanguageHeader createContentLanguageHeader(String contentLanguage) {
        ContentLanguageHeader c = new ContentLanguageHeader();
        c.setLanguageTag(contentLanguage);
        return c;
    }

    public ContentLengthHeader createContentLengthHeader(int contentLength) {
        ContentLengthHeader c = new ContentLengthHeader();
        c.setContentLength(contentLength);
        return c;
    }

    public ContentTypeHeader createContentTypeHeader(String contentType, String contentSubType) throws ParseException {
        ContentTypeHeader c = new ContentTypeHeader();
        c.setContentType(contentType, contentSubType);
        return c;
    }

    public DateHeader createDateHeader(Calendar date) {
        return this.createDateHeader(date.getTime());
    }

    public DateHeader createDateHeader(Date date) {
        DateHeader d = new DateHeader();
        d.setDate(date);
        return d;
    }

    public EventHeader createEventHeader(String eventType) {
        EventHeader event = new EventHeader();
        event.setEventType(eventType);
        return event;
    }

    public ExpiresHeader createExpiresHeader(int expires) {
        ExpiresHeader e = new ExpiresHeader();
        e.setExpires(expires);
        return e;
    }

    public ExtensionHeader createExtensionHeader(String name, String value) {
        ExtensionHeader ext = new ExtensionHeader(name);
        ext.setValue(value);
        return ext;
    }

    public FromHeader createFromHeader(Address address, String tag) throws ParseException {
        FromHeader from = new FromHeader();
        from.setAddress(address);
        if (tag != null) {
            from.setTag(tag);
        }
        return from;
    }

    public InReplyToHeader createInReplyToHeader(String callId) {
        InReplyToHeader inReplyTo = new InReplyToHeader();
        inReplyTo.setCallId(callId);
        return inReplyTo;
    }

    public MaxForwardsHeader createMaxForwardsHeader(int maxForwards) {
        MaxForwardsHeader m = new MaxForwardsHeader();
        m.setMaxForwards(maxForwards);
        return m;
    }

    public MimeVersionHeader createMimeVersionHeader(int majorVersion, int minorVersion) {
        MimeVersionHeader m = new MimeVersionHeader();
        m.setValue(majorVersion + "." + minorVersion);
        return m;
    }

    public MinExpiresHeader createMinExpiresHeader(int minExpires) {
        MinExpiresHeader min = new MinExpiresHeader();
        min.setExpires(minExpires);
        return min;
    }

    public OrganizationHeader createOrganizationHeader(String organization) {
        OrganizationHeader o = new OrganizationHeader();
        o.setOrganization(organization);
        return o;
    }

    public PriorityHeader createPriorityHeader(String priority) {
        PriorityHeader p = new PriorityHeader();
        p.setPriority(priority);
        return p;
    }

    public ProxyAuthenticateHeader createProxyAuthenticateHeader(String scheme) {
        ProxyAuthenticateHeader p = new ProxyAuthenticateHeader();
        p.setScheme(scheme);
        return p;
    }

    public ProxyAuthorizationHeader createProxyAuthorizationHeader(String scheme) {
        ProxyAuthorizationHeader p = new ProxyAuthorizationHeader();
        p.setScheme(scheme);
        return p;
    }

    public ProxyRequireHeader createProxyRequireHeader(String optionTag) {
        ProxyRequireHeader p = new ProxyRequireHeader();
        p.setOptionTag(optionTag);
        return p;
    }

    public RAckHeader createRAckHeader(int rSeqNumber, int cSeqNumber, String method) {
        RAckHeader rack = new RAckHeader();
        rack.setMethod(method);
        rack.setCSeqNumber(cSeqNumber);
        rack.setRSeqNumber(rSeqNumber);
        return rack;
    }

    public RSeqHeader createRSeqHeader(int sequenceNumber) {
        RSeqHeader rseq = new RSeqHeader();
        rseq.setSequenceNumber(sequenceNumber);
        return rseq;
    }

    public ReasonHeader createReasonHeader(String protocol, int cause, String text) {
        ReasonHeader reason = new ReasonHeader();
        reason.setProtocol(protocol);
        reason.setCause(cause);
        reason.setText(text);
        return reason;
    }

    public RecordRouteHeader createRecordRouteHeader(Address address) {
        RecordRouteHeader recordRoute = new RecordRouteHeader();
        recordRoute.setAddress(address);
        return recordRoute;
    }

    public ReplyToHeader createReplyToHeader(Address address) {
        ReplyToHeader replyTo = new ReplyToHeader();
        replyTo.setAddress(address);
        return replyTo;
    }

    public RequireHeader createRequireHeader(String optionTag) {
        RequireHeader require = new RequireHeader();
        require.setOptionTag(optionTag);
        return require;
    }

    public RetryAfterHeader createRetryAfterHeader(int retryAfter) {
        RetryAfterHeader r = new RetryAfterHeader();
        r.setRetryAfter(retryAfter);
        return r;
    }

    public RouteHeader createRouteHeader(Address address) {
        RouteHeader route = new RouteHeader();
        route.setAddress(address);
        return route;
    }

    public ServerHeader createServerHeader(String product) {
        ServerHeader server = new ServerHeader();
        server.setProduct(product);
        return server;
    }

    public SubjectHeader createSubjectHeader(String subject) {
        SubjectHeader s = new SubjectHeader();
        s.setSubject(subject);
        return s;
    }

    public SubscriptionStateHeader createSubscriptionStateHeader(String subscriptionState) {
        SubscriptionStateHeader s = new SubscriptionStateHeader();
        s.setState(subscriptionState);
        return s;
    }

    public SupportedHeader createSupportedHeader(String optionTag) {
        SupportedHeader supported = new SupportedHeader();
        supported.setOptionTag(optionTag);
        return supported;
    }

    public TimeStampHeader createTimeStampHeader(float timeStamp) {
        TimeStampHeader t = new TimeStampHeader();
        t.setTimeStamp(timeStamp);
        return t;
    }

    public ToHeader createToHeader(Address address, String tag) throws ParseException {
        ToHeader to = new ToHeader();
        to.setAddress(address);
        if (tag != null) {
            to.setTag(tag);
        }
        return to;
    }

    public UnsupportedHeader createUnsupportedHeader(String optionTag) {
        UnsupportedHeader unsupported = new UnsupportedHeader();
        unsupported.setOptionTag(optionTag);
        return unsupported;
    }

    public UserAgentHeader createUserAgentHeader(String product) {
        UserAgentHeader userAgent = new UserAgentHeader();
        userAgent.setProduct(product);
        return userAgent;
    }

    public ViaHeader createViaHeader(String host, int port, String transport, String branch) throws ParseException {
        ViaHeader via = new ViaHeader();
        if (branch != null) {
            via.setBranch(branch);
        }
        if (((String)host).indexOf(58) >= 0 && ((String)host).indexOf(91) < 0) {
            host = "[" + (String)host + "]";
        }
        via.setHost((String)host);
        via.setPort(port);
        via.setTransport(transport);
        return via;
    }

    public WWWAuthenticateHeader createWWWAuthenticateHeader(String scheme) {
        WWWAuthenticateHeader www = new WWWAuthenticateHeader();
        www.setScheme(scheme);
        return www;
    }

    public WarningHeader createWarningHeader(String agent, int code, String comment) {
        WarningHeader warning = new WarningHeader();
        warning.setAgent(agent);
        warning.setCode(code);
        warning.setText(comment);
        return warning;
    }

    public ErrorInfoHeader createErrorInfoHeader(URI errorInfo) {
        return new ErrorInfoHeader(errorInfo);
    }

    public Header createHeader(String headerName, String headerValue) throws ParseException {
        String hdrText = new StringBuffer().append(headerName).append(":").append(headerValue).toString();
        Header sipHeader = HeaderFactory.parseSIPHeader(hdrText);
        if (sipHeader instanceof HeaderList) {
            if (((HeaderList)sipHeader).size() > 1) {
                throw new ParseException("Only singleton allowed " + hdrText, 0);
            }
            if (((HeaderList)sipHeader).size() == 0) {
                return sipHeader;
            }
            return ((HeaderList)sipHeader).first();
        }
        return sipHeader;
    }

    public List createHeaders(String headers) throws ParseException {
        Header shdr = HeaderFactory.parseSIPHeader(headers);
        if (shdr instanceof HeaderList) {
            return (HeaderList)shdr;
        }
        throw new ParseException("List of headers of this type is not allowed in a message", 0);
    }

    public ReferToHeader createReferToHeader(Address address) {
        ReferToHeader referTo = new ReferToHeader();
        referTo.setAddress(address);
        return referTo;
    }

    public static Header parseSIPHeader(String header) throws ParseException {
        header = (String)header + "\n\n";
        StringBuffer nmessage = new StringBuffer(((String)header).length() + 5);
        int i = 0;
        while (((String)header).charAt(i) == '\n' || ((String)header).charAt(i) == '\t' || ((String)header).charAt(i) == ' ') {
            ++i;
        }
        while (i < ((String)header).length()) {
            if (i < ((String)header).length() - 1 && ((String)header).charAt(i) == '\n' && (((String)header).charAt(i + 1) == '\t' || ((String)header).charAt(i + 1) == ' ')) {
                nmessage.append(' ');
                ++i;
            } else {
                nmessage.append(((String)header).charAt(i));
            }
            ++i;
        }
        nmessage.append('\n');
        return HeaderFactory.createHeader(nmessage.toString());
    }

    static {
        headerNames.put("t", "To");
        headerNames.put("f", "From");
        headerNames.put("v", "Via");
        headerNames.put("i", "Call-ID");
        headerNames.put("m", "Contact");
        headerNames.put("c", "Content-Type");
        headerNames.put("l", "Content-Length");
        headerNames.put("e", "Content-Encoding");
        headerNames.put("s", "Subject");
        headerNames.put("Authorization".toLowerCase(), "Authorization");
        headerNames.put("Call-ID".toLowerCase(), "Call-ID");
        headerNames.put("Content-Disposition".toLowerCase(), "Content-Disposition");
        headerNames.put("Content-Length".toLowerCase(), "Content-Length");
        headerNames.put("Content-Type".toLowerCase(), "Content-Type");
        headerNames.put("CSeq".toLowerCase(), "CSeq");
        headerNames.put("Date".toLowerCase(), "Date");
        headerNames.put("Event".toLowerCase(), "Event");
        headerNames.put("Expires".toLowerCase(), "Expires");
        headerNames.put("From".toLowerCase(), "From");
        headerNames.put("Max-Forwards".toLowerCase(), "Max-Forwards");
        headerNames.put("MIME-Version".toLowerCase(), "MIME-Version");
        headerNames.put("Min-Expires".toLowerCase(), "Min-Expires");
        headerNames.put("Organization".toLowerCase(), "Organization");
        headerNames.put("Priority".toLowerCase(), "Priority");
        headerNames.put("Proxy-Authenticate".toLowerCase(), "Proxy-Authenticate");
        headerNames.put("Proxy-Authorization".toLowerCase(), "Proxy-Authorization");
        headerNames.put("WWW-Authenticate".toLowerCase(), "WWW-Authenticate");
        headerNames.put("RAck".toLowerCase(), "RAck");
        headerNames.put("RSeq".toLowerCase(), "RSeq");
        headerNames.put("Reason".toLowerCase(), "Reason");
        headerNames.put("Refer-To".toLowerCase(), "Refer-To");
        headerNames.put("Reply-To".toLowerCase(), "Reply-To");
        headerNames.put("Retry-After".toLowerCase(), "Retry-After");
        headerNames.put("Server".toLowerCase(), "Server");
        headerNames.put("Subject".toLowerCase(), "Subject");
        headerNames.put("Subscription-State".toLowerCase(), "Subscription-State");
        headerNames.put("Timestamp".toLowerCase(), "Timestamp");
        headerNames.put("To".toLowerCase(), "To");
        headerNames.put("User-Agent".toLowerCase(), "User-Agent");
        headerNames.put("Accept".toLowerCase(), "Accept");
        headerNames.put("Accept-Encoding".toLowerCase(), "Accept-Encoding");
        headerNames.put("Accept-Language".toLowerCase(), "Accept-Language");
        headerNames.put("Alert-Info".toLowerCase(), "Alert-Info");
        headerNames.put("Allow".toLowerCase(), "Allow");
        headerNames.put("Allow-Events".toLowerCase(), "Allow-Events");
        headerNames.put("Authentication-Info".toLowerCase(), "Authentication-Info");
        headerNames.put("Call-Info".toLowerCase(), "Call-Info");
        headerNames.put("Contact".toLowerCase(), "Contact");
        headerNames.put("Content-Encoding".toLowerCase(), "Content-Encoding");
        headerNames.put("Content-Language".toLowerCase(), "Content-Language");
        headerNames.put("Error-Info".toLowerCase(), "Error-Info");
        headerNames.put("In-Reply-To".toLowerCase(), "In-Reply-To");
        headerNames.put("Proxy-Require".toLowerCase(), "Proxy-Require");
        headerNames.put("Record-Route".toLowerCase(), "Record-Route");
        headerNames.put("Require".toLowerCase(), "Require");
        headerNames.put("Route".toLowerCase(), "Route");
        headerNames.put("Supported".toLowerCase(), "Supported");
        headerNames.put("Unsupported".toLowerCase(), "Unsupported");
        headerNames.put("Warning".toLowerCase(), "Warning");
        headerNames.put("Via".toLowerCase(), "Via");
        headerNames.put("P-Asserted-Identity".toLowerCase(), "P-Asserted-Identity");
    }
}

