/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.address.AddressFactory;
import com.smile.telephony.sip.address.URI;
import com.smile.telephony.sip.header.ParametersHeader;
import java.text.ParseException;

public abstract class InfoHeader
extends ParametersHeader {
    protected URI uri;

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    @Override
    protected int parse(String value, int offset) throws ParseException {
        int i = value.indexOf(59, offset);
        if (i != -1) {
            this.parse(value.substring(offset, i));
            return super.parse(value, i + 1);
        }
        i = value.indexOf(44, offset);
        if (i != -1) {
            this.parse(value.substring(offset, i));
            return i;
        }
        this.parse(value.substring(offset));
        return value.length();
    }

    private void parse(String value) throws ParseException {
        int j;
        int i = value.indexOf(60);
        if (i != -1 && (j = value.indexOf(62)) != -1) {
            this.uri = AddressFactory.parseURI(value.substring(i, j));
        }
    }

    @Override
    protected String encodeBody() {
        Object body = super.encodeBody();
        if (this.uri != null) {
            body = "<" + this.uri.encode() + ">" + (String)body;
        }
        return body;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.uri.equals(((InfoHeader)obj).uri);
    }
}

