/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.header;

import com.smile.telephony.sip.header.Header;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;

public abstract class ParametersHeader
extends Header {
    protected HashMap parameters = new HashMap();

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.parameters.equals(((ParametersHeader)obj).parameters);
    }

    public String getParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public Iterator getParameterNames() {
        return this.parameters.keySet().iterator();
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public boolean hasParameter(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }

    public void removeParameters() {
        this.parameters.clear();
    }

    public HashMap getParameters() {
        return this.parameters;
    }

    public void setParameters(HashMap map) {
        this.parameters = map;
    }

    public int getIntParameter(String name) {
        Object value = this.parameters.get(name);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt((String)value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public float getFloatParameter(String name) {
        Object value = this.parameters.get(name);
        if (value == null) {
            return -1.0f;
        }
        try {
            return Float.parseFloat((String)value);
        }
        catch (NumberFormatException e) {
            return -1.0f;
        }
    }

    public boolean getBooleanParameter(String name) {
        Object value = this.parameters.get(name);
        if (value == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean((String)value);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    protected int parse(String str, int offset) throws ParseException {
        int i;
        String name = null;
        int n = i = offset;
        boolean quoted = false;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\"': {
                    quoted = !quoted;
                    break;
                }
                case ',': {
                    if (quoted) break;
                    if (name != null) {
                        this.setParameter(name, str.substring(n, i));
                    } else if (i > n) {
                        this.setParameter(str.substring(n, i), null);
                    }
                    return i + 1;
                }
                case '\t': 
                case ' ': {
                    if (quoted || name != null) break;
                    ++n;
                    break;
                }
                case '=': {
                    if (quoted) break;
                    name = str.substring(n, i);
                    n = i + 1;
                    break;
                }
                case ';': {
                    if (quoted) break;
                    if (name != null) {
                        this.setParameter(name, str.substring(n, i));
                        name = null;
                    } else if (i > n) {
                        this.setParameter(str.substring(n, i), null);
                    }
                    n = i + 1;
                }
            }
            ++i;
        }
        if (i > n) {
            if (name != null) {
                this.setParameter(name, str.substring(n, i));
            } else {
                this.setParameter(str.substring(n, i), null);
            }
        }
        return i;
    }

    public void parseParameter(String prm) {
        String value;
        String name;
        int i = prm.indexOf(61);
        if (i != -1) {
            name = prm.substring(0, i);
            value = prm.substring(i + 1);
        } else {
            name = prm;
            value = null;
        }
        this.parameters.put(name, value);
    }

    @Override
    protected String encodeBody() {
        Object retval = "";
        for (String key : this.parameters.keySet()) {
            Object value = this.parameters.get(key);
            retval = (String)retval + ";" + key;
            if (value == null) continue;
            retval = (String)retval + "=" + value.toString();
        }
        return retval;
    }
}

