/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.message;

import com.smile.telephony.sip.header.AuthorizationHeader;
import com.smile.telephony.sip.header.CSeqHeader;
import com.smile.telephony.sip.header.CallIdHeader;
import com.smile.telephony.sip.header.ContentDispositionHeader;
import com.smile.telephony.sip.header.ContentEncodingHeader;
import com.smile.telephony.sip.header.ContentLanguageHeader;
import com.smile.telephony.sip.header.ContentLengthHeader;
import com.smile.telephony.sip.header.ContentTypeHeader;
import com.smile.telephony.sip.header.ExpiresHeader;
import com.smile.telephony.sip.header.ExtensionHeader;
import com.smile.telephony.sip.header.FromHeader;
import com.smile.telephony.sip.header.Header;
import com.smile.telephony.sip.header.HeaderFactory;
import com.smile.telephony.sip.header.HeaderList;
import com.smile.telephony.sip.header.MaxForwardsHeader;
import com.smile.telephony.sip.header.ToHeader;
import com.smile.telephony.sip.header.ViaHeader;
import com.smile.telephony.sip.message.Request;
import com.smile.telephony.sip.message.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class Message {
    public static final String BRANCH_MAGIC_COOKIE = "z9hG4bK";
    public static final String DEFAULT_CHARSET = "UTF-8";
    protected String sipVersion = "SIP/2.0";
    protected HashMap headers = new HashMap();
    private byte[] contentBytes = null;
    private InputStream contentStream;

    abstract String getFirstLine();

    public void setSIPVersion(String version) {
        this.sipVersion = version;
    }

    public String getSIPVersion() {
        return this.sipVersion;
    }

    public Iterator getHeaderNames() {
        return this.headers.keySet().iterator();
    }

    public Iterator getHeaders() {
        return this.headers.values().iterator();
    }

    public ListIterator getHeaders(String headerName) {
        Header header = (Header)this.headers.get(headerName);
        if (header instanceof HeaderList) {
            return ((HeaderList)header).listIterator();
        }
        HeaderList headerList = new HeaderList(headerName);
        if (header != null) {
            headerList.add(header);
        }
        return headerList.listIterator();
    }

    public HeaderList getHeaderList(String headerName) {
        Header header = (Header)this.headers.get(headerName);
        if (header == null) {
            return null;
        }
        if (header instanceof HeaderList) {
            return (HeaderList)header;
        }
        HeaderList headerList = new HeaderList(headerName);
        headerList.add(header);
        return headerList;
    }

    public List getExtensionHeaders() {
        Vector list = new Vector();
        for (Object header : this.headers.values()) {
            if (!(header instanceof ExtensionHeader)) continue;
            list.add(header);
        }
        return list;
    }

    public Header getHeader(String headerName) {
        Header header = (Header)this.headers.get(headerName);
        if (header instanceof HeaderList) {
            header = ((HeaderList)header).getFirst();
        }
        return header;
    }

    public void addHeader(String string) throws ParseException {
        block4: {
            try {
                this.addHeader(HeaderFactory.createHeader(string));
            }
            catch (ParseException ex) {
                int n = string.indexOf(58);
                if (n == -1) {
                    throw ex;
                }
                String h = string.substring(0, n).trim();
                if (Header.isRequired(h) || h.equals("Contact")) {
                    throw ex;
                }
                if (HeaderList.isHeaderList(h)) break block4;
                ExtensionHeader eh = new ExtensionHeader(h);
                eh.setValue(string.substring(n + 1));
                this.headers.put(h, eh);
            }
        }
    }

    public void addHeader(Header header) {
        Object obj = this.headers.get(header.getName());
        if (obj instanceof HeaderList) {
            if (header instanceof HeaderList) {
                Iterator it = ((HeaderList)header).iterator();
                while (it.hasNext()) {
                    ((HeaderList)obj).add(it.next());
                }
            } else {
                ((HeaderList)obj).add(header);
            }
        } else if (!(header instanceof HeaderList) && HeaderList.isHeaderList(header.getName())) {
            HeaderList hlist = new HeaderList(header.getName());
            if (obj instanceof Header) {
                hlist.add(obj);
            }
            hlist.add(header);
            this.headers.put(header.getName(), hlist);
        } else {
            this.headers.put(header.getName(), header);
        }
    }

    public void removeHeader(String headerName) {
        this.headers.remove(headerName);
    }

    public boolean equals(Object obj) {
        return this.getClass().equals(obj.getClass()) && this.headers.equals(obj);
    }

    public ContentLengthHeader getContentLengthHeader() {
        return (ContentLengthHeader)this.getHeader("Content-Length");
    }

    public ContentTypeHeader getContentTypeHeader() {
        return (ContentTypeHeader)this.getHeader("Content-Type");
    }

    public FromHeader getFrom() {
        return (FromHeader)this.getHeader("From");
    }

    public HeaderList getContactHeaders() {
        return this.getHeaderList("Contact");
    }

    public HeaderList getViaHeaders() {
        return this.getHeaderList("Via");
    }

    public ViaHeader getTopmostVia() {
        ListIterator it = this.getHeaders("Via");
        if (!it.hasNext()) {
            return null;
        }
        return (ViaHeader)it.next();
    }

    public void setVia(List viaList) {
        HeaderList vList = new HeaderList("Via");
        ListIterator it = viaList.listIterator();
        while (it.hasNext()) {
            ViaHeader via = (ViaHeader)it.next();
            vList.add(via);
        }
        this.addHeader(vList);
    }

    public int getSequenceNumber() {
        CSeqHeader cseq = this.getCSeq();
        return cseq != null ? cseq.getSequenceNumber() : -1;
    }

    public CSeqHeader getCSeq() {
        return (CSeqHeader)this.getHeader("CSeq");
    }

    public AuthorizationHeader getAuthorization() {
        return (AuthorizationHeader)this.getHeader("Authorization");
    }

    public MaxForwardsHeader getMaxForwards() {
        return (MaxForwardsHeader)this.getHeader("Max-Forwards");
    }

    public void setMaxForwards(MaxForwardsHeader maxForwards) {
        this.addHeader(maxForwards);
    }

    public HeaderList getRouteHeaders() {
        return this.getHeaderList("Route");
    }

    public CallIdHeader getCallIdHeader() {
        return (CallIdHeader)this.getHeader("Call-ID");
    }

    public String getCallId() {
        return this.getCallIdHeader().getCallId();
    }

    public void setCallId(CallIdHeader callId) {
        this.addHeader(callId);
    }

    public void setCallId(String callId) {
        CallIdHeader callIDHeader = this.getCallIdHeader();
        if (callIDHeader == null) {
            callIDHeader = new CallIdHeader();
            this.addHeader(callIDHeader);
        }
        callIDHeader.setCallId(callId);
    }

    public HeaderList getRecordRouteHeaders() {
        return this.getHeaderList("Record-Route");
    }

    public ToHeader getTo() {
        return (ToHeader)this.getHeader("To");
    }

    public void setTo(ToHeader to) {
        this.addHeader(to);
    }

    public void setFrom(FromHeader from) {
        this.addHeader(from);
    }

    public boolean hasHeader(String headerName) {
        return this.headers.containsKey(headerName);
    }

    public String getToTag() {
        ToHeader toHeader = this.getTo();
        return toHeader == null ? null : toHeader.getTag();
    }

    public ContentDispositionHeader getContentDisposition() {
        return (ContentDispositionHeader)this.getHeader("Content-Disposition");
    }

    public ContentEncodingHeader getContentEncoding() {
        return (ContentEncodingHeader)this.getHeader("Content-Encoding");
    }

    public ContentLanguageHeader getContentLanguage() {
        return (ContentLanguageHeader)this.getHeader("Content-Language");
    }

    public ExpiresHeader getExpires() {
        return (ExpiresHeader)this.getHeader("Expires");
    }

    public void setExpires(ExpiresHeader expiresHeader) {
        this.addHeader(expiresHeader);
    }

    public void setContentDisposition(ContentDispositionHeader contentDispositionHeader) {
        this.addHeader(contentDispositionHeader);
    }

    public void setContentEncoding(ContentEncodingHeader contentEncodingHeader) {
        this.addHeader(contentEncodingHeader);
    }

    public void setContentLanguage(ContentLanguageHeader contentLanguageHeader) {
        this.addHeader(contentLanguageHeader);
    }

    public void setContentType(ContentTypeHeader contentTypeHeader) {
        this.addHeader(contentTypeHeader);
    }

    public void setContentLength(ContentLengthHeader contentLengthHeader) {
        this.addHeader(contentLengthHeader);
    }

    public void setContentLength(int contentLength) {
        ContentLengthHeader contentLengthHeader = this.getContentLengthHeader();
        if (contentLengthHeader == null) {
            contentLengthHeader = new ContentLengthHeader();
            this.addHeader(contentLengthHeader);
        }
        contentLengthHeader.setContentLength(contentLength);
    }

    public void setCSeq(CSeqHeader cseqHeader) {
        this.addHeader(cseqHeader);
    }

    public void setCSeqNumber(int number) {
        CSeqHeader cseqHeader = this.getCSeq();
        if (cseqHeader == null) {
            cseqHeader = new CSeqHeader();
            this.addHeader(cseqHeader);
        }
        cseqHeader.setSequenceNumber(number);
    }

    public int getContentLength() {
        ContentLengthHeader contentLengthHeader = this.getContentLengthHeader();
        return contentLengthHeader != null ? contentLengthHeader.getContentLength() : 0;
    }

    public InputStream getContentStream() {
        return this.contentStream;
    }

    public void setContentStream(InputStream stream) {
        this.contentStream = stream;
    }

    public void setContentBytes(byte[] content) {
        this.contentBytes = content;
    }

    public void setContent(Object content) {
        if (content instanceof byte[]) {
            this.contentBytes = (byte[])content;
        } else if (content instanceof InputStream) {
            this.contentStream = (InputStream)content;
        }
    }

    public void removeContent() {
        this.contentBytes = null;
        this.contentStream = null;
        this.setContentLength(0);
    }

    public Object getContent() {
        return this.contentBytes != null ? this.contentBytes : (byte[])this.contentStream;
    }

    public byte[] getContentBytes() {
        return this.contentBytes;
    }

    public byte[] getContentBytes(int maxbytes) {
        int clength;
        if (this.contentStream != null && (clength = Math.min(maxbytes, this.getContentLength())) > 0) {
            byte[] b = new byte[clength];
            try {
                int readlength;
                for (int nread = 0; nread < clength && (readlength = this.contentStream.read(b, nread, clength - nread)) > 0; nread += readlength) {
                }
                this.contentBytes = b;
                this.contentStream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.contentBytes;
    }

    public String getContentAsString() {
        if (this.contentBytes == null) {
            return "";
        }
        String charset = null;
        ContentTypeHeader contentTypeHeader = this.getContentTypeHeader();
        if (contentTypeHeader != null) {
            charset = contentTypeHeader.getCharset();
        }
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        try {
            return new String(this.contentBytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.contentBytes);
        }
    }

    protected String encodeHeaders() {
        Header header2;
        Object encoded = this.getFirstLine();
        ContentLengthHeader contentLengthHeader = this.getContentLengthHeader();
        if (contentLengthHeader == null) {
            contentLengthHeader = new ContentLengthHeader();
            if (this.contentBytes != null) {
                contentLengthHeader.setContentLength(this.contentBytes.length);
            }
        }
        if ((header2 = (Header)this.headers.get("Call-ID")) != null) {
            encoded = (String)encoded + header2.encode();
        }
        if ((header2 = (Header)this.headers.get("Via")) != null) {
            encoded = (String)encoded + header2.encode();
        }
        if ((header2 = (Header)this.headers.get("From")) != null) {
            encoded = (String)encoded + header2.encode();
        }
        if ((header2 = (Header)this.headers.get("To")) != null) {
            encoded = (String)encoded + header2.encode();
        }
        if ((header2 = (Header)this.headers.get("CSeq")) != null) {
            encoded = (String)encoded + header2.encode();
        }
        for (Header header2 : this.headers.values()) {
            if (header2 instanceof ContentLengthHeader || header2.isRequired()) continue;
            encoded = (String)encoded + header2.encode();
        }
        encoded = (String)encoded + contentLengthHeader.encode();
        encoded = (String)encoded + "\r\n";
        return encoded;
    }

    public String encodeAsString() {
        return this.encodeHeaders() + this.getContentAsString();
    }

    public byte[] encodeAsBytes() throws UnsupportedEncodingException {
        byte[] headers = this.encodeHeaders().getBytes(DEFAULT_CHARSET);
        if (this.contentBytes == null) {
            return headers;
        }
        byte[] msg = new byte[headers.length + this.contentBytes.length];
        System.arraycopy(headers, 0, msg, 0, headers.length);
        System.arraycopy(this.contentBytes, 0, msg, headers.length, this.contentBytes.length);
        return msg;
    }

    public String getDialogId(boolean isServer) {
        FromHeader from = this.getFrom();
        ToHeader to = this.getTo();
        String id = this.getCallId() + ":";
        id = !isServer ? id + from.getUserAtHost() + ":" + to.getUserAtHost() : id + to.getUserAtHost() + ":" + from.getUserAtHost();
        return id.toLowerCase();
    }

    public String getTransactionId() {
        ViaHeader topVia = null;
        HeaderList vialist = this.getViaHeaders();
        if (vialist != null && !vialist.isEmpty()) {
            topVia = (ViaHeader)this.getViaHeaders().get(0);
        }
        if (topVia != null && topVia.getBranch() != null && topVia.getBranch().toUpperCase().startsWith(BRANCH_MAGIC_COOKIE.toUpperCase())) {
            return topVia.getBranch();
        }
        FromHeader from = this.getFrom();
        ToHeader to = this.getTo();
        String id = from.getUserAtHost() + ":";
        if (from.hasTag()) {
            id = id + from.getTag() + ":";
        }
        id = id + to.getUserAtHost() + ":" + this.getCallId() + ":" + this.getSequenceNumber();
        if (topVia != null) {
            id = id + ":" + topVia.getHost() + ":" + (topVia.hasPort() ? topVia.getPort() : 5060);
        }
        return String.valueOf(id.hashCode());
    }

    public String getTransactionKey() {
        return this.getCSeq().getMethod().toLowerCase() + this.getCSeq().getSequenceNumber() + ";" + this.getTransactionId();
    }

    public String getSubsribeTransactionKey() {
        return this.getCallId() + ":" + this.getFrom().getTag() + ":" + this.getHeader("Event");
    }

    public String toString() {
        return this.encodeAsString();
    }

    public static Message parseMessage(String currentMessage) throws ParseException {
        Vector<String> messageHeaders = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(currentMessage, "\n", true);
        try {
            while (tokenizer.hasMoreElements()) {
                String nexttok = tokenizer.nextToken();
                if (nexttok.equals("\n")) {
                    String nextnexttok = tokenizer.nextToken();
                    if (!nextnexttok.equals("\n")) {
                        messageHeaders.add(nextnexttok);
                        continue;
                    }
                    break;
                }
                messageHeaders.add(nexttok);
            }
        }
        catch (NoSuchElementException nexttok) {
            // empty catch block
        }
        String firstLine = ((String)messageHeaders.elementAt(0)).trim();
        Message sipmsg = null;
        sipmsg = firstLine.startsWith("SIP") ? new Response(firstLine) : new Request(firstLine);
        for (int i = 1; i < messageHeaders.size(); ++i) {
            String hdrstring = (String)messageHeaders.elementAt(i);
            if (hdrstring.trim().equals("")) continue;
            sipmsg.addHeader(hdrstring);
        }
        return sipmsg;
    }
}

