/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.message;

import com.smile.telephony.sip.address.AddressFactory;
import com.smile.telephony.sip.address.URI;
import com.smile.telephony.sip.header.CSeqHeader;
import com.smile.telephony.sip.header.CallIdHeader;
import com.smile.telephony.sip.header.ContentTypeHeader;
import com.smile.telephony.sip.header.FromHeader;
import com.smile.telephony.sip.header.Header;
import com.smile.telephony.sip.header.HeaderList;
import com.smile.telephony.sip.header.MaxForwardsHeader;
import com.smile.telephony.sip.header.ToHeader;
import com.smile.telephony.sip.header.ViaHeader;
import com.smile.telephony.sip.message.Message;
import com.smile.telephony.sip.message.Response;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;

public final class Request
extends Message {
    public static final String ACK = "ACK";
    public static final String BYE = "BYE";
    public static final String CANCEL = "CANCEL";
    public static final String INVITE = "INVITE";
    public static final String OPTIONS = "OPTIONS";
    public static final String REGISTER = "REGISTER";
    public static final String NOTIFY = "NOTIFY";
    public static final String SUBSCRIBE = "SUBSCRIBE";
    public static final String MESSAGE = "MESSAGE";
    public static final String REFER = "REFER";
    public static final String INFO = "INFO";
    public static final String PRACK = "PRACK";
    public static final String UPDATE = "UPDATE";
    private URI uri;
    private String method;
    private String receivedAddress;
    private int receivedPort;
    private boolean isclient;

    public Request() {
    }

    public Request(String str) throws ParseException {
        int i = str.indexOf(32);
        int j = str.indexOf(32, i + 1);
        if (i == -1 || j == -1) {
            throw new ParseException(str, 0);
        }
        this.method = str.substring(0, i);
        this.uri = AddressFactory.parseURI(str.substring(i + 1, j));
        this.sipVersion = str.substring(j + 1);
    }

    public Request(URI uri, String method, CallIdHeader callId, CSeqHeader cSeq, FromHeader from, ToHeader to, List via, MaxForwardsHeader maxForwards) throws ParseException {
        this.uri = uri;
        this.method = method;
        this.addHeader(callId);
        this.addHeader(cSeq);
        this.addHeader(from);
        this.addHeader(to);
        this.setVia(via);
        this.addHeader(maxForwards);
    }

    public URI getRequestURI() {
        return this.uri;
    }

    public void setRequestURI(URI uri) {
        this.uri = uri;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    @Override
    public String getFirstLine() {
        return this.method + " " + this.uri.encode() + " " + this.sipVersion + "\r\n";
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Request r = (Request)obj;
        return this.method.equals(r.method) && this.uri.equals(r.uri) && super.equals(obj);
    }

    public Response createResponse(int statusCode, ContentTypeHeader contentType, byte[] content) throws ParseException {
        Response sipResponse = this.createResponse(statusCode, null);
        sipResponse.setContentType(contentType);
        sipResponse.setContent(content);
        return sipResponse;
    }

    public Response createResponse(int statusCode) {
        return this.createResponse(statusCode, null);
    }

    public Response createResponse(int statusCode, String reasonPhrase) {
        Response response = new Response();
        response.setStatusCode(statusCode);
        if (reasonPhrase != null) {
            response.setReasonPhrase(reasonPhrase);
        } else {
            response.setReasonPhrase(Response.getReasonPhrase(statusCode));
        }
        Iterator headerIterator = this.getHeaders();
        while (headerIterator.hasNext()) {
            Header nextHeader = (Header)headerIterator.next();
            String hname = nextHeader.getName();
            if (hname.equals("Via")) {
                ViaHeader via = (ViaHeader)((HeaderList)nextHeader).get(0);
                if (!this.receivedAddress.equals(via.getHost())) {
                    via.setReceived(this.receivedAddress);
                }
                if (via.hasRport()) {
                    via.setRport(this.receivedPort);
                }
                response.addHeader(nextHeader);
            }
            if (!hname.equals("Call-ID") && !hname.equals("From") && !hname.equals("To") && !hname.equals("CSeq") && !hname.equals("Max-Forwards") && !hname.equals("Record-Route")) continue;
            response.addHeader(nextHeader);
        }
        return response;
    }

    public void setReceived(String address, int port) {
        this.receivedAddress = address;
        this.receivedPort = port;
    }

    public String getReceivedAddress() {
        return this.receivedAddress;
    }

    public int getReceivedPort() {
        return this.receivedPort;
    }

    public boolean isFromClient() {
        return this.isclient;
    }

    public void setFromClient() {
        this.isclient = true;
    }
}

