/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.message;

import com.smile.telephony.sip.message.Message;
import java.text.ParseException;

public final class Response
extends Message {
    public static final int TRYING = 100;
    public static final int RINGING = 180;
    public static final int CALL_IS_BEING_FORWARDED = 181;
    public static final int QUEUED = 182;
    public static final int SESSION_PROGRESS = 183;
    public static final int OK = 200;
    public static final int ACCEPTED = 202;
    public static final int MULTIPLE_CHOICES = 300;
    public static final int MOVED_PERMANENTLY = 301;
    public static final int MOVED_TEMPORARILY = 302;
    public static final int USE_PROXY = 305;
    public static final int ALTERNATIVE_SERVICE = 380;
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int PAYMENT_REQUIRED = 402;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int METHOD_NOT_ALLOWED = 405;
    public static final int NOT_ACCEPTABLE = 406;
    public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int REQUEST_TIMEOUT = 408;
    public static final int GONE = 410;
    public static final int REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int REQUEST_URI_TOO_LONG = 414;
    public static final int UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int UNSUPPORTED_URI_SCHEME = 416;
    public static final int BAD_EXTENSION = 420;
    public static final int EXTENSION_REQUIRED = 421;
    public static final int INTERVAL_TOO_BRIEF = 423;
    public static final int TEMPORARILY_UNAVAILABLE = 480;
    public static final int CALL_OR_TRANSACTION_DOES_NOT_EXIST = 481;
    public static final int LOOP_DETECTED = 482;
    public static final int TOO_MANY_HOPS = 483;
    public static final int ADDRESS_INCOMPLETE = 484;
    public static final int AMBIGUOUS = 485;
    public static final int BUSY_HERE = 486;
    public static final int REQUEST_TERMINATED = 487;
    public static final int NOT_ACCEPTABLE_HERE = 488;
    public static final int BAD_EVENT = 489;
    public static final int REQUEST_PENDING = 491;
    public static final int UNDECIPHERABLE = 493;
    public static final int SERVER_INTERNAL_ERROR = 500;
    public static final int NOT_IMPLEMENTED = 501;
    public static final int BAD_GATEWAY = 502;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final int SERVER_TIMEOUT = 504;
    public static final int VERSION_NOT_SUPPORTED = 505;
    public static final int MESSAGE_TOO_LARGE = 513;
    public static final int BUSY_EVERYWHERE = 600;
    public static final int DECLINE = 603;
    public static final int DOES_NOT_EXIST_ANYWHERE = 604;
    public static final int SESSION_NOT_ACCEPTABLE = 606;
    protected int statusCode;
    protected String reasonPhrase = "";

    public static String getReasonPhrase(int rc) {
        String retval = null;
        switch (rc) {
            case 100: {
                retval = "Trying";
                break;
            }
            case 180: {
                retval = "Ringing";
                break;
            }
            case 181: {
                retval = "Call is being forwarded";
                break;
            }
            case 182: {
                retval = "Queued";
                break;
            }
            case 183: {
                retval = "Session progress";
                break;
            }
            case 200: {
                retval = "OK";
                break;
            }
            case 202: {
                retval = "Accepted";
                break;
            }
            case 300: {
                retval = "Multiple choices";
                break;
            }
            case 301: {
                retval = "Moved permanently";
                break;
            }
            case 302: {
                retval = "Moved Temporarily";
                break;
            }
            case 305: {
                retval = "Use proxy";
                break;
            }
            case 380: {
                retval = "Alternative service";
                break;
            }
            case 400: {
                retval = "Bad request";
                break;
            }
            case 401: {
                retval = "Unauthorized";
                break;
            }
            case 402: {
                retval = "Payment required";
                break;
            }
            case 403: {
                retval = "Forbidden";
                break;
            }
            case 404: {
                retval = "Not found";
                break;
            }
            case 405: {
                retval = "Method not allowed";
                break;
            }
            case 406: {
                retval = "Not acceptable";
                break;
            }
            case 407: {
                retval = "Proxy Authentication required";
                break;
            }
            case 408: {
                retval = "Request timeout";
                break;
            }
            case 410: {
                retval = "Gone";
                break;
            }
            case 480: {
                retval = "Temporarily Unavailable";
                break;
            }
            case 413: {
                retval = "Request entity too large";
                break;
            }
            case 414: {
                retval = "Request-URI too large";
                break;
            }
            case 415: {
                retval = "Unsupported media type";
                break;
            }
            case 416: {
                retval = "Unsupported URI Scheme";
                break;
            }
            case 420: {
                retval = "Bad extension";
                break;
            }
            case 421: {
                retval = "Etension Required";
                break;
            }
            case 423: {
                retval = "Interval too brief";
                break;
            }
            case 481: {
                retval = "Call leg/Transaction does not exist";
                break;
            }
            case 482: {
                retval = "Loop detected";
                break;
            }
            case 483: {
                retval = "Too many hops";
                break;
            }
            case 484: {
                retval = "Address incomplete";
                break;
            }
            case 485: {
                retval = "Ambiguous";
                break;
            }
            case 486: {
                retval = "Busy here";
                break;
            }
            case 487: {
                retval = "Request Terminated";
                break;
            }
            case 488: {
                retval = "Not Accpetable here";
                break;
            }
            case 489: {
                retval = "Bad Event";
                break;
            }
            case 491: {
                retval = "Request Pending";
                break;
            }
            case 500: {
                retval = "Server Internal Error";
                break;
            }
            case 493: {
                retval = "Undecipherable";
                break;
            }
            case 501: {
                retval = "Not implemented";
                break;
            }
            case 502: {
                retval = "Bad gateway";
                break;
            }
            case 503: {
                retval = "Service unavailable";
                break;
            }
            case 504: {
                retval = "Gateway timeout";
                break;
            }
            case 505: {
                retval = "SIP version not supported";
                break;
            }
            case 513: {
                retval = "Message Too Large";
                break;
            }
            case 600: {
                retval = "Busy everywhere";
                break;
            }
            case 603: {
                retval = "Decline";
                break;
            }
            case 604: {
                retval = "Does not exist anywhere";
                break;
            }
            case 606: {
                retval = "Session Not acceptable";
                break;
            }
            default: {
                retval = "Unkown Reason";
            }
        }
        return retval;
    }

    public Response() {
    }

    public Response(String str) throws ParseException {
        int i = str.indexOf(32);
        if (i == -1) {
            throw new ParseException(str, 0);
        }
        this.sipVersion = str.substring(0, i);
        String status = str.substring(i + 1);
        if ((i = status.indexOf(32)) != -1) {
            this.reasonPhrase = status.substring(i + 1);
            status = status.substring(0, i);
        }
        try {
            this.statusCode = Integer.parseInt(status);
        }
        catch (NumberFormatException e) {
            throw new ParseException(str, 0);
        }
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public boolean isFinalResponse() {
        return this.statusCode >= 200 && this.statusCode < 700;
    }

    @Override
    public String getFirstLine() {
        return this.sipVersion + " " + this.statusCode + " " + this.getReasonPhrase() + "\r\n";
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Response r = (Response)obj;
        return this.statusCode == r.statusCode && super.equals(r);
    }
}

