/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.stack;

import com.smile.telephony.sip.address.Address;
import com.smile.telephony.sip.address.SipURI;
import com.smile.telephony.sip.address.URI;
import com.smile.telephony.sip.header.CSeqHeader;
import com.smile.telephony.sip.header.CallIdHeader;
import com.smile.telephony.sip.header.ContactHeader;
import com.smile.telephony.sip.header.ContentLengthHeader;
import com.smile.telephony.sip.header.FromHeader;
import com.smile.telephony.sip.header.Header;
import com.smile.telephony.sip.header.HeaderList;
import com.smile.telephony.sip.header.RecordRouteHeader;
import com.smile.telephony.sip.header.RouteHeader;
import com.smile.telephony.sip.header.ToHeader;
import com.smile.telephony.sip.header.ViaHeader;
import com.smile.telephony.sip.message.Message;
import com.smile.telephony.sip.message.Request;
import com.smile.telephony.sip.message.Response;
import com.smile.telephony.sip.stack.ClientTransaction;
import com.smile.telephony.sip.stack.Hop;
import com.smile.telephony.sip.stack.MessageChannel;
import com.smile.telephony.sip.stack.ServerTransaction;
import com.smile.telephony.sip.stack.SipStack;
import com.smile.telephony.sip.stack.Transaction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TimerTask;

public class Dialog {
    protected static final int WINDOW_SIZE = 8;
    public static final int EARLY_STATE = 0;
    public static final int CONFIRMED_STATE = 1;
    public static final int COMPLETED_STATE = 2;
    public static final int TERMINATED_STATE = 3;
    private boolean reInviteFlag;
    private Request originalRequest;
    private Transaction firstTransaction;
    private Transaction lastTransaction;
    private String dialogId;
    private int localSequenceNumber = 0;
    private int remoteSequenceNumber = -1;
    private String myTag;
    private String hisTag;
    private HeaderList routeList = new HeaderList("Route");
    private RouteHeader contactRoute;
    private SipStack sipStack;
    private int dialogState = -1;
    private boolean ackSeen;
    protected Request lastAck;
    protected boolean ackProcessed;
    protected DialogTimerTask timerTask;
    protected Integer nextSeqno;
    private int retransmissionTicksLeft;
    private int prevRetransmissionTicks;
    protected CallIdHeader callIdHeader;

    protected Dialog() {
    }

    public Dialog(Transaction transaction) {
        this();
        this.sipStack = transaction.sipStack;
        this.addTransaction(transaction);
    }

    public void setDialogId(String id) {
        this.dialogId = id;
    }

    public int getState() {
        return this.dialogState;
    }

    public void setState(int state) {
        this.dialogState = state;
        if (state == 3) {
            this.sipStack.removeDialog(this);
            this.stopTimer();
        }
    }

    public void requestConsumed() {
        this.nextSeqno = new Integer(this.getRemoteSequenceNumber() + 1);
    }

    public boolean isRequestConsumable(Request dialogRequest) {
        if (this.getRemoteSequenceNumber() == -1) {
            return true;
        }
        if (this.nextSeqno == null) {
            return false;
        }
        return this.nextSeqno <= dialogRequest.getCSeq().getSequenceNumber();
    }

    public void ackReceived(Request sipRequest) {
        if (this.ackSeen) {
            return;
        }
        ServerTransaction tr = this.getInviteTransaction();
        if (tr != null && tr.getCSeq() == sipRequest.getCSeq().getSequenceNumber()) {
            this.ackSeen = true;
            this.lastAck = sipRequest;
            this.setState(1);
        }
    }

    public boolean isAckSeen() {
        return this.ackSeen;
    }

    public Request getLastAck() {
        return this.lastAck;
    }

    public Transaction getFirstTransaction() {
        return this.firstTransaction;
    }

    protected String getMethod() {
        return this.originalRequest.getMethod();
    }

    public Iterator getRouteSet() {
        return this.routeList.iterator();
    }

    public void setStack(SipStack sipStack) {
        this.sipStack = sipStack;
    }

    public void setRoutes(Message sipMessage) {
        HeaderList contactList;
        if (this.dialogState == 1 || this.dialogState == 2 || this.dialogState == 3) {
            return;
        }
        if (sipMessage instanceof Response && ((Response)sipMessage).getStatusCode() == 100) {
            return;
        }
        this.routeList = new HeaderList("Route");
        HeaderList rlist = sipMessage.getRecordRouteHeaders();
        if (rlist != null) {
            RecordRouteHeader rr;
            ListIterator li;
            if (sipMessage instanceof Request) {
                li = rlist.listIterator();
                while (li.hasNext()) {
                    rr = (RecordRouteHeader)li.next();
                    RouteHeader route = new RouteHeader();
                    route.setAddress((Address)rr.getAddress().clone());
                    route.setParameters((HashMap)rr.getParameters().clone());
                    this.routeList.add(route);
                }
            } else {
                li = rlist.listIterator(rlist.size());
                while (li.hasPrevious()) {
                    rr = (RecordRouteHeader)li.previous();
                    RouteHeader route = new RouteHeader();
                    route.setAddress((Address)rr.getAddress().clone());
                    route.setParameters((HashMap)rr.getParameters().clone());
                    this.routeList.add(route);
                }
            }
        }
        if ((contactList = sipMessage.getContactHeaders()) != null && contactList.size() > 0) {
            ContactHeader contact = (ContactHeader)contactList.getFirst();
            this.contactRoute = new RouteHeader();
            this.contactRoute.setAddress((Address)contact.getAddress().clone());
        }
    }

    public boolean isServer() {
        return this.firstTransaction instanceof ServerTransaction;
    }

    public boolean isInviteDialog() {
        return this.originalRequest.getMethod().equals("INVITE");
    }

    protected boolean isReInvite() {
        return this.reInviteFlag;
    }

    public String getDialogId() {
        if (this.firstTransaction instanceof ServerTransaction) {
            this.dialogId = this.originalRequest.getDialogId(true);
        }
        return this.dialogId;
    }

    public void addTransaction(Transaction transaction) {
        Request sipRequest = transaction.getRequest();
        if (this.firstTransaction != null && this.firstTransaction != transaction && transaction.getMethod().equals(this.firstTransaction.getMethod())) {
            this.reInviteFlag = true;
        }
        if (sipRequest.getMethod().equals("BYE")) {
            this.setState(2);
        }
        if (this.firstTransaction == null) {
            this.firstTransaction = transaction;
            this.originalRequest = sipRequest;
            if (transaction instanceof ServerTransaction) {
                this.hisTag = sipRequest.getFrom().getTag();
            } else {
                this.setLocalSequenceNumber(sipRequest.getCSeq().getSequenceNumber());
                this.myTag = sipRequest.getFrom().getTag();
                if (this.myTag == null) {
                    throw new RuntimeException("The request's From header is missing the required Tag parameter.");
                }
            }
        } else if (transaction.getMethod().equals(this.firstTransaction.getMethod()) && (this.firstTransaction instanceof ServerTransaction && transaction instanceof ClientTransaction || this.firstTransaction instanceof ClientTransaction && transaction instanceof ServerTransaction)) {
            this.firstTransaction = transaction;
            this.originalRequest = sipRequest;
        }
        if (transaction instanceof ServerTransaction) {
            this.setRemoteSequenceNumber(sipRequest.getCSeq().getSequenceNumber());
        }
        this.lastTransaction = transaction;
        transaction.setDialog(this);
    }

    public void setRemoteTag(String hisTag) {
        this.hisTag = hisTag;
    }

    public Transaction getLastTransaction() {
        return this.lastTransaction;
    }

    public ServerTransaction getInviteTransaction() {
        if (this.timerTask != null) {
            return this.timerTask.transaction;
        }
        return null;
    }

    protected void setLocalSequenceNumber(int lCseq) {
        this.localSequenceNumber = lCseq;
    }

    public void setRemoteSequenceNumber(int rCseq) {
        this.remoteSequenceNumber = rCseq;
    }

    public void incrementLocalSequenceNumber() {
        ++this.localSequenceNumber;
    }

    public int getRemoteSequenceNumber() {
        return this.remoteSequenceNumber;
    }

    public int getLocalSequenceNumber() {
        return this.localSequenceNumber;
    }

    public String getLocalTag() {
        return this.myTag;
    }

    public String getRemoteTag() {
        return this.hisTag;
    }

    public void setLocalTag(String mytag) {
        this.myTag = mytag;
    }

    protected void deleteTransactions() {
        this.firstTransaction = null;
        this.lastTransaction = null;
    }

    public void delete() {
        this.setState(3);
    }

    private Address getRemoteTarget() {
        if (this.contactRoute == null) {
            return null;
        }
        return this.contactRoute.getAddress();
    }

    public Hop getNextHop() throws Exception {
        int port;
        SipURI sipUri = null;
        if (!this.routeList.isEmpty()) {
            RouteHeader route = (RouteHeader)this.routeList.getFirst();
            sipUri = (SipURI)route.getAddress().getURI();
        } else if (this.contactRoute != null && this.contactRoute.getAddress().getURI() instanceof SipURI) {
            sipUri = (SipURI)this.contactRoute.getAddress().getURI();
        } else {
            throw new Exception("No route found!");
        }
        String host = sipUri.getMAddrParam() != null ? sipUri.getMAddrParam() : sipUri.getHost();
        String transport = sipUri.getTransportParam();
        if (transport == null) {
            transport = "UDP";
        }
        if ((port = sipUri.getPort()) == -1 && "TLS".equalsIgnoreCase(transport)) {
            port = 5061;
        }
        if (port == -1) {
            port = 5060;
        }
        return new Hop(host, port, transport);
    }

    public void sendAck(Request request) throws Exception {
        Hop hop;
        Request ackRequest = request;
        if (ackRequest.getMethod().equals("ACK") && (this.dialogState == -1 || this.dialogState == 0)) {
            throw new IllegalStateException("Bad dialog state " + this.dialogState);
        }
        if (ackRequest.getMethod().equals("PRACK") && this.dialogState == -1) {
            throw new IllegalStateException("Bad dialog state sending PRACK" + this.dialogState);
        }
        if (ackRequest.getMethod().equals("PRACK") && this.dialogState == 0) {
            this.setState(1);
        }
        if (!this.originalRequest.getCallId().equals(request.getCallId())) {
            throw new IllegalArgumentException("Bad call ID in request");
        }
        if (this.getLocalTag() != null) {
            ackRequest.getFrom().setTag(this.getLocalTag());
        }
        if (this.getRemoteTag() != null) {
            ackRequest.getTo().setTag(this.getRemoteTag());
        }
        if (ackRequest.getHeader("Route") == null) {
            if (this.routeList.size() > 0) {
                HeaderList routes = (HeaderList)this.routeList.clone();
                RouteHeader route = (RouteHeader)routes.getFirst();
                SipURI sipUri = (SipURI)route.getAddress().getURI();
                if (sipUri.hasLrParam()) {
                    ackRequest.setRequestURI(this.getRemoteTarget().getURI());
                    ackRequest.addHeader(routes);
                } else {
                    routes.removeFirst();
                    ackRequest.setRequestURI(sipUri);
                    if (routes.size() > 0) {
                        ackRequest.addHeader(routes);
                    }
                    if (this.contactRoute != null) {
                        ackRequest.addHeader(this.contactRoute);
                    }
                }
            } else if (this.getRemoteTarget() != null) {
                ackRequest.setRequestURI(this.getRemoteTarget().getURI());
            }
        }
        if ((hop = this.sipStack.getNextHop(request)) == null) {
            hop = this.getNextHop();
        }
        MessageChannel messageChannel = this.sipStack.getMessageChannel(hop);
        ClientTransaction clientTransaction = this.sipStack.createClientTransaction(messageChannel, ackRequest);
        this.sipStack.addTransaction(clientTransaction);
        clientTransaction.sendMessage(ackRequest);
        this.lastAck = ackRequest;
        clientTransaction.setState(5);
    }

    public Request createRequest(String method) throws Exception {
        if (this.dialogState == -1 || this.dialogState == 3 && !method.equalsIgnoreCase("BYE") || this.isServer() && this.dialogState == 0 && method.equalsIgnoreCase("BYE")) {
            throw new IllegalStateException("Dialog  " + this.getDialogId() + " not yet established or terminated " + this.dialogState);
        }
        Request newRequest = new Request();
        newRequest.setMethod(method);
        URI uri = this.isServer() ? this.originalRequest.getFrom().getAddress().getURI() : this.originalRequest.getTo().getAddress().getURI();
        newRequest.setRequestURI(uri);
        Iterator headerIterator = this.originalRequest.getHeaders();
        while (headerIterator.hasNext()) {
            Header nextHeader = (Header)headerIterator.next();
            String hname = nextHeader.getName();
            if (hname.equals("CSeq")) {
                CSeqHeader newCseq = (CSeqHeader)nextHeader.clone();
                nextHeader = newCseq;
                newCseq.setMethod(method);
            } else if (hname.equals("Via")) {
                ViaHeader via = (ViaHeader)((HeaderList)nextHeader).getFirst().clone();
                via.removeParameter("branch");
                nextHeader = via;
            } else if (hname.equals("To")) {
                ToHeader to = (ToHeader)nextHeader;
                if (this.isServer()) {
                    nextHeader = new FromHeader(to);
                    ((FromHeader)nextHeader).removeTag();
                } else {
                    nextHeader = (Header)to.clone();
                    ((ToHeader)nextHeader).removeTag();
                }
            } else if (hname.equals("From")) {
                FromHeader from = (FromHeader)nextHeader;
                if (this.isServer()) {
                    nextHeader = new ToHeader(from);
                    ((ToHeader)nextHeader).removeTag();
                } else {
                    nextHeader = (Header)from.clone();
                    ((FromHeader)nextHeader).removeTag();
                }
            } else if (hname.equals("Content-Length")) {
                ContentLengthHeader cl = (ContentLengthHeader)nextHeader.clone();
                cl.setContentLength(0);
                nextHeader = cl;
            } else if (!hname.equals("Call-ID") && !hname.equals("Max-Forwards")) continue;
            newRequest.addHeader(nextHeader);
        }
        if (!method.equals("ACK")) {
            CSeqHeader cseq = newRequest.getCSeq();
            cseq.setSequenceNumber(this.localSequenceNumber + 1);
        } else {
            Transaction transaction = this.lastTransaction;
            if (transaction == null) {
                throw new IllegalStateException("Could not create ack!");
            }
            Response response = this.lastTransaction.getLastResponse();
            if (response == null) {
                throw new IllegalStateException("Could not find response!");
            }
            int seqno = response.getCSeq().getSequenceNumber();
            CSeqHeader cseq = newRequest.getCSeq();
            cseq.setSequenceNumber(seqno);
        }
        if (this.isServer()) {
            newRequest.removeHeader("Via");
            newRequest.addHeader(this.sipStack.createViaHeader());
        }
        if (this.getLocalTag() != null) {
            newRequest.getFrom().setTag(this.getLocalTag());
        }
        if (this.getRemoteTag() != null) {
            newRequest.getTo().setTag(this.getRemoteTag());
        }
        if (this.routeList.size() > 0) {
            HeaderList routes = (HeaderList)this.routeList.clone();
            RouteHeader route = (RouteHeader)routes.getFirst();
            SipURI sipUri = (SipURI)route.getAddress().getURI();
            if (sipUri.hasLrParam()) {
                if (this.getRemoteTarget() != null) {
                    newRequest.setRequestURI(this.getRemoteTarget().getURI());
                }
                newRequest.addHeader(routes);
            } else {
                routes.removeFirst();
                newRequest.setRequestURI(sipUri);
                if (routes.size() > 0) {
                    newRequest.addHeader(routes);
                }
                if (this.contactRoute != null) {
                    newRequest.addHeader(this.contactRoute);
                }
            }
        } else if (this.getRemoteTarget() != null) {
            newRequest.setRequestURI(this.getRemoteTarget().getURI());
        }
        if (newRequest.getRequestURI() instanceof SipURI) {
            ((SipURI)newRequest.getRequestURI()).setTransportParam(newRequest.getTopmostVia().getTransport());
        }
        return newRequest;
    }

    public void sendRequest(ClientTransaction clientTransactionId) throws Exception {
        Hop hop;
        Request dialogRequest = clientTransactionId.getRequest();
        if (clientTransactionId == null) {
            throw new NullPointerException("null parameter");
        }
        if (dialogRequest.getMethod().equals("ACK") || dialogRequest.getMethod().equals("CANCEL")) {
            throw new IllegalArgumentException("Bad Request Method. " + dialogRequest.getMethod());
        }
        if (this.dialogState == -1) {
            throw new IllegalStateException("Bad dialog state " + this.getState());
        }
        if (dialogRequest.getTopmostVia() == null) {
            dialogRequest.addHeader(this.sipStack.createViaHeader());
        }
        if (!this.originalRequest.getCallId().equals(dialogRequest.getCallId())) {
            throw new IllegalArgumentException("Bad call ID in request");
        }
        clientTransactionId.dialog = this;
        this.addTransaction(clientTransactionId);
        clientTransactionId.isMapped = true;
        if (this.getLocalTag() != null) {
            dialogRequest.getFrom().setTag(this.getLocalTag());
        }
        if (this.getRemoteTag() != null) {
            dialogRequest.getTo().setTag(this.getRemoteTag());
        }
        if (dialogRequest.getHeader("Route") == null) {
            if (this.routeList.size() > 0) {
                HeaderList routes = (HeaderList)this.routeList.clone();
                RouteHeader route = (RouteHeader)routes.getFirst();
                SipURI sipUri = (SipURI)route.getAddress().getURI();
                if (sipUri.hasLrParam()) {
                    dialogRequest.setRequestURI(this.getRemoteTarget().getURI());
                    dialogRequest.addHeader(routes);
                } else {
                    routes.removeFirst();
                    dialogRequest.setRequestURI(sipUri);
                    if (routes.size() > 0) {
                        dialogRequest.addHeader(routes);
                    }
                    if (this.contactRoute != null) {
                        dialogRequest.addHeader(this.contactRoute);
                    }
                }
            } else if (this.getRemoteTarget() != null) {
                dialogRequest.setRequestURI(this.getRemoteTarget().getURI());
            }
        }
        try {
            hop = this.getNextHop();
        }
        catch (Exception se) {
            hop = this.sipStack.getNextHop(dialogRequest);
            if (hop != null) {
                hop = new Hop(hop.getHost(), hop.getPort(), hop.getTransport());
            }
            throw se;
        }
        MessageChannel messageChannel = this.sipStack.getMessageChannel(hop);
        clientTransactionId.setEncapsulatedChannel(messageChannel);
        ++this.localSequenceNumber;
        dialogRequest.getCSeq().setSequenceNumber(this.getLocalSequenceNumber());
        if (this.myTag != null) {
            dialogRequest.getFrom().setTag(this.myTag);
        }
        if (this.hisTag != null) {
            dialogRequest.getTo().setTag(this.hisTag);
        }
        clientTransactionId.sendMessage(dialogRequest);
        if (dialogRequest.getMethod().equalsIgnoreCase("BYE")) {
            this.setState(2);
        }
    }

    protected boolean toRetransmitFinalResponse() {
        if (--this.retransmissionTicksLeft == 0) {
            this.prevRetransmissionTicks = this.retransmissionTicksLeft = 2 * this.prevRetransmissionTicks;
            return true;
        }
        return false;
    }

    protected void setRetransmissionTicks() {
        this.retransmissionTicksLeft = 1;
        this.prevRetransmissionTicks = 1;
    }

    public void resendAck() throws Exception {
        if (this.lastAck != null) {
            this.sendAck(this.lastAck);
        }
    }

    protected void startTimer(ServerTransaction transaction) {
        if (this.timerTask != null && this.timerTask.transaction == transaction) {
            return;
        }
        this.ackSeen = false;
        if (this.timerTask != null) {
            this.timerTask.transaction = transaction;
        } else {
            this.timerTask = new DialogTimerTask(this, transaction);
            this.sipStack.timer.schedule((TimerTask)this.timerTask, 500L, 500L);
        }
        this.setRetransmissionTicks();
    }

    protected void stopTimer() {
        try {
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class DialogTimerTask
    extends TimerTask {
        Dialog dialog;
        SipStack stack;
        ServerTransaction transaction;

        public DialogTimerTask(Dialog dialog, ServerTransaction transaction) {
            this.dialog = dialog;
            this.stack = dialog.sipStack;
            this.transaction = transaction;
        }

        @Override
        public void run() {
            Response response;
            if (!this.dialog.ackSeen && (response = this.transaction.getLastResponse()).getStatusCode() == 200) {
                try {
                    if (this.dialog.toRetransmitFinalResponse()) {
                        this.transaction.sendMessage(response);
                    }
                }
                catch (Exception ex) {
                    this.dialog.setState(3);
                }
                finally {
                    this.transaction.fireTimer();
                }
            }
            if (this.dialog.isAckSeen() || this.dialog.dialogState == 3) {
                this.cancel();
                this.dialog.timerTask = null;
            }
        }
    }
}

