/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.stack;

import java.util.StringTokenizer;

public class Hop {
    private String host;
    private int port;
    private String transport;
    private boolean explicitRoute;
    private boolean defaultRoute;
    private boolean uriRoute;
    private int ttl;

    public String toString() {
        return this.host + ":" + this.port + "/" + this.transport;
    }

    public Hop(String hostName, int portNumber, String trans) {
        this.host = hostName;
        this.port = portNumber;
        this.transport = trans;
    }

    public Hop(String hop) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(hop + "/");
        String hostPort = stringTokenizer.nextToken("/").trim();
        this.transport = stringTokenizer.nextToken().trim();
        if (this.transport == null || this.transport.equals("")) {
            this.transport = "UDP";
        }
        String portString = null;
        if (hostPort.charAt(0) == '[') {
            int rightSqBrackIndex = hostPort.indexOf(93);
            if (rightSqBrackIndex == -1) {
                throw new IllegalArgumentException("Bad IPv6 reference spec");
            }
            this.host = hostPort.substring(0, rightSqBrackIndex + 1);
            int portColon = hostPort.indexOf(58, rightSqBrackIndex);
            if (portColon != -1) {
                try {
                    portString = hostPort.substring(portColon + 1).trim();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
        } else if (hostPort.indexOf(58) != hostPort.lastIndexOf(":")) {
            this.host = "[" + hostPort + "]";
        } else {
            int portColon = hostPort.indexOf(58);
            if (portColon == -1) {
                this.host = hostPort;
            } else {
                this.host = hostPort.substring(0, portColon).trim();
                try {
                    portString = hostPort.substring(portColon + 1).trim();
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        this.port = portString == null || portString.equals("") ? 5060 : Integer.parseInt(portString);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getTransport() {
        return this.transport;
    }

    public boolean isExplicitRoute() {
        return this.explicitRoute;
    }

    public boolean isDefaultRoute() {
        return this.defaultRoute;
    }

    public boolean isURIRoute() {
        return this.uriRoute;
    }

    public void setURIRouteFlag() {
        this.uriRoute = true;
    }

    public void setDefaultRouteFlag() {
        this.defaultRoute = true;
    }

    public void setExplicitRouteFlag() {
        this.explicitRoute = true;
    }

    public void setTTL(int t) {
        this.ttl = t;
    }

    public int getTTL() {
        return this.ttl;
    }
}

