/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.stack;

import com.smile.telephony.sip.message.Message;
import com.smile.telephony.sip.message.Request;
import com.smile.telephony.sip.message.Response;
import com.smile.telephony.sip.stack.MessageChannel;
import com.smile.telephony.sip.stack.SipMessageHandler;
import com.smile.telephony.sip.stack.SipStack;
import com.smile.telephony.sip.stack.TCPMessageProcessor;
import com.smile.telephony.sip.stack.TCPMessageSender;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.text.ParseException;
import java.util.List;
import java.util.Vector;

public class TCPMessageChannel
implements MessageChannel,
Runnable {
    private TCPMessageProcessor messageProcessor;
    private SipStack stack;
    private InetAddress peerAddress;
    private int peerPort;
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private TCPMessageSender sender;

    protected TCPMessageChannel(Socket sock, TCPMessageProcessor messageProcessor, SipStack stack) throws IOException {
        this.messageProcessor = messageProcessor;
        this.stack = stack;
        this.peerAddress = sock.getInetAddress();
        this.peerPort = sock.getPort();
        this.socket = sock;
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
        this.sender = new TCPMessageSender(this);
        new Thread(this).start();
    }

    public InetAddress getPeerAddress() {
        return this.peerAddress;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    @Override
    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sender.cancel();
        this.sender = null;
        this.messageProcessor.removeMessageChannel(this);
    }

    @Override
    public void sendMessage(Message sipMessage) throws IOException {
        if (this.sender == null) {
            throw new IOException();
        }
        this.sender.add(sipMessage);
    }

    public void send(Message sipMessage) throws IOException {
        int code;
        byte[] data = sipMessage.encodeAsBytes();
        this.outputStream.write(data);
        this.outputStream.flush();
        if (this.stack.channelLog()) {
            this.stack.log(this.hashCode() + "\t" + this.peerAddress + ":" + this.peerPort + "\t<-\t" + sipMessage.getCSeq().getSequenceNumber() + " " + sipMessage.getCSeq().getMethod() + " " + (Serializable)(sipMessage instanceof Response ? Integer.valueOf(((Response)sipMessage).getStatusCode()) : ""));
        }
        if (sipMessage instanceof Response && sipMessage.getCSeq().getMethod().equals("REGISTER") && ((code = ((Response)sipMessage).getStatusCode()) == 302 || sipMessage.hasHeader("Warning"))) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.close();
        }
    }

    public void processMessage(List requestLines) throws IOException {
        int contentLength;
        Message sipMessage = null;
        int i = 0;
        try {
            String requestLine = (String)requestLines.get(0);
            if (requestLine.startsWith("SIP")) {
                sipMessage = new Response(requestLine);
            } else {
                sipMessage = new Request(requestLine);
                ((Request)sipMessage).setReceived(this.peerAddress.getHostAddress(), this.peerPort);
            }
            for (i = 1; i < requestLines.size(); ++i) {
                sipMessage.addHeader((String)requestLines.get(i));
            }
        }
        catch (ParseException e) {
            if (this.stack.channelLog()) {
                this.stack.log(Thread.currentThread().getId() + "\t" + this.peerAddress + ":" + this.peerPort + "\tInvalid line: " + requestLines.get(i));
            }
            if (sipMessage instanceof Request) {
                Response response = new Response();
                response.setStatusCode(400);
                this.sendMessage(response);
            }
            return;
        }
        if (this.stack.channelLog()) {
            this.stack.log(this.hashCode() + "\t" + this.peerAddress + ":" + this.peerPort + "\t->\t" + sipMessage.getCSeq().getSequenceNumber() + " " + sipMessage.getCSeq().getMethod() + " " + (Serializable)(sipMessage instanceof Response ? Integer.valueOf(((Response)sipMessage).getStatusCode()) : ""));
        }
        if ((contentLength = sipMessage.getContentLength()) > 0) {
            if (contentLength < this.stack.getMaxMessageSize()) {
                int n;
                byte[] content = new byte[contentLength];
                for (int readBytes = 0; readBytes < contentLength && (n = this.inputStream.read(content, readBytes, contentLength - readBytes)) != -1; readBytes += n) {
                }
                sipMessage.setContentBytes(content);
            } else if (sipMessage instanceof Request) {
                Response response = new Response();
                response.setStatusCode(513);
                this.sendMessage(response);
                return;
            }
        }
        new Thread(new SipMessageHandler(sipMessage, this, this.stack)).start();
    }

    @Override
    public void run() {
        int id = this.hashCode();
        boolean log = this.stack.channelLog();
        Vector<Object> lines = new Vector<Object>();
        byte[] buf = new byte[4096];
        boolean crlf = false;
        int i = 0;
        int j = 0;
        try {
            this.stack.log(id + "\t" + this.peerAddress + ":" + this.peerPort + " connected");
            Object line = "";
            while (true) {
                int b;
                if ((b = this.inputStream.read()) == -1) {
                    if (log) {
                        this.stack.log(id + "\t" + this.peerAddress + ":" + this.peerPort + " end of stream");
                    }
                    break;
                }
                buf[i] = (byte)b;
                if (b == 10 && i > 0 && buf[i - 1] == 13) {
                    if (crlf) {
                        this.processMessage(lines);
                        crlf = false;
                        i = 0;
                        j = 0;
                        lines.clear();
                        continue;
                    }
                    crlf = true;
                } else if (crlf) {
                    if (b == 32 || b == 9) {
                        line = (String)line + new String(buf, j, i - j - 2).trim() + " ";
                        crlf = false;
                    } else {
                        line = (String)line + new String(buf, j, i - j).trim();
                        lines.add(line);
                        line = "";
                        if (b != 13) {
                            crlf = false;
                        }
                    }
                    j = i;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.stack.log(id + "\t" + this.peerAddress + ":" + this.peerPort + " " + e.toString());
        }
        this.close();
    }
}

