/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.stack;

import com.smile.telephony.sip.stack.Hop;
import com.smile.telephony.sip.stack.MessageChannel;
import com.smile.telephony.sip.stack.MessageProcessor;
import com.smile.telephony.sip.stack.SipStack;
import com.smile.telephony.sip.stack.TCPMessageChannel;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;

public class TCPMessageProcessor
implements MessageProcessor {
    protected SipStack sipStack;
    private Hashtable channels;

    public TCPMessageProcessor(SipStack sipStack, int port) throws Exception {
        this.sipStack = sipStack;
        this.channels = new Hashtable();
    }

    @Override
    public void dispose() {
        this.channels.clear();
    }

    protected Socket createSocket(InetAddress address, int port) throws Exception {
        return new Socket(address, port);
    }

    @Override
    public MessageChannel getMessageChannel(Hop hop, boolean reopen) throws Exception {
        String key = hop.getHost() + ":" + hop.getPort();
        MessageChannel channel = (MessageChannel)this.channels.get(key);
        if (channel == null && reopen) {
            InetAddress iaddress = InetAddress.getByName(hop.getHost());
            channel = new TCPMessageChannel(this.createSocket(iaddress, hop.getPort()), this, this.sipStack);
            this.channels.put(key, channel);
            String nkey = iaddress.getHostAddress() + ":" + hop.getPort();
            if (!key.equals(nkey)) {
                this.channels.put(nkey, channel);
            }
        }
        return channel;
    }

    protected void removeMessageChannel(TCPMessageChannel channel) {
        this.removeMessageChannel(channel.getPeerAddress(), channel.getPeerPort());
    }

    private void removeMessageChannel(InetAddress iaddress, int port) {
        String key = iaddress.getHostAddress() + ":" + port;
        this.channels.remove(key);
        String nkey = iaddress.getHostName() + ":" + port;
        if (!key.equals(nkey)) {
            this.channels.remove(nkey);
        }
    }
}

