/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.stack;

import com.smile.telephony.sip.message.Message;
import com.smile.telephony.sip.message.Request;
import com.smile.telephony.sip.message.Response;
import com.smile.telephony.sip.stack.Dialog;
import com.smile.telephony.sip.stack.MessageChannel;
import com.smile.telephony.sip.stack.ServerTransaction;
import com.smile.telephony.sip.stack.SipStack;
import com.smile.telephony.sip.stack.UDPMessageChannel;

public abstract class Transaction {
    public static final int CALLING = 0;
    public static final int TRYING = 1;
    public static final int PROCEEDING = 2;
    public static final int COMPLETED = 3;
    public static final int CONFIRMED = 4;
    public static final int TERMINATED = 5;
    protected static final int BASE_TIMER_INTERVAL = 500;
    protected static final int T1 = 1;
    protected static final int T4 = 10;
    protected static final int T2 = 8;
    protected static final int TIMER_A = 1;
    protected static final int TIMER_B = 64;
    protected static final int TIMER_J = 64;
    protected static final int TIMER_F = 64;
    protected static final int TIMER_H = 64;
    protected static final int TIMER_I = 10;
    protected static final int TIMER_K = 10;
    protected static final int TIMER_D = 64;
    protected static final int TIMER_C = 360;
    protected static final int MAXIMUM_RETRANSMISSION_TICK_COUNT = 8;
    public static final int TIMEOUT_ERROR = 1;
    public static final int TRANSPORT_ERROR = 2;
    public static final int TIMEOUT_RETRANSMIT = 3;
    protected Response lastResponse;
    protected Dialog dialog;
    protected boolean isMapped;
    protected boolean isAckSeen;
    protected String transactionId;
    protected String transactionKey;
    protected SipStack sipStack;
    protected Request request;
    protected MessageChannel messageChannel;
    private String branch;
    private String method;
    private int currentState;
    private int cSeq;
    private int timeoutTimerTicksLeft;
    private int retransmissionTimerLastTickCount;
    private int retransmissionTimerTicksLeft = -1;

    protected abstract void fireRetransmissionTimer();

    protected abstract void fireTimeoutTimer();

    protected Transaction(SipStack stack, MessageChannel channel, Request request) {
        this.sipStack = stack;
        this.messageChannel = channel;
        this.request = request;
        this.method = request.getMethod();
        this.cSeq = request.getCSeq().getSequenceNumber();
        this.transactionId = request.getTransactionId();
        this.transactionKey = request.getTransactionKey();
        this.disableRetransmissionTimer();
        this.disableTimeoutTimer();
        this.currentState = -1;
    }

    public Request getRequest() {
        return this.request;
    }

    public String getTransactionKey() {
        return this.transactionKey;
    }

    public final boolean isInviteTransaction() {
        return this.getMethod().equals("INVITE");
    }

    public final boolean isCancelTransaction() {
        return this.getMethod().equals("CANCEL");
    }

    public final boolean isByeTransaction() {
        return this.getMethod().equals("BYE");
    }

    public MessageChannel getMessageChannel() {
        return this.messageChannel;
    }

    public final void setBranch(String newBranch) {
        this.branch = newBranch;
    }

    public final String getBranch() {
        if (this.branch == null) {
            this.branch = this.request.getTopmostVia().getBranch();
        }
        return this.branch;
    }

    public final String getMethod() {
        return this.method;
    }

    public final int getCSeq() {
        return this.cSeq;
    }

    public void setState(int newState) {
        this.currentState = newState;
    }

    public int getState() {
        return this.currentState;
    }

    public final void enableRetransmissionTimer() {
        this.enableRetransmissionTimer(2);
    }

    public final void enableRetransmissionTimer(int tickCount) {
        this.retransmissionTimerLastTickCount = this.retransmissionTimerTicksLeft = Math.min(tickCount, 8);
    }

    public final void disableRetransmissionTimer() {
        this.retransmissionTimerTicksLeft = -1;
    }

    public final void enableTimeoutTimer(int tickCount) {
        this.timeoutTimerTicksLeft = tickCount;
    }

    public final void disableTimeoutTimer() {
        this.timeoutTimerTicksLeft = -1;
    }

    final void fireTimer() {
        try {
            if (this.timeoutTimerTicksLeft != -1 && --this.timeoutTimerTicksLeft == 0) {
                this.fireTimeoutTimer();
            }
            if (this.retransmissionTimerTicksLeft != -1 && --this.retransmissionTimerTicksLeft == 0) {
                this.enableRetransmissionTimer(this.retransmissionTimerLastTickCount * 2);
                this.fireRetransmissionTimer();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final boolean isTerminated() {
        return this.getState() == 5;
    }

    public boolean isReliable() {
        return !(this.messageChannel instanceof UDPMessageChannel);
    }

    public void sendMessage(Message messageToSend) throws Exception {
        this.messageChannel.sendMessage(messageToSend);
    }

    protected void processEvent(int errorEventID) {
        if (errorEventID == 3) {
            return;
        }
        if (errorEventID == 2) {
            this.setState(5);
            if (this instanceof ServerTransaction && this.isByeTransaction() && this.dialog != null) {
                this.dialog.setState(3);
            }
            this.disableTimeoutTimer();
            this.disableRetransmissionTimer();
        } else if (errorEventID == 1) {
            this.setState(5);
            if (this instanceof ServerTransaction && this.isByeTransaction() && this.dialog != null) {
                this.dialog.setState(3);
            }
        }
        try {
            this.sipStack.processTimeout(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean IsServerTransaction() {
        return this instanceof ServerTransaction;
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    public int getRetransmitTimer() {
        return 500;
    }

    public Response getLastResponse() {
        return this.lastResponse;
    }

    public Response getResponse() {
        return this.lastResponse;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public int hashCode() {
        if (this.transactionId == null) {
            return -1;
        }
        return this.transactionId.hashCode();
    }

    public void setRetransmitTimer(int retransmitTimer) {
        throw new UnsupportedOperationException("Feature not supported");
    }

    public void setEncapsulatedChannel(MessageChannel messageChannel) {
        this.messageChannel = messageChannel;
    }

    public void startTransactionTimer() {
        this.sipStack.startTransactionTimer(this);
    }
}

