/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.stack;

import com.smile.telephony.sip.stack.ClientTransaction;
import com.smile.telephony.sip.stack.SipStack;
import com.smile.telephony.sip.stack.Transaction;
import java.util.TimerTask;

public class TransactionTimer
extends TimerTask {
    private Transaction transaction;
    private SipStack sipStack;
    private boolean terminated;

    public TransactionTimer(Transaction transaction, SipStack sipStack) {
        this.transaction = transaction;
        this.sipStack = sipStack;
    }

    @Override
    public void run() {
        if (this.terminated) {
            this.sipStack.removeTransaction(this.transaction);
        } else if (this.transaction.isTerminated()) {
            this.cancel();
            if (this.transaction instanceof ClientTransaction) {
                this.sipStack.removeTransaction(this.transaction);
            } else {
                TransactionTimer task = new TransactionTimer(this.transaction, this.sipStack);
                task.terminated = true;
                this.sipStack.timer.schedule((TimerTask)task, 16000L);
            }
        } else {
            this.transaction.fireTimer();
        }
    }
}

