/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.sip.stack;

import com.smile.telephony.sip.stack.Hop;
import com.smile.telephony.sip.stack.MessageChannel;
import com.smile.telephony.sip.stack.MessageProcessor;
import com.smile.telephony.sip.stack.SipStack;
import com.smile.telephony.sip.stack.UDPMessageChannel;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.TimerTask;

public class UDPMessageProcessor
implements MessageProcessor,
Runnable {
    private SipStack sipStack;
    private int port;
    private DatagramSocket socket;
    private boolean isRunning;

    public UDPMessageProcessor(SipStack sipStack, int port) throws Exception {
        this.sipStack = sipStack;
        this.port = port;
        this.socket = new DatagramSocket(port, sipStack.getInetAddress());
        this.start();
    }

    public void start() throws IOException {
        this.isRunning = true;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.setName("UDPMessageProcessorThread");
        thread.setPriority(6);
        thread.start();
    }

    @Override
    public void run() {
        int bufsize = 8192;
        while (this.isRunning) {
            try {
                byte[] message = new byte[bufsize];
                DatagramPacket packet = new DatagramPacket(message, bufsize);
                this.socket.receive(packet);
                new UDPMessageChannel(packet, this, this.sipStack);
            }
            catch (IOException ex) {
                if (!this.isRunning) continue;
                System.out.println("SIP UDPMessageProcessor: " + ex.toString());
                this.isRunning = false;
                this.restart();
            }
            catch (Throwable ex) {
                System.out.println("SIP UDPMessageProcessor: " + ex.toString());
            }
        }
    }

    private void restart() {
        this.socket.close();
        TimerTask ttask = new TimerTask(){

            @Override
            public void run() {
                try {
                    UDPMessageProcessor.this.socket = new DatagramSocket(UDPMessageProcessor.this.port, UDPMessageProcessor.this.sipStack.getInetAddress());
                    UDPMessageProcessor.this.start();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        this.sipStack.timer.schedule(ttask, 1000L);
    }

    @Override
    public void dispose() {
        this.isRunning = false;
        this.socket.close();
    }

    public void send(DatagramPacket packet) throws IOException {
        this.socket.send(packet);
    }

    @Override
    public MessageChannel getMessageChannel(Hop hop, boolean reopen) throws IOException {
        return new UDPMessageChannel(InetAddress.getByName(hop.getHost()), hop.getPort(), this, this.sipStack);
    }

    public void onResponse(InetAddress address, String message) {
    }
}

