/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.video;

import com.smile.sound.WavAudioFormat;
import com.smile.telephony.AudioCodec;
import com.smile.telephony.CallInfo;
import com.smile.telephony.MediaSocket;
import com.smile.telephony.RouteSocket;
import com.smile.telephony.sip.SdpInfo;
import com.smile.telephony.sip.SipPort;
import com.smile.telephony.video.FrameBuffer;
import com.smile.telephony.video.SipVideoEndpoint;
import com.smile.telephony.video.VideoCapability;
import com.smile.telephony.video.VideoResource;
import com.smile.telephony.video.VideoSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SipVideoPort
extends SipPort
implements VideoResource {
    private int videomode;
    private Vector videoCapabilities;
    private VideoSocket videoSocket;
    private VideoResource routedVideo;
    private boolean pstart = false;
    private boolean rstart = false;
    private byte[] image = null;

    public SipVideoPort(String openKey) {
        super(openKey);
    }

    @Override
    public boolean setRoutedSocket(RouteSocket routeSocket) {
        if (!super.setRoutedSocket(routeSocket)) {
            return false;
        }
        if (routeSocket instanceof VideoResource) {
            this.routedVideo = (VideoResource)((Object)routeSocket);
        }
        return true;
    }

    public VideoResource getRoutedVideoResource() {
        return this.routedVideo;
    }

    @Override
    public void setEndpointProperties(Hashtable info) {
        super.setEndpointProperties(info);
        this.videomode = (this.parameters[5] & 0x8000) == 0 ? 0 : -1;
    }

    @Override
    public String makeCall(String calledParty, int timeout, CallInfo info) {
        this.videoCapabilities = (Vector)info.getAttribute("cti.VideoCapabilities");
        this.image = (byte[])info.getAttribute("cti.CalledUserIcon");
        return super.makeCall(calledParty, timeout, info);
    }

    @Override
    public boolean startPlayback(AudioCodec codec) {
        this.pstart = super.startPlayback(codec);
        return this.pstart;
    }

    @Override
    public boolean startRecord(AudioCodec codec) {
        this.rstart = super.startRecord(codec);
        return this.rstart;
    }

    @Override
    protected void clear() {
        super.clear();
        if (this.videoSocket != null) {
            try {
                this.videoSocket.close();
                Vector v = this.videoSocket.getSessionInfo();
                if (!v.isEmpty()) {
                    Object str = "";
                    Enumeration en = v.elements();
                    while (en.hasMoreElements()) {
                        Hashtable info = (Hashtable)en.nextElement();
                        Enumeration enn = info.keys();
                        while (enn.hasMoreElements()) {
                            String key = (String)enn.nextElement();
                            str = (String)str + key + "=" + info.get(key) + " ";
                        }
                        str = (String)str + "\r\n";
                    }
                    this.sesionInfo = this.sesionInfo + "Video session details:\r\n" + (String)str;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.videoSocket = null;
        this.routedVideo = null;
        this.videoCapabilities = null;
        this.pstart = false;
        this.rstart = false;
        this.image = null;
    }

    @Override
    public Hashtable getCallInfo() {
        Hashtable h = super.getCallInfo();
        if (h != null && this.videoSocket != null && this.videoCapabilities != null && !this.videoCapabilities.isEmpty()) {
            h.put("cti.VideoCodec", ((VideoCapability)this.videoCapabilities.elementAt(0)).getCodec());
        }
        return h;
    }

    @Override
    protected SdpInfo buildSDPContent(int[] caps, boolean nowait, boolean tsmit) {
        Vector vcaps;
        SdpInfo info = super.buildSDPContent(caps, nowait, tsmit);
        if (info == null) {
            return null;
        }
        boolean connect = this.pstart && this.rstart;
        SdpInfo rinfo = this.getRemoteSDPInfo();
        int mode = this.routedVideo != null ? this.routedVideo.getVideoMode() : 0;
        this.toLog(" buildSDPContent routedVideo=" + this.routedVideo + " mode=" + mode + " videomode=" + this.videomode + " socket=" + this.socket + " connect=" + connect + " rinfo=" + rinfo + " rcaps=" + (rinfo != null ? rinfo.getVideoCapabilities() : null));
        if (mode == -1 || this.videomode == -1 || this.socket != null && !(this.socket instanceof VideoResource)) {
            return info;
        }
        if (!(rinfo == null || rinfo.getVideoCapabilities() != null || connect && this.routedVideo != null)) {
            return info;
        }
        if (!connect && this.routedVideo != null && this.routedVideo.getVideoMode() == -1) {
            return info;
        }
        if (this.videoSocket == null) {
            Vector vector = vcaps = this.routedVideo != null ? this.routedVideo.getVideoCapabilities() : this.videoCapabilities;
            if (vcaps == null || vcaps.isEmpty()) {
                return info;
            }
            info.setVideoCapabilities(vcaps);
            this.videoSocket = new VideoSocket(this);
        } else if (this.videoCapabilities != null) {
            VideoCapability lcap = this.selectVideoCapability(this.videoCapabilities, this.routedVideo, nowait && tsmit);
            if (lcap == null) {
                info.setVideoCapabilities(new Vector());
                return info;
            }
            Vector<VideoCapability> lcaps = new Vector<VideoCapability>();
            lcaps.add(lcap);
            info.setVideoCapabilities(lcaps);
        } else if (rinfo == null && this.routedVideo != null) {
            vcaps = this.routedVideo.getVideoCapabilities();
            if (vcaps == null || vcaps.isEmpty()) {
                return info;
            }
            info.setVideoCapabilities(vcaps);
        } else {
            return info;
        }
        if (this.cryptokey != null) {
            this.videoSocket.setCryptoKey(this.cryptokey);
        } else {
            info.setVideoCrypto(this.getLocalVideoCryptoCapabilities());
        }
        int port = this.videoSocket.getLocalPort();
        if (this.routedVideo instanceof SipVideoPort && this.sigOnlyAddress) {
            port = ((SipVideoPort)this.routedVideo).videoSocket.getRemotePort();
        } else if (port == 0) {
            this.createRTPSession(this.videoSocket);
            port = this.videoSocket.getLocalPort();
        }
        if (this.endpoint.isStunUsable() && !this.endpoint.isNatUsable()) {
            port = this.videoSocket.getSocketLocalPort();
        }
        this.toLog(" buildSDPContent port=" + port + " mode=" + mode + " caps=" + this.videoCapabilities);
        this.videomode = mode;
        info.setVideoMode(mode);
        info.setVideoPort(port);
        return info;
    }

    @Override
    public boolean redefineMedia() {
        this.toLog(" redefineMedia videoSocket=" + this.videoSocket);
        if (this.videoSocket != null) {
            this.videoSocket.redefineMedia();
        }
        return super.redefineMedia();
    }

    @Override
    protected boolean needAckSDP() {
        SdpInfo info = this.getRemoteSDPInfo();
        if (info == null) {
            return false;
        }
        Vector caps = info.getVideoCapabilities();
        return caps != null && caps.size() > 1;
    }

    @Override
    protected void setMediaAddress(String remoteHost, int port, String origin) throws UnknownHostException {
        super.setMediaAddress(remoteHost, port, origin);
        SdpInfo info = this.getRemoteSDPInfo();
        if (info == null || this.videomode == -1) {
            return;
        }
        Vector vcaps = info.getVideoCapabilities();
        this.toLog(" setVideoAddress: " + remoteHost + ":" + port + " videoSocket=" + this.videoSocket + " vcaps=" + vcaps);
        if (vcaps != null && !vcaps.isEmpty()) {
            this.videoCapabilities = vcaps;
            if (this.videoSocket == null) {
                this.videoSocket = new VideoSocket(this);
            } else {
                this.selectVideoCapability(vcaps, this.routedVideo, true);
            }
            this.videomode = info.getVideoMode();
            InetAddress iaddress = super.getRemoteAddress();
            this.videoSocket.setRemoteAddress(iaddress, info.getVideoPort(), this.endpoint.hasDirectNetworkRoute(iaddress));
            Vector cryptoCaps = info.getVideoCrypto();
            if (cryptoCaps != null) {
                super.setRemoteVideoCryptoCapabilities(cryptoCaps);
                try {
                    this.videoSocket.setCryptoParameters(this.tsmVideoCryptoParameters, this.rcvVideoCryptoParameters);
                }
                catch (Exception e) {
                    this.toLog("setCryptoParameters - " + e.toString());
                }
            } else {
                this.videoSocket.removeCryptoParameters();
            }
        } else {
            this.videoCapabilities = null;
            if (this.videoSocket != null) {
                this.videoSocket.close();
                this.videoSocket = null;
            }
        }
        this.toLog(" setVideoAddress " + remoteHost + " caps=" + this.videoCapabilities);
    }

    protected VideoCapability selectVideoCapability(Vector vcaps, VideoResource routedVideo, boolean offer) {
        Vector rcaps = routedVideo != null ? routedVideo.getVideoCapabilities() : ((SipVideoEndpoint)this.sip).getVideoCapabilities();
        this.toLog(" selectVideoCapability routedVideo=" + routedVideo + " rcaps=" + rcaps + " vcaps=" + vcaps);
        if (rcaps == null || vcaps == null) {
            return null;
        }
        if (routedVideo instanceof MediaSocket) {
            Enumeration en = rcaps.elements();
            while (en.hasMoreElements()) {
                VideoCapability vc1 = (VideoCapability)en.nextElement();
                Enumeration enu = vcaps.elements();
                while (enu.hasMoreElements()) {
                    VideoCapability vc2 = (VideoCapability)enu.nextElement();
                    if (!vc1.equals(vc2)) continue;
                    if (offer) {
                        this.videoCapabilities.clear();
                        this.videoCapabilities.add(vc2);
                        return vc2;
                    }
                    this.videoCapabilities.clear();
                    this.videoCapabilities.add(vc1);
                    vc2.adjustCapabilities(vc1);
                    return vc1;
                }
            }
        } else {
            VideoCapability rcap = null;
            VideoCapability lcap = null;
            Enumeration en = vcaps.elements();
            while (en.hasMoreElements()) {
                VideoCapability vc2;
                VideoCapability vc1;
                this.toLog(" selectVideoCapability rcap=" + rcap + " lcap=" + lcap + " vc1=" + vc1 + " vc2=" + vc2 + (String)((vc2 = (vc1 = (VideoCapability)en.nextElement()).select(rcaps)) != null && rcap != null ? " pref=" + vc1.isPreferred(rcap) : ""));
                if (vc2 == null || rcap != null && !vc1.isPreferred(rcap)) continue;
                rcap = vc1;
                lcap = vc2;
            }
            if (rcap != null) {
                this.videoCapabilities.clear();
                this.videoCapabilities.add(rcap);
                return lcap.createCapability(rcap);
            }
        }
        return null;
    }

    @Override
    public void startTransmitter(Object ps, VideoCapability cap, FrameBuffer in) {
        this.toLog(" startVideoTransmitter videoSocket=" + this.videoSocket + " cap=" + cap + " socket=" + this.socket + " buf=" + this.isBuffered() + " ps=" + ps);
        if (this.videoSocket != null && this.isBuffered() && this.getLocalSDPInfo().getVideoMode() != 2) {
            if (ps instanceof VideoResource) {
                this.routedVideo = (VideoResource)ps;
            }
            this.videoSocket.startTransmitter(cap, in);
        }
    }

    @Override
    public void startReceiver(Object ps, VideoCapability cap, FrameBuffer out) {
        this.toLog(" startVideoReceiver videoSocket=" + this.videoSocket + " cap=" + cap + " socket=" + this.socket + " mr=" + this.isMediaRouting() + " ps=" + ps);
        if (this.videoSocket != null && super.isMediaRouting() && this.getLocalSDPInfo().getVideoMode() != 1) {
            if (ps instanceof VideoResource) {
                this.routedVideo = (VideoResource)ps;
            }
            this.videoSocket.startReceiver(cap, out, ps);
        }
    }

    @Override
    public void stopTransmitter(Object ps) {
        this.toLog(" stopVideoTransmitter videoSocket=" + this.videoSocket + " ps=" + ps);
        if (this.videoSocket != null) {
            this.videoSocket.stopTransmitter();
        }
    }

    @Override
    public void stopReceiver(Object ps) {
        this.toLog(" stopVideoReceiver videoSocket=" + this.videoSocket + " ps=" + ps);
        if (this.videoSocket != null) {
            this.videoSocket.stopReceiver();
        }
    }

    @Override
    public int getVideoMode() {
        return this.videomode;
    }

    @Override
    public Vector getVideoCapabilities() {
        return this.videoCapabilities;
    }

    public VideoSocket getVideoSocket() {
        return this.videoSocket;
    }

    @Override
    public double adjustRate(Object src, int ssrc, int rsrc, double rate) {
        if (this.videoSocket != null) {
            this.videoSocket.sendTMMBR(ssrc, rsrc, rate);
        }
        return -1.0;
    }

    @Override
    public int adjustFormat(Object ps, int ssrc, int rsrc, int seq, int index) {
        if (this.videoSocket != null) {
            this.videoSocket.sendTSTR(ssrc, rsrc, seq, index);
        }
        return -1;
    }

    public void sendRateNotification(int ssrc, double rate) {
        if (this.videoSocket != null) {
            this.videoSocket.sendTMMBN(ssrc, rate);
        }
    }

    public void sendFormatNotification(int ssrc, int seq, int index) {
        if (this.videoSocket != null) {
            this.videoSocket.sendTSTN(ssrc, seq, index);
        }
    }

    @Override
    public void keyFrameRequest(Object src, int ssrc, int rsrc) {
        if (this.videoSocket != null) {
            this.videoSocket.sendPLI(ssrc, rsrc);
        }
    }

    @Override
    public void decoderRefreshRequest(Object ps, int ssrc, int rsrc) {
        if (this.videoSocket != null) {
            this.videoSocket.sendFIR(ssrc, rsrc);
        }
    }

    public void nackRequest(int ssrc, int rsrc, int pid, int mask) {
        if (this.videoSocket != null) {
            this.videoSocket.sendNack(ssrc, rsrc, pid, mask);
        }
    }

    @Override
    public String processMediaControl(String str) {
        if (this.routedVideo instanceof SipVideoPort) {
            ((SipVideoPort)this.routedVideo).sendMediaControl(str);
            return null;
        }
        if (this.routedVideo != null && str.indexOf("picture_fast_update") != -1) {
            this.routedVideo.keyFrameRequest(this, 0, 0);
            return null;
        }
        return super.processMediaControl(str);
    }

    public void sendPictureFastUpdateRequest() {
        this.sendMediaControl("<?xml version=\"1.0\" encoding=\"utf-8\" ?><media_control><vc_primitive><to_encoder><picture_fast_update></picture_fast_update></to_encoder></vc_primitive></media_control>");
    }

    public FrameBuffer getStillImage() {
        return null;
    }

    @Override
    public int record(String filename, char[] signal_mask, int maxtime, int maxsilence, WavAudioFormat codec) {
        return -1;
    }

    @Override
    public int play(String filename, char[] term_mask, int maxtime) {
        return -1;
    }
}

