/*
 * Decompiled with CFR 0.152.
 */
package com.smile.telephony.video;

import com.smile.net.StunClient;
import com.smile.telephony.rtp.RTCP;
import com.smile.telephony.rtp.RTP;
import com.smile.telephony.rtp.RTPPacket;
import com.smile.telephony.rtp.SRTP;
import com.smile.telephony.video.Frame;
import com.smile.telephony.video.FrameBuffer;
import com.smile.telephony.video.SipVideoPort;
import com.smile.telephony.video.VideoCapability;
import com.smile.telephony.video.VideoResource;
import com.smile.telephony.video.VideoSocketTransmitter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Hashtable;
import java.util.Random;
import java.util.TimerTask;
import java.util.Vector;
import smile.util.ResourceStore;
import smile.util.Utils;

public class VideoSocket
implements Runnable {
    private static final int MTU = 1250;
    private static final int RCVBUF = 262144;
    private static final int SNDBUF = 524288;
    private static final int RCVBUFDELAY = 3000;
    private static final int MAXSEQLOST = 15;
    public static Random random = new Random(System.currentTimeMillis());
    private InetAddress remoteAddress;
    private int remotePort;
    private int localPort;
    private int exposedLocalPort;
    private String localAddress;
    private String cryptoParameters;
    private SipVideoPort media;
    private VideoSocketTransmitter transmitter;
    private DatagramSocket socket;
    private RTCP rtcp;
    private SRTP srtpT;
    private SRTP srtpR;
    private boolean first;
    private boolean running;
    private boolean dmz;
    private boolean nat;
    private boolean sym;
    private int totalPacketsSent = 0;
    private int totalOctetsSent = 0;
    private int totalPacketsReceived = 0;
    private int totalOctetsReceived = 0;
    private int mtu = 1250;
    private long minRcvBufferDelay;
    private long rcvBufferDelay = this.minRcvBufferDelay = 270000L;
    private int roundTripDelay = 200;
    private double minMediaRate = 32000.0;
    private double maxMediaRate = 0.0;
    private double targetRate = 2.147483647E9;
    private int llcount = 0;
    public static final int MAXBUFSIZE = 8192;
    private static final byte[] NAL_PREFIX = new byte[]{0, 0, 1};
    private VideoCapability capability;
    private int payloadType;
    private int currentSsrc;
    private int oldssrc;
    private int expectedSeqnumber;
    private long passedTimestamp;
    private FrameBuffer output;
    private ByteArrayOutputStream fuaBuffer;
    private boolean inwork = false;
    private VideoSocket pipe;
    private boolean nack = false;
    private boolean fir = false;
    private boolean pli = false;
    private long last_pli = 0L;
    private Vector<RTPPacket> queue = new Vector();
    private Hashtable nacks = new Hashtable();
    private Frame lastKeyFrame;

    public VideoSocket(SipVideoPort media) {
        this.media = media;
        this.localPort = 0;
    }

    public void createDatagramSocket(int port, InetAddress address, int tos, boolean symnat) throws Exception {
        this.socket = new DatagramSocket(port, address);
        this.exposedLocalPort = this.localPort = this.socket.getLocalPort();
        if (!address.isAnyLocalAddress() && !address.isLoopbackAddress()) {
            this.localAddress = address.getHostAddress();
        }
        if (tos != 0) {
            try {
                this.socket.setTrafficClass(tos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.rtcp = new RTCP(this, new DatagramSocket(this.socket.getLocalPort() + 1, address));
        if (this.remoteAddress != null) {
            this.rtcp.setRemoteAddress(this.remoteAddress, this.remotePort + 1);
        }
        this.rtcp.setReportInterval(2500);
        this.rtcp.open();
        this.sym = symnat;
        this.running = true;
    }

    public void setStunAddress(InetAddress stunAddress, int stunPort) {
        if (stunAddress == null) {
            return;
        }
        StunClient stun = new StunClient(this.socket);
        stun.sendRequest(stunAddress, stunPort);
        String addr = stun.getReturnAddress();
        if (addr != null) {
            this.localAddress = addr;
            this.exposedLocalPort = stun.getReturnPort();
            this.nat = true;
        }
    }

    public void redefineMedia() {
        if (this.nat && this.localAddress != null && !this.localAddress.equals(this.socket.getLocalAddress().getHostAddress())) {
            this.localAddress = null;
            this.exposedLocalPort = this.localPort;
            this.nat = false;
        }
    }

    public void setRemoteAddress(InetAddress iaddress, int port, boolean isdir) {
        this.dmz = true;
        if (this.nat && this.remoteAddress != null && !this.remoteAddress.isSiteLocalAddress() && iaddress.isSiteLocalAddress()) {
            this.localAddress = null;
            this.exposedLocalPort = this.localPort;
            this.nat = false;
        }
        this.remoteAddress = iaddress;
        this.remotePort = port;
        if (this.rtcp != null) {
            this.rtcp.setRemoteAddress(iaddress, port + 1);
        }
        this.first = true;
        this.toLog("setRemoteVideoAddress " + this.remoteAddress + ":" + this.remotePort + " dmz=" + this.dmz + " localAddress=" + this.localAddress + ":" + this.exposedLocalPort);
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getCryptoParameters() {
        return this.cryptoParameters;
    }

    public void setMTU(int m) {
        this.mtu = m;
    }

    public int getMTU() {
        return this.mtu;
    }

    public void setMinBuffer(int millis) {
        this.rcvBufferDelay = this.minRcvBufferDelay = (long)(millis * 90);
    }

    public long getMaxBuffer() {
        return this.rcvBufferDelay;
    }

    public String toString() {
        return "VideoSocket " + this.remoteAddress + ":" + this.remotePort;
    }

    public void close() {
        this.running = false;
        if (this.transmitter != null) {
            this.transmitter.close();
        }
        Thread cleaner = new Thread(){

            @Override
            public void run() {
                if (VideoSocket.this.rtcp != null) {
                    VideoSocket.this.rtcp.close();
                }
                if (VideoSocket.this.socket != null) {
                    VideoSocket.this.socket.close();
                }
            }
        };
        cleaner.start();
    }

    public void removeCryptoParameters() {
        this.cryptoParameters = null;
        this.srtpT = null;
        this.srtpR = null;
    }

    public void setCryptoParameters(String tsm, String rcv) throws Exception {
        this.toLog("setCryptoParameters tsm=" + tsm + " rcv=" + rcv);
        this.cryptoParameters = tsm;
        if (tsm != null) {
            this.srtpT = new SRTP(tsm);
        }
        if (rcv != null) {
            this.srtpR = new SRTP(rcv);
        }
    }

    public void setCryptoKey(byte[] key) {
        this.srtpT = new SRTP(key);
        this.srtpR = new SRTP(key);
        this.toLog("setCryptoKey srtpT=" + this.srtpT + " srtpR=" + this.srtpR);
    }

    public Vector getSessionInfo() {
        return this.rtcp.getSessionInfo();
    }

    public String getReceiveCodec() {
        return this.rtcp.getReceiveCodec();
    }

    public String getSendCodec() {
        return this.rtcp.getReceiveCodec();
    }

    public int getPacketsSent() {
        int n = this.totalPacketsSent;
        this.totalPacketsSent = 0;
        return n;
    }

    public int getOctetsSent() {
        int n = this.totalOctetsSent;
        this.totalOctetsSent = 0;
        return n;
    }

    public int getPacketsReceived() {
        int n = this.totalPacketsReceived;
        this.totalPacketsReceived = 0;
        return n;
    }

    public int getOctetsReceived() {
        int n = this.totalOctetsReceived;
        this.totalOctetsReceived = 0;
        return n;
    }

    public int getPacketsLost() {
        return this.rtcp.getPacketsLost();
    }

    public int getJitter() {
        return this.rtcp.getJitter();
    }

    public int getJitterMax() {
        return this.rtcp.getJitterMax();
    }

    public int getPacketsSentLost() {
        return this.rtcp.getPacketsSentLost();
    }

    public int getJitterFarEnd() {
        return this.rtcp.getJitterFarEnd();
    }

    public int getDelay() {
        return this.rtcp.getDelay();
    }

    public int getDelayMax() {
        return this.rtcp.getDelayMax();
    }

    public int getSocketLocalPort() {
        return this.socket.getLocalPort();
    }

    public int getLocalPort() {
        return this.exposedLocalPort;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void startReceiver(VideoCapability cap, FrameBuffer out, Object ps) {
        if (this.socket == null) {
            this.media.createRTPSession(this);
        }
        this.startReceive(cap, out, ps);
    }

    public void stopReceiver() {
        if (this.inwork) {
            this.stopReceive();
        }
    }

    public void startTransmitter(VideoCapability cap, FrameBuffer in) {
        if (this.socket == null) {
            this.media.createRTPSession(this);
        }
        if (this.transmitter == null) {
            this.transmitter = new VideoSocketTransmitter(this);
        }
        this.transmitter.start(cap, in);
    }

    public void stopTransmitter() {
        if (this.transmitter != null) {
            this.transmitter.stop();
        }
    }

    public boolean isTransmit() {
        return this.transmitter != null && this.transmitter.isRunning();
    }

    public int getTransmitCodecType() {
        if (this.transmitter == null) {
            return -1;
        }
        return this.transmitter.getPayloadType();
    }

    public int getReceiveCodecType() {
        if (!this.inwork) {
            return -1;
        }
        return this.getPayloadType();
    }

    public void onRTCPPacket(byte[] data, int length) throws Exception {
        VideoSocket vs = this.getPipe();
        if (vs != null) {
            vs.sendRTCPPacket(data, length);
        }
    }

    public void onReceiverReport(int ssrc, int rsrc, double mediaRate, double fraction, long roundTrip) {
        this.toLog(" ssrc" + rsrc + ": fraction=" + fraction + " mediaRate=" + mediaRate + " targetRate=" + this.targetRate + " maxMediaRate=" + this.maxMediaRate);
        if (mediaRate > this.maxMediaRate) {
            this.maxMediaRate = mediaRate;
        }
        double c = 0.0;
        if (fraction == 0.0) {
            if (this.targetRate < this.maxMediaRate && ++this.llcount > 3) {
                this.adjustRate(rsrc, ssrc, this.targetRate + Math.pow(2.0, 15.0));
                this.llcount = 0;
            }
        } else {
            this.llcount = 0;
            if (fraction > 2.0 && this.targetRate > this.minMediaRate) {
                c = (100.0 - fraction * 2.0) / 100.0;
                if (c < 0.5) {
                    c = 0.5;
                }
                this.adjustRate(rsrc, ssrc, c * Math.min(this.targetRate, this.maxMediaRate));
            }
        }
        if (roundTrip > 0L) {
            this.roundTripDelay = (int)((double)roundTrip * 1.4);
            this.rcvBufferDelay = Math.max((long)(this.roundTripDelay * 90), this.minRcvBufferDelay);
        }
    }

    public void adjustRate(int ssrc, int rsrc, double rate) {
        if (this.media.isCallDisconnected()) {
            return;
        }
        VideoResource routedVideo = this.media.getRoutedVideoResource();
        if (routedVideo != null) {
            if (!(routedVideo instanceof SipVideoPort) && this.transmitter != null && this.transmitter.getSyncSource() != rsrc) {
                return;
            }
            double newrate = routedVideo.adjustRate(this.media, ssrc, rsrc, rate);
            if (newrate != -1.0) {
                this.sendTMMBN(rsrc, newrate);
            }
            this.toLog(" adjustRate rate=" + rate + " newrate=" + newrate + " targetRate=" + this.targetRate);
        }
    }

    public void rateChangeRequest(int ssrc, int rsrc, double rate) {
        this.toLog(" RTP_FEEDBACK: TMMBR ssrc=" + ssrc + " rsrc=" + rsrc + " rate=" + rate);
        this.adjustRate(ssrc, rsrc, rate);
    }

    public void rateChangeNotification(int ssrc, double rate) {
        this.toLog(" RTP_FEEDBACK: TMMBN ssrc=" + ssrc + " rate=" + rate);
        VideoResource routedVideo = this.media.getRoutedVideoResource();
        if (routedVideo instanceof SipVideoPort) {
            ((SipVideoPort)routedVideo).sendRateNotification(ssrc, rate);
        }
    }

    public void temporalSpatialRequest(int ssrc, int rsrc, int seq, int index) {
        this.toLog(" RTP_FEEDBACK: TSTR ssrc=" + ssrc + " rsrc=" + rsrc + " seq=" + seq + " index=" + index);
        VideoResource routedVideo = this.media.getRoutedVideoResource();
        if (routedVideo != null) {
            int newindex = routedVideo.adjustFormat(this.media, ssrc, rsrc, seq, index);
            if (newindex != -1) {
                this.sendTSTN(rsrc, seq, newindex);
            }
            this.toLog(" temporalSpatialRequest seq=" + seq + " newindex=" + newindex);
        }
    }

    public void temporalSpatialNotification(int ssrc, int seq, int index) {
        this.toLog(" RTP_FEEDBACK: TSTN ssrc=" + ssrc + " seq=" + seq + " index=" + index);
        VideoResource routedVideo = this.media.getRoutedVideoResource();
        if (routedVideo instanceof SipVideoPort) {
            ((SipVideoPort)routedVideo).sendFormatNotification(ssrc, seq, index);
        }
    }

    public void pictureLostIndication(int ssrc, int rsrc) {
        this.toLog(" RTP_FEEDBACK: PLI ssrc=" + ssrc + " rsrc=" + rsrc);
        VideoResource routedVideo = this.media.getRoutedVideoResource();
        if (routedVideo != null) {
            routedVideo.keyFrameRequest(this.media, ssrc, rsrc);
        }
        if (this.transmitter != null) {
            this.transmitter.clearStore();
        }
    }

    public void decoderRefreshRequest(int ssrc, int rsrc) {
        this.toLog(" RTP_FEEDBACK: FIR ssrc=" + ssrc + " rsrc=" + rsrc);
        VideoResource routedVideo = this.media.getRoutedVideoResource();
        if (routedVideo != null) {
            routedVideo.decoderRefreshRequest(this.media, ssrc, rsrc);
        }
    }

    public void nack(int ssrc, int rsrc, int pid, int mask) {
        VideoResource routedVideo = this.media.getRoutedVideoResource();
        if (routedVideo instanceof SipVideoPort) {
            ((SipVideoPort)routedVideo).nackRequest(ssrc, rsrc, pid, mask);
        } else if (this.transmitter != null) {
            this.transmitter.nackReceived(rsrc, pid, mask);
        }
    }

    public void sendNack(int ssrc, int mssrc, int pid, int mask) {
        this.rtcp.sendNack(ssrc, mssrc, pid, mask);
    }

    public void sendFIR(int ssrc, int mssrc) {
        this.rtcp.sendFIR(ssrc, mssrc);
        this.toLog(" sendFIR: ssrc=" + ssrc + " mssrc=" + mssrc);
    }

    public void sendPLI(int ssrc, int mssrc) {
        this.rtcp.sendPLI(ssrc, mssrc);
        this.toLog(" sendPLI: ssrc=" + ssrc + " mssrc=" + mssrc + " ls=" + this.rtcp.getLocalSources().keySet());
    }

    public void sendTMMBR(int ssrc, int rsrc, double rate) {
        this.rtcp.sendTMMBR(ssrc, rsrc, rate);
        this.toLog(" sendTMMBR: ssrc=" + ssrc + " rsrc=" + rsrc + " rate=" + rate);
    }

    public void sendTMMBN(int rsrc, double rate) {
        this.rtcp.sendTMMBN(rsrc, rate);
        this.targetRate = rate;
        this.toLog(" sendTMMBN: rsrc=" + rsrc + " rate=" + rate);
    }

    public void sendTSTR(int ssrc, int rsrc, int seq, int index) {
        if (ssrc == 0) {
            ssrc = this.rtcp.findSSRC(this.remoteAddress.getHostAddress(), this.remotePort);
        }
        this.rtcp.sendTSTR(ssrc, rsrc, seq, index);
        this.toLog(" sendTSTR: ssrc=" + ssrc + " rsrc=" + rsrc + " seq=" + seq + " index=" + index);
    }

    public void sendTSTN(int rsrc, int seq, int index) {
        this.rtcp.sendTSTN(rsrc, seq, index);
        this.toLog(" sendTSTN: rsrc=" + rsrc + " seq=" + seq + " index=" + index);
    }

    public void sendRTCPPacket(byte[] buffer, int len) throws Exception {
        this.rtcp.send(buffer, len);
    }

    public void sendRTPPacket(byte[] buffer, int len) throws Exception {
        this.sendRTPPacket(new RTPPacket(buffer, len));
    }

    public void sendRTPPacket(RTPPacket packet) throws Exception {
        this.sendRTPPacket(packet, this.srtpT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRTPPacket(RTPPacket packet, SRTP srtp) throws Exception {
        block7: {
            if (!this.running || this.remoteAddress == null) {
                return;
            }
            if (srtp != null) {
                srtp.encrypt(packet);
            }
            try {
                VideoSocket videoSocket = this;
                synchronized (videoSocket) {
                    this.socket.send(new DatagramPacket(packet.getBuffer(), packet.getSize(), this.remoteAddress, this.remotePort));
                }
                this.rtcp.onSendData(packet, this.remoteAddress.getHostAddress(), this.remotePort);
                ++this.totalPacketsSent;
                this.totalOctetsSent += packet.getSize() + 20;
            }
            catch (Exception e) {
                if (this.totalPacketsSent != 0 || this.media.getServerAddress() == null) break block7;
                this.remoteAddress = this.media.getServerAddress();
                this.rtcp.setRemoteAddress(this.remoteAddress, this.remotePort + 1);
                ResourceStore.toLog("setRemoteAddress " + this.remoteAddress);
            }
        }
    }

    public void sendDumb(int payloadType) {
        try {
            RTPPacket packet = new RTPPacket(16);
            packet.setPayloadType(0);
            packet.setTimestamp(System.currentTimeMillis());
            packet.setSequenceNumber(1);
            this.rtcp.send(packet.getBuffer(), packet.getSize());
            if (this.srtpT != null) {
                this.srtpT.encrypt(packet);
            }
            DatagramPacket p = new DatagramPacket(packet.getBuffer(), packet.getSize(), this.remoteAddress, this.remotePort);
            this.socket.send(p);
            this.toLog("VideoReceiver-" + this.hashCode() + " send " + p.getLength() + " byte packet to " + this.remoteAddress + ":" + this.remotePort);
        }
        catch (Exception e) {
            System.out.println("Sending initial packet: " + e.toString());
        }
    }

    public void startReceive(VideoCapability cap, FrameBuffer out, Object ps) {
        this.capability = cap;
        this.output = out;
        this.pipe = ps instanceof SipVideoPort ? ((SipVideoPort)ps).getVideoSocket() : null;
        this.payloadType = cap.getRTPType();
        this.fuaBuffer = new ByteArrayOutputStream(1024);
        this.pli = this.capability.hasCapability("nack pli");
        this.nack = this.capability.hasCapability("nack");
        this.toLog("start VideoReceiver inwork=" + this.inwork + " buffer=" + this.output + " payloadType=" + this.payloadType + " fb=" + cap.getCapabilities() + " pli=" + this.pli + " nack=" + this.nack);
        if (!this.inwork) {
            this.inwork = true;
            Thread thread = new Thread((Runnable)this, "VideoReceiver-" + this.localPort);
            thread.start();
        } else {
            this.fir = true;
        }
    }

    public void stopReceive() {
        this.toLog("STOP VideoReceiver. buffer=" + this.output);
        this.payloadType = -1;
        this.output.dispose();
        this.pipe = null;
        this.first = true;
    }

    public int getPayloadType() {
        return this.payloadType;
    }

    public boolean isPipeMode() {
        return this.pipe != null;
    }

    public VideoSocket getPipe() {
        return this.pipe;
    }

    @Override
    public void run() {
        int socketTimeout = this.media.getEndpoint().getSocketTimeout();
        long dmztimeout = 0L;
        if (this.dmz) {
            this.sendDumb(this.payloadType);
            try {
                this.socket.setSoTimeout(100);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            dmztimeout = System.currentTimeMillis() + 5000L;
        } else if (socketTimeout > 0) {
            try {
                this.socket.setSoTimeout(socketTimeout);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        this.toLog("Run VideoReceiver-" + this.hashCode() + " codec=" + this.capability.getCodec() + " dmztimeout=" + dmztimeout + " socketTimeout=" + socketTimeout + " socket=" + this.socket + " srtp=" + this.srtpR + " running=" + this.running + " pipe=" + this.pipe);
        long prev_timestamp = 0L;
        while (this.running) {
            try {
                byte[] buf = new byte[8192];
                DatagramPacket datagram = new DatagramPacket(buf, 8192);
                this.socket.receive(datagram);
                if (this.payloadType == -1) continue;
                RTPPacket packet = new RTPPacket(datagram.getData(), datagram.getLength());
                if (packet.getSize() < 13 || packet.getPayloadType() != this.payloadType) {
                    this.toLog("VideoReceiver: invalid packet: ssrc=" + packet.getSyncSource() + " sn=" + packet.getSequenceNumber() + " ts=" + packet.getTimestamp() + " type=" + packet.getPayloadType() + " psize=" + packet.getPayloadSize() + " size=" + packet.getSize());
                    continue;
                }
                int sequenceNumber = packet.getSequenceNumber();
                long timestamp = packet.getTimestamp();
                int ssrc = packet.getSyncSource();
                if (this.srtpR != null) {
                    try {
                        this.srtpR.decrypt(packet, !this.nack);
                    }
                    catch (Exception e) {
                        this.toLog("VideoReceiver decrypt - " + e);
                        continue;
                    }
                }
                packet.setVersion(RTP.VERSION);
                if (this.first) {
                    InetAddress receivedAddress = datagram.getAddress();
                    int receivedPort = datagram.getPort();
                    this.toLog("VideoReceiver: receivedAddress=" + receivedAddress + ":" + receivedPort + " remoteAddress=" + this.remoteAddress + ":" + this.remotePort + " sym=" + this.sym);
                    if (this.remoteAddress == null || this.sym && (receivedPort != this.remotePort || !receivedAddress.equals(this.remoteAddress))) {
                        this.remoteAddress = receivedAddress;
                        this.remotePort = receivedPort;
                        this.rtcp.setRemoteAddress(receivedAddress, receivedPort + 1);
                    }
                    this.first = false;
                    if (dmztimeout > 0L) {
                        dmztimeout = 0L;
                        this.socket.setSoTimeout(socketTimeout);
                    }
                    if (this.fir) {
                        this.rtcp.sendFIR(this.remoteAddress.getHostAddress(), this.remotePort, ssrc);
                        this.fir = false;
                    } else if (!this.isStartSequence(packet)) {
                        this.pictureLost(ssrc, System.currentTimeMillis());
                    }
                    prev_timestamp = timestamp;
                    this.expectedSeqnumber = sequenceNumber;
                    this.currentSsrc = ssrc;
                    this.queue.clear();
                    this.nacks.clear();
                }
                if (this.pipe != null) {
                    this.pipe.sendRTPPacket(packet.getBuffer(), packet.getSize());
                } else if (!this.output.isPauseMode()) {
                    int c;
                    int q;
                    if (packet.getPayloadOffset() >= packet.getSize()) {
                        this.toLog("VideoReceiver: invalid packet payload: ssrc=" + ssrc + " sn=" + sequenceNumber + " ts=" + timestamp + " type=" + packet.getPayloadType() + " psize=" + packet.getPayloadSize() + " size=" + packet.getSize() + " offset=" + packet.getPayloadOffset());
                        continue;
                    }
                    if (ssrc != this.currentSsrc) {
                        if (this.oldssrc != 0 || ssrc == 0) continue;
                        this.toLog("New SSRC packet sn=" + sequenceNumber + " ts=" + timestamp + " passedTimestamp=" + this.passedTimestamp + " oldssrc=" + this.oldssrc + " ssrc=" + ssrc);
                        this.oldssrc = this.currentSsrc;
                        this.currentSsrc = ssrc;
                        prev_timestamp = timestamp;
                        this.expectedSeqnumber = sequenceNumber + 1 & 0xFFFF;
                        this.passedTimestamp = 0L;
                        this.queue.clear();
                        this.nacks.clear();
                        this.output.reset();
                        Utils.getTimer().schedule(new TimerTask(){

                            @Override
                            public void run() {
                                VideoSocket.this.oldssrc = 0;
                            }
                        }, 3000L);
                    }
                    if (timestamp <= this.passedTimestamp) continue;
                    boolean exists = false;
                    int qsn = 0;
                    for (q = this.queue.size() - 1; q >= 0 && (c = sequenceNumber - (qsn = this.queue.elementAt(q).getSequenceNumber())) <= 0 && c >= Short.MIN_VALUE; --q) {
                        if (c != 0) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    this.queue.insertElementAt(packet, q + 1);
                    long now = System.currentTimeMillis();
                    int c2 = sequenceNumber - this.expectedSeqnumber;
                    if (c2 < Short.MIN_VALUE) {
                        c2 += 65536;
                    }
                    if (c2 > 0) {
                        if (c2 > 15 || !this.nack && this.isIFrame(packet)) {
                            if (!this.isStartSequence(packet)) {
                                this.pictureLost(ssrc, now);
                                prev_timestamp = timestamp;
                                this.expectedSeqnumber = sequenceNumber + 1 & 0xFFFF;
                                continue;
                            }
                        } else if (this.nack) {
                            long ts = now + 25L;
                            this.nacks.put(this.expectedSeqnumber, ts);
                            int mask = 0;
                            for (int i = 1; i < c2; ++i) {
                                mask |= 1 << i - 1;
                                this.nacks.put(this.expectedSeqnumber + i, ts);
                            }
                        }
                    }
                    if (c2 >= 0) {
                        this.expectedSeqnumber = sequenceNumber + 1 & 0xFFFF;
                        prev_timestamp = timestamp;
                    } else if (this.nack) {
                        this.nacks.remove(sequenceNumber);
                    }
                    if (c2 != 0 || packet.getMarker() || timestamp != prev_timestamp) {
                        try {
                            int n = this.checkProcess(ssrc, timestamp, now);
                            if (n > 0) {
                                this.rtcp.onPacketsSkipped(ssrc, n);
                            }
                        }
                        catch (Exception e) {
                            ResourceStore.error("VideoSocket", e);
                        }
                    }
                }
                this.rtcp.onReceiveData(packet, datagram.getAddress(), datagram.getPort(), 90);
                ++this.totalPacketsReceived;
                this.totalOctetsReceived += datagram.getLength() + 20;
            }
            catch (SocketTimeoutException se) {
                this.toLog("VideoReceiver-" + this.hashCode() + " SocketTimeoutException socketTimeout=" + socketTimeout + " dmztimeout=" + dmztimeout);
                if (dmztimeout <= 0L) continue;
                if (System.currentTimeMillis() < dmztimeout) {
                    this.sendDumb(this.payloadType);
                    continue;
                }
                dmztimeout = 0L;
                try {
                    this.socket.setSoTimeout(socketTimeout);
                }
                catch (Exception exception) {}
            }
            catch (Throwable e) {
                if (!this.running) break;
                ResourceStore.error("VideoSocket", e);
                break;
            }
        }
        this.inwork = false;
        this.toLog("End VideoReceiver-" + this.hashCode());
    }

    private void pictureLost(int ssrc, long now) {
        if (now - this.last_pli < (long)Math.max(1000, this.roundTripDelay)) {
            return;
        }
        this.last_pli = now;
        if (this.pli) {
            this.rtcp.sendPLI(this.remoteAddress.getHostAddress(), this.remotePort, ssrc);
        } else if (this.capability.hasCapability("ccm fir")) {
            this.rtcp.sendFIR(this.remoteAddress.getHostAddress(), this.remotePort, ssrc);
        } else {
            this.media.sendPictureFastUpdateRequest();
        }
        this.nacks.clear();
        this.queue.clear();
        this.toLog(" pictureLost");
    }

    public void sendNack(int mssrc, int pid, int mask) {
        this.rtcp.sendNack(this.remoteAddress.getHostAddress(), this.remotePort, mssrc, pid, mask);
    }

    private int checkProcess(int ssrc, long timestamp, long now) throws IOException {
        int i;
        int skipped = 0;
        boolean valid = true;
        if (!this.nacks.isEmpty()) {
            int j;
            int i2;
            int iframeEnd = -1;
            for (i2 = this.queue.size() - 1; i2 >= 0; --i2) {
                RTPPacket packet = this.queue.elementAt(i2);
                if (iframeEnd != -1) {
                    RTPPacket prev = this.queue.elementAt(i2);
                    if (prev.getTimestamp() != packet.getTimestamp()) {
                        if (this.isIFrameStart(prev)) break;
                        iframeEnd = -1;
                    }
                    if (prev.getSequenceNumber() == (packet.getSequenceNumber() + 1 & 0xFFFF)) continue;
                    iframeEnd = -1;
                    continue;
                }
                if (!packet.getMarker() || !this.isIFrame(packet)) continue;
                iframeEnd = i2;
            }
            if (iframeEnd != -1) {
                skipped = i2++;
                this.processQueuePackets(i2, iframeEnd);
                for (int j2 = 0; j2 < i2; ++j2) {
                    int sn = this.queue.elementAt(j2).getSequenceNumber() + 1 & 0xFFF;
                    int dsn = this.queue.elementAt(j2 + 1).getSequenceNumber() - sn;
                    if (dsn == 0) continue;
                    if (dsn < Short.MIN_VALUE) {
                        dsn += 65536;
                    }
                    for (int k = 0; k < dsn; ++k) {
                        this.nacks.remove(sn + k);
                    }
                }
                for (i2 = iframeEnd; i2 >= 0; --i2) {
                    this.queue.removeElementAt(i2);
                }
                if (this.queue.isEmpty()) {
                    return skipped;
                }
            }
            int sn = this.queue.elementAt(0).getSequenceNumber();
            long diff = timestamp - this.queue.elementAt(0).getTimestamp();
            if (diff < Integer.MIN_VALUE) {
                diff += 0x100000000L;
            }
            boolean expired = diff > this.rcvBufferDelay;
            int fsn = 0;
            int mask = 0;
            for (i2 = j = 15; i2 > 0; --i2) {
                int nsn = sn - i2;
                if (nsn < Short.MIN_VALUE) {
                    nsn += 65536;
                }
                if (expired) {
                    this.nacks.remove(nsn);
                    continue;
                }
                Long t = (Long)this.nacks.get(nsn);
                if (t == null) continue;
                valid = false;
                if (now <= t) continue;
                if (fsn == 0) {
                    fsn = nsn;
                    j = i2 - 1;
                } else {
                    mask |= 1 << j - i2;
                }
                this.nacks.put(nsn, now + (long)this.roundTripDelay);
            }
            if (!valid && !expired) {
                if (fsn != 0) {
                    this.sendNack(ssrc, fsn, mask);
                }
                return skipped;
            }
        }
        boolean keyRequest = false;
        boolean process = true;
        int c = 0;
        int r = -1;
        for (i = 0; i < this.queue.size(); ++i) {
            if (i > 0) {
                int nsn = this.queue.elementAt(i - 1).getSequenceNumber() + 1 & 0xFFFF;
                int dsn = (this.queue.elementAt(i).getSequenceNumber() & 0xFFFF) - nsn;
                if (dsn != 0) {
                    long rts;
                    long diff;
                    process = false;
                    if (dsn < Short.MIN_VALUE) {
                        dsn += 65536;
                    }
                    if ((diff = timestamp - (rts = this.queue.elementAt(i - 1).getTimestamp())) < Integer.MIN_VALUE) {
                        diff += 0x100000000L;
                    }
                    if (diff < this.rcvBufferDelay && !this.nacks.isEmpty()) {
                        Long t = (Long)this.nacks.get(nsn);
                        if (t != null && now > t) {
                            long ts = now + (long)this.roundTripDelay;
                            this.nacks.put(nsn, ts);
                            int mask = 0;
                            for (int j = 1; j < dsn; ++j) {
                                mask += 1 << j - 1;
                                this.nacks.put(nsn + j & 0xFFFF, ts);
                            }
                            this.sendNack(ssrc, nsn, mask);
                        }
                    } else {
                        for (int j = 0; j < dsn; ++j) {
                            this.nacks.remove(nsn + j & 0xFFFF);
                        }
                        while (this.queue.elementAt(i).getTimestamp() == rts && ++i != this.queue.size()) {
                            int sn = this.queue.elementAt(i - 1).getSequenceNumber() + 1 & 0xFFFF;
                            dsn = this.queue.elementAt(i).getSequenceNumber() - sn;
                            if (dsn == 0) continue;
                            if (dsn < Short.MIN_VALUE) {
                                dsn += 65536;
                            }
                            for (int j = 0; j < dsn; ++j) {
                                this.nacks.remove(sn + j & 0xFFFF);
                            }
                        }
                        if (!this.nack || i == this.queue.size() || this.isIFrame(this.queue.elementAt(i - 1))) {
                            keyRequest = true;
                        }
                        skipped += i - c;
                        r = i - 1;
                        c = i;
                        this.passedTimestamp = rts;
                    }
                }
            }
            if (!process || !this.queue.elementAt(i).getMarker() || !this.isCompleteOrFirst(this.queue.elementAt(c))) continue;
            if (!this.processQueuePackets(c, i)) {
                keyRequest = true;
            }
            c = i + 1;
            r = i;
        }
        if (r != -1) {
            for (i = r; i >= 0; --i) {
                this.queue.removeElementAt(i);
            }
        }
        if (keyRequest || this.queue.size() > 60) {
            if (keyRequest) {
                for (i = 0; i < this.queue.size(); ++i) {
                    if (!this.isStartSequence(this.queue.elementAt(i))) continue;
                    return skipped;
                }
            }
            this.pictureLost(ssrc, now);
            if (this.lastKeyFrame != null) {
                this.output.reset();
                this.output.put(this.lastKeyFrame);
            }
        }
        return skipped;
    }

    private boolean processQueuePackets(int first, int last) throws IOException {
        for (int i = first; i <= last; ++i) {
            this.processPacket(this.queue.elementAt(i));
        }
        this.passedTimestamp = this.queue.elementAt(last).getTimestamp();
        if (this.fuaBuffer.size() > 3) {
            byte[] b = this.fuaBuffer.toByteArray();
            Frame frame = new Frame(b, this.passedTimestamp);
            int type = b[3] & 0x1F;
            if (type == 9 && b.length > 8) {
                type = b[8] & 0x1F;
            }
            if (type == 5 || type == 7 || type == 8) {
                frame.setKey();
                this.lastKeyFrame = frame;
            }
            this.fuaBuffer.reset();
            boolean result = this.output.put(frame);
            if (!result) {
                return false;
            }
        }
        return true;
    }

    private void processPacket(RTPPacket packet) throws IOException {
        switch (this.capability.getCodecType()) {
            case 4: {
                this.processH264(packet);
                break;
            }
            case 2: {
                this.processH263(packet);
                break;
            }
            case 1: {
                this.processH263_RFC2190(packet);
            }
        }
    }

    private boolean isStartSequence(RTPPacket packet) {
        switch (this.capability.getCodecType()) {
            case 4: {
                byte[] input = packet.getBuffer();
                int offset = packet.getPayloadOffset();
                int nal_unit_type = input[offset] & 0x1F;
                return nal_unit_type == 7;
            }
        }
        return false;
    }

    private boolean isIFrame(RTPPacket packet) {
        switch (this.capability.getCodecType()) {
            case 4: {
                byte[] input = packet.getBuffer();
                int offset = packet.getPayloadOffset();
                int nal_unit_type = input[offset] & 0x1F;
                return nal_unit_type == 5 || (nal_unit_type == 28 || nal_unit_type == 29) && (input[offset + 1] & 0x1F) == 5;
            }
        }
        return false;
    }

    private boolean isIFrameStart(RTPPacket packet) {
        switch (this.capability.getCodecType()) {
            case 4: {
                byte[] input = packet.getBuffer();
                int offset = packet.getPayloadOffset();
                int nal_unit_type = input[offset] & 0x1F;
                return nal_unit_type == 5 || (nal_unit_type == 28 || nal_unit_type == 29) && (input[offset + 1] & 0x9F) == 133;
            }
        }
        return false;
    }

    private boolean isValuedFrame(RTPPacket packet) {
        switch (this.capability.getCodecType()) {
            case 4: {
                byte[] input = packet.getBuffer();
                int offset = packet.getPayloadOffset();
                int nri = (input[offset] & 0xE0) >> 5;
                return nri == 3;
            }
        }
        return false;
    }

    private boolean isCompleteOrFirst(RTPPacket packet) {
        switch (this.capability.getCodecType()) {
            case 4: {
                byte[] input = packet.getBuffer();
                int offset = packet.getPayloadOffset();
                int nal_unit_type = input[offset] & 0x1F;
                return nal_unit_type != 28 && nal_unit_type != 29 || (input[offset + 1] & 0x80) != 0;
            }
        }
        return true;
    }

    private boolean processH264(RTPPacket packet) throws IOException {
        byte[] input = packet.getBuffer();
        int length = packet.getPayloadSize();
        int offset = packet.getPayloadOffset();
        byte header = input[offset];
        int nal_unit_type = header & 0x1F;
        if (nal_unit_type >= 1 && nal_unit_type <= 23) {
            this.fuaBuffer.write(NAL_PREFIX);
            this.fuaBuffer.write(input, offset, length);
            if (nal_unit_type == 5) {
                // empty if block
            }
            return true;
        }
        if (nal_unit_type != 24 && nal_unit_type == 28) {
            boolean end_bit;
            --length;
            byte fu_header = input[++offset];
            ++offset;
            --length;
            boolean start_bit = (fu_header & 0x80) != 0;
            boolean bl = end_bit = (fu_header & 0x40) != 0;
            if (start_bit) {
                this.fuaBuffer.write(NAL_PREFIX);
                this.fuaBuffer.write(header & 0xE0 | fu_header & 0x1F);
                this.fuaBuffer.write(input, offset, length);
                return false;
            }
            if (this.fuaBuffer.size() == 0) {
                return false;
            }
            this.fuaBuffer.write(input, offset, length);
            return end_bit;
        }
        return false;
    }

    private void processH263(RTPPacket packet) throws IOException {
        byte[] input = packet.getBuffer();
        int length = packet.getPayloadSize();
        int offset = packet.getPayloadOffset();
        boolean pBit = (input[offset] & 4) != 0;
        boolean vBit = (input[offset] & 2) != 0;
        int plen = ((input[offset] & 1) << 5) + ((input[offset + 1] & 0xF8) >> 3);
        int dataLength = length - 2 - plen - (vBit ? 1 : 0);
        if (pBit) {
            this.fuaBuffer.write(0);
            this.fuaBuffer.write(0);
        }
        if (vBit) {
            // empty if block
        }
        this.fuaBuffer.write(input, offset + 2 + (vBit ? 1 : 0) + plen, dataLength);
    }

    private void processH263_RFC2190(RTPPacket packet) throws IOException {
        byte[] input = packet.getBuffer();
        int length = packet.getPayloadSize();
        int offset = packet.getPayloadOffset();
        int dataLength = length;
        this.fuaBuffer.write(input, offset + 4, dataLength - 4);
    }

    public void toLog(String str) {
        this.media.toLog(str);
    }
}

